/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot3D;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.cleanup.CleanUpToolBar;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.swing.flat.JFlatButtonComboBox;
import se.prediktera.map.common.swing.flat.JFlatToggleButton;
import se.prediktera.map.main.GlobalMessageInterface;
import se.prediktera.map.plot.AbstractPlot;
import se.prediktera.map.plot.axisplot.FloatPlotWindow;
import se.prediktera.map.plot.axisplot.plot3D.FloatWindowPlot3D;

public class Plot3DToolbar
extends CleanUpToolBar
implements GlobalMessageInterface {
    private static final byte ROTATE3D = 0;
    private static final byte RESET3D = 1;
    private static final byte RESETXZ = 2;
    private static final byte RESETXY = 3;
    private static final byte RESETYZ = 4;
    private static final byte RESETNEGXZ = 5;
    private static final byte RESETNEGXY = 6;
    private static final byte RESETNEGYZ = 7;
    private final JFlatToggleButton rotate3D = new JFlatToggleButton();
    private final JFlatButtonComboBox resetComboBox = new JFlatButtonComboBox();
    private final JFlatButton reset3D = new JFlatButton();
    private final JFlatButton resetXZ = new JFlatButton();
    private final JFlatButton resetXY = new JFlatButton();
    private final JFlatButton resetYZ = new JFlatButton();
    private final JFlatButton resetNegXZ = new JFlatButton();
    private final JFlatButton resetNegXY = new JFlatButton();
    private final JFlatButton resetNegYZ = new JFlatButton();
    private final FloatPlotWindow floatPlotWindow;
    private final FloatWindowPlot3D.PlotRenderer renderer;
    private final ButtonGroup plotButtonGroup;
    private final ResetListener resetListener = new ResetListener();

    public Plot3DToolbar(FloatPlotWindow floatPlotWindow, FloatWindowPlot3D.PlotRenderer plotRenderer, ButtonGroup buttonGroup) {
        this.floatPlotWindow = floatPlotWindow;
        this.renderer = plotRenderer;
        this.plotButtonGroup = buttonGroup;
        this.jbInit();
    }

    public void PostGlobalMessage(byte by) {
        if (this.floatPlotWindow != null) {
            this.floatPlotWindow.PostGlobalMessage((byte)4, by);
        }
    }

    public byte SendGlobalMessage(byte by) {
        switch (by) {
            case 0: {
                this.rotate3D.setSelected(true);
                break;
            }
            case 1: {
                this.resetComboBox.setSelectedButton(this.reset3D);
                break;
            }
            case 2: {
                this.resetComboBox.setSelectedButton(this.resetXZ);
                break;
            }
            case 3: {
                this.resetComboBox.setSelectedButton(this.resetXY);
                break;
            }
            case 4: {
                this.resetComboBox.setSelectedButton(this.resetYZ);
                break;
            }
            case 5: {
                this.resetComboBox.setSelectedButton(this.resetNegXZ);
                break;
            }
            case 6: {
                this.resetComboBox.setSelectedButton(this.resetNegXY);
                break;
            }
            case 7: {
                this.resetComboBox.setSelectedButton(this.resetNegYZ);
            }
        }
        return 1;
    }

    @Override
    protected void cleanUpChild() {
    }

    private void jbInit() {
        this.setFloatable(false);
        this.rotate3D.setToolTipText("Rotate 3D");
        this.rotate3D.setIcon(new ImageIcon(AbstractPlot.class.getResource("image/rotate3D.gif")));
        this.rotate3D.addItemListener(itemEvent -> this.rotate3D_itemStateChanged(itemEvent));
        this.reset3D.setToolTipText("Reset 3D View");
        this.reset3D.setIcon(new ImageIcon(AbstractPlot.class.getResource("image/reset.gif")));
        this.reset3D.setActionCommand("0");
        this.reset3D.addActionListener(this.resetListener);
        this.resetYZ.setToolTipText("Show Y-Z plane from -X");
        this.resetYZ.setIcon(new ImageIcon(AbstractPlot.class.getResource("image/reset.gif")));
        this.resetYZ.setActionCommand("1");
        this.resetYZ.addActionListener(this.resetListener);
        this.resetXZ.setToolTipText("Show X-Z plane from -Y");
        this.resetXZ.setIcon(new ImageIcon(AbstractPlot.class.getResource("image/reset.gif")));
        this.resetXZ.setActionCommand("2");
        this.resetXZ.addActionListener(this.resetListener);
        this.resetXY.setToolTipText("Show X-Y plane from -Z");
        this.resetXY.setIcon(new ImageIcon(AbstractPlot.class.getResource("image/reset.gif")));
        this.resetXY.setActionCommand("3");
        this.resetXY.addActionListener(this.resetListener);
        this.resetNegYZ.setToolTipText("Show Y-Z plane from X");
        this.resetNegYZ.setIcon(new ImageIcon(AbstractPlot.class.getResource("image/reset.gif")));
        this.resetNegYZ.setActionCommand("4");
        this.resetNegYZ.addActionListener(this.resetListener);
        this.resetNegXZ.setToolTipText("Show X-Z plane from Y");
        this.resetNegXZ.setIcon(new ImageIcon(AbstractPlot.class.getResource("image/reset.gif")));
        this.resetNegXZ.setActionCommand("5");
        this.resetNegXZ.addActionListener(this.resetListener);
        this.resetNegXY.setToolTipText("Show X-Y plane from Z");
        this.resetNegXY.setIcon(new ImageIcon(AbstractPlot.class.getResource("image/reset.gif")));
        this.resetNegXY.setActionCommand("6");
        this.resetNegXY.addActionListener(this.resetListener);
        this.resetComboBox.addButton(this.reset3D);
        this.resetComboBox.addButton(this.resetXZ);
        this.resetComboBox.addButton(this.resetXY);
        this.resetComboBox.addButton(this.resetYZ);
        this.resetComboBox.addButton(this.resetNegXZ);
        this.resetComboBox.addButton(this.resetNegXY);
        this.resetComboBox.addButton(this.resetNegYZ);
        this.resetComboBox.setSelectedButton(this.reset3D);
        this.resetComboBox.setToolTipText("View");
        this.plotButtonGroup.add(this.rotate3D);
        this.addSeparator();
        this.add((Component)this.rotate3D, null);
        this.add((Component)this.resetComboBox, null);
    }

    private void rotate3D_itemStateChanged(ItemEvent itemEvent) {
        this.renderer.setCanRotate(itemEvent.getStateChange() == 1);
        if (itemEvent.getStateChange() == 1) {
            this.PostGlobalMessage((byte)0);
        }
    }

    class ResetListener
    implements ActionListener {
        ResetListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFlatButton jFlatButton = null;
            if (actionEvent.getSource() instanceof CMenuItem) {
                jFlatButton = (JFlatButton)((CMenuItem)actionEvent.getSource()).getButton();
            } else if (actionEvent.getSource() instanceof JFlatButton) {
                jFlatButton = (JFlatButton)actionEvent.getSource();
            }
            if (jFlatButton != null) {
                try {
                    byte by = Byte.parseByte(jFlatButton.getActionCommand());
                    Plot3DToolbar.this.renderer.resetView(by);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }
}

