/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot3D.contour3D;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Iterator;
import java.util.List;
import se.prediktera.map.common.BooleanArray;
import se.prediktera.map.common.ComplexName;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.LeafList;
import se.prediktera.map.plot.axisplot.ZoneArray;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot3D.MatrixFuncs;
import se.prediktera.map.plot.axisplot.plot3D.contour3D.ZoneSurface;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.ComboBoxColor;
import se.prediktera.map.plot.axisplot.settings.ComboBoxComment;
import se.prediktera.map.plot.axisplot.settings.ComboBoxRangeSurface;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxHelper;

public class Contour3DLayer
extends AbstractAxisLayer {
    private static final int excludeColor = Color.lightGray.getRGB();
    private ComboBoxRangeSurface boxRange;
    private final Surface surface = new Surface();

    private static void calculateTriangleNormals(ZoneSurface zoneSurface, float f, float f2, float f3, ZoneSurface zoneSurface2, float f4, float f5, float f6, int n) {
        float f7 = f3 - f2;
        float f8 = f4 - f;
        float f9 = f5 - f2;
        float[] fArray = new float[]{f8 * f7, f9, -f8};
        float[] fArray2 = zoneSurface.getNormalArray();
        float[] fArray3 = zoneSurface2.getNormalArray();
        MatrixFuncs.normalize(fArray);
        MatrixFuncs.addTo(fArray2, n * 3, fArray);
        MatrixFuncs.addTo(fArray2, (n + 1) * 3, fArray);
        MatrixFuncs.addTo(fArray3, n * 3, fArray);
        float f10 = f - f4;
        f7 = f3 - f5;
        f9 = f6 - f5;
        fArray[0] = -f10 * f9;
        fArray[1] = f9 - f7;
        fArray[2] = f10;
        MatrixFuncs.normalize(fArray);
        MatrixFuncs.addTo(fArray2, (n + 1) * 3, fArray);
        MatrixFuncs.addTo(fArray3, n * 3, fArray);
        MatrixFuncs.addTo(fArray3, (n + 1) * 3, fArray);
    }

    public Contour3DLayer(AbstractAxisPlot abstractAxisPlot, PlotInit plotInit, LeafList leafList, LeafList leafList2, int n) {
        super(plotInit, abstractAxisPlot, leafList, leafList2, n);
        this.layerName = "Layer " + n;
        this.jbinit();
    }

    public Contour3DLayer(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.jbinit();
    }

    @Override
    public final void beginCalculations() {
        AbstractPlotSettingsBox abstractPlotSettingsBox = (AbstractPlotSettingsBox)this.settingsBoxMap.get((byte)9);
        if (abstractPlotSettingsBox != null) {
            abstractPlotSettingsBox.getMatrix().beginCalculations();
        }
    }

    public final void calculateNormals() {
        this.beginCalculations();
        this.surface.calculateNormals();
        this.endCalculations();
    }

    public void calculatePlotShapeFixed(byte by) {
        List<ZoneLeaf> list = this.getRootList();
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).setShapeType(by);
        }
    }

    public final void colorsChanged() {
        this.surface.colorsChanged();
    }

    @Override
    public AbstractAxisLayer createSubLayer(LeafList leafList, int n, PlotInit plotInit) {
        return new Contour3DLayer(this.axisPlot, plotInit, this.zoneList, leafList, n);
    }

    @Override
    public final void endCalculations() {
        AbstractPlotSettingsBox abstractPlotSettingsBox = (AbstractPlotSettingsBox)this.settingsBoxMap.get((byte)9);
        if (abstractPlotSettingsBox != null) {
            abstractPlotSettingsBox.getMatrix().endCalculations();
        }
    }

    public double getAxisValue(byte by, int n, int n2, int n3) {
        return this.boxRange.getAxisValue(by, n, n2, n3);
    }

    @Override
    public Font getDescriptionFont() {
        return null;
    }

    @Override
    public double[] getMinmax(int n) {
        return this.boxRange.getMinmax(n);
    }

    @Override
    public int getNrObjects() {
        if (this.zoneList != null) {
            int[] nArray = this.getPrimaryIndexArray();
            int n = nArray == null ? 0 : nArray.length;
            return this.zoneList.size() * n;
        }
        return 0;
    }

    @Override
    public int getNrVisibleObjects() {
        int n = 0;
        if (this.zoneList != null) {
            int[] nArray = this.getPrimaryIndexArray();
            int n2 = nArray == null ? 0 : nArray.length;
            for (ZoneArray zoneArray : this.zoneList) {
                if (!zoneArray.isVisible()) continue;
                n += n2;
            }
        }
        return n;
    }

    @Override
    public byte getTreeType() {
        return 5;
    }

    @Override
    public void includePoints(List<ZoneLeaf> list, AbstractAxisLayer abstractAxisLayer) {
        for (int i = 0; i < list.size(); ++i) {
            ZoneArray zoneArray = (ZoneArray)list.get(i);
            int n = zoneArray.getFirstTagged();
            while (n >= 0) {
                zoneArray.setLayer(n, this);
                n = zoneArray.getNextTagged(n);
            }
            zoneArray.checkLayerArray();
        }
        this.updateCalculations(null, true);
        if (this.isCreated) {
            this.axisPlot.contentPaint((byte)7);
        }
    }

    public boolean isShowLines() {
        return false;
    }

    public final void paintSurface(GL2 gL2, InnerColumnBoolean innerColumnBoolean, BooleanArray booleanArray) {
        this.surface.paint(gL2, innerColumnBoolean, booleanArray);
    }

    public void reCalc() {
    }

    @Override
    public void setShowLines(boolean bl) {
    }

    @Override
    public void SettingsBoxChangeEvent(AbstractPlotSettingsBox abstractPlotSettingsBox, boolean bl) {
        if (abstractPlotSettingsBox instanceof ComboBoxColor || abstractPlotSettingsBox instanceof ComboBoxRangeSurface) {
            this.colorsChanged();
        }
        super.SettingsBoxChangeEvent(abstractPlotSettingsBox, bl);
    }

    @Override
    public String toString() {
        return this.layerName;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.boxRange = null;
        this.surface.cleanUp();
    }

    @Override
    protected void InitLayer() {
        PlotInit plotInit = this.getPlotInit();
        boolean bl = plotInit.plotType == 1 || plotInit.dofold;
        ComplexName complexName = bl ? OBSCATEGORYSTRING : VARCATEGORYSTRING;
        ComplexName complexName2 = bl ? VARCATEGORYSTRING : OBSCATEGORYSTRING;
        AbstractDataMatrix abstractDataMatrix = plotInit.getMatrix(0);
        this.boxColor = new ComboBoxColor(abstractDataMatrix, this);
        this.boxColor.addItem(new ComboItem(FIXEDSTRING, 1));
        this.boxColor.addItem(new ComboItem(OBSVALUESTRING, 100));
        this.boxColor.addItem(new ComboItem(VARVALUESTRING, 0));
        if (!plotInit.dofold) {
            this.boxColor.addItem(new ComboItem(complexName, 7));
            if (plotInit.isSecondaryMatrixTagObsVar()) {
                this.boxColor.addItem(new ComboItem(complexName2, 101));
            }
        } else {
            this.boxColor.addItem(new ComboItem(CATEGORYSTRING, 7));
        }
        if (bl) {
            this.boxColor.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        }
        this.boxColor.addItem(new ComboItem(AMPLITUDESTRING, 11));
        this.boxColor.addItem(new ComboItem("%SEPARATOR#", 3));
        this.boxColor.setAltitudeAxis((byte)2);
        this.settingsBoxMap.put(this.boxColor.getType(), this.boxColor);
        this.boxComment = new ComboBoxComment(abstractDataMatrix, this);
        this.boxComment.addItem(new ComboItem(NONESTRING, 2));
        this.boxComment.addItem(new ComboItem(CUSTOMSTRING, 1));
        this.boxComment.addItem(new ComboItem(CATEGORYSTRING, 7));
        if (plotInit.dofold) {
            this.boxComment.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        }
        this.boxComment.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxComment.getType(), this.boxComment);
        this.InitLayerChild();
    }

    @Override
    protected void InitLayerChild() {
        this.boxRange = new ComboBoxRangeSurface(this, true);
        this.boxRange.addItem(new ComboItem("[MATRIX]", 10));
        this.boxRange.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxRange.getType(), this.boxRange);
        if (this.isSubLayer()) {
            this.boxRange.setEnabled(false);
        }
    }

    private float[] createSelColor() {
        Color color = this.axisPlot.getSelectionColor();
        return new float[]{(float)color.getRed() / 255.0f * 100.0f / 255.0f, (float)color.getGreen() / 255.0f * 100.0f / 255.0f, (float)color.getBlue() / 255.0f * 100.0f / 255.0f, 0.60784316f};
    }

    private void jbinit() {
        this.add(SettingsBoxHelper.createRangePanel(this.boxRange));
        this.add(SettingsBoxHelper.createColorPanel(this.boxColor));
        this.add(SettingsBoxHelper.createCommentPanel(this.boxComment));
    }

    public void setVboEnabled(boolean bl) {
    }

    class Surface {
        private boolean newVertices = true;
        private boolean newColors = true;
        private final int[] vertexBuffer = new int[1];
        private final int[] normalBuffer = new int[1];
        private final int[] colorBuffer = new int[1];
        private final int[] indexBuffer = new int[1];
        private int lineCount = 0;
        private int pointsPerLine = 0;
        private GL2 gl = null;
        private Dimension lastDimension;

        Surface() {
        }

        public final void calculateNormals() {
            int n;
            double d;
            int n2;
            this.newVertices = true;
            Iterator<ZoneLeaf> iterator = Contour3DLayer.this.getRootList().iterator();
            if (!iterator.hasNext()) {
                return;
            }
            ZoneSurface zoneSurface = (ZoneSurface)iterator.next();
            this.pointsPerLine = n2 = zoneSurface.getNoChildren();
            this.lineCount = 1;
            int[] nArray = Contour3DLayer.this.getPrimaryIndexArray();
            boolean bl = Contour3DLayer.this.boxRange.getObservationTag();
            int[] nArray2 = Contour3DLayer.this.boxRange.getIndexToCoord();
            AbstractDataMatrix abstractDataMatrix = Contour3DLayer.this.boxRange.getMatrix();
            int n3 = zoneSurface.getSecondaryIndex();
            int n4 = bl ? abstractDataMatrix.getKrefOrig(n3) : abstractDataMatrix.getNrefOrig(n3);
            double d2 = d = nArray2 == null || n4 < 0 ? (double)n4 : (double)nArray2[n4];
            while (iterator.hasNext()) {
                ZoneSurface zoneSurface2 = (ZoneSurface)iterator.next();
                int n5 = zoneSurface2.getSecondaryIndex();
                n = bl ? abstractDataMatrix.getKrefOrig(n5) : abstractDataMatrix.getNrefOrig(n5);
                double d3 = nArray2 == null || n < 0 ? (double)n : (double)nArray2[n];
                int n6 = zoneSurface2.getNoChildren();
                if (n6 < n2) {
                    n2 = n6;
                }
                int n7 = nArray[0];
                int n8 = bl ? abstractDataMatrix.getNrefOrig(n7) : abstractDataMatrix.getKrefOrig(n7);
                for (int i = 0; i < n2 - 1; ++i) {
                    float f;
                    float f2;
                    float f3;
                    float f4;
                    int n9;
                    int n10 = nArray[i + 1];
                    int n11 = n9 = bl ? abstractDataMatrix.getNrefOrig(n10) : abstractDataMatrix.getKrefOrig(n10);
                    if (bl) {
                        f4 = (float)abstractDataMatrix.getValue(n8, n4);
                        f3 = (float)abstractDataMatrix.getValue(n9, n4);
                        f2 = (float)abstractDataMatrix.getValue(n8, n);
                        f = (float)abstractDataMatrix.getValue(n9, n);
                    } else {
                        f4 = (float)abstractDataMatrix.getValue(n4, n8);
                        f3 = (float)abstractDataMatrix.getValue(n4, n9);
                        f2 = (float)abstractDataMatrix.getValue(n, n8);
                        f = (float)abstractDataMatrix.getValue(n, n9);
                    }
                    Contour3DLayer.calculateTriangleNormals(zoneSurface, (float)d, f4, f3, zoneSurface2, (float)d3, f2, f, i);
                    n8 = n9;
                }
                n2 = n6;
                zoneSurface = zoneSurface2;
                n4 = n;
                d = d3;
                ++this.lineCount;
            }
            for (ZoneSurface zoneSurface2 : Contour3DLayer.this.getRootList()) {
                n2 = zoneSurface2.getNoChildren();
                float[] fArray = zoneSurface2.getNormalArray();
                for (n = 0; n < n2; ++n) {
                    float f = -1.0f / MatrixFuncs.length(fArray, n * 3);
                    int n12 = n * 3 + 0;
                    fArray[n12] = fArray[n12] * f;
                    int n13 = n * 3 + 1;
                    fArray[n13] = fArray[n13] * f;
                    int n14 = n * 3 + 2;
                    fArray[n14] = fArray[n14] * f;
                }
            }
        }

        public void cleanUp() {
            if (this.gl != null) {
                try {
                    this.gl.glDeleteBuffers(1, this.vertexBuffer, 0);
                    this.gl.glDeleteBuffers(1, this.normalBuffer, 0);
                    this.gl.glDeleteBuffers(1, this.colorBuffer, 0);
                    this.gl.glDeleteBuffers(1, this.indexBuffer, 0);
                }
                catch (GLException gLException) {
                    // empty catch block
                }
                this.gl = null;
            }
        }

        public final void colorsChanged() {
            this.newColors = true;
        }

        public final void paint(GL2 gL2, InnerColumnBoolean innerColumnBoolean, BooleanArray booleanArray) {
            this.gl = gL2;
            Contour3DLayer.this.beginCalculations();
            if (IniManager.is3dAccelerated()) {
                this.paintSurfaceVbo(gL2, innerColumnBoolean, booleanArray);
            } else {
                this.paintSurface(gL2, innerColumnBoolean, booleanArray);
            }
            this.paintSelection(gL2, booleanArray);
            Contour3DLayer.this.endCalculations();
        }

        private final void paintSelection(GL2 gL2, BooleanArray booleanArray) {
            boolean bl = Contour3DLayer.this.getFoldN() > 0;
            gL2.glPointSize(3.0f);
            gL2.glBegin(1);
            gL2.glColor4d(0.0, 0.0, 0.0, 0.75);
            ZoneArray zoneArray = null;
            ZoneArray zoneArray2 = null;
            ZoneArray zoneArray3 = null;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            Iterator<ZoneLeaf> iterator = Contour3DLayer.this.getRootList().iterator();
            zoneArray3 = (ZoneArray)iterator.next();
            bl4 = zoneArray3.isVisible();
            int n = zoneArray3.getNoChildren();
            while (iterator.hasNext()) {
                zoneArray2 = zoneArray;
                bl3 = bl2;
                zoneArray = zoneArray3;
                bl2 = bl4;
                if (iterator.hasNext()) {
                    zoneArray3 = (ZoneArray)iterator.next();
                    bl4 = zoneArray3.isVisible();
                } else {
                    bl4 = false;
                }
                int n2 = -1;
                int n3 = -1;
                int n4 = -1;
                int n5 = -1;
                boolean bl5 = false;
                boolean bl6 = false;
                boolean bl7 = false;
                boolean bl8 = false;
                boolean bl9 = false;
                boolean bl10 = false;
                boolean bl11 = false;
                boolean bl12 = false;
                boolean bl13 = false;
                n4 = 0;
                bl7 = (bl && zoneArray.isSelected(n4) || !bl && booleanArray.get(n4)) && zoneArray.isSelected() && zoneArray.isVisible(n4);
                for (int i = 0; i < n; ++i) {
                    n3 = n2;
                    bl6 = bl5;
                    n2 = n4;
                    bl5 = bl7;
                    if (bl3) {
                        bl9 = bl8;
                        n5 = i;
                        bl8 = bl10;
                        if (i + 1 < n) {
                            boolean bl14 = bl10 = (bl && zoneArray2.isSelected(i + 1) || !bl && booleanArray.get(i + 1)) && zoneArray2.isSelected() && zoneArray2.isVisible(i + 1);
                        }
                    }
                    if (bl4) {
                        bl12 = bl11;
                        bl11 = bl13;
                        if (i + 1 < n) {
                            boolean bl15 = bl13 = (bl && zoneArray3.isSelected(i + 1) || !bl && booleanArray.get(i + 1)) && zoneArray3.isSelected() && zoneArray3.isVisible(i + 1);
                        }
                    }
                    if (i + 1 < n) {
                        n4 = i + 1;
                        bl7 = (bl && zoneArray.isSelected(n4) || !bl && booleanArray.get(n4)) && zoneArray.isSelected() && zoneArray.isVisible(n4);
                    } else {
                        bl7 = false;
                    }
                    if (!(!bl6 || !bl5 || bl9 && bl11 && bl12 && bl8)) {
                        gL2.glVertex3d((double)(n3 + 1), zoneArray.getValue(n3, (byte)1), zoneArray.getValue(n3, (byte)2));
                        gL2.glVertex3d((double)(n2 + 1), zoneArray.getValue(n2, (byte)1), zoneArray.getValue(n2, (byte)2));
                    }
                    if (!(!bl5 || !bl8 || bl9 && bl7 && bl6 && bl10)) {
                        gL2.glVertex3d((double)(n5 + 1), zoneArray2.getValue(n5, (byte)1), zoneArray2.getValue(n5, (byte)2));
                        gL2.glVertex3d((double)(n2 + 1), zoneArray.getValue(n2, (byte)1), zoneArray.getValue(n2, (byte)2));
                    }
                    if (!bl5 || bl6 || bl7 || bl9 || bl8 || bl11 || bl13) continue;
                    gL2.glEnd();
                    gL2.glBegin(0);
                    gL2.glVertex3d((double)(n2 + 1), zoneArray.getValue(n2, (byte)1), zoneArray.getValue(n2, (byte)2));
                    gL2.glEnd();
                    gL2.glBegin(1);
                }
            }
            gL2.glEnd();
            gL2.glPointSize(1.0f);
        }

        private final void paintSurface(GL2 gL2, InnerColumnBoolean innerColumnBoolean, BooleanArray booleanArray) {
            int n = Contour3DLayer.this.getFoldN();
            boolean bl = n > 0;
            Iterator<ZoneLeaf> iterator = Contour3DLayer.this.getRootList().iterator();
            boolean bl2 = false;
            for (int i = booleanArray.size(); i > 0; --i) {
                if (!booleanArray.get(i)) continue;
                bl2 = true;
                break;
            }
            if (!iterator.hasNext()) {
                return;
            }
            ZoneSurface zoneSurface = (ZoneSurface)iterator.next();
            int n2 = zoneSurface.getNoChildren();
            if (n2 < 1) {
                return;
            }
            int[] nArray = Contour3DLayer.this.getPrimaryIndexArray();
            AbstractDataMatrix abstractDataMatrix = Contour3DLayer.this.boxRange.getMatrix();
            boolean bl3 = Contour3DLayer.this.boxRange.getObservationTag();
            int[] nArray2 = Contour3DLayer.this.boxRange.getIndexToCoord();
            double[] dArray = new double[3];
            gL2.glEnable(32823);
            gL2.glPolygonOffset(1.1f, 4.5f);
            float[] fArray = Contour3DLayer.this.createSelColor();
            while (iterator.hasNext()) {
                ZoneSurface zoneSurface2 = (ZoneSurface)iterator.next();
                int n3 = zoneSurface2.getNoChildren();
                if (n3 < n2) {
                    n2 = n3;
                }
                gL2.glBegin(5);
                int n4 = zoneSurface.getSecondaryIndex();
                int n5 = bl3 ? abstractDataMatrix.getKrefOrig(n4) : abstractDataMatrix.getNrefOrig(n4);
                double d = nArray2 == null || n5 < 0 ? (double)n5 : (double)nArray2[n5];
                int n6 = zoneSurface2.getSecondaryIndex();
                int n7 = bl3 ? abstractDataMatrix.getKrefOrig(n6) : abstractDataMatrix.getNrefOrig(n6);
                double d2 = nArray2 == null || n7 < 0 ? (double)n7 : (double)nArray2[n7];
                for (int i = 0; i < n2; ++i) {
                    int n8;
                    boolean bl4;
                    boolean bl5 = bl4 = innerColumnBoolean != null && !innerColumnBoolean.getValueBool(zoneSurface2.getPrimaryIndex(i) * n + zoneSurface2.getSecondaryIndex());
                    if (bl4) {
                        dArray[0] = excludeColor >> 16 & 1;
                        dArray[1] = excludeColor >> 8 & 1;
                        dArray[2] = (excludeColor & 0xFF) / 255;
                    } else {
                        n8 = zoneSurface.getColorRGB(i);
                        dArray[0] = (double)(n8 >> 16 & 0xFF) / 255.0;
                        dArray[1] = (double)(n8 >> 8 & 0xFF) / 255.0;
                        dArray[2] = (double)(n8 & 0xFF) / 255.0;
                    }
                    gL2.glNormal3fv(zoneSurface.getNormalArray(), i * 3);
                    if (!zoneSurface.isVisible(i) || !zoneSurface.getLayer(i).isLayerVisible()) {
                        gL2.glColor4d(1.0, 1.0, 1.0, 0.0);
                    } else if (bl2 && zoneSurface.isSelected() && (bl && zoneSurface.isSelected(i) || !bl && booleanArray.get(i))) {
                        gL2.glColor3d((double)fArray[0] + (double)fArray[3] * dArray[0], (double)fArray[1] + (double)fArray[3] * dArray[1], (double)fArray[2] + (double)fArray[3] * dArray[2]);
                    } else {
                        gL2.glColor3d(dArray[0], dArray[1], dArray[2]);
                    }
                    n8 = nArray[i];
                    int n9 = bl3 ? abstractDataMatrix.getNrefOrig(n8) : abstractDataMatrix.getKrefOrig(n8);
                    double d3 = bl3 ? abstractDataMatrix.getValue(n9, n5) : abstractDataMatrix.getValue(n5, n9);
                    gL2.glVertex3d((double)(i + 1), d, d3);
                    if (!bl4) {
                        int n10 = zoneSurface2.getColorRGB(i);
                        dArray[0] = (double)(n10 >> 16 & 0xFF) / 255.0;
                        dArray[1] = (double)(n10 >> 8 & 0xFF) / 255.0;
                        dArray[2] = (double)(n10 & 0xFF) / 255.0;
                    }
                    gL2.glNormal3fv(zoneSurface2.getNormalArray(), i * 3);
                    if (!zoneSurface2.isVisible(i) || !zoneSurface2.getLayer(i).isLayerVisible()) {
                        gL2.glColor4d(1.0, 1.0, 1.0, 0.0);
                    } else if (bl2 && zoneSurface2.isSelected() && (bl && zoneSurface2.isSelected(i) || !bl && booleanArray.get(i))) {
                        gL2.glColor3d((double)fArray[0] + (double)fArray[3] * dArray[0], (double)fArray[1] + (double)fArray[3] * dArray[1], (double)fArray[2] + (double)fArray[3] * dArray[2]);
                    } else {
                        gL2.glColor3d(dArray[0], dArray[1], dArray[2]);
                    }
                    double d4 = bl3 ? abstractDataMatrix.getValue(n9, n7) : abstractDataMatrix.getValue(n7, n9);
                    gL2.glVertex3d((double)(i + 1), d2, d4);
                }
                gL2.glEnd();
                n2 = n3;
                zoneSurface = zoneSurface2;
            }
            gL2.glDisable(32823);
        }

        /*
         * WARNING - void declaration
         */
        private final synchronized void paintSurfaceVbo(GL2 gL2, InnerColumnBoolean innerColumnBoolean, BooleanArray booleanArray) {
            int n;
            FloatBuffer floatBuffer;
            Object object;
            boolean bl = Contour3DLayer.this.getFoldN() > 0;
            int n2 = Contour3DLayer.this.getFoldN();
            int n3 = this.lineCount * this.pointsPerLine;
            if (n3 < 10) {
                this.calculateNormals();
                n3 = this.lineCount * this.pointsPerLine;
            }
            if (Contour3DLayer.this.axisPlot != null) {
                if (this.lastDimension != null) {
                    if (!this.lastDimension.equals(Contour3DLayer.this.axisPlot.getSize())) {
                        this.newVertices = true;
                        this.newColors = true;
                        this.lastDimension = Contour3DLayer.this.axisPlot.getSize();
                    }
                } else {
                    this.lastDimension = Contour3DLayer.this.axisPlot.getSize();
                }
            }
            if (this.newVertices) {
                int zoneSurface;
                object = Buffers.newDirectFloatBuffer((int)(3 * n3));
                floatBuffer = Buffers.newDirectFloatBuffer((int)(3 * n3));
                for (ZoneSurface object22 : Contour3DLayer.this.getRootList()) {
                    floatBuffer.put(object22.getNormalArray());
                    for (zoneSurface = 0; zoneSurface < this.pointsPerLine; ++zoneSurface) {
                        ((FloatBuffer)object).put((float)object22.getValue(zoneSurface, (byte)0));
                        ((FloatBuffer)object).put((float)object22.getValue(zoneSurface, (byte)1));
                        ((FloatBuffer)object).put((float)object22.getValue(zoneSurface, (byte)2));
                    }
                }
                ((FloatBuffer)object).flip();
                floatBuffer.flip();
                IntBuffer i = Buffers.newDirectIntBuffer((int)(2 * (this.lineCount - 1) * this.pointsPerLine));
                for (zoneSurface = 0; zoneSurface < this.lineCount - 1; ++zoneSurface) {
                    for (n = 0; n < this.pointsPerLine; ++n) {
                        i.put(zoneSurface * this.pointsPerLine + n);
                        i.put((zoneSurface + 1) * this.pointsPerLine + n);
                    }
                }
                i.flip();
                if (this.vertexBuffer[0] == 0) {
                    gL2.glGenBuffers(1, this.vertexBuffer, 0);
                }
                gL2.glBindBuffer(34962, this.vertexBuffer[0]);
                gL2.glBufferData(34962, (long)(((Buffer)object).capacity() * 4), (Buffer)object, 35044);
                if (this.normalBuffer[0] == 0) {
                    gL2.glGenBuffers(1, this.normalBuffer, 0);
                }
                gL2.glBindBuffer(34962, this.normalBuffer[0]);
                gL2.glBufferData(34962, (long)(floatBuffer.capacity() * 4), (Buffer)floatBuffer, 35044);
                if (this.indexBuffer[0] == 0) {
                    gL2.glGenBuffers(1, this.indexBuffer, 0);
                }
                gL2.glBindBuffer(34963, this.indexBuffer[0]);
                gL2.glBufferData(34963, (long)(i.capacity() * 4), (Buffer)i, 35044);
                this.newVertices = false;
            }
            if (this.newColors) {
                void var10_15;
                object = Contour3DLayer.this.createSelColor();
                floatBuffer = Buffers.newDirectFloatBuffer((int)(4 * n3));
                List<ZoneLeaf> list = Contour3DLayer.this.getRootList();
                boolean bl2 = false;
                while (var10_15 < list.size()) {
                    ZoneSurface zoneSurface = (ZoneSurface)list.get((int)var10_15);
                    for (n = 0; n < this.pointsPerLine; ++n) {
                        Color color = zoneSurface.getColor(n);
                        boolean bl3 = bl && zoneSurface.isSelected(n) || !bl && booleanArray.get(n);
                        boolean bl4 = false;
                        if (bl) {
                            bl4 = innerColumnBoolean != null && !innerColumnBoolean.getValueBool(zoneSurface.getPrimaryIndex(n) * n2 + zoneSurface.getSecondaryIndex());
                        } else {
                            boolean bl5 = bl4 = innerColumnBoolean != null && !innerColumnBoolean.getValueBool(zoneSurface.getSecondaryIndex());
                        }
                        if (!zoneSurface.isVisible(n) || !zoneSurface.getLayer(n).isLayerVisible()) {
                            floatBuffer.put(1.0f);
                            floatBuffer.put(1.0f);
                            floatBuffer.put(1.0f);
                            floatBuffer.put(0.5f);
                            continue;
                        }
                        if (bl4) {
                            floatBuffer.put(0.5f);
                            floatBuffer.put(0.5f);
                            floatBuffer.put(0.5f);
                            floatBuffer.put(1.0f);
                            continue;
                        }
                        if (bl3 && zoneSurface.isSelected()) {
                            floatBuffer.put((float)(object[0] + object[3] * (float)color.getRed() / 255.0f));
                            floatBuffer.put((float)(object[1] + object[3] * (float)color.getGreen() / 255.0f));
                            floatBuffer.put((float)(object[2] + object[3] * (float)color.getBlue() / 255.0f));
                            floatBuffer.put(1.0f);
                            continue;
                        }
                        floatBuffer.put((float)color.getRed() / 255.0f);
                        floatBuffer.put((float)color.getGreen() / 255.0f);
                        floatBuffer.put((float)color.getBlue() / 255.0f);
                        floatBuffer.put(1.0f);
                    }
                    ++var10_15;
                }
                floatBuffer.flip();
                if (this.colorBuffer[0] == 0) {
                    gL2.glGenBuffers(1, this.colorBuffer, 0);
                }
                gL2.glBindBuffer(34962, this.colorBuffer[0]);
                gL2.glBufferData(34962, (long)(floatBuffer.capacity() * 4), (Buffer)floatBuffer, 35044);
                this.newColors = false;
            }
            gL2.glEnableClientState(32884);
            gL2.glEnableClientState(32885);
            gL2.glEnableClientState(32886);
            gL2.glEnable(32823);
            gL2.glPolygonOffset(1.1f, 4.5f);
            gL2.glBindBuffer(34962, this.vertexBuffer[0]);
            gL2.glVertexPointer(3, 5126, 0, 0L);
            gL2.glBindBuffer(34962, this.colorBuffer[0]);
            gL2.glColorPointer(4, 5126, 0, 0L);
            gL2.glBindBuffer(34962, this.normalBuffer[0]);
            gL2.glNormalPointer(5126, 0, 0L);
            gL2.glBindBuffer(34963, this.indexBuffer[0]);
            int n5 = 2 * this.pointsPerLine;
            for (int i = 0; i < this.lineCount - 1; ++i) {
                gL2.glDrawElements(5, n5, 5125, (long)(i * n5 * 4));
            }
            gL2.glDisable(32823);
            gL2.glDisableClientState(32884);
            gL2.glDisableClientState(32885);
            gL2.glDisableClientState(32886);
            gL2.glBindBuffer(34962, 0);
            gL2.glBindBuffer(34963, 0);
        }
    }
}

