/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot3D.contour3D;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.gl2.GLUT;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.BooleanArray;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.common.tools3d.Camera;
import se.prediktera.map.common.tools3d.Utility;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.TickInfo;
import se.prediktera.map.plot.axisplot.ZoneArray;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot3D.FloatWindowPlot3D;
import se.prediktera.map.plot.axisplot.plot3D.contour3D.Contour3DLayer;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;

public class FloatWindowContour3D
extends FloatWindowPlot3D {
    private boolean useVbo = false;

    public FloatWindowContour3D(AbstractPlotBaseWindow abstractPlotBaseWindow, PlotInit plotInit, double d, double d2, double d3, double d4) {
        super(abstractPlotBaseWindow, plotInit, d, d2, d3, d4);
        this.selectionArray = new BooleanArray(this.getOriginalSize(this.isRowPrimary()));
    }

    public FloatWindowContour3D(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.selectionArray = randomInputStream.getSaveVersion() > 89L && mapProperty.hasProperty("selArr") ? new BooleanArray(mapProperty.getLVBooleanArray()) : new BooleanArray(this.getOriginalSize(this.isRowPrimary()));
        if (this.isSAM()) {
            this.hideComboBoxOfType((byte)9);
        }
    }

    @Override
    public AbstractAxisLayer createLayer(PlotInit plotInit, int n) {
        return new Contour3DLayer(this, plotInit, null, null, n);
    }

    @Override
    public boolean dataInfoEvent(DataInfoEvent dataInfoEvent) {
        if (this.plotAxisLayerPanel != null) {
            int n = this.plotAxisLayerPanel.getMainLayerCount();
            for (int i = 0; i < n; ++i) {
                Contour3DLayer contour3DLayer = (Contour3DLayer)this.plotAxisLayerPanel.getMainLayer(i);
                contour3DLayer.colorsChanged();
            }
        }
        return super.dataInfoEvent(dataInfoEvent);
    }

    @Override
    public boolean doInteraction(InteractionInterface interactionInterface) {
        int n = this.plotAxisLayerPanel.getMainLayerCount();
        for (int i = 0; i < n; ++i) {
            Contour3DLayer contour3DLayer = (Contour3DLayer)this.plotAxisLayerPanel.getMainLayer(i);
            contour3DLayer.colorsChanged();
        }
        return super.doInteraction(interactionInterface);
    }

    @Override
    public String getInfoAtCords(AbstractAxisLayer abstractAxisLayer, int n, int n2) {
        if (abstractAxisLayer == null) {
            abstractAxisLayer = this.getLayer(0);
        }
        ZoneArray zoneArray = (ZoneArray)this.getLeafAtIndex(abstractAxisLayer, n, n2);
        StringBuilder stringBuilder = new StringBuilder(20);
        if (zoneArray != null) {
            int n3 = zoneArray.getFirstTagged();
            stringBuilder.append(abstractAxisLayer).append("\n");
            String string = abstractAxisLayer.getComment(zoneArray);
            if (string != null) {
                stringBuilder.append(string).append("\n");
            }
            stringBuilder.append("Spectr: ").append(abstractAxisLayer.getDescription(0, (byte)1, n2)).append("\n");
            stringBuilder.append("Descr: ").append(abstractAxisLayer.getDescription(0, (byte)0, abstractAxisLayer.getPrimaryIndexArray()[n3])).append("\n");
            stringBuilder.append("X: ").append(NiceDataFormat.toString(zoneArray.getValue(n3, (byte)0))).append("\n");
            stringBuilder.append("Y: ").append(NiceDataFormat.toString(zoneArray.getValue(n3, (byte)1) + 1.0)).append("\n");
            stringBuilder.append("Z: ").append(NiceDataFormat.toString(zoneArray.getValue(n3, (byte)2))).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public double[] getMinmax(int n, int n2) {
        double[] dArray = new double[]{0.0, 0.0};
        if (this.plotAxisLayerPanel == null) {
            return dArray;
        }
        int n3 = this.plotAxisLayerPanel.getLayerCount();
        boolean bl = true;
        for (int i = 0; i < n3; ++i) {
            Contour3DLayer contour3DLayer = (Contour3DLayer)this.plotAxisLayerPanel.getLayerAtIndex(i);
            if (contour3DLayer.isSubLayer()) continue;
            List<ZoneLeaf> list = contour3DLayer.getRootList();
            for (int j = 0; j < list.size(); ++j) {
                ZoneLeaf zoneLeaf = list.get(j);
                int n4 = zoneLeaf.getNoChildren();
                for (int k = 0; k < n4; ++k) {
                    if (zoneLeaf.isMissing(k)) continue;
                    double d = zoneLeaf.getValue(k, (byte)n);
                    if (bl) {
                        dArray[0] = d;
                        dArray[1] = d;
                        bl = false;
                        continue;
                    }
                    if (dArray[0] > d) {
                        dArray[0] = d;
                        continue;
                    }
                    if (!(dArray[1] < d)) continue;
                    dArray[1] = d;
                }
            }
        }
        return dArray;
    }

    @Override
    public Point getPointAtCordsAt(AbstractAxisLayer abstractAxisLayer, Point point, int n, int n2) {
        ZoneArray zoneArray;
        if (point == null) {
            point = new Point();
        }
        if ((zoneArray = (ZoneArray)this.getLeafAtIndex(abstractAxisLayer, n, n2)) != null) {
            int n3 = zoneArray.getFirstTagged();
            int[] nArray = new int[3];
            this.translateToScreenInt(zoneArray, n3, nArray, 0);
            point.x = (int)((double)nArray[0] + this.getTryOrigoX());
            point.y = (int)((double)nArray[1] + this.getTryOrigoY());
        }
        return point;
    }

    @Override
    public int getSelectedObjectCount() {
        return this.selectionList.size() * this.selectionArray.getSetCount();
    }

    @Override
    public byte getTreeType() {
        return 7;
    }

    @Override
    public boolean handleDirectPrintout() {
        return false;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.rubberband != null && !mouseEvent.isConsumed()) {
                this.rubberbandEnded(this.rubberband, mouseEvent.getModifiersEx(), mouseEvent);
                this.rubberband.clear();
                mouseEvent.consume();
            }
            super.mouseReleased(mouseEvent);
        }
    }

    public void rubberbandEnded(AbstractRubberband abstractRubberband, int n, MouseEvent mouseEvent) {
        boolean bl;
        Rectangle rectangle = abstractRubberband.getBoundingBox();
        boolean bl2 = (n & 0x40) == 64;
        boolean bl3 = bl = (n & 0x80) == 128;
        if (abstractRubberband.getType() == AbstractRubberband.RubberAction.Selection) {
            if (!bl && !bl2) {
                this.selectedItems(this.selectionList, false, false);
            }
            LinkedList<ZoneLeaf> linkedList = this.collectRectangleFromScreen(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false, abstractRubberband.getRubberType());
            Iterator iterator = linkedList.iterator();
            int[] nArray = new int[3];
            while (iterator.hasNext()) {
                ZoneArray zoneArray = (ZoneArray)iterator.next();
                boolean bl4 = false;
                int n2 = zoneArray.getFirstTagged();
                while (n2 >= 0) {
                    this.translateToScreenInt(zoneArray, n2, nArray, 0);
                    if (!this.mustBeBoundedInSelection() || abstractRubberband.isInside(nArray[0], nArray[1])) {
                        int n3 = zoneArray.getPrimaryIndex(n2);
                        if (bl && this.selectionArray.get(n2)) {
                            if (bl2) {
                                this.selectionArray.set(n3, false);
                                zoneArray.setSelected(n2, false);
                            }
                        } else if (!(bl && bl2 || !zoneArray.isVisible(n2))) {
                            this.selectionArray.set(n3);
                            zoneArray.setSelected(n2, true);
                            if (!bl4 && !this.selectionList.contains(zoneArray)) {
                                this.selectionList.add(zoneArray);
                            }
                            bl4 = true;
                        }
                    }
                    n2 = zoneArray.getNextTagged(n2);
                }
            }
            if (this.selectionList != null && this.plot.hasInteractivity()) {
                this.plot.getPlot_GUI().getProject_GUI().doInteraction(this);
            }
            this.repaintPlot((byte)2);
        }
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyBooleanArray("selArr", this.selectionArray.getInternalArray());
    }

    @Override
    public void selectedItems(AbstractAxisPlot.SelectionList selectionList, boolean bl, boolean bl2) {
        for (ZoneArray zoneArray : selectionList) {
            zoneArray.setSelected(bl);
        }
        if (!bl) {
            for (int i = 0; i < this.selectionArray.size(); ++i) {
                this.selectionArray.set(i, false);
            }
            selectionList.clear();
        }
        int n = this.plotAxisLayerPanel.getLayerCount();
        for (int i = 0; i < n; ++i) {
            Contour3DLayer contour3DLayer = (Contour3DLayer)this.plotAxisLayerPanel.getLayerAtIndex(i);
            contour3DLayer.colorsChanged();
        }
        if (bl2 && this.selectionList != null && this.plot.hasInteractivity()) {
            this.plot.getPlot_GUI().getProject_GUI().doInteraction(this);
        }
    }

    public boolean vboEnabled() {
        return this.useVbo;
    }

    @Override
    protected LinkedList<ZoneLeaf> collectRectangleFromScreen(int n, int n2, int n3, int n4, boolean bl, AbstractRubberband.RubberType rubberType, boolean bl2, boolean bl3) {
        LinkedList<ZoneLeaf> linkedList = new LinkedList<ZoneLeaf>();
        if (this.hasVisibleLayer()) {
            int[] nArray = new int[3];
            int n5 = this.plotAxisLayerPanel.getLayerCount();
            for (int i = 0; i < n5; ++i) {
                AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getLayerAtIndex(i);
                if (abstractAxisLayer.isSubLayer() || !abstractAxisLayer.isLayerReady()) continue;
                List<ZoneLeaf> list = abstractAxisLayer.getRootList();
                for (int j = 0; j < list.size(); ++j) {
                    ZoneArray zoneArray = (ZoneArray)list.get(j);
                    boolean bl4 = false;
                    int n6 = zoneArray.getNoChildren();
                    for (int k = 0; k < n6; ++k) {
                        this.translateToScreenInt(zoneArray, k, nArray, 0);
                        if (!(!zoneArray.isVisibleAndNotMissing(k) || this.selectionArray.get(zoneArray.getPrimaryIndex(k)) && bl)) {
                            boolean bl5 = nArray[0] >= n && nArray[0] <= n + n3 && nArray[1] >= n2 && nArray[1] <= n2 + n4;
                            zoneArray.setTagged(k, bl5);
                            if (!bl5 || bl4) continue;
                            linkedList.add(zoneArray);
                            bl4 = true;
                            if (!bl2 || bl3) continue;
                            return linkedList;
                        }
                        zoneArray.setTagged(k, false);
                    }
                }
            }
        }
        return linkedList;
    }

    @Override
    protected FloatWindowPlot3D.PlotRenderer createRenderer(MapProperty mapProperty) throws IOException {
        return new Countour3dRenderer(mapProperty);
    }

    @Override
    protected void doQuickInteraction(ZoneLeaf zoneLeaf) {
        ZoneArray zoneArray = (ZoneArray)zoneLeaf;
        if (zoneArray != null) {
            int n = zoneArray.getFirstTagged();
            int n2 = this.getPrimaryMatrixTag();
            int n3 = this.plotAxisLayerPanel.getFoldN();
            if (this.isFoldMatrix()) {
                int n4 = zoneArray.getPrimaryIndex(n);
                int n5 = zoneArray.getSecondaryIndex();
                this.plot.getPlot_GUI().getProject_GUI().doQuickInteraction(this, n2, n4 * n3 + n5, 16, -1);
            } else {
                int n6 = zoneArray.getSecondaryIndex();
                int n7 = this.getSecondaryMatrixTag();
                int n8 = zoneArray.getPrimaryIndex(n);
                this.plot.getPlot_GUI().getProject_GUI().doQuickInteraction(this, n2, n6, n7, n8);
            }
        } else {
            this.plot.getPlot_GUI().getProject_GUI().doQuickInteraction(this, -1, -1, -1, -1);
        }
    }

    @Override
    protected String getToolTip(ZoneLeaf zoneLeaf) {
        if (zoneLeaf instanceof ZoneArray) {
            ZoneArray zoneArray = (ZoneArray)zoneLeaf;
            int n = zoneArray.getFirstTagged();
            AbstractAxisLayer abstractAxisLayer = zoneArray.getLayer();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
            stringBuilder.append("<tr><th colspan=\"2\">").append(abstractAxisLayer.toString()).append("</th></tr>");
            String string = abstractAxisLayer.getComment(zoneArray, "<br>");
            if (string != null) {
                stringBuilder.append("<tr><td colspan=\"2\">").append(string).append("</td></tr>");
            }
            stringBuilder.append("<tr><td>Spectr:</td><td>").append(abstractAxisLayer.getDescription(0, (byte)1, zoneArray.getSecondaryIndex())).append("</td></tr>");
            stringBuilder.append("<tr><td>Descr:</td><td>").append(abstractAxisLayer.getDescription(0, (byte)0, abstractAxisLayer.getPrimaryIndexArray()[n])).append("</td></tr>");
            stringBuilder.append("<tr><td>X:</td><td>").append(NiceDataFormat.toString(zoneArray.getValue(n, (byte)0))).append("</td></tr>");
            stringBuilder.append("<tr><td>Y:</td><td>").append(NiceDataFormat.toString(zoneArray.getValue(n, (byte)1) + 1.0)).append("</td></tr>");
            stringBuilder.append("<tr><td>Z:</td><td>").append(NiceDataFormat.toString(zoneArray.getValue(n, (byte)2))).append("</td></tr>");
            stringBuilder.append("</table></html>");
            return stringBuilder.toString();
        }
        return null;
    }

    @Override
    protected boolean hasZoneArray() {
        return true;
    }

    @Override
    protected boolean mustBeBoundedInSelection() {
        return this.plotAxisLayerPanel.getFoldN() > 0;
    }

    @Override
    protected void translateToScreenInt(ZoneArray zoneArray, int n, int[] nArray, int n2) {
        AxisRange axisRange = this.getRange(1, 0);
        int n3 = (int)axisRange.getDataMax() - 1;
        this.renderer.translateToScreenInt(zoneArray.getValue(n, (byte)0), (double)n3 - zoneArray.getValue(n, (byte)1), zoneArray.getValue(n, (byte)2), nArray);
    }

    @Override
    protected void translateToScreenInt(ZoneLeaf zoneLeaf, int[] nArray, int n) {
        AxisRange axisRange = this.getRange(1, 0);
        int n2 = (int)axisRange.getDataMax() - 1;
        this.renderer.translateToScreenInt(zoneLeaf.getValue((byte)0), (double)n2 - zoneLeaf.getValue((byte)1), zoneLeaf.getValue((byte)2), nArray);
    }

    protected class Countour3dRenderer
    extends FloatWindowPlot3D.PlotRenderer {
        public Countour3dRenderer(MapProperty mapProperty) throws IOException {
            super(mapProperty);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drawGridY(GL2 gL2, float[] fArray, float[] fArray2) {
            List<TickInfo> list;
            AxisRange axisRange = FloatWindowContour3D.this.getRange(1, 0);
            double d = axisRange.getMax();
            double d2 = axisRange.getMin();
            List<TickInfo> list2 = list = axisRange.getTickList();
            synchronized (list2) {
                for (TickInfo tickInfo : list) {
                    float f = (float)(axisRange.invTransform(d - tickInfo.pos + d2) - 0.5);
                    gL2.glColor4fv(fArray, 0);
                    gL2.glBegin(1);
                    gL2.glVertex3f(this.flipX, f, -0.5f);
                    gL2.glVertex3f(this.flipX, f, 0.5f);
                    gL2.glVertex3f(-0.5f, f, this.flipZ);
                    gL2.glVertex3f(0.5f, f, this.flipZ);
                    gL2.glVertex3f(this.flipX, f, -this.flipZ * 1.0f);
                    gL2.glVertex3f(this.flipX, f, -this.flipZ * 1.1f);
                    gL2.glEnd();
                    Utility.renderStrokeString(gL2, this.glut, this.flipX, f, -this.flipZ * 1.2f, tickInfo.text, 9, fArray2);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void paint(GL2 gL2, GLU gLU, GLUT gLUT) {
            super.paint(gL2, gLU, gLUT);
            double[] dArray = new double[]{0.0, 1.0, 0.0, 0.5};
            double[] dArray2 = new double[]{0.0, -1.0, 0.0, 0.5};
            double[] dArray3 = new double[]{1.0, 0.0, 0.0, 0.5};
            double[] dArray4 = new double[]{-1.0, 0.0, 0.0, 0.5};
            double[] dArray5 = new double[]{0.0, 0.0, 1.0, 0.5};
            double[] dArray6 = new double[]{0.0, 0.0, -1.0, 0.5};
            gL2.glPushAttrib(12288);
            gL2.glClipPlane(12288, dArray, 0);
            gL2.glClipPlane(12289, dArray2, 0);
            gL2.glClipPlane(12290, dArray3, 0);
            gL2.glClipPlane(12291, dArray4, 0);
            gL2.glClipPlane(12292, dArray5, 0);
            gL2.glClipPlane(12293, dArray6, 0);
            gL2.glEnable(12288);
            gL2.glEnable(12289);
            gL2.glEnable(12290);
            gL2.glEnable(12291);
            gL2.glEnable(12292);
            gL2.glEnable(12293);
            gL2.glDisable(2884);
            gL2.glPushMatrix();
            gL2.glTranslated(-0.5, 0.5, -0.5);
            AxisRange axisRange = FloatWindowContour3D.this.getRange(0, 0);
            AxisRange axisRange2 = FloatWindowContour3D.this.getRange(1, 0);
            AxisRange axisRange3 = FloatWindowContour3D.this.getRange(2, 0);
            gL2.glScaled(1.0 / axisRange.getAbs(), -1.0 / axisRange2.getAbs(), 1.0 / axisRange3.getAbs());
            gL2.glTranslated(-axisRange.getMin(), -axisRange2.getMin(), -axisRange3.getMin());
            if (FloatWindowContour3D.this.hasVisibleLayer()) {
                int n = FloatWindowContour3D.this.plotAxisLayerPanel.getMainLayerCount();
                for (int i = 0; i < n; ++i) {
                    Contour3DLayer contour3DLayer = (Contour3DLayer)FloatWindowContour3D.this.plotAxisLayerPanel.getMainLayer(i);
                    if (!contour3DLayer.isLayerReady()) continue;
                    InnerColumnBoolean innerColumnBoolean = FloatWindowContour3D.this.getIncludeColumn(contour3DLayer);
                    contour3DLayer.paintSurface(gL2, innerColumnBoolean, FloatWindowContour3D.this.selectionArray);
                }
            }
            gL2.glPopMatrix();
            gL2.glPopAttrib();
        }

        @Override
        public void resetView() {
            this.resetView((byte)6);
        }

        @Override
        public void resetView(byte by) {
            if (by == 0) {
                this.transfY = 0.0f;
                this.transfX = 0.0f;
                this.transfZ = -3.7f;
                this.camera = new Camera();
                this.camera.rotateView(1.3089969389957472, 1.0, 0.0, 0.0);
                this.camera.rotateView(0.4363323129985824, 0.0, 0.0, 1.0);
                this.repaintPlot(false);
            } else {
                super.resetView(by);
            }
        }

        @Override
        public void translateToScreenInt(double d, double d2, double d3, int[] nArray, AxisRange axisRange, AxisRange axisRange2, AxisRange axisRange3) {
            super.translateToScreenInt(d, d2 + axisRange2.getDataMin(), d3, nArray, axisRange, axisRange2, axisRange3);
        }

        @Override
        protected void localInit(GL2 gL2, GLU gLU) {
            gL2.glDisable(32826);
            gL2.glEnable(2977);
            boolean bl = gL2.isExtensionAvailable("GL2.GL_ARB_vertex_buffer_object");
            boolean bl2 = gL2.isFunctionAvailable("glGenBuffersARB") && gL2.isFunctionAvailable("glBindBufferARB") && gL2.isFunctionAvailable("glBufferDataARB") && gL2.isFunctionAvailable("glDeleteBuffersARB");
            FloatWindowContour3D.this.useVbo = bl && bl2;
            System.out.println("Using VBO: " + FloatWindowContour3D.this.useVbo);
            int n = FloatWindowContour3D.this.plotAxisLayerPanel.getLayerCount();
            for (int i = 0; i < n; ++i) {
                Contour3DLayer contour3DLayer = (Contour3DLayer)FloatWindowContour3D.this.plotAxisLayerPanel.getLayerAtIndex(i);
                contour3DLayer.setVboEnabled(FloatWindowContour3D.this.useVbo);
            }
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }
    }
}

