/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot3D.cube3D;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.gl2.GLUT;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot3D.Abstract3DLayer;
import se.prediktera.map.plot.axisplot.plot3D.FloatWindowPlot3D;
import se.prediktera.map.plot.axisplot.plot3D.cube3D.Cube3DLayer;
import se.prediktera.map.plot.axisplot.plot3D.cube3D.ZoneCube;
import se.prediktera.map.plot.axisplot.plot3D.scatter3D.FloatWindowScatter3D;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;

public class FloatWindowCube3D
extends FloatWindowScatter3D {
    public FloatWindowCube3D(AbstractPlotBaseWindow abstractPlotBaseWindow, PlotInit plotInit, double d, double d2, double d3, double d4) {
        super(abstractPlotBaseWindow, plotInit, d, d2, d3, d4);
    }

    public FloatWindowCube3D(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    @Override
    public AbstractAxisLayer createLayer(PlotInit plotInit, int n) {
        return new Cube3DLayer(this, plotInit, null, null, n);
    }

    @Override
    public double[] getMinmax(int n, int n2) {
        double[] dArray = new double[]{0.0, 0.0};
        if (this.plotAxisLayerPanel == null) {
            return dArray;
        }
        DataTreeInterface dataTreeInterface = this.getPlotInit().getDataTreeInterface();
        FoldMatrix foldMatrix = (FoldMatrix)dataTreeInterface;
        if (n == 0) {
            return new double[]{0.0, foldMatrix.getK()};
        }
        if (n == 1) {
            return new double[]{0.0, foldMatrix.getN()};
        }
        if (n == 2) {
            return new double[]{0.0, foldMatrix.getFoldsize()};
        }
        int n3 = this.plotAxisLayerPanel.getLayerCount();
        boolean bl = true;
        for (int i = 0; i < n3; ++i) {
            AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getLayerAtIndex(i);
            if (abstractAxisLayer.isSubLayer()) continue;
            List<ZoneLeaf> list = abstractAxisLayer.getRootList();
            for (int j = 0; j < list.size(); ++j) {
                ZoneLeaf zoneLeaf = list.get(j);
                int n4 = zoneLeaf.getNoChildren();
                for (int k = 0; k < n4; ++k) {
                    if (zoneLeaf.isMissing(k)) continue;
                    double d = zoneLeaf.getValue(k, (byte)n);
                    if (bl) {
                        dArray[0] = d;
                        dArray[1] = d;
                        bl = false;
                        continue;
                    }
                    if (dArray[0] > d) {
                        dArray[0] = d;
                        continue;
                    }
                    if (!(dArray[1] < d)) continue;
                    dArray[1] = d;
                }
            }
        }
        return dArray;
    }

    @Override
    public byte getTreeType() {
        return 20;
    }

    @Override
    protected LinkedList<ZoneLeaf> collectRectangleFromScreen(int n, int n2, int n3, int n4, boolean bl, AbstractRubberband.RubberType rubberType, boolean bl2, boolean bl3) {
        return new LinkedList<ZoneLeaf>();
    }

    @Override
    protected FloatWindowPlot3D.PlotRenderer createRenderer(MapProperty mapProperty) throws IOException {
        return new Cube3dRenderer(mapProperty);
    }

    protected class Cube3dRenderer
    extends FloatWindowScatter3D.Scatter3dRenderer {
        public Cube3dRenderer(MapProperty mapProperty) throws IOException {
            super(FloatWindowCube3D.this, mapProperty);
        }

        @Override
        protected void paintLayer(GL2 gL2, GLU gLU, GLUT gLUT, Abstract3DLayer abstract3DLayer, float f, float f2, float f3) {
            abstract3DLayer.beginCalculations();
            AxisRange axisRange = FloatWindowCube3D.this.getRange(0, 0);
            AxisRange axisRange2 = FloatWindowCube3D.this.getRange(1, 0);
            AxisRange axisRange3 = FloatWindowCube3D.this.getRange(2, 0);
            if (axisRange.getAbs() <= 0.0 || axisRange2.getAbs() <= 0.0 || axisRange3.getAbs() <= 0.0) {
                return;
            }
            this.perspectiveSize = abstract3DLayer.getPerspective(this.perspMinMax);
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = -10.0f;
            float f8 = -10.0f;
            float f9 = -10.0f;
            byte by = 0;
            int n = 0;
            Iterator<ZoneLeaf> iterator = abstract3DLayer.getLeafIterator();
            while (iterator.hasNext()) {
                ZoneLeaf zoneLeaf = iterator.next();
                if (!zoneLeaf.isVisibleAndNotMissing()) continue;
                ZoneCube zoneCube = (ZoneCube)zoneLeaf;
                double d = zoneCube.getSecondaryIndex();
                double d2 = zoneCube.getFoldIndex();
                f5 = (float)(axisRange2.invTransform(d) - 0.5);
                if ((double)f5 < -0.5 || (double)f5 > 0.5 || (double)(f6 = (float)(axisRange3.invTransform(d2) - 0.5)) < -0.5 || (double)f6 > 0.5) continue;
                int n2 = zoneCube.getNoChildren();
                for (int i = 0; i < n2; ++i) {
                    byte by2;
                    double d3;
                    if (zoneCube.isMissing(i) || (double)(f4 = (float)(axisRange.invTransform(d3 = (double)i) - 0.5)) < -0.5 || (double)f4 > 0.5 || (by2 = zoneLeaf.getSize()) <= by && Float.compare(f4, f7) == 0 && Float.compare(f5, f8) == 0 && Float.compare(f6, f9) == 0) continue;
                    n = this.paintObject(gL2, gLUT, f, f2, f3, 0, zoneLeaf, f4, f5, f6, by2, n);
                    f7 = f4;
                    by = by2;
                }
                f8 = f5;
                f9 = f6;
            }
            gL2.glColor3f(0.0f, 0.0f, 0.0f);
            abstract3DLayer.endCalculations();
        }
    }
}

