/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot3D.properties;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.plot3D.FloatWindowPlot3D;
import se.prediktera.map.plot.axisplot.plot3D.contour3D.Contour3DLayer;
import se.prediktera.map.plot.axisplot.plot3D.contour3D.FloatWindowContour3D;

public class Settings3DPanel
extends JPanel {
    private final JRadioButton radioLowRender = new JRadioButton();
    private final JRadioButton radioHighRender = new JRadioButton();
    private final ItemChanged itemChanged = new ItemChanged();
    private final JCheckBox checkLightning = new JCheckBox();
    private final JRadioButton radioMediumRender = new JRadioButton();

    public Settings3DPanel(FloatWindowPlot3D floatWindowPlot3D) {
        super(new GridLayout(2, 1, 5, 5));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.radioLowRender.setText("Low quality render (wireframe)");
        this.radioHighRender.setSelected(floatWindowPlot3D.isWireframe());
        this.radioHighRender.setText("High quality render (shading)");
        this.radioHighRender.setSelected(!floatWindowPlot3D.isFlatShade());
        this.radioHighRender.addItemListener(this.itemChanged);
        jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Render settings"));
        this.checkLightning.setSelected(floatWindowPlot3D.lightsEnabled());
        this.checkLightning.setText("Enable lighting effects");
        this.radioMediumRender.setSelected(floatWindowPlot3D.isFlatShade());
        this.radioMediumRender.setText("Medium quality render (flat)");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioLowRender);
        buttonGroup.add(this.radioHighRender);
        buttonGroup.add(this.radioMediumRender);
        this.add((Component)jPanel, null);
        jPanel.add((Component)this.radioLowRender, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)this.radioMediumRender, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)this.radioHighRender, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)this.checkLightning, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 0, new Insets(6, 30, 6, 6), 0, 0));
        this.itemChanged.itemStateChanged(null);
    }

    public void applyChanges(AbstractAxisPlot abstractAxisPlot) {
        if (abstractAxisPlot instanceof FloatWindowPlot3D) {
            FloatWindowPlot3D floatWindowPlot3D = (FloatWindowPlot3D)abstractAxisPlot;
            floatWindowPlot3D.setFlatShading(!this.isShading());
            floatWindowPlot3D.setWireFrame(this.isWireFrame());
            floatWindowPlot3D.setLights(this.isLightsEnable());
        }
        if (abstractAxisPlot instanceof FloatWindowContour3D) {
            for (int i = 0; i < abstractAxisPlot.getLayerCount(); ++i) {
                AbstractAxisLayer abstractAxisLayer = abstractAxisPlot.getLayer(i);
                if (!(abstractAxisLayer instanceof Contour3DLayer)) continue;
                ((Contour3DLayer)abstractAxisLayer).colorsChanged();
            }
        }
    }

    private boolean isLightsEnable() {
        return this.checkLightning.isSelected();
    }

    private boolean isShading() {
        return this.radioHighRender.isSelected();
    }

    private boolean isWireFrame() {
        return this.radioLowRender.isSelected();
    }

    class ItemChanged
    implements ItemListener {
        ItemChanged() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Settings3DPanel.this.checkLightning.setEnabled(!Settings3DPanel.this.radioLowRender.isSelected());
        }
    }
}

