/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot3D.scatter3D;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.gl2.GLUT;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.vecmath.Vector3d;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.tools3d.Utility;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot3D.Abstract3DLayer;
import se.prediktera.map.plot.axisplot.plot3D.FloatWindowPlot3D;
import se.prediktera.map.plot.axisplot.plot3D.Objects3D;
import se.prediktera.map.plot.axisplot.plot3D.scatter3D.Scatter3DLayer;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;
import se.prediktera.map.plot.axisplot.settings.ComboBoxAxis;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxInterface;

public class FloatWindowScatter3D
extends FloatWindowPlot3D {
    protected boolean as3d = true;

    private static final double getLeafValue(int n, AbstractDataMatrix abstractDataMatrix, int n2, int n3, boolean bl) {
        int n4 = bl ? abstractDataMatrix.getNrefOrig(n) : abstractDataMatrix.getKrefOrig(n);
        return FloatWindowScatter3D.getLeafValueOrigIndex(n4, abstractDataMatrix, n2, n3, bl);
    }

    private static final double getLeafValueOrigIndex(int n, AbstractDataMatrix abstractDataMatrix, int n2, int n3, boolean bl) {
        if (n2 == 4) {
            return n + 1;
        }
        if (n < 0) {
            return 0.0;
        }
        if (n3 < 0) {
            return n;
        }
        if (bl) {
            return abstractDataMatrix.getValue(n, n3);
        }
        return abstractDataMatrix.getValue(n3, n);
    }

    public FloatWindowScatter3D(AbstractPlotBaseWindow abstractPlotBaseWindow, PlotInit plotInit, double d, double d2, double d3, double d4) {
        super(abstractPlotBaseWindow, plotInit, d, d2, d3, d4);
    }

    public FloatWindowScatter3D(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.as3d = mapProperty.getPropertyBoolean("s3d", this.as3d);
    }

    @Override
    public AbstractAxisLayer createLayer(PlotInit plotInit, int n) {
        return new Scatter3DLayer(this, plotInit, null, null, n);
    }

    @Override
    public byte getTreeType() {
        return 4;
    }

    @Override
    public boolean handleDirectPrintout() {
        return false;
    }

    @Override
    public boolean lightsEnabled() {
        return this.as3d && !this.isrotate && super.lightsEnabled();
    }

    public void newPlot() {
    }

    public boolean renderObjectsIn3d() {
        return this.as3d;
    }

    public void renderObjectsIn3d(boolean bl) {
        this.as3d = bl;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyBoolean("s3d", this.as3d);
    }

    @Override
    public void selectNnearest(int n, int n2) {
        if (n == 2) {
            return;
        }
        Iterator iterator = this.selectionList.iterator();
        LinkedList<ZoneLeaf> linkedList = new LinkedList<ZoneLeaf>();
        AxisRange axisRange = this.getRange(0, 0);
        AxisRange axisRange2 = this.getRange(1, 0);
        AxisRange axisRange3 = this.getRange(2, 0);
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0, 0.0};
        double d = axisRange.getAbs();
        double d2 = axisRange2.getAbs();
        double d3 = axisRange3.getAbs();
        while (iterator.hasNext()) {
            ZoneLeaf zoneLeaf = (ZoneLeaf)iterator.next();
            double d4 = zoneLeaf.getValue((byte)0);
            double d5 = zoneLeaf.getValue((byte)1);
            double d6 = zoneLeaf.getValue((byte)2);
            LinkedList<ZoneLeaf> linkedList2 = null;
            for (int i = 1; i <= 10; ++i) {
                double d7 = d * (double)i * (double)i * 0.01;
                double d8 = d2 * (double)i * (double)i * 0.01;
                double d9 = d3 * (double)i * (double)i * 0.01;
                dArray[0] = d4 - d7;
                dArray[1] = d5 - d8;
                dArray[2] = d6 - d9;
                dArray2[0] = d4 + d7;
                dArray2[1] = d5 + d8;
                dArray2[2] = d6 + d9;
                linkedList2 = ((Scatter3dRenderer)this.renderer).collectRectangleFromData(dArray, dArray2, true);
                if (linkedList2.size() > n2 * 2) break;
            }
            Collections.sort(linkedList2, new SortItems(zoneLeaf));
            Iterator iterator2 = linkedList2.iterator();
            int n3 = 0;
            while (iterator2.hasNext() && n3 < n2) {
                ZoneLeaf zoneLeaf2 = (ZoneLeaf)iterator2.next();
                if (zoneLeaf2.isSelected()) continue;
                ++n3;
                linkedList.add(zoneLeaf2);
                zoneLeaf2.setSelected(true);
            }
        }
        if (n == 0) {
            this.selectedItems(this.selectionList, false, true);
        }
        this.selectionList.addAll(linkedList);
        this.repaintPlot((byte)2);
    }

    @Override
    protected void adjustToAspectRatio() {
        AxisRange axisRange = this.getRange(0, 0);
        AxisRange axisRange2 = this.getRange(1, 0);
        AxisRange axisRange3 = this.getRange(2, 0);
        double d = axisRange.getAbs();
        double d2 = axisRange2.getAbs();
        double d3 = axisRange3.getAbs();
        if (Double.compare(d, 0.0) == 0 || Double.compare(d2, 0.0) == 0 || Double.compare(d3, 0.0) == 0) {
            return;
        }
        double d4 = axisRange.getDataAbs();
        double d5 = axisRange2.getDataAbs();
        double d6 = axisRange3.getDataAbs();
        if (d4 < d) {
            axisRange.zoomAll();
            d = d4;
        }
        if (d5 < d2) {
            axisRange2.zoomAll();
            d2 = d5;
        }
        if (d6 < d3) {
            axisRange3.zoomAll();
            d3 = d6;
        }
        double d7 = Math.max(Math.max(d, d2), d3);
        axisRange.zoomNoAdjust(0.5 * d7 / d - 0.5);
        axisRange2.zoomNoAdjust(0.5 * d7 / d2 - 0.5);
        axisRange3.zoomNoAdjust(0.5 * d7 / d3 - 0.5);
        this.calculateAxisTicks((byte)0);
        this.calculateAxisTicks((byte)1);
        this.calculateAxisTicks((byte)2);
    }

    @Override
    protected LinkedList<ZoneLeaf> collectRectangleFromScreen(int n, int n2, int n3, int n4, boolean bl, AbstractRubberband.RubberType rubberType, boolean bl2, boolean bl3) {
        LinkedList<ZoneLeaf> linkedList = new LinkedList<ZoneLeaf>();
        if (this.hasVisibleLayer()) {
            AxisRange axisRange = this.getRange(0, 0);
            AxisRange axisRange2 = this.getRange(1, 0);
            AxisRange axisRange3 = this.getRange(2, 0);
            double[] dArray = new double[3];
            double[] dArray2 = new double[3];
            double[] dArray3 = new double[3];
            double[] dArray4 = new double[3];
            double[] dArray5 = new double[3];
            double[] dArray6 = new double[3];
            this.translateToPlot(n, n2, 0, dArray, axisRange, axisRange2, axisRange3);
            this.translateToPlot(n, n2 + n4, 0, dArray2, axisRange, axisRange2, axisRange3);
            this.translateToPlot(n + n3, n2, 0, dArray3, axisRange, axisRange2, axisRange3);
            this.translateToPlot(n + n3, n2 + n4, 0, dArray4, axisRange, axisRange2, axisRange3);
            this.translateToPlot(n, n2, 1, dArray5, axisRange, axisRange2, axisRange3);
            this.translateToPlot(n + n3, n2 + n4, 1, dArray6, axisRange, axisRange2, axisRange3);
            Vector3d vector3d = new Vector3d(dArray2[0] - dArray[0], dArray2[1] - dArray[1], dArray2[2] - dArray[2]);
            Vector3d vector3d2 = new Vector3d(dArray5[0] - dArray[0], dArray5[1] - dArray[1], dArray5[2] - dArray[2]);
            Vector3d vector3d3 = new Vector3d(dArray3[0] - dArray[0], dArray3[1] - dArray[1], dArray3[2] - dArray[2]);
            Vector3d vector3d4 = new Vector3d(dArray3[0] - dArray4[0], dArray3[1] - dArray4[1], dArray3[2] - dArray4[2]);
            Vector3d vector3d5 = new Vector3d(dArray2[0] - dArray4[0], dArray2[1] - dArray4[1], dArray2[2] - dArray4[2]);
            Vector3d vector3d6 = new Vector3d(dArray6[0] - dArray4[0], dArray6[1] - dArray4[1], dArray6[2] - dArray4[2]);
            Vector3d vector3d7 = new Vector3d();
            vector3d7.cross(vector3d, vector3d2);
            vector3d7.normalize();
            Vector3d vector3d8 = new Vector3d();
            vector3d8.cross(vector3d2, vector3d3);
            vector3d8.normalize();
            Vector3d vector3d9 = new Vector3d();
            vector3d9.cross(vector3d4, vector3d6);
            vector3d9.normalize();
            Vector3d vector3d10 = new Vector3d();
            vector3d10.cross(vector3d6, vector3d5);
            vector3d10.normalize();
            Vector3d vector3d11 = new Vector3d();
            double d = Double.MAX_VALUE;
            double d2 = this.renderer.getEyeX();
            double d3 = this.renderer.getEyeY();
            double d4 = this.renderer.getEyeZ();
            int n5 = this.plotAxisLayerPanel.getLayerCount();
            for (int i = 0; i < n5; ++i) {
                AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getLayerAtIndex(i);
                if (!abstractAxisLayer.isLayerVisible() || !abstractAxisLayer.isLayerReady()) continue;
                abstractAxisLayer.beginCalculations();
                ComboBoxAxis comboBoxAxis = (ComboBoxAxis)abstractAxisLayer.getSettingsBoxMap().get((byte)0);
                ComboBoxAxis comboBoxAxis2 = (ComboBoxAxis)abstractAxisLayer.getSettingsBoxMap().get((byte)1);
                ComboBoxAxis comboBoxAxis3 = (ComboBoxAxis)abstractAxisLayer.getSettingsBoxMap().get((byte)2);
                AbstractDataMatrix abstractDataMatrix = comboBoxAxis.getMatrix();
                AbstractDataMatrix abstractDataMatrix2 = comboBoxAxis2.getMatrix();
                AbstractDataMatrix abstractDataMatrix3 = comboBoxAxis3.getMatrix();
                int n6 = comboBoxAxis.getSelectedType();
                int n7 = comboBoxAxis2.getSelectedType();
                int n8 = comboBoxAxis3.getSelectedType();
                int n9 = comboBoxAxis.getAxisIndex();
                int n10 = comboBoxAxis2.getAxisIndex();
                int n11 = comboBoxAxis3.getAxisIndex();
                boolean bl4 = comboBoxAxis.getObservationTag();
                boolean bl5 = comboBoxAxis2.getObservationTag();
                boolean bl6 = comboBoxAxis3.getObservationTag();
                boolean bl7 = abstractDataMatrix == abstractDataMatrix2 && abstractDataMatrix2 == abstractDataMatrix3 && bl4 == bl5 && bl5 == bl6;
                List<ZoneLeaf> list = abstractAxisLayer.getRootList();
                for (int j = 0; j < list.size(); ++j) {
                    double d5;
                    double d6;
                    double d7;
                    ZoneLeaf zoneLeaf = list.get(j);
                    if (!zoneLeaf.isVisibleAndNotMissing() || !zoneLeaf.getLayer().isLayerVisible()) continue;
                    int n12 = zoneLeaf.getPrimaryIndex();
                    if (bl7) {
                        int n13 = bl4 ? abstractDataMatrix.getNrefOrig(n12) : abstractDataMatrix.getKrefOrig(n12);
                        d7 = FloatWindowScatter3D.getLeafValueOrigIndex(n13, abstractDataMatrix, n6, n9, bl4);
                        d6 = FloatWindowScatter3D.getLeafValueOrigIndex(n13, abstractDataMatrix2, n7, n10, bl5);
                        d5 = FloatWindowScatter3D.getLeafValueOrigIndex(n13, abstractDataMatrix3, n8, n11, bl6);
                    } else {
                        d7 = FloatWindowScatter3D.getLeafValue(n12, abstractDataMatrix, n6, n9, bl4);
                        d6 = FloatWindowScatter3D.getLeafValue(n12, abstractDataMatrix2, n7, n10, bl5);
                        d5 = FloatWindowScatter3D.getLeafValue(n12, abstractDataMatrix3, n8, n11, bl6);
                    }
                    double d8 = 0.0;
                    if (bl3) {
                        vector3d11.set(d2 - d7, d3 - d6, d4 - d5);
                        d8 = vector3d11.dot(vector3d11);
                        if (d8 >= d) continue;
                    }
                    vector3d11.set(d7 - dArray[0], d6 - dArray[1], d5 - dArray[2]);
                    vector3d11.normalize();
                    if (!(vector3d11.dot(vector3d7) > 0.0) || !(vector3d11.dot(vector3d8) > 0.0)) continue;
                    vector3d11.set(d7 - dArray4[0], d6 - dArray4[1], d5 - dArray4[2]);
                    vector3d11.normalize();
                    if (!(vector3d11.dot(vector3d9) > 0.0) || !(vector3d11.dot(vector3d10) > 0.0)) continue;
                    if (bl3) {
                        d = d8;
                        linkedList.clear();
                        linkedList.add(zoneLeaf);
                        continue;
                    }
                    linkedList.add(zoneLeaf);
                    if (!bl2) continue;
                    abstractAxisLayer.endCalculations();
                    return linkedList;
                }
                abstractAxisLayer.endCalculations();
            }
        }
        return linkedList;
    }

    @Override
    protected FloatWindowPlot3D.PlotRenderer createRenderer(MapProperty mapProperty) throws IOException {
        return new Scatter3dRenderer(mapProperty);
    }

    @Override
    protected String getToolTip(ZoneLeaf zoneLeaf) {
        if (zoneLeaf != null && zoneLeaf.getType() == 0) {
            AbstractAxisLayer abstractAxisLayer = zoneLeaf.getLayer();
            StringBuilder stringBuilder = new StringBuilder(280);
            stringBuilder.append("<html><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
            stringBuilder.append("<tr><th colspan=\"2\">").append(abstractAxisLayer.toString()).append("</th></tr>");
            String string = abstractAxisLayer.getComment(zoneLeaf, "<br>");
            if (string != null) {
                stringBuilder.append("<tr><td colspan=\"2\">").append(string).append("</td></tr>");
            }
            int n = abstractAxisLayer.getDescriptionCount();
            for (int i = 0; i < n; ++i) {
                String string2 = abstractAxisLayer.getDescriptionTitle(i);
                String string3 = abstractAxisLayer.getDescription(i, zoneLeaf);
                stringBuilder.append("<tr><td>").append(string2).append(":</td><td>");
                stringBuilder.append(string3).append("</td></tr>");
            }
            stringBuilder.append("<tr><td>X:</td><td>").append(NiceDataFormat.toString(zoneLeaf.getValue((byte)0))).append("</td></tr>");
            stringBuilder.append("<tr><td>Y:</td><td>").append(NiceDataFormat.toString(zoneLeaf.getValue((byte)1))).append("</td></tr>");
            stringBuilder.append("<tr><td>Z:</td><td>").append(NiceDataFormat.toString(zoneLeaf.getValue((byte)2))).append("</td></tr>");
            stringBuilder.append("</table></html>");
            return stringBuilder.toString();
        }
        return null;
    }

    protected class Scatter3dRenderer
    extends FloatWindowPlot3D.PlotRenderer
    implements SettingsBoxInterface {
        protected Objects3D objects3D;
        protected boolean perspectiveSize;
        protected double[] perspMinMax;

        public Scatter3dRenderer(MapProperty mapProperty) throws IOException {
            super(mapProperty);
            this.perspMinMax = new double[2];
        }

        public LinkedList<ZoneLeaf> collectRectangleFromData(double[] dArray, double[] dArray2, boolean bl) {
            LinkedList<ZoneLeaf> linkedList = new LinkedList<ZoneLeaf>();
            int n = FloatWindowScatter3D.this.plotAxisLayerPanel.getMainLayerCount();
            for (int i = 0; i < n; ++i) {
                AbstractAxisLayer abstractAxisLayer = FloatWindowScatter3D.this.plotAxisLayerPanel.getMainLayer(i);
                if (!abstractAxisLayer.isLayerReady()) continue;
                List<ZoneLeaf> list = abstractAxisLayer.getRootList();
                for (int j = 0; j < list.size(); ++j) {
                    double d;
                    double d2;
                    double d3;
                    ZoneLeaf zoneLeaf = list.get(j);
                    if (!zoneLeaf.isVisibleAndNotMissing() || bl && zoneLeaf.isSelected() || (d3 = zoneLeaf.getValue((byte)0)) < dArray[0] || d3 > dArray2[0] || (d2 = zoneLeaf.getValue((byte)1)) < dArray[1] || d2 > dArray2[1] || !((d = zoneLeaf.getValue((byte)2)) >= dArray[2]) || !(d <= dArray2[2])) continue;
                    linkedList.add(zoneLeaf);
                }
            }
            return linkedList;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        protected void localInit(GL2 gL2, GLU gLU) {
            this.objects3D = new Objects3D(gL2, FloatWindowScatter3D.this.getRootResourceNode());
            this.objects3D.glCompile2DObjects();
            this.objects3D.glCompile3DObjects();
        }

        @Override
        protected void paint(GL2 gL2, GLU gLU, GLUT gLUT) {
            super.paint(gL2, gLU, gLUT);
            if (FloatWindowScatter3D.this.hasVisibleLayer()) {
                this.paintObjects(gL2, gLU, gLUT);
            }
        }

        protected void paintLayer(GL2 gL2, GLU gLU, GLUT gLUT, Abstract3DLayer abstract3DLayer, float f, float f2, float f3) {
            double d;
            double d2;
            double d3;
            Object object;
            Object object2;
            float f4;
            float f5;
            float f6;
            InnerColumnBoolean innerColumnBoolean = FloatWindowScatter3D.this.getIncludeColumn(abstract3DLayer);
            abstract3DLayer.beginCalculations();
            AxisRange axisRange = FloatWindowScatter3D.this.getRange(0, 0);
            AxisRange axisRange2 = FloatWindowScatter3D.this.getRange(1, 0);
            AxisRange axisRange3 = FloatWindowScatter3D.this.getRange(2, 0);
            if (axisRange.getAbs() <= 0.0 || axisRange2.getAbs() <= 0.0 || axisRange3.getAbs() <= 0.0) {
                return;
            }
            ComboBoxAxis comboBoxAxis = (ComboBoxAxis)abstract3DLayer.getSettingsBoxMap().get((byte)0);
            ComboBoxAxis comboBoxAxis2 = (ComboBoxAxis)abstract3DLayer.getSettingsBoxMap().get((byte)1);
            ComboBoxAxis comboBoxAxis3 = (ComboBoxAxis)abstract3DLayer.getSettingsBoxMap().get((byte)2);
            AbstractDataMatrix abstractDataMatrix = comboBoxAxis.getMatrix();
            AbstractDataMatrix abstractDataMatrix2 = comboBoxAxis2.getMatrix();
            AbstractDataMatrix abstractDataMatrix3 = comboBoxAxis3.getMatrix();
            int n = comboBoxAxis.getSelectedType();
            int n2 = comboBoxAxis2.getSelectedType();
            int n3 = comboBoxAxis3.getSelectedType();
            int n4 = comboBoxAxis.getAxisIndex();
            int n5 = comboBoxAxis2.getAxisIndex();
            int n6 = comboBoxAxis3.getAxisIndex();
            boolean bl = comboBoxAxis.getObservationTag();
            boolean bl2 = comboBoxAxis2.getObservationTag();
            boolean bl3 = comboBoxAxis3.getObservationTag();
            boolean bl4 = abstractDataMatrix == abstractDataMatrix2 && abstractDataMatrix2 == abstractDataMatrix3 && bl == bl2 && bl2 == bl3;
            boolean bl5 = true;
            int n7 = abstract3DLayer.getDescriptionFont().getSize();
            this.perspectiveSize = abstract3DLayer.getPerspective(this.perspMinMax);
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            if (!FloatWindowScatter3D.this.isrotate && abstract3DLayer.isShowLines()) {
                gL2.glPushAttrib(12288);
                f6 = 0.0f;
                f5 = 0.0f;
                f4 = 0.0f;
                abstract3DLayer.beginLines(gL2);
                this.enableLights((GL)gL2, false);
                double[] dArray = new double[]{0.0, 1.0, 0.0, 0.5};
                double[] dArray2 = new double[]{0.0, -1.0, 0.0, 0.5};
                object2 = new double[]{1.0, 0.0, 0.0, 0.5};
                object = new double[]{-1.0, 0.0, 0.0, 0.5};
                double[] dArray3 = new double[]{0.0, 0.0, 1.0, 0.5};
                double[] dArray4 = new double[]{0.0, 0.0, -1.0, 0.5};
                gL2.glClipPlane(12288, dArray, 0);
                gL2.glClipPlane(12289, dArray2, 0);
                gL2.glClipPlane(12290, (double[])object2, 0);
                gL2.glClipPlane(12291, (double[])object, 0);
                gL2.glClipPlane(12292, dArray3, 0);
                gL2.glClipPlane(12293, dArray4, 0);
                gL2.glEnable(12288);
                gL2.glEnable(12289);
                gL2.glEnable(12290);
                gL2.glEnable(12291);
                gL2.glEnable(12292);
                gL2.glEnable(12293);
                gL2.glEnable(3042);
                gL2.glBegin(1);
                Iterator<ZoneLeaf> iterator = abstract3DLayer.getLeafIterator();
                while (iterator.hasNext()) {
                    ZoneLeaf zoneLeaf = iterator.next();
                    if (!zoneLeaf.isVisibleAndNotMissing()) continue;
                    int n8 = zoneLeaf.getPrimaryIndex();
                    if (bl4) {
                        int n9 = bl ? abstractDataMatrix.getNrefOrig(n8) : abstractDataMatrix.getKrefOrig(n8);
                        d3 = FloatWindowScatter3D.getLeafValueOrigIndex(n9, abstractDataMatrix, n, n4, bl);
                        d2 = FloatWindowScatter3D.getLeafValueOrigIndex(n9, abstractDataMatrix2, n2, n5, bl2);
                        d = FloatWindowScatter3D.getLeafValueOrigIndex(n9, abstractDataMatrix3, n3, n6, bl3);
                    } else {
                        d3 = FloatWindowScatter3D.getLeafValue(n8, abstractDataMatrix, n, n4, bl);
                        d2 = FloatWindowScatter3D.getLeafValue(n8, abstractDataMatrix2, n2, n5, bl2);
                        d = FloatWindowScatter3D.getLeafValue(n8, abstractDataMatrix3, n3, n6, bl3);
                    }
                    f7 = (float)(axisRange.invTransform(d3) - 0.5);
                    f8 = (float)(axisRange2.invTransform(d2) - 0.5);
                    f9 = (float)(axisRange3.invTransform(d) - 0.5);
                    if (!bl5) {
                        gL2.glVertex3f(f6, f5, f4);
                        gL2.glVertex3f(f7, f8, f9);
                    }
                    bl5 = false;
                    f6 = f7;
                    f5 = f8;
                    f4 = f9;
                }
                gL2.glEnd();
                this.enableLights((GL)gL2, FloatWindowScatter3D.this.lightsEnabled());
                gL2.glLineWidth(1.0f);
                gL2.glPopAttrib();
            }
            f6 = -10.0f;
            f5 = -10.0f;
            f4 = -10.0f;
            byte by = 0;
            int n10 = 0;
            object2 = abstract3DLayer.getLeafIterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!((ZoneLeaf)object).isVisibleAndNotMissing()) continue;
                int n11 = ((ZoneLeaf)object).getPrimaryIndex();
                if (bl4) {
                    n11 = bl ? abstractDataMatrix.getNrefOrig(n11) : abstractDataMatrix.getKrefOrig(n11);
                    d3 = FloatWindowScatter3D.getLeafValueOrigIndex(n11, abstractDataMatrix, n, n4, bl);
                } else {
                    d3 = FloatWindowScatter3D.getLeafValue(n11, abstractDataMatrix, n, n4, bl);
                }
                if ((double)(f7 = (float)(axisRange.invTransform(d3) - 0.5)) < -0.5 || (double)f7 > 0.5 || (double)(f8 = (float)(axisRange2.invTransform(d2 = bl4 ? FloatWindowScatter3D.getLeafValueOrigIndex(n11, abstractDataMatrix2, n2, n5, bl2) : FloatWindowScatter3D.getLeafValue(n11, abstractDataMatrix2, n2, n5, bl2)) - 0.5)) < -0.5 || (double)f8 > 0.5 || (double)(f9 = (float)(axisRange3.invTransform(d = bl4 ? FloatWindowScatter3D.getLeafValueOrigIndex(n11, abstractDataMatrix3, n3, n6, bl3) : FloatWindowScatter3D.getLeafValue(n11, abstractDataMatrix3, n3, n6, bl3)) - 0.5)) < -0.5 || (double)f9 > 0.5) continue;
                ((ZoneLeaf)object).setExcluded(innerColumnBoolean != null && !innerColumnBoolean.getValueBool(((ZoneLeaf)object).getPrimaryIndex()));
                byte by2 = ((ZoneLeaf)object).getSize();
                if (by2 <= by && Float.compare(f7, f6) == 0 && Float.compare(f8, f5) == 0 && Float.compare(f9, f4) == 0) continue;
                n10 = this.paintObject(gL2, gLUT, f, f2, f3, n7, (ZoneLeaf)object, f7, f8, f9, by2, n10);
                f6 = f7;
                f5 = f8;
                f4 = f9;
                by = by2;
            }
            gL2.glColor3f(0.0f, 0.0f, 0.0f);
            abstract3DLayer.endCalculations();
        }

        protected final int paintObject(GL2 gL2, GLUT gLUT, float f, float f2, float f3, int n, ZoneLeaf zoneLeaf, float f4, float f5, float f6, float f7, int n2) {
            String string;
            float f8;
            gL2.glPushMatrix();
            gL2.glTranslatef(f4, f5, f6);
            double d = 1.0;
            if (this.perspectiveSize) {
                float f9 = f - f4;
                f8 = f2 - f5;
                float f10 = f3 - f6;
                d = Math.sqrt(f9 * f9 + f8 * f8 + f10 * f10) / 1.42;
                d = this.perspMinMax[1] * (1.0 - d) + this.perspMinMax[0] * d;
            }
            if ((string = zoneLeaf.getDescription()).length() > 0 && !FloatWindowScatter3D.this.isrotate) {
                this.enableLights((GL)gL2, false);
                f8 = 0.002f * f7 * (float)d;
                gL2.glColor3f((float)FloatWindowScatter3D.this.axisColor.getRed() / 255.0f, (float)FloatWindowScatter3D.this.axisColor.getGreen() / 255.0f, (float)FloatWindowScatter3D.this.axisColor.getBlue() / 255.0f);
                n2 = FloatWindowScatter3D.this.axisColor.getRGB();
                gL2.glPushMatrix();
                gL2.glEnable(3042);
                Utility.billboard(gL2);
                Utility.renderStrokeString(gL2, gLUT, f8, f8, 0.0f, true, string, n, null, false);
                gL2.glDisable(3042);
                gL2.glPopMatrix();
                this.enableLights((GL)gL2, FloatWindowScatter3D.this.lightsEnabled());
            }
            int n3 = zoneLeaf.getRGB();
            if (zoneLeaf.isExcluded()) {
                f7 = 1.0f;
                n3 = Color.lightGray.getRGB();
            }
            if (n3 != n2) {
                gL2.glColor4f((float)(n3 >> 16 & 0xFF) / 255.0f, (float)(n3 >> 8 & 0xFF) / 255.0f, (float)(n3 & 0xFF) / 255.0f, (float)(n3 >> 24 & 0xFF) / 255.0f);
            }
            if (FloatWindowScatter3D.this.as3d && !FloatWindowScatter3D.this.isrotate) {
                gL2.glScaled((double)f7 * 0.1 * d, (double)f7 * 0.1 * d, (double)f7 * 0.1 * d);
                if (this.objects3D.drawObject3D(zoneLeaf.getShapeType(), zoneLeaf.isSelected())) {
                    n3 = 0;
                }
            } else {
                Utility.billboard(gL2, 10.0f * f, 10.0f * f2, 10.0f * f3, f4, f5, f6);
                gL2.glScaled((double)f7 * 0.1 * d, (double)f7 * 0.1 * d, (double)f7 * 0.1 * d);
                if (this.objects3D.drawObject(zoneLeaf.getShapeType(), zoneLeaf.isSelected())) {
                    n3 = 0;
                }
            }
            gL2.glPopMatrix();
            return n3;
        }

        private final void paintObjects(GL2 gL2, GLU gLU, GLUT gLUT) {
            float f = (float)this.getEyeX();
            float f2 = (float)this.getEyeY();
            float f3 = (float)this.getEyeZ();
            float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
            f = f * 0.71f / f4;
            f2 = f2 * 0.71f / f4;
            f3 = f3 * 0.71f / f4;
            int n = FloatWindowScatter3D.this.plotAxisLayerPanel.getLayerCount();
            for (int i = 0; i < n; ++i) {
                Abstract3DLayer abstract3DLayer = (Abstract3DLayer)FloatWindowScatter3D.this.plotAxisLayerPanel.getLayerAtIndex(i);
                if (!abstract3DLayer.isLayerVisible() || !abstract3DLayer.isLayerReady()) continue;
                this.paintLayer(gL2, gLU, gLUT, abstract3DLayer, f, f2, f3);
            }
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }
    }

    static class SortItems
    implements Comparator<ZoneLeaf> {
        private final ZoneLeaf leaf;

        public SortItems(ZoneLeaf zoneLeaf) {
            this.leaf = zoneLeaf;
        }

        @Override
        public int compare(ZoneLeaf zoneLeaf, ZoneLeaf zoneLeaf2) {
            double d = this.distSq(this.leaf, zoneLeaf);
            double d2 = this.distSq(this.leaf, zoneLeaf2);
            return Double.compare(d, d2);
        }

        public double distSq(ZoneLeaf zoneLeaf, ZoneLeaf zoneLeaf2) {
            double d = zoneLeaf.getValue((byte)0);
            double d2 = zoneLeaf.getValue((byte)1);
            double d3 = zoneLeaf.getValue((byte)2);
            double d4 = zoneLeaf2.getValue((byte)0);
            double d5 = zoneLeaf2.getValue((byte)1);
            double d6 = zoneLeaf2.getValue((byte)2);
            double d7 = d - d4;
            double d8 = d2 - d5;
            double d9 = d3 - d6;
            return d7 * d7 + d8 * d8 + d9 * d9;
        }
    }
}

