/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.swing.JFontChooser;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.windows.FloatTextWindow;

public class AxisProperties
extends JPanel {
    private static final byte TITLE = 3;
    private final LocalAxisPanel[] localAxisPanel = new LocalAxisPanel[4];
    private final JCheckBox autoScaleCheckBox = new JCheckBox("Auto Rescale");
    private final JCheckBox keepAspectCheckBox = new JCheckBox("Preserve Aspect Ratio");

    public AxisProperties(AbstractAxisPlot abstractAxisPlot) {
        super(new GridBagLayout());
        this.localAxisPanel[3] = new LocalAxisPanel(abstractAxisPlot, "Title", 3, true);
        this.localAxisPanel[0] = new LocalAxisPanel(abstractAxisPlot, "X-axis", 0, false);
        this.localAxisPanel[1] = new LocalAxisPanel(abstractAxisPlot, "Y-axis", 1, false);
        if (abstractAxisPlot.getLabelWindow((byte)2) != null) {
            this.localAxisPanel[2] = new LocalAxisPanel(abstractAxisPlot, "Z-axis", 2, true);
        }
        if (this.localAxisPanel[this.localAxisPanel.length - 1] != null) {
            this.add((Component)this.localAxisPanel[this.localAxisPanel.length - 1], new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        }
        for (int i = 0; i < this.localAxisPanel.length - 1; ++i) {
            if (this.localAxisPanel[i] == null) continue;
            this.add((Component)this.localAxisPanel[i], new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        }
        this.autoScaleCheckBox.setFont(new Font("Dialog", 0, 10));
        this.autoScaleCheckBox.setToolTipText("Automatically resize plot to show all data");
        this.autoScaleCheckBox.setSelected(abstractAxisPlot.isAutoRescale());
        this.add((Component)this.autoScaleCheckBox, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(6, 6, 6, 6), 0, 0));
        this.keepAspectCheckBox.setFont(new Font("Dialog", 0, 10));
        this.keepAspectCheckBox.setToolTipText("Preserve aspect ratio when zooming/resizing window");
        this.keepAspectCheckBox.setSelected(abstractAxisPlot.getKeepAspectRatio());
        this.add((Component)this.keepAspectCheckBox, new GridBagConstraints(1, -1, 1, 1, 1.0, 1.0, 18, 2, new Insets(6, 6, 6, 6), 0, 0));
    }

    public void applyChanges(AbstractAxisPlot abstractAxisPlot) {
        for (LocalAxisPanel localAxisPanel : this.localAxisPanel) {
            if (localAxisPanel == null) continue;
            localAxisPanel.applyChanges(abstractAxisPlot);
        }
        if (abstractAxisPlot.isAutoRescale() != this.autoScaleCheckBox.isSelected()) {
            abstractAxisPlot.setAutoRescale(this.autoScaleCheckBox.isSelected());
        }
        if (abstractAxisPlot.getKeepAspectRatio() != this.keepAspectCheckBox.isSelected()) {
            abstractAxisPlot.setKeepAspectRatio(this.keepAspectCheckBox.isSelected());
        }
    }

    public void setAxisPanelEnabled(int n, boolean bl) {
        this.localAxisPanel[n].setEnabled(bl);
    }

    private class LocalAxisPanel
    extends JPanel {
        private JTextComponent axisValue;
        private final JCheckBox checkAuto;
        private final JTextFieldButtonUppDown minValue;
        private final JTextFieldButtonUppDown maxValue;
        private final JTextFieldButtonUppDown tickDensity;
        private Font selectFont;
        private final byte type;
        private final boolean supportTickDensity;

        public LocalAxisPanel(AbstractAxisPlot abstractAxisPlot, String string, byte by, boolean bl) {
            Object object;
            FloatTextWindow floatTextWindow;
            super(new GridBagLayout());
            this.checkAuto = new JCheckBox("Auto Text");
            this.minValue = new JTextFieldButtonUppDown(true);
            this.maxValue = new JTextFieldButtonUppDown(true);
            this.tickDensity = new JTextFieldButtonUppDown(4, 0.1, 25.0, true);
            this.selectFont = null;
            this.supportTickDensity = abstractAxisPlot.supportsTickDensity(by);
            this.minValue.setRoundDoubles(false);
            this.maxValue.setRoundDoubles(false);
            this.maxValue.setDecimals(3);
            this.minValue.setDecimals(3);
            if (by == 3) {
                floatTextWindow = abstractAxisPlot.getTitleWindow();
            } else {
                floatTextWindow = abstractAxisPlot.getLabelWindow(by);
                this.setTickDensity(abstractAxisPlot.getTickDensity(by));
                object = abstractAxisPlot.getRange(by, 0);
                this.setMin(((AxisRange)object).getMin());
                this.setMax(((AxisRange)object).getMax());
            }
            this.type = by;
            if (bl) {
                this.axisValue = new JTextArea();
                ((JTextArea)this.axisValue).setRows(1);
            } else {
                this.axisValue = new JTextField();
            }
            this.tickDensity.setStepSize(0.1);
            this.setBorder(EvinceBorderFactory.createEvinceBorder(string));
            object = new Font("Dialog", 0, 10);
            JLabel jLabel = new JLabel("Name:");
            jLabel.setFont((Font)object);
            this.checkAuto.setFont((Font)object);
            this.checkAuto.addItemListener(itemEvent -> this.checkAutoStateChanged());
            if (floatTextWindow == null) {
                this.selectFont = new Font("SansSerif", 1, 25);
                this.checkAuto.setSelected(true);
            } else {
                this.checkAuto.setSelected(floatTextWindow.hasAutoText());
                this.axisValue.setText(floatTextWindow.getFloatText());
                this.selectFont = floatTextWindow.getFloatFont();
            }
            JButton jButton = new JButton("Font");
            jButton.addActionListener(actionEvent -> {
                this.selectFont = JFontChooser.showDialog(this, "Choose Font", this.selectFont, this.axisValue.getText());
            });
            this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 6, 6, 0), 0, 0));
            this.add((Component)new JScrollPane(this.axisValue, 20, 31), new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 1, new Insets(6, 6, 6, 0), 0, 0));
            this.add((Component)this.checkAuto, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 12, 6, 0), 0, 0));
            this.add((Component)jButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 12, 6, 6), 0, 0));
            if (by == 0 || by == 1 || by == 2) {
                JLabel jLabel2 = new JLabel("Min:");
                jLabel2.setFont((Font)object);
                JLabel jLabel3 = new JLabel("Max:");
                jLabel3.setFont((Font)object);
                this.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 6, 0), 0, 0));
                this.add((Component)this.minValue, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 6, 6, 0), 0, 0));
                this.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 6, 0), 0, 0));
                this.add((Component)this.maxValue, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 6, 6, 0), 0, 0));
                JPanel jPanel = new JPanel(new GridBagLayout());
                this.add((Component)jPanel, new GridBagConstraints(2, 1, 5, 2, 0.0, 0.0, 17, 1, new Insets(0, 6, 6, 0), 0, 0));
                JLabel jLabel4 = new JLabel("Tick density:");
                jLabel4.setFont((Font)object);
                jPanel.add((Component)jLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 6, 0), 0, 0));
                jPanel.add((Component)this.tickDensity, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 6, 6, 6), 0, 0));
                jLabel4.setEnabled(this.supportTickDensity);
                this.tickDensity.setEnabled(this.supportTickDensity);
            }
        }

        public void applyChanges(AbstractAxisPlot abstractAxisPlot) {
            FloatTextWindow floatTextWindow;
            if (!this.checkAuto.isSelected()) {
                if (this.type == 3) {
                    abstractAxisPlot.setTitle(this.axisValue.getText());
                } else {
                    abstractAxisPlot.setLabel(this.type, this.axisValue.getText());
                }
            }
            FloatTextWindow floatTextWindow2 = floatTextWindow = this.type == 3 ? abstractAxisPlot.getTitleWindow() : abstractAxisPlot.getLabelWindow(this.type);
            if (floatTextWindow != null) {
                floatTextWindow.setAutoText(this.checkAuto.isSelected());
                if (this.selectFont != null) {
                    floatTextWindow.setFloatFont(this.selectFont);
                    this.selectFont = null;
                }
            }
            if (this.type != 3) {
                if (this.isEnabled()) {
                    AxisRange axisRange = abstractAxisPlot.getRange(this.type, 0);
                    axisRange.setMinMax(this.getMin(), this.getMax());
                }
                abstractAxisPlot.setTickDensity(this.type, this.getTickDensity());
            }
        }

        public double getMax() {
            return this.maxValue.getNumber();
        }

        public double getMin() {
            return this.minValue.getNumber();
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.minValue.setEnabled(bl);
            this.maxValue.setEnabled(bl);
            this.tickDensity.setEnabled(this.supportTickDensity);
        }

        public void setMax(double d) {
            this.maxValue.setNumber(d);
        }

        public void setMin(double d) {
            this.minValue.setNumber(d);
        }

        private void checkAutoStateChanged() {
            this.axisValue.setEditable(!this.checkAuto.isSelected());
            if (this.checkAuto.isSelected()) {
                this.axisValue.setBackground(Color.lightGray);
            } else {
                this.axisValue.setBackground(Color.white);
            }
        }

        private double getTickDensity() {
            return this.tickDensity.getNumber();
        }

        private void setTickDensity(double d) {
            this.tickDensity.setNumber(d);
        }
    }
}

