/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.properties;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.color.ContinuousColorInterface;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.plot2D.radar.design.FloatWindowDesign;
import se.prediktera.map.plot.axisplot.plot2D.scatter.FloatWindowScatter;
import se.prediktera.map.plot.axisplot.plot2D.spectral.FloatWindowSpectral;
import se.prediktera.map.plot.axisplot.settings.Color.PlotContinuousColor;
import se.prediktera.map.plot.axisplot.settings.Color.ScalePanel;

public class GraphicsProperties
extends JPanel {
    private final JCheckBox showBorder;
    private final JCheckBox showGrids = new JCheckBox("Show grid", true);
    private final JCheckBox showTicks = new JCheckBox("Show ticks", true);
    private final JCheckBox showZeroLines = new JCheckBox("Show axis lines", true);
    private final ScalePanel backgroundColor = new ScalePanel(new PlotContinuousColor("Fixed", Color.white));
    private final ScalePanel plotBgColor = new ScalePanel(new PlotContinuousColor("Fixed", Color.white));
    private final ScalePanel gridColor = new ScalePanel(new PlotContinuousColor("Fixed", Color.lightGray));
    private final JTextFieldButtonUppDown gridWidth = new JTextFieldButtonUppDown(0.0, 100.0, true);
    private final ScalePanel axisColor = new ScalePanel(new PlotContinuousColor("Fixed", Color.black));
    private final JTextFieldButtonUppDown axisWidth = new JTextFieldButtonUppDown(0.0, 100.0, true);
    private final ScalePanel objectBorderColor = new ScalePanel(new PlotContinuousColor("Fixed", Color.black));
    private final ScalePanel zeroColor = new ScalePanel(new PlotContinuousColor("Fixed", Color.black));
    private final ScalePanel selectionColor = new ScalePanel(new PlotContinuousColor("Fixed", Color.yellow));

    public GraphicsProperties(AbstractAxisPlot abstractAxisPlot) {
        super(new BorderLayout());
        this.backgroundColor.getContinuesColor().setColor(0, abstractAxisPlot.getBackground());
        this.plotBgColor.getContinuesColor().setColor(0, abstractAxisPlot.getPlotBgColor());
        this.gridColor.getContinuesColor().setColor(0, abstractAxisPlot.getGridColor());
        this.gridWidth.setNumber(abstractAxisPlot.getGridWidth());
        this.axisColor.getContinuesColor().setColor(0, abstractAxisPlot.getAxisColor());
        this.axisWidth.setNumber(abstractAxisPlot.getAxisWidth());
        this.objectBorderColor.getContinuesColor().setColor(0, abstractAxisPlot.getObjectBorderColor());
        this.zeroColor.getContinuesColor().setColor(0, abstractAxisPlot.getZeroColor());
        this.selectionColor.getContinuesColor().setColor(0, abstractAxisPlot.getSelectionColor());
        this.showBorder = abstractAxisPlot instanceof FloatWindowScatter || abstractAxisPlot instanceof FloatWindowDesign || abstractAxisPlot instanceof FloatWindowSpectral ? new JCheckBox("Show object borders", abstractAxisPlot.showBorders()) : null;
        this.showGrids.setSelected(abstractAxisPlot.showGrid());
        this.showTicks.setSelected(abstractAxisPlot.showTicks());
        this.showZeroLines.setSelected(abstractAxisPlot.showZeroLines());
        this.jbInit();
    }

    public void applyChanges(AbstractAxisPlot abstractAxisPlot) {
        ContinuousColorInterface continuousColorInterface = this.backgroundColor.getContinuesColor();
        if (!continuousColorInterface.getColor(0).equals(abstractAxisPlot.getBackground())) {
            abstractAxisPlot.setBackground(continuousColorInterface.getColor(0));
        }
        if (!(continuousColorInterface = this.plotBgColor.getContinuesColor()).getColor(0).equals(abstractAxisPlot.getBackground())) {
            abstractAxisPlot.setPlotBgColor(continuousColorInterface.getColor(0));
        }
        if (!(continuousColorInterface = this.gridColor.getContinuesColor()).getColor(0).equals(abstractAxisPlot.getGridColor())) {
            abstractAxisPlot.setGridColor(continuousColorInterface.getColor(0));
        }
        if (this.gridWidth.getNumber() != (double)abstractAxisPlot.getGridWidth()) {
            abstractAxisPlot.setGridWidth((float)this.gridWidth.getNumber());
        }
        if (!(continuousColorInterface = this.axisColor.getContinuesColor()).getColor(0).equals(abstractAxisPlot.getAxisColor())) {
            abstractAxisPlot.setAxisColor(continuousColorInterface.getColor(0));
        }
        if (this.axisWidth.getNumber() != (double)abstractAxisPlot.getAxisWidth()) {
            abstractAxisPlot.setAxisWidth((float)this.axisWidth.getNumber());
        }
        if (!(continuousColorInterface = this.objectBorderColor.getContinuesColor()).getColor(0).equals(abstractAxisPlot.getObjectBorderColor())) {
            abstractAxisPlot.setObjectBorderColor(continuousColorInterface.getColor(0));
        }
        if (!(continuousColorInterface = this.zeroColor.getContinuesColor()).getColor(0).equals(abstractAxisPlot.getZeroColor())) {
            abstractAxisPlot.setZeroColor(continuousColorInterface.getColor(0));
        }
        if (!(continuousColorInterface = this.selectionColor.getContinuesColor()).getColor(0).equals(abstractAxisPlot.getSelectionColor())) {
            abstractAxisPlot.setSelectionColor(continuousColorInterface.getColor(0));
        }
        abstractAxisPlot.setShowBorders(this.isShowBorder());
        abstractAxisPlot.setShowGrid(this.isShowGrids());
        abstractAxisPlot.setShowTicks(this.isShowTicks());
        abstractAxisPlot.setShowZeroLines(this.isShowZeroLines());
        abstractAxisPlot.setRenderingHighQuality(true);
        abstractAxisPlot.setAntiAliasOn(true);
    }

    private boolean isShowBorder() {
        if (this.showBorder == null) {
            return true;
        }
        return this.showBorder.isSelected();
    }

    private boolean isShowGrids() {
        return this.showGrids.isSelected();
    }

    private boolean isShowTicks() {
        return this.showTicks.isSelected();
    }

    private boolean isShowZeroLines() {
        return this.showZeroLines.isSelected();
    }

    private void jbInit() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Appearance"));
        this.showGrids.setFont(new Font("Dialog", 0, 10));
        this.showTicks.setFont(new Font("Dialog", 0, 10));
        this.showZeroLines.setFont(new Font("Dialog", 0, 10));
        JPanel jPanel2 = new JPanel(new GridLayout(10, 1, 5, 5));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.backgroundColor.setBorder(BorderFactory.createEtchedBorder());
        this.plotBgColor.setBorder(BorderFactory.createEtchedBorder());
        this.gridColor.setBorder(BorderFactory.createEtchedBorder());
        this.axisColor.setBorder(BorderFactory.createEtchedBorder());
        this.objectBorderColor.setBorder(BorderFactory.createEtchedBorder());
        this.zeroColor.setBorder(BorderFactory.createEtchedBorder());
        this.selectionColor.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)jPanel, "North");
        if (this.showBorder != null) {
            this.showBorder.setFont(new Font("Dialog", 0, 10));
            jPanel2.add(this.showBorder);
        }
        jPanel2.add(this.showGrids);
        jPanel2.add(this.showTicks);
        jPanel2.add(this.showZeroLines);
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 6), 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 6), 0, 0));
        int n = 0;
        jPanel3.add((Component)new JLabel("Background:"), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 6), 0, 0));
        jPanel3.add((Component)this.backgroundColor, new GridBagConstraints(1, n++, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)new JLabel("Plot Background:"), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 0, 0, 6), 0, 0));
        jPanel3.add((Component)this.plotBgColor, new GridBagConstraints(1, n++, 2, 1, 1.0, 0.0, 10, 1, new Insets(12, 0, 0, 0), 0, 0));
        jPanel3.add((Component)new JLabel("Text:"), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 0, 0, 6), 0, 0));
        jPanel3.add((Component)this.axisColor, new GridBagConstraints(1, n++, 2, 1, 1.0, 0.0, 10, 1, new Insets(12, 0, 0, 0), 0, 0));
        jPanel3.add((Component)new JLabel("Object Border:"), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 0, 0, 6), 0, 0));
        jPanel3.add((Component)this.objectBorderColor, new GridBagConstraints(1, n++, 2, 1, 1.0, 0.0, 10, 1, new Insets(12, 0, 0, 0), 0, 0));
        jPanel3.add((Component)new JLabel("Axis Line:"), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 0, 0, 6), 0, 0));
        jPanel3.add((Component)this.zeroColor, new GridBagConstraints(1, n++, 2, 1, 1.0, 0.0, 10, 1, new Insets(12, 0, 0, 0), 0, 0));
        jPanel3.add((Component)new JLabel("Width:"), new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel3.add((Component)this.axisWidth, new GridBagConstraints(2, n++, 1, 1, 1.0, 0.0, 10, 1, new Insets(6, 0, 0, 0), 0, 0));
        jPanel3.add((Component)new JLabel("Grid:"), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 0, 0, 6), 0, 0));
        jPanel3.add((Component)this.gridColor, new GridBagConstraints(1, n++, 2, 1, 0.0, 0.0, 10, 1, new Insets(12, 0, 0, 0), 0, 0));
        jPanel3.add((Component)new JLabel("Width:"), new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel3.add((Component)this.gridWidth, new GridBagConstraints(2, n++, 1, 1, 1.0, 0.0, 10, 1, new Insets(6, 0, 0, 0), 0, 0));
        jPanel3.add((Component)new JLabel("Selection:"), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 0, 6, 6), 0, 0));
        jPanel3.add((Component)this.selectionColor, new GridBagConstraints(1, n++, 2, 1, 1.0, 0.0, 10, 1, new Insets(12, 0, 6, 0), 0, 0));
    }
}

