/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.rubberband;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;
import javax.swing.SwingUtilities;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandEllipse;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandFreehand;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandHorizontal;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandLine;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandNormal;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandRectangle;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandSimilar;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandVertical;

public abstract class AbstractRubberband {
    private static final float[] dash1 = new float[]{10.0f};
    public static final BasicStroke robberStroke = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
    protected static final BasicStroke normalStroke = new BasicStroke(1.0f, 0, 0, 10.0f);
    protected Point anchorPt = new Point(0, 0);
    protected Point stretchedPt = new Point(0, 0);
    protected Point lastPt = new Point(0, 0);
    protected Point endPt = new Point(0, 0);
    protected Component component;
    private final GeneralPath plusminus = new GeneralPath();
    private RubberAction action = RubberAction.Selection;
    private boolean firstStretch = true;
    private boolean firstPlusminus = true;
    private boolean active = false;
    private boolean mouseInside = false;
    private final Point lastMouseLocation = null;
    private Cursor cursor = Cursor.getPredefinedCursor(1);

    public AbstractRubberband(Component component) {
        this.setComponentHandle(component);
        this.component = component;
    }

    public AbstractRubberband(Component component, RubberAction rubberAction) {
        this(component);
        this.action = rubberAction;
    }

    public void anchor(Point point) {
        this.firstStretch = true;
        this.anchorPt.x = point.x;
        this.anchorPt.y = point.y;
        this.stretchedPt.x = this.lastPt.x = this.anchorPt.x;
        this.stretchedPt.y = this.lastPt.y = this.anchorPt.y;
    }

    public abstract void clear();

    public abstract void drawLast(Graphics2D var1);

    public abstract void drawNext(Graphics2D var1);

    public abstract void end();

    public void end(Point point) {
        this.lastPt.x = this.endPt.x = point.x;
        this.lastPt.y = this.endPt.y = point.y;
        Graphics2D graphics2D = (Graphics2D)this.component.getGraphics();
        if (graphics2D != null) {
            graphics2D.setStroke(robberStroke);
        }
        this.end();
        if (graphics2D != null) {
            try {
                graphics2D.setColor(this.component.getForeground());
                graphics2D.setXORMode(this.component.getBackground());
                this.drawLast(graphics2D);
            }
            finally {
                graphics2D.dispose();
            }
        }
    }

    public Point getAnchor() {
        return this.anchorPt;
    }

    public Shape getShape() {
        return this.getBoundingBox();
    }

    public Shape getShape(boolean bl) {
        Rectangle rectangle = this.getBounds();
        if (bl && (rectangle.getWidth() == 0.0 || rectangle.getHeight() == 0.0)) {
            return new Rectangle(rectangle.x, rectangle.y, 1, 1);
        }
        return this.getShape();
    }

    public abstract Rectangle getBoundingBox();

    public Rectangle getBounds() {
        return new Rectangle(this.stretchedPt.x < this.anchorPt.x ? this.stretchedPt.x : this.anchorPt.x, this.stretchedPt.y < this.anchorPt.y ? this.stretchedPt.y : this.anchorPt.y, Math.abs(this.stretchedPt.x - this.anchorPt.x), Math.abs(this.stretchedPt.y - this.anchorPt.y));
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public Point getEnd() {
        return this.endPt;
    }

    public Point getLast() {
        return this.lastPt;
    }

    public abstract RubberType getRubberType();

    public Point getStart() {
        return null;
    }

    public Point getStretched() {
        return this.stretchedPt;
    }

    public void setType(RubberAction rubberAction) {
        this.action = rubberAction;
    }

    public RubberAction getType() {
        return this.action;
    }

    public boolean isActive() {
        return this.active;
    }

    public abstract boolean isInside(int var1, int var2);

    public boolean keyPressed(KeyEvent keyEvent) {
        if (!this.mouseInside || this.lastMouseLocation == null) {
            return false;
        }
        if (!keyEvent.isConsumed()) {
            this.paintPlusMinus(keyEvent.getModifiersEx(), this.lastMouseLocation);
        }
        keyEvent.consume();
        return true;
    }

    public boolean keyReleased(KeyEvent keyEvent) {
        if (!this.mouseInside || this.lastMouseLocation == null) {
            return false;
        }
        if (!keyEvent.isConsumed()) {
            this.paintPlusMinus(keyEvent.getModifiersEx(), this.lastMouseLocation);
        }
        keyEvent.consume();
        return true;
    }

    public Rectangle lastBounds() {
        return new Rectangle(this.lastPt.x < this.anchorPt.x ? this.lastPt.x : this.anchorPt.x, this.lastPt.y < this.anchorPt.y ? this.lastPt.y : this.anchorPt.y, Math.abs(this.lastPt.x - this.anchorPt.x), Math.abs(this.lastPt.y - this.anchorPt.y));
    }

    public boolean multipleSelection() {
        return true;
    }

    public void setActive(boolean bl) {
        if (bl) {
            this.component.setCursor(this.cursor);
        } else {
            this.clear();
        }
        this.active = bl;
    }

    public void setComponentHandle(Component component) {
        this.component = component;
        this.component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (AbstractRubberband.this.isReady() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    AbstractRubberband.this.end(mouseEvent.getPoint());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                AbstractRubberband.this.mouseInside = true;
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                AbstractRubberband.this.mouseInside = false;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (AbstractRubberband.this.isReady() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    AbstractRubberband.this.anchor(mouseEvent.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (AbstractRubberband.this.isReady() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    AbstractRubberband.this.end(mouseEvent.getPoint());
                }
            }
        });
        this.component.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (!AbstractRubberband.this.isReady()) {
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && AbstractRubberband.this.isActive()) {
                    AbstractRubberband.this.stretch(mouseEvent.getPoint());
                }
            }
        });
    }

    public boolean isReady() {
        AbstractAxisPlot abstractAxisPlot;
        Component component = this.component;
        if (component instanceof AbstractAxisPlot && !(abstractAxisPlot = (AbstractAxisPlot)component).getPlotLayout().isContentReady()) {
            return false;
        }
        return this.active;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
        this.component.setCursor(cursor);
    }

    public void stretch(Point point) {
        this.lastPt.x = this.stretchedPt.x;
        this.lastPt.y = this.stretchedPt.y;
        this.stretchedPt.x = point.x;
        this.stretchedPt.y = point.y;
        Graphics2D graphics2D = (Graphics2D)this.component.getGraphics();
        if (graphics2D != null) {
            graphics2D.setStroke(robberStroke);
            try {
                graphics2D.setColor(this.component.getForeground());
                graphics2D.setXORMode(this.component.getBackground());
                if (this.firstStretch) {
                    this.firstStretch = false;
                } else {
                    this.drawLast(graphics2D);
                }
                this.drawNext(graphics2D);
            }
            finally {
                graphics2D.dispose();
            }
        }
    }

    public boolean supportHandSelection() {
        return false;
    }

    protected Point getCurPoint() {
        return this.stretchedPt;
    }

    protected Point getLastPoint() {
        return this.lastPt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintPlusMinus(int n, Point point) {
        Graphics2D graphics2D = (Graphics2D)this.component.getGraphics();
        if (graphics2D != null) {
            try {
                graphics2D.setStroke(normalStroke);
                graphics2D.setColor(this.component.getForeground());
                graphics2D.setXORMode(this.component.getBackground());
                if (this.firstPlusminus) {
                    this.firstPlusminus = false;
                } else {
                    graphics2D.draw(this.plusminus);
                }
                this.plusminus.reset();
                if ((n & 0x80) == 128) {
                    this.plusminus.moveTo(point.x + 6, point.y + 8);
                    this.plusminus.lineTo(point.x + 11, point.y + 8);
                    this.plusminus.moveTo(point.x + 8, point.y + 6);
                    this.plusminus.lineTo(point.x + 8, point.y + 7);
                    this.plusminus.moveTo(point.x + 8, point.y + 9);
                    this.plusminus.lineTo(point.x + 8, point.y + 11);
                    graphics2D.draw(this.plusminus);
                } else if ((n & 0x40) == 64) {
                    this.plusminus.moveTo(point.x + 6, point.y + 8);
                    this.plusminus.lineTo(point.x + 11, point.y + 8);
                    graphics2D.draw(this.plusminus);
                }
            }
            finally {
                graphics2D.dispose();
            }
        }
    }

    public static AbstractRubberband createRubberband(RubberType rubberType, RubberAction rubberAction, int n, Component component) {
        AbstractRubberband abstractRubberband = AbstractRubberband.createRubberband(rubberType, n, component);
        abstractRubberband.setType(rubberAction);
        return abstractRubberband;
    }

    public static AbstractRubberband createRubberband(RubberType rubberType, int n, Component component) {
        switch (rubberType.ordinal()) {
            case 0: {
                return new RubberbandEllipse(component);
            }
            case 1: {
                return new RubberbandFreehand(component);
            }
            case 5: {
                return new RubberbandHorizontal(component, (RubberbandHorizontal.RubberbandMinMax)null, RubberAction.Selection);
            }
            case 7: {
                return new RubberbandLine(component);
            }
            case 2: {
                return new RubberbandNormal(component, n, RubberAction.Selection);
            }
            case 3: {
                return new RubberbandRectangle(component);
            }
            case 6: {
                return new RubberbandSimilar(component);
            }
            case 4: {
                return new RubberbandVertical(component, (RubberbandHorizontal.RubberbandMinMax)null, RubberAction.Selection);
            }
        }
        return new RubberbandEllipse(component);
    }

    public static enum RubberAction {
        Selection,
        Zoom,
        Pan;

    }

    public static enum RubberType {
        Ellipse,
        Freehand,
        Normal,
        Rectangle,
        Vertical,
        Horizontal,
        Similar,
        Line;


        public String iconName() {
            switch (this.ordinal()) {
                case 1: {
                    return "Free";
                }
                case 2: {
                    return "Pixel";
                }
                case 3: {
                    return "Rect";
                }
            }
            return this.name();
        }
    }
}

