/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.rubberband;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;

public class RubberbandEllipse
extends AbstractRubberband {
    private Ellipse2D ellipse2D = null;

    public RubberbandEllipse(Component component) {
        super(component);
    }

    @Override
    public void clear() {
        this.ellipse2D = null;
    }

    @Override
    public void drawLast(Graphics2D graphics2D) {
        if (this.ellipse2D != null) {
            graphics2D.draw(this.ellipse2D);
        }
    }

    @Override
    public void drawNext(Graphics2D graphics2D) {
        Rectangle rectangle = this.getBounds();
        if (this.ellipse2D == null) {
            this.ellipse2D = new Ellipse2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.ellipse2D.setFrame(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics2D.draw(this.ellipse2D);
    }

    @Override
    public void end() {
    }

    @Override
    public Shape getShape() {
        return this.ellipse2D;
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.getBounds();
    }

    @Override
    public AbstractRubberband.RubberType getRubberType() {
        return AbstractRubberband.RubberType.Ellipse;
    }

    @Override
    public boolean isInside(int n, int n2) {
        if (this.ellipse2D != null) {
            return this.ellipse2D.contains(n, n2);
        }
        return false;
    }
}

