/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.rubberband;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import se.prediktera.map.plot.axisplot.plot2D.scatter.FloatWindowScatter;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;

public class RubberbandFreehand
extends AbstractRubberband {
    private final GeneralPath path = new GeneralPath();
    private final Point firstp = new Point();

    public RubberbandFreehand(Component component) {
        super(component);
    }

    @Override
    public void clear() {
        this.path.reset();
    }

    @Override
    public void drawLast(Graphics2D graphics2D) {
        Point point = this.getLastPoint();
        graphics2D.draw(this.path);
        graphics2D.drawLine(point.x, point.y, this.firstp.x, this.firstp.y);
    }

    @Override
    public void drawNext(Graphics2D graphics2D) {
        Point point = this.getCurPoint();
        if (this.path.getCurrentPoint() == null) {
            this.path.moveTo(this.anchorPt.x, this.anchorPt.y);
            this.firstp.setLocation(this.anchorPt);
        }
        this.path.lineTo(point.x, point.y);
        graphics2D.draw(this.path);
        graphics2D.drawLine(point.x, point.y, this.firstp.x, this.firstp.y);
    }

    @Override
    public void end() {
        if (this.path.getCurrentPoint() != null) {
            this.path.closePath();
        }
    }

    @Override
    public Shape getShape() {
        return this.path;
    }

    @Override
    public Rectangle getBoundingBox() {
        if (this.multipleSelection() || !this.supportHandSelection()) {
            return this.path.getBounds();
        }
        Point point = this.getCurPoint();
        return new Rectangle(point.x - 12, point.y - 12, 24, 24);
    }

    @Override
    public AbstractRubberband.RubberType getRubberType() {
        return AbstractRubberband.RubberType.Freehand;
    }

    @Override
    public boolean isInside(int n, int n2) {
        if (this.multipleSelection()) {
            return this.path.contains(n, n2);
        }
        return true;
    }

    @Override
    public boolean multipleSelection() {
        return this.path.getCurrentPoint() != null;
    }

    @Override
    public boolean supportHandSelection() {
        return this.component instanceof FloatWindowScatter;
    }
}

