/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.rubberband;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;

public class RubberbandLine
extends AbstractRubberband {
    private Point lastp = null;
    private Point firstp = null;
    private int startx;
    private int starty;
    private double cosa;
    private double sina;

    public RubberbandLine(Component component) {
        super(component);
    }

    @Override
    public void clear() {
        if (this.firstp != null) {
            this.lastp = (Point)this.firstp.clone();
            this.firstp = null;
        }
    }

    @Override
    public void drawLast(Graphics2D graphics2D) {
        if (this.firstp != null) {
            Point point = this.getLastPoint();
            graphics2D.drawLine(point.x, point.y, this.firstp.x, this.firstp.y);
        }
    }

    @Override
    public void drawNext(Graphics2D graphics2D) {
        Point point = this.getCurPoint();
        if (this.firstp == null) {
            this.firstp = new Point(this.anchorPt);
        }
        graphics2D.drawLine(point.x, point.y, this.firstp.x, this.firstp.y);
    }

    @Override
    public void end() {
    }

    @Override
    public Rectangle getBoundingBox() {
        if (this.firstp != null) {
            int n;
            int n2;
            int n3;
            int n4;
            Point point = this.getLastPoint();
            if (this.firstp.x < point.x) {
                this.startx = this.firstp.x;
                this.starty = this.firstp.y;
                n4 = point.x;
                n3 = point.y - this.starty;
            } else {
                n4 = this.firstp.x;
                this.startx = point.x;
                this.starty = point.y;
                n3 = this.firstp.y - this.starty;
            }
            int n5 = n4 - this.startx;
            if (this.firstp.y < point.y) {
                n2 = this.firstp.y;
                n = point.y;
            } else {
                n = this.firstp.y;
                n2 = point.y;
            }
            int n6 = n - n2;
            double d = Math.atan((double)(-n3) / (double)n5);
            this.cosa = Math.cos(d);
            this.sina = Math.sin(d);
            return new Rectangle(this.startx, n2, n5, n6);
        }
        return new Rectangle(0, 0);
    }

    @Override
    public AbstractRubberband.RubberType getRubberType() {
        return AbstractRubberband.RubberType.Line;
    }

    @Override
    public Point getStart() {
        return this.lastp;
    }

    @Override
    public boolean isInside(int n, int n2) {
        double d = n2 - this.starty;
        double d2 = n - this.startx;
        double d3 = Math.abs(d * this.cosa + d2 * this.sina);
        return d3 < 1.0;
    }
}

