/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings.Axis;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.datasetcontainer.AbstractDataNode;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.main.DataBrowser;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.ComboBoxRange;

public class DataSearchPanel
extends WizardPageClass {
    private final JComboBox comboDataFilter = new JComboBox();
    private final JList listData;
    private int selectedIndex;
    private final Vector<String> vectorData = new Vector();
    private AbstractPlotSettingsBox settingsBox;
    private final int plotType;
    private AbstractDataMatrix curMatrix;
    private DataBrowser dataBrowser;
    private boolean issyncing = false;

    public DataSearchPanel(AbstractPlotSettingsBox abstractPlotSettingsBox, PlotInit plotInit) {
        super(new BorderLayout());
        this.settingsBox = abstractPlotSettingsBox;
        this.plotType = plotInit.plotType;
        this.listData = UpdateHelper.Product.isRunningProductEvince() ? new JList() : null;
        Plot_GUI plot_GUI = abstractPlotSettingsBox.getPlot_GUI();
        AbstractDataNode abstractDataNode = null;
        if (plot_GUI != null && plot_GUI.getProject_GUI() != null) {
            abstractDataNode = plot_GUI.getProject_GUI().getRootNode();
        }
        this.dataBrowser = new DataBrowser((DataTreeInterface)abstractDataNode, false){

            @Override
            public boolean supportData(DataTreeInterface dataTreeInterface) {
                return dataTreeInterface instanceof AbstractDataMatrix;
            }
        };
        this.add((Component)this.createLeftPanel(), "Center");
        if (!(abstractPlotSettingsBox instanceof ComboBoxRange)) {
            this.add((Component)this.createRightPanel(), "East");
        }
        this.synchronize(abstractPlotSettingsBox.getMatrix(), 0);
    }

    public int getIndex() {
        if (this.listData != null) {
            return this.listData.getSelectedIndex();
        }
        return this.selectedIndex;
    }

    public AbstractDataMatrix getMatrix() {
        return this.curMatrix;
    }

    @Override
    public void pageShown() {
        if (this.curMatrix instanceof FoldMatrix) {
            this.dataBrowser.UpdateDataTree(((FoldMatrix)this.curMatrix).getReferencedMatrix());
        } else {
            this.dataBrowser.UpdateDataTree(this.curMatrix);
        }
        this.dataBrowser.setCreated();
    }

    public final void synchronize(AbstractDataMatrix abstractDataMatrix, int n) {
        this.issyncing = true;
        if (!this.sameAsCurrentMatrix(abstractDataMatrix)) {
            this.curMatrix = abstractDataMatrix;
            if (this.curMatrix != null) {
                if (this.settingsBox.hasSecondaryItem()) {
                    this.dataBrowser.setTagFilter(15);
                } else {
                    this.dataBrowser.setTagFilter(this.plotType);
                }
                if (this.listData != null) {
                    this.setCurMatrixIntoList();
                }
                if (this.curMatrix instanceof FoldMatrix) {
                    this.dataBrowser.ReloadDataTree(((FoldMatrix)this.curMatrix).getReferencedMatrix());
                } else {
                    this.dataBrowser.ReloadDataTree(this.curMatrix);
                }
            }
        }
        this.selectedIndex = n;
        if (this.listData != null && n >= 0 && this.listData.getSelectedIndex() != n) {
            this.listData.setSelectedIndex(n);
        }
        this.issyncing = false;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.dataBrowser != null) {
            this.dataBrowser.cleanUp();
            this.dataBrowser = null;
        }
        this.settingsBox = null;
        this.curMatrix = null;
        this.comboDataFilter.removeAllItems();
        if (this.listData != null) {
            this.listData.removeAll();
            this.vectorData.clear();
        }
    }

    private final JPanel createLeftPanel() {
        this.dataBrowser.addTreeSelectionListener(new MyTreeSelectionListener());
        this.dataBrowser.setFilterCase(true);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.comboDataFilter.setPreferredSize(new Dimension(50, 21));
        this.comboDataFilter.addItemListener(new ComboBoxListener());
        jPanel.add((Component)jPanel2, "North");
        jPanel2.add((Component)new JLabel("Show:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.comboDataFilter, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 100, 0));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().add((Component)this.dataBrowser, null);
        this.comboDataFilter.addItem("All");
        this.comboDataFilter.addItem("DataSet");
        this.comboDataFilter.addItem("Models");
        return jPanel;
    }

    private final JPanel createRightPanel() {
        JTextField jTextField = new JTextField();
        jTextField.addKeyListener(new KeyDown());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setPreferredSize(new Dimension(150, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        jPanel2.add((Component)new JLabel("Search:"), "North");
        jPanel2.add((Component)jTextField, "Center");
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().add((Component)this.listData, null);
        return jPanel;
    }

    private int findSecondaryIndex(String string) {
        for (int i = 0; i < this.vectorData.size(); ++i) {
            if (!string.equalsIgnoreCase(this.vectorData.elementAt(i))) continue;
            return i;
        }
        return -1;
    }

    private boolean sameAsCurrentMatrix(AbstractDataMatrix abstractDataMatrix) {
        if (this.curMatrix == null) {
            return abstractDataMatrix == null;
        }
        if (this.curMatrix instanceof FoldMatrix && ((FoldMatrix)this.curMatrix).getReferencedMatrix().equals(abstractDataMatrix) || abstractDataMatrix instanceof FoldMatrix && ((FoldMatrix)abstractDataMatrix).getReferencedMatrix().equals(this.curMatrix)) {
            return true;
        }
        return abstractDataMatrix.equals(this.curMatrix);
    }

    private void setCurMatrixIntoList() {
        int n = 0;
        int n2 = this.plotType;
        if (this.curMatrix.isModel() || n2 == 2) {
            n = this.curMatrix.getN();
        } else if (n2 == 1) {
            n = this.curMatrix.getK();
        }
        this.vectorData.clear();
        for (int i = 0; i < n; ++i) {
            String string = "";
            if (this.curMatrix.isModel() || n2 == 2) {
                string = this.curMatrix.getRowDescription(i, 0);
            } else if (n2 == 1) {
                string = this.curMatrix.getColumnDescription(i, 0);
            }
            this.vectorData.addElement(string);
        }
        this.listData.setListData(this.vectorData);
        this.listData.setSelectedIndex(0);
    }

    class MyTreeSelectionListener
    implements TreeSelectionListener {
        MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            AbstractDataMatrix abstractDataMatrix;
            DefaultMutableTreeNode defaultMutableTreeNode;
            Object object;
            if (!DataSearchPanel.this.issyncing && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent()).getUserObject()) instanceof AbstractDataMatrix && !DataSearchPanel.this.sameAsCurrentMatrix(abstractDataMatrix = (AbstractDataMatrix)object)) {
                DataSearchPanel.this.synchronize(abstractDataMatrix, 0);
            }
        }
    }

    class ComboBoxListener
    implements ItemListener {
        ComboBoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                switch (DataSearchPanel.this.comboDataFilter.getSelectedIndex()) {
                    case 0: {
                        DataSearchPanel.this.dataBrowser.setFilter((byte)-1);
                        break;
                    }
                    case 1: {
                        DataSearchPanel.this.dataBrowser.setFilter((byte)9);
                        break;
                    }
                    case 2: {
                        DataSearchPanel.this.dataBrowser.setFilter((byte)10);
                        break;
                    }
                }
            }
        }
    }

    class KeyDown
    extends KeyAdapter {
        KeyDown() {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            JTextField jTextField = (JTextField)keyEvent.getSource();
            int n = DataSearchPanel.this.findSecondaryIndex(jTextField.getText());
            if (n >= 0) {
                DataSearchPanel.this.selectedIndex = n;
                if (DataSearchPanel.this.listData != null) {
                    DataSearchPanel.this.listData.setSelectedIndex(n);
                }
            }
        }
    }
}

