/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings.Color;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.color.ContinuousColorInterface;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.common.wizard.PageInterface;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.ClassSettings;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.layer.AbstractAdvancedFrame;
import se.prediktera.map.main.layer.AbstractSettingsBox;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.settings.AbstractAdvanceSettings;
import se.prediktera.map.plot.axisplot.settings.AbstractClassPanel;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;
import se.prediktera.map.plot.axisplot.settings.Axis.DataSearchPanel;
import se.prediktera.map.plot.axisplot.settings.Color.AbstractColorInterface;
import se.prediktera.map.plot.axisplot.settings.Color.ColorChooserPanel;
import se.prediktera.map.plot.axisplot.settings.Color.ColorScalePanel;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;
import se.prediktera.map.plot.axisplot.settings.Color.PlotContinuousColor;
import se.prediktera.map.plot.axisplot.settings.Color.ScalePanel;
import se.prediktera.map.plot.axisplot.settings.ComboBoxColor;

public class ColorAdvanceFrame
extends AbstractAdvanceSettings
implements PageInterface {
    private FixedColorPanel fixedColorCard = null;
    private ColorScalePanel colorByNumbersCard = null;
    private ColorScalePanel colorBySecondIndexCard = null;
    private ColorScalePanel continuesColorXCard = null;
    private ColorScalePanel continuesColorYCard = null;
    private ColorScalePanel continuesColorAltCard = null;
    private ColorScalePanel continuesColorMissingCard = null;
    private ColorScalePanel continuesColorDensityCard = null;
    private ClassPanel classXCard = null;
    private ClassPanel classYCard = null;
    private ClassPanel classPCard = null;

    public ColorAdvanceFrame(AbstractPlotSettingsBox abstractPlotSettingsBox, PlotInit plotInit, List<PlotContinuousColor> list, int n, String string, boolean bl) {
        super("Advanced Color Settings", abstractPlotSettingsBox, plotInit);
        Color color = plotInit.initcolor;
        if (color == null) {
            color = PerfectSpread.generateColor(n - 1);
        }
        if (abstractPlotSettingsBox.hasMainType(1)) {
            this.fixedColorCard = new FixedColorPanel(color);
        }
        if (abstractPlotSettingsBox.hasMainType(4)) {
            this.colorByNumbersCard = new ColorScalePanel(list, string, bl);
        }
        if (abstractPlotSettingsBox.hasMainType(18)) {
            this.colorBySecondIndexCard = new ColorScalePanel(list, string, bl);
        }
        if (abstractPlotSettingsBox.hasMainType(0)) {
            this.continuesColorXCard = new ColorScalePanel(list, string, bl);
        }
        if (abstractPlotSettingsBox.hasMainType(100)) {
            this.continuesColorYCard = new ColorScalePanel(list, string, bl);
        }
        if (abstractPlotSettingsBox.hasMainType(11)) {
            this.continuesColorAltCard = new ColorScalePanel(list, string, bl);
        }
        if (abstractPlotSettingsBox.hasMainType(14)) {
            this.continuesColorMissingCard = new ColorScalePanel(list, string, bl);
        }
        if (abstractPlotSettingsBox.hasMainType(8)) {
            this.continuesColorDensityCard = new ColorScalePanel(list, true, string, bl);
        }
        if (abstractPlotSettingsBox.hasMainType(7)) {
            this.classXCard = new ClassPanel(list, true, abstractPlotSettingsBox.getDataInfoFromAxis(0));
        }
        if (abstractPlotSettingsBox.hasMainType(101)) {
            this.classYCard = new ClassPanel(list, false, abstractPlotSettingsBox.getDataInfoFromAxis(1));
        }
        if (abstractPlotSettingsBox.hasMainType(19)) {
            this.classPCard = new ClassPanel(list, true, abstractPlotSettingsBox.getDataInfoFromAxis(0));
        }
        this.dataSearchPanel = new DataSearchPanel(abstractPlotSettingsBox, plotInit);
        this.jbInit();
    }

    public ColorAdvanceFrame(MapProperty mapProperty, AbstractPlotSettingsBox abstractPlotSettingsBox, PlotInit plotInit, List<PlotContinuousColor> list) throws IOException {
        super("Advanced Color Settings", abstractPlotSettingsBox, plotInit);
        String string = mapProperty.getPrefix();
        if (abstractPlotSettingsBox.hasMainType(1)) {
            mapProperty.setPrefix(string + "cf");
            this.fixedColorCard = new FixedColorPanel(mapProperty);
        }
        if (abstractPlotSettingsBox.hasMainType(4)) {
            mapProperty.setPrefix(string + "cbn");
            this.colorByNumbersCard = new ColorScalePanel(mapProperty, list);
        }
        if (abstractPlotSettingsBox.hasMainType(18)) {
            mapProperty.setPrefix(string + "cbsi");
            this.colorBySecondIndexCard = new ColorScalePanel(mapProperty, list);
        }
        if (abstractPlotSettingsBox.hasMainType(0)) {
            mapProperty.setPrefix(string + "ccx");
            this.continuesColorXCard = new ColorScalePanel(mapProperty, list);
        }
        if (abstractPlotSettingsBox.hasMainType(100)) {
            mapProperty.setPrefix(string + "ccy");
            this.continuesColorYCard = new ColorScalePanel(mapProperty, list);
        }
        if (abstractPlotSettingsBox.hasMainType(11)) {
            mapProperty.setPrefix(string + "cca");
            this.continuesColorAltCard = new ColorScalePanel(mapProperty, list);
        }
        if (abstractPlotSettingsBox.hasMainType(14)) {
            mapProperty.setPrefix(string + "ccm");
            this.continuesColorMissingCard = new ColorScalePanel(mapProperty, list);
        }
        if (abstractPlotSettingsBox.hasMainType(8)) {
            mapProperty.setPrefix(string + "ccd");
            this.continuesColorDensityCard = new ColorScalePanel(mapProperty, list, true);
        }
        if (abstractPlotSettingsBox.hasMainType(7)) {
            mapProperty.setPrefix(string + "clx");
            this.classXCard = new ClassPanel(list, mapProperty, true, abstractPlotSettingsBox.getDataInfoFromAxis(0));
        }
        if (abstractPlotSettingsBox.hasMainType(101)) {
            mapProperty.setPrefix(string + "cly");
            this.classYCard = new ClassPanel(list, mapProperty, false, abstractPlotSettingsBox.getDataInfoFromAxis(1));
        }
        if (abstractPlotSettingsBox.hasMainType(19)) {
            mapProperty.setPrefix(string + "clp");
            this.classPCard = new ClassPanel(list, mapProperty, true, abstractPlotSettingsBox.getDataInfoFromAxis(0));
        }
        mapProperty.setPrefix(string + "cd");
        this.dataSearchPanel = new DataSearchPanel(abstractPlotSettingsBox, plotInit);
        mapProperty.setPrefix(string);
        this.jbInit();
    }

    public void changeFixedColor(Color color) {
        if (this.fixedColorCard != null) {
            this.fixedColorCard.setFixedColor(color);
            this.fixedColorCard.repaint();
            this.settingsCardPanel.setSelected(1);
            this.applyChanges();
        }
    }

    public void copySettings(AbstractAdvancedFrame abstractAdvancedFrame) {
        ColorAdvanceFrame colorAdvanceFrame = (ColorAdvanceFrame)abstractAdvancedFrame;
        if (this.fixedColorCard != null && colorAdvanceFrame.fixedColorCard != null) {
            this.fixedColorCard.setFixedColor(colorAdvanceFrame.fixedColorCard.colorChooser.getColor());
        }
        if (this.colorByNumbersCard != null && colorAdvanceFrame.colorByNumbersCard != null) {
            this.colorByNumbersCard.copySettings(colorAdvanceFrame.colorByNumbersCard);
        }
        if (this.colorBySecondIndexCard != null && colorAdvanceFrame.colorBySecondIndexCard != null) {
            this.colorBySecondIndexCard.copySettings(colorAdvanceFrame.colorBySecondIndexCard);
        }
        if (this.continuesColorXCard != null && colorAdvanceFrame.continuesColorXCard != null) {
            this.continuesColorXCard.copySettings(colorAdvanceFrame.continuesColorXCard);
        }
        if (this.continuesColorYCard != null && colorAdvanceFrame.continuesColorYCard != null) {
            this.continuesColorYCard.copySettings(colorAdvanceFrame.continuesColorYCard);
        }
        if (this.continuesColorAltCard != null && colorAdvanceFrame.continuesColorAltCard != null) {
            this.continuesColorAltCard.copySettings(colorAdvanceFrame.continuesColorAltCard);
        }
        if (this.continuesColorMissingCard != null && colorAdvanceFrame.continuesColorMissingCard != null) {
            this.continuesColorMissingCard.copySettings(colorAdvanceFrame.continuesColorMissingCard);
        }
        if (this.continuesColorDensityCard != null && colorAdvanceFrame.continuesColorDensityCard != null) {
            this.continuesColorDensityCard.copySettings(colorAdvanceFrame.continuesColorDensityCard);
        }
        if (this.classXCard != null && colorAdvanceFrame.classXCard != null) {
            this.classXCard.copySettings(colorAdvanceFrame.classXCard);
        }
        if (this.classYCard != null && colorAdvanceFrame.classYCard != null) {
            this.classYCard.copySettings(colorAdvanceFrame.classYCard);
        }
        if (this.classPCard != null && colorAdvanceFrame.classPCard != null) {
            this.classPCard.copySettings(colorAdvanceFrame.classPCard);
        }
        this.applyChanges();
    }

    public ContinuousColorInterface getContinuesColor() {
        if (this.settingsCardPanel == null || !(this.settingsCardPanel.getSelectedPanel() instanceof AbstractColorInterface)) {
            return new PlotContinuousColor("Error", Color.red);
        }
        return ((AbstractColorInterface)((Object)this.settingsCardPanel.getSelectedPanel())).getContinuesColor();
    }

    public double[] getContinuesMinMax() {
        if (this.settingsCardPanel == null || !(this.settingsCardPanel.getSelectedPanel() instanceof AbstractColorInterface)) {
            return null;
        }
        return ((AbstractColorInterface)((Object)this.settingsCardPanel.getSelectedPanel())).getContinuesMinMax();
    }

    public Color getFixedColor() {
        return this.fixedColorCard.getContinuesColor().getColor(0);
    }

    public double getMaxScale() {
        return ((ColorScalePanel)this.settingsCardPanel.getSelectedPanel()).getMaxScale();
    }

    public double getMinScale() {
        return ((ColorScalePanel)this.settingsCardPanel.getSelectedPanel()).getMinScale();
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        JPanel jPanel = this.settingsCardPanel.getSelectedPanel();
        if (jPanel instanceof ColorScalePanel) {
            ((ColorScalePanel)jPanel).addProperties(properties);
        } else if (jPanel instanceof ClassPanel) {
            ((ClassPanel)jPanel).addProperties(properties);
        }
        return properties;
    }

    public boolean hasAutoScale() {
        return ((ColorScalePanel)this.settingsCardPanel.getSelectedPanel()).hasAutoScale();
    }

    @Override
    public void pageShown() {
        if (this.classXCard != null) {
            this.classXCard.pageShown();
        }
        if (this.classYCard != null) {
            this.classYCard.pageShown();
        }
        if (this.classPCard != null) {
            this.classPCard.pageShown();
        }
    }

    @Override
    public void Save(RandomOutputStream randomOutputStream) throws IOException {
        String string = randomOutputStream.getPrefix();
        if (this.fixedColorCard != null) {
            randomOutputStream.setPrefix(string + "cf");
            this.fixedColorCard.save(randomOutputStream);
        }
        if (this.colorByNumbersCard != null) {
            randomOutputStream.setPrefix(string + "cbn");
            this.colorByNumbersCard.Save(randomOutputStream);
        }
        if (this.colorBySecondIndexCard != null) {
            randomOutputStream.setPrefix(string + "cbsi");
            this.colorBySecondIndexCard.Save(randomOutputStream);
        }
        if (this.continuesColorXCard != null) {
            randomOutputStream.setPrefix(string + "ccx");
            this.continuesColorXCard.Save(randomOutputStream);
        }
        if (this.continuesColorYCard != null) {
            randomOutputStream.setPrefix(string + "ccy");
            this.continuesColorYCard.Save(randomOutputStream);
        }
        if (this.continuesColorAltCard != null) {
            randomOutputStream.setPrefix(string + "cca");
            this.continuesColorAltCard.Save(randomOutputStream);
        }
        if (this.continuesColorMissingCard != null) {
            randomOutputStream.setPrefix(string + "ccm");
            this.continuesColorMissingCard.Save(randomOutputStream);
        }
        if (this.continuesColorDensityCard != null) {
            randomOutputStream.setPrefix(string + "ccd");
            this.continuesColorDensityCard.Save(randomOutputStream);
        }
        if (this.classXCard != null) {
            randomOutputStream.setPrefix(string + "clx");
            this.classXCard.Save(randomOutputStream);
        }
        if (this.classYCard != null) {
            randomOutputStream.setPrefix(string + "cly");
            this.classYCard.Save(randomOutputStream);
        }
        if (this.classPCard != null) {
            randomOutputStream.setPrefix(string + "clp");
            this.classPCard.Save(randomOutputStream);
        }
        randomOutputStream.setPrefix(string);
    }

    public void setContinuousColor(ContinuousColorInterface continuousColorInterface) {
        JPanel jPanel = this.settingsCardPanel.getSelectedPanel();
        if (jPanel instanceof ColorScalePanel) {
            ((ColorScalePanel)jPanel).setContinuousColor(continuousColorInterface);
        }
    }

    public void setContinuousColor(int n, int n2) throws Exception {
        if (n == 11 && this.continuesColorAltCard != null) {
            this.continuesColorAltCard.setContinouesColorIndex(n2);
        } else if (n == 8 && this.continuesColorDensityCard != null) {
            this.continuesColorDensityCard.setContinouesColorIndex(n2);
        } else if (n == 4 && this.colorByNumbersCard != null) {
            this.colorByNumbersCard.setContinouesColorIndex(n2);
        } else if (n == 18 && this.colorBySecondIndexCard != null) {
            this.colorBySecondIndexCard.setContinouesColorIndex(n2);
        }
    }

    public void setProperties(Properties properties) {
        JPanel jPanel = this.settingsCardPanel.getSelectedPanel();
        if (jPanel instanceof ColorScalePanel) {
            ((ColorScalePanel)jPanel).setProperties(properties);
            this.applyChanges();
        } else if (jPanel instanceof ClassPanel) {
            ((ClassPanel)jPanel).setProperties(properties);
            this.applyChanges();
        }
    }

    public void setScale(double d, double d2) {
        ColorScalePanel colorScalePanel = (ColorScalePanel)this.settingsCardPanel.getSelectedPanel();
        colorScalePanel.setMinScale(d);
        colorScalePanel.setMaxScale(d2);
    }

    public void setScale(int n, boolean bl, double d, double d2) {
        if (n == 11) {
            this.continuesColorAltCard.setAutoScale(false);
            this.continuesColorAltCard.setMinScale(d);
            this.continuesColorAltCard.setMaxScale(d2);
        }
    }

    @Override
    public void SyncronizeComboBox(AbstractDataMatrix abstractDataMatrix, int n, int n2) {
        this.dataSearchPanel.synchronize(abstractDataMatrix, n2);
        if (7 == n) {
            this.classXCard.setClassIndex(n, n2);
        } else if (101 == n) {
            this.classYCard.setClassIndex(n, n2);
        } else if (19 == n) {
            this.classPCard.setClassIndex(n, n2);
        } else if (0 == n || 100 == n) {
            this.dataSearchPanel.synchronize(abstractDataMatrix, n2);
        } else if (1 == n) {
            this.fixedColorCard.setFixedColor(((ComboBoxColor)this.settingsBox).getFixedColor());
        }
        this.settingsCardPanel.setSelected(n);
    }

    @Override
    protected void applyChanges() {
        int n = this.settingsCardPanel.getSelected();
        int n2 = 0;
        if (n == 1) {
            ComboBoxColor comboBoxColor = (ComboBoxColor)this.settingsBox;
            comboBoxColor.setContinuesColor(this.fixedColorCard.getContinuesColor());
        } else if (n == 7) {
            this.settingsBox.setMatrix(this.dataSearchPanel.getMatrix(), false);
            n2 = this.classXCard.getClassIndex();
        } else if (n == 101) {
            this.settingsBox.setMatrix(this.dataSearchPanel.getMatrix(), false);
            n2 = this.classYCard.getClassIndex();
        } else if (n == 19) {
            this.settingsBox.setMatrix(this.dataSearchPanel.getMatrix(), false);
            n2 = this.classPCard.getClassIndex();
        } else if (n == 0 || n == 100) {
            this.settingsBox.setMatrix(this.dataSearchPanel.getMatrix(), false);
            n2 = this.dataSearchPanel.getIndex();
        }
        this.settingsBox.setSelected(n, n2);
        this.setDefaultSelectionColor(this.settingsBox);
        if (this.fixedColorCard != null) {
            this.fixedColorCard.resetPreview();
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.dataSearchPanel != null) {
            this.dataSearchPanel.cleanUp();
            this.dataSearchPanel = null;
        }
        if (this.fixedColorCard != null) {
            this.fixedColorCard.cleanUp();
            this.fixedColorCard = null;
        }
        if (this.colorByNumbersCard != null) {
            this.colorByNumbersCard.cleanUp();
            this.colorByNumbersCard = null;
        }
        if (this.colorBySecondIndexCard != null) {
            this.colorBySecondIndexCard.cleanUp();
            this.colorBySecondIndexCard = null;
        }
        if (this.continuesColorXCard != null) {
            this.continuesColorXCard.cleanUp();
            this.continuesColorXCard = null;
        }
        if (this.continuesColorYCard != null) {
            this.continuesColorYCard.cleanUp();
            this.continuesColorYCard = null;
        }
        if (this.continuesColorAltCard != null) {
            this.continuesColorAltCard.cleanUp();
            this.continuesColorAltCard = null;
        }
        if (this.continuesColorMissingCard != null) {
            this.continuesColorMissingCard.cleanUp();
            this.continuesColorMissingCard = null;
        }
        if (this.continuesColorDensityCard != null) {
            this.continuesColorDensityCard.cleanUp();
            this.continuesColorDensityCard = null;
        }
        if (this.classXCard != null) {
            this.classXCard.cleanUp();
            this.classXCard = null;
        }
        if (this.classYCard != null) {
            this.classYCard.cleanUp();
            this.classYCard = null;
        }
        if (this.classPCard != null) {
            this.classPCard.cleanUp();
            this.classPCard = null;
        }
    }

    private void jbInit() {
        Object object;
        this.settingsTabbed.addTab("Color", this.settingsCardPanel);
        int n = this.settingsBox.getItemCount();
        block13: for (int i = 0; i < n && (object = this.settingsBox.getItemAt(i)) instanceof ComboItem; ++i) {
            ComboItem comboItem = (ComboItem)object;
            if (!((ComboItem)object).isMainitem()) break;
            switch (comboItem.getType()) {
                case 1: {
                    this.settingsCardPanel.addRadioButton("Fixed Color", 1, this.fixedColorCard);
                    continue block13;
                }
                case 4: {
                    this.settingsCardPanel.addRadioButton(this.settingsBox.getNiceMainString(4), 4, this.colorByNumbersCard);
                    continue block13;
                }
                case 18: {
                    this.settingsCardPanel.addRadioButton(this.settingsBox.getNiceMainString(18), 18, this.colorBySecondIndexCard);
                    continue block13;
                }
                case 0: {
                    this.settingsCardPanel.addRadioButton(this.settingsBox.getNiceMainString(0), 0, this.continuesColorXCard);
                    continue block13;
                }
                case 100: {
                    this.settingsCardPanel.addRadioButton(this.settingsBox.getNiceMainString(100), 100, this.continuesColorYCard);
                    continue block13;
                }
                case 7: {
                    this.settingsCardPanel.addRadioButton(this.settingsBox.getNiceMainString(7), 7, this.classXCard);
                    continue block13;
                }
                case 101: {
                    this.settingsCardPanel.addRadioButton(this.settingsBox.getNiceMainString(101), 101, this.classYCard);
                    continue block13;
                }
                case 19: {
                    this.settingsCardPanel.addRadioButton(this.settingsBox.getNiceMainString(19), 19, this.classPCard);
                    continue block13;
                }
                case 8: {
                    this.settingsCardPanel.addRadioButton(this.settingsBox.getNiceMainString(8), 8, this.continuesColorDensityCard);
                    continue block13;
                }
                case 11: {
                    this.settingsCardPanel.addRadioButton(this.settingsBox.getNiceMainString(11), 11, this.continuesColorAltCard);
                    continue block13;
                }
                case 14: {
                    this.settingsCardPanel.addRadioButton(this.settingsBox.getNiceMainString(14), 14, this.continuesColorMissingCard);
                }
            }
        }
        this.settingsTabbed.addTab("Color Source", this.dataSearchPanel);
    }

    private void setDefaultSelectionColor(AbstractSettingsBox abstractSettingsBox) {
        if (abstractSettingsBox instanceof ComboBoxColor) {
            ComboBoxColor comboBoxColor = (ComboBoxColor)abstractSettingsBox;
            Color color = this.getContinuesColor().getSelectionColor();
            if (color != null) {
                comboBoxColor.getLayer().getAxisPlot().setSelectionColor(color);
            }
        }
    }

    private class FixedColorPanel
    extends AbstractSettingsPanel
    implements AbstractColorInterface {
        private final PlotContinuousColor continuesColor;
        private JColorChooser colorChooser;

        public FixedColorPanel(Color color) {
            this.continuesColor = new PlotContinuousColor("Fixed", color);
            this.init();
        }

        public FixedColorPanel(MapProperty mapProperty) throws IOException {
            this.continuesColor = new PlotContinuousColor(mapProperty);
            this.init();
        }

        @Override
        public ContinuousColorInterface getContinuesColor() {
            if (this.colorChooser != null) {
                this.continuesColor.setColor(0, this.colorChooser.getColor());
            }
            return this.continuesColor;
        }

        @Override
        public double[] getContinuesMinMax() {
            return null;
        }

        public void resetPreview() {
            if (this.colorChooser != null) {
                this.colorChooser.setPreviewPanel(null);
                this.colorChooser.revalidate();
            }
        }

        public void save(RandomOutputStream randomOutputStream) throws IOException {
            this.continuesColor.Save(randomOutputStream);
        }

        public void setFixedColor(Color color) {
            if (this.colorChooser != null) {
                this.colorChooser.setColor(color);
            }
        }

        private void init() {
            if (UpdateHelper.Product.isRunningProductEvince()) {
                this.colorChooser = new JColorChooser();
                AbstractColorChooserPanel[] abstractColorChooserPanelArray = this.colorChooser.getChooserPanels();
                AbstractColorChooserPanel[] abstractColorChooserPanelArray2 = new AbstractColorChooserPanel[abstractColorChooserPanelArray.length];
                for (int i = 0; i < abstractColorChooserPanelArray.length; ++i) {
                    abstractColorChooserPanelArray2[i] = abstractColorChooserPanelArray[i].toString().startsWith("javax.swing.colorchooser.DefaultSwatchChooserPanel") ? new ColorChooserPanel() : abstractColorChooserPanelArray[i];
                }
                this.colorChooser.setChooserPanels(abstractColorChooserPanelArray2);
                if (this.continuesColor.getNrColors() > 0) {
                    this.colorChooser.setColor(this.continuesColor.getColor(0));
                }
                this.removeScrolling();
                this.setPreferredSize(new Dimension(380, 400));
                this.centerPanel.add((Component)this.colorChooser, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 6, 6, 6), 0, 0));
            }
        }
    }

    private class ClassPanel
    extends AbstractClassPanel
    implements AbstractColorInterface {
        private final PlotContinuousColor classColorScale;
        private final Vector<ScalePanel> classColors;
        private final ItemSelector itemSelector;
        private final JComboBox boxAutocolor;
        private final List<PlotContinuousColor> colorScales;
        private final JCheckBox checkReverse;
        private final JCheckBox checkIndex;
        private final JButton transferColorButton;
        private boolean updateColors;
        private final boolean isPrimary;

        public ClassPanel(List<PlotContinuousColor> list, boolean bl, AbstractDataInfo abstractDataInfo) {
            super(abstractDataInfo);
            this.classColorScale = new PlotContinuousColor("category", Color.red);
            this.classColors = new Vector();
            this.itemSelector = new ItemSelector();
            this.boxAutocolor = new JComboBox();
            this.checkReverse = new JCheckBox("Reverse colors", false);
            this.checkIndex = new JCheckBox("By index (1,2,3...)", false);
            this.transferColorButton = new JButton("Transfer plot color settings to category");
            this.updateColors = true;
            this.isPrimary = bl;
            this.colorScales = list;
            this.setItemSelector(this.itemSelector);
            this.init(0);
        }

        public ClassPanel(List<PlotContinuousColor> list, MapProperty mapProperty, boolean bl, AbstractDataInfo abstractDataInfo) throws IOException {
            int n;
            super(mapProperty, abstractDataInfo);
            this.classColorScale = new PlotContinuousColor("category", Color.red);
            this.classColors = new Vector();
            this.itemSelector = new ItemSelector();
            this.boxAutocolor = new JComboBox();
            this.checkReverse = new JCheckBox("Reverse colors", false);
            this.checkIndex = new JCheckBox("By index (1,2,3...)", false);
            this.transferColorButton = new JButton("Transfer plot color settings to category");
            this.updateColors = true;
            this.isPrimary = bl;
            this.colorScales = list;
            this.setItemSelector(this.itemSelector, true);
            PlotContinuousColor plotContinuousColor = new PlotContinuousColor(mapProperty);
            int n2 = Math.min(this.classColors.size(), plotContinuousColor.getNrColors());
            for (n = 0; n < n2; ++n) {
                this.classColors.elementAt(n).setContinuesColor(new PlotContinuousColor("Fixed", plotContinuousColor.getColor(n)));
            }
            n = 0;
            if (mapProperty.hasProperty("acolor")) {
                n = mapProperty.getLVInt();
            }
            if (mapProperty.hasProperty("rev")) {
                this.checkReverse.setSelected(mapProperty.getLVBoolean());
            }
            if (mapProperty.hasProperty("index")) {
                this.checkIndex.setSelected(mapProperty.getLVBoolean());
            }
            this.init(n);
        }

        public void addProperties(Properties properties) {
            Object object = this.boxAutocolor.getSelectedItem();
            properties.put("colorscheme", object.toString());
            if (object.equals("[CUSTOM]")) {
                for (int i = 0; i < this.classColors.size(); ++i) {
                    Color color = this.classColors.elementAt(i).getContinuesColor().getColor(0);
                    properties.put("color" + (i + 1), PerfectSpread.getColorToString(color));
                }
            }
        }

        public void copySettings(AbstractSettingsPanel abstractSettingsPanel) {
            if (abstractSettingsPanel instanceof ClassPanel) {
                ClassPanel classPanel = (ClassPanel)abstractSettingsPanel;
                this.checkReverse.setSelected(classPanel.checkReverse.isSelected());
                this.checkIndex.setSelected(classPanel.checkIndex.isSelected());
                this.classColors.clear();
                for (int i = 0; i < classPanel.classColors.size(); ++i) {
                    this.classColors.add(classPanel.classColors.elementAt(i));
                }
            }
        }

        @Override
        public ContinuousColorInterface getContinuesColor() {
            if (this.classColors.size() <= 0) {
                return this.classColorScale;
            }
            PlotContinuousColor plotContinuousColor = new PlotContinuousColor("Class Scales");
            for (int i = 0; i < this.classColors.size(); ++i) {
                plotContinuousColor.addColor(this.classColors.elementAt(i).getContinuesColor().getColor(0));
            }
            return plotContinuousColor;
        }

        @Override
        public double[] getContinuesMinMax() {
            return null;
        }

        @Override
        public void pageShown() {
            AbstractAxisLayer abstractAxisLayer = ((AbstractPlotSettingsBox)ColorAdvanceFrame.this.settingsBox).getLayer();
            AbstractDataInfo abstractDataInfo = abstractAxisLayer.getDataInfoFromAxis(ColorAdvanceFrame.this.dataSearchPanel.getMatrix(), this.isPrimary ? 0 : 1);
            this.setDataInfo(abstractDataInfo);
        }

        @Override
        public void Save(RandomOutputStream randomOutputStream) throws IOException {
            super.Save(randomOutputStream);
            this.getContinuesColor().Save(randomOutputStream);
            randomOutputStream.writePropertyInt("acolor", this.boxAutocolor.getSelectedIndex());
            randomOutputStream.writePropertyBoolean("rev", this.checkReverse.isSelected());
            randomOutputStream.writePropertyBoolean("index", this.checkIndex.isSelected());
        }

        public void setProperties(Properties properties) {
            if (ScriptHelper.hasKey(properties, "colorscheme")) {
                String string = ScriptHelper.getProperty(properties, "colorscheme");
                for (int i = 0; i < this.boxAutocolor.getItemCount(); ++i) {
                    if (!string.equalsIgnoreCase(this.boxAutocolor.getItemAt(i).toString())) continue;
                    this.boxAutocolor.setSelectedIndex(i);
                    if (!this.boxAutocolor.getSelectedItem().equals("[CUSTOM]")) break;
                    for (int j = 0; j < this.classColors.size(); ++j) {
                        Color color;
                        if (!ScriptHelper.hasKey(properties, "color" + (j + 1)) || (color = PerfectSpread.getColorFromString(ScriptHelper.getProperty(properties, "color" + (j + 1)))) == null) continue;
                        this.classColors.elementAt(j).setFixedColor(color);
                    }
                    break;
                }
            }
            if (ScriptHelper.hasKey(properties, "reverse")) {
                this.checkReverse.setSelected(ScriptHelper.getPropertyBool(properties, "reverse"));
            }
            if (ScriptHelper.hasKey(properties, "index")) {
                this.checkIndex.setSelected(ScriptHelper.getPropertyBool(properties, "index"));
            }
            if (ScriptHelper.hasKey(properties, "updatecolors")) {
                this.updateColors = ScriptHelper.getPropertyBool(properties, "updatecolors");
            }
        }

        public void transferColorsToCategory() {
            ClassTypes classTypes = (ClassTypes)this.comboClassTypes.getSelectedItem();
            for (int i = 0; i < this.classColors.size(); ++i) {
                ScalePanel scalePanel = this.classColors.elementAt(i);
                ContinuousColorInterface continuousColorInterface = scalePanel.getContinuesColor();
                ClassSettings classSettings = classTypes.getClassSettings(i);
                classSettings.setColor(continuousColorInterface.getColor(0));
            }
            JOptionPane.showConfirmDialog(this, "Plot color settings are now transfered to category", "Color transfer", -1, 1);
        }

        @Override
        protected void changeOrder(boolean bl, int[] nArray, int[] nArray2) {
            if (bl) {
                for (int i = 0; i < nArray.length; ++i) {
                    ScalePanel scalePanel = this.classColors.get(nArray2[i]);
                    this.classColors.set(nArray2[i], this.classColors.get(nArray[i]));
                    this.classColors.set(nArray[i], scalePanel);
                }
            } else {
                for (int i = nArray2.length - 1; i >= 0; --i) {
                    ScalePanel scalePanel = this.classColors.get(nArray[i]);
                    this.classColors.set(nArray[i], this.classColors.get(nArray2[i]));
                    this.classColors.set(nArray2[i], scalePanel);
                }
            }
            this.updateItems(false);
            this.updateComboItems();
        }

        @Override
        protected DataTreeInterface getSpecificDti() {
            if (ColorAdvanceFrame.this.settingsBox != null) {
                return ColorAdvanceFrame.this.settingsBox.getMatrix();
            }
            return null;
        }

        @Override
        protected void updateComboItems() {
            if (ColorAdvanceFrame.this.settingsBox != null) {
                ColorAdvanceFrame.this.settingsBox.updateClasses();
            }
        }

        @Override
        protected void updateItemsLocal(boolean bl) {
            ClassTypes classTypes = (ClassTypes)this.comboClassTypes.getSelectedItem();
            this.centerPanel.removeAll();
            this.centerPanel.add((Component)new JLabel("Category"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.centerPanel.add((Component)new JLabel("Color"), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
            if (classTypes != null) {
                ClassSettings classSettings;
                int n;
                int n2 = classTypes.size();
                if (n2 > 255) {
                    n2 = 255;
                }
                if (n2 > this.classColors.size()) {
                    for (n = this.classColors.size(); n < n2; ++n) {
                        classSettings = classTypes.getClassSettings(n);
                        this.classColors.addElement(new ScalePanel(new PlotContinuousColor("Fixed", classSettings.getColor())));
                    }
                } else if (n2 < this.classColors.size()) {
                    this.classColors.setSize(n2);
                }
                for (n = 0; n < n2; ++n) {
                    classSettings = classTypes.getClassSettings(n);
                    this.centerPanel.add((Component)new JLabel(classSettings.getName()), new GridBagConstraints(0, n + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
                    if (this.updatecolorexplicitly && this.updateColors) {
                        this.classColors.get(n).setFixedColor(classSettings.getColor());
                    }
                    this.centerPanel.add((Component)this.classColors.get(n).cloneScalePanel(), new GridBagConstraints(1, n + 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 6, 0, 12), 0, 0));
                }
                this.centerPanel.add((Component)new JLabel(""), new GridBagConstraints(1, n + 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                if (bl) {
                    this.resetColors(true);
                }
            }
            this.centerPanel.revalidate();
            this.centerPanel.repaint();
            this.updatecolorexplicitly = false;
        }

        private Color getAutoColor(int n, int n2) {
            if (this.colorScales == null) {
                return PerfectSpread.generateColor(n);
            }
            int n3 = this.boxAutocolor.getSelectedIndex();
            if (n3 <= 0) {
                return PerfectSpread.generateColor(n);
            }
            PlotContinuousColor plotContinuousColor = this.colorScales.get(n3 - 1);
            int n4 = 0;
            if (this.checkIndex.isSelected()) {
                n4 = n;
            } else if (n2 > 1) {
                n4 = (int)((double)n / (double)(n2 - 1) * (double)plotContinuousColor.getNrColors());
            }
            if (this.checkReverse.isSelected()) {
                n4 = plotContinuousColor.getNrColors() - n4;
            }
            return plotContinuousColor.getColor(n4);
        }

        private void init(int n) {
            this.boxAutocolor.addItem("[CUSTOM]");
            for (PlotContinuousColor plotContinuousColor : this.colorScales) {
                this.boxAutocolor.addItem(plotContinuousColor.toString().toUpperCase());
            }
            this.boxAutocolor.setSelectedIndex(n);
            this.boxAutocolor.addItemListener(itemEvent -> this.resetColors(false));
            this.checkReverse.setEnabled(this.boxAutocolor.getSelectedIndex() > 0);
            this.checkReverse.addItemListener(this.boxAutocolor.getItemListeners()[0]);
            this.checkIndex.setEnabled(this.boxAutocolor.getSelectedIndex() > 0);
            this.checkIndex.addItemListener(this.boxAutocolor.getItemListeners()[0]);
            this.transferColorButton.addActionListener(actionEvent -> this.transferColorsToCategory());
            this.northPanel.add((Component)new JLabel("Color:"), new GridBagConstraints(0, this.row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.northPanel.add((Component)this.boxAutocolor, new GridBagConstraints(1, this.row++, 0, 1, 0.0, 0.0, 17, 2, new Insets(6, 6, 0, 12), 0, 0));
            this.northPanel.add((Component)this.checkReverse, new GridBagConstraints(1, this.row++, 0, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 0), 0, 0));
            this.northPanel.add((Component)this.checkIndex, new GridBagConstraints(1, this.row++, 0, 1, 0.0, 0.0, 18, 0, new Insets(2, 6, 6, 0), 0, 0));
            this.southPanel.add((Component)this.transferColorButton, new GridBagConstraints(1, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 6, 0), 0, 0));
        }

        private void resetColors(boolean bl) {
            ClassTypes classTypes = (ClassTypes)this.comboClassTypes.getSelectedItem();
            boolean bl2 = this.boxAutocolor.getSelectedIndex() <= 0;
            int n = 0;
            for (int i = 0; i < this.classColors.size(); ++i) {
                ScalePanel scalePanel = this.classColors.elementAt(i);
                scalePanel.setEnabled(bl2);
                ContinuousColorInterface continuousColorInterface = scalePanel.getContinuesColor();
                ClassSettings classSettings = classTypes.getClassSettings(i);
                if (bl && classSettings != null) {
                    continuousColorInterface.setColor(0, classSettings.getColor());
                    continue;
                }
                if (!bl2 && classSettings != null && classSettings.isNoClass()) {
                    continuousColorInterface.setColor(0, PerfectSpread.generateColor(0));
                    continue;
                }
                continuousColorInterface.setColor(0, this.getAutoColor(n++, this.classColors.size()));
            }
            this.checkReverse.setEnabled(!bl2);
            this.checkIndex.setEnabled(!bl2);
            this.updateItems(false);
        }

        private class ItemSelector
        implements ItemListener {
            private ItemSelector() {
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if ((itemEvent == null || itemEvent.getStateChange() == 1) && ClassPanel.this.comboClassTypes.getSelectedItem() instanceof ClassTypes) {
                    ClassPanel.this.updateItems(true);
                }
            }
        }
    }
}

