/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings.Color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class ColorChooserPanel
extends AbstractColorChooserPanel {
    @Override
    public String getDisplayName() {
        return "Samples";
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public void updateChooser() {
    }

    @Override
    protected void buildChooser() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new ColorFields(), "Center");
        this.add(jPanel);
    }

    private class ColorFields
    extends JPanel {
        private final Color[][] colors = new Color[9][31];

        public ColorFields() {
            for (int i = 0; i < this.colors.length; ++i) {
                for (int j = 0; j < this.colors[i].length; ++j) {
                    this.colors[i][j] = this.getColor(i, j);
                }
            }
            this.setOpaque(true);
            this.setBackground(Color.white);
            this.setRequestFocusEnabled(false);
            this.setToolTipText("");
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    int n = ColorFields.this.getHeight() / ColorFields.this.colors.length;
                    int n2 = ColorFields.this.getWidth() / ColorFields.this.colors[0].length;
                    ColorChooserPanel.this.getColorSelectionModel().setSelectedColor(ColorFields.this.colors[mouseEvent.getY() / n2][mouseEvent.getX() / n]);
                }
            });
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(10 * this.colors[0].length, 10 * this.colors.length);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.getHeight() / this.colors.length;
            int n2 = this.getWidth() / this.colors[0].length;
            Color color = this.colors[mouseEvent.getY() / n2][mouseEvent.getX() / n];
            return "(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int n = this.getHeight() / this.colors.length;
            int n2 = this.getWidth() / this.colors[0].length;
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (int i = 0; i < this.colors.length; ++i) {
                for (int j = 0; j < this.colors[i].length; ++j) {
                    graphics.setColor(this.colors[i][j]);
                    graphics.fillRect(j * n + 1, i * n2 + 1, n - 2, n2 - 2);
                    graphics.setColor(Color.black);
                    graphics.drawLine((j + 1) * n - 1, i * n2 + 1, (j + 1) * n - 1, (i + 1) * n2 - 1);
                    graphics.drawLine(j * n + 1, (i + 1) * n2 - 1, (j + 1) * n - 1, (i + 1) * n2 - 1);
                }
            }
        }

        private Color getColor(int n, int n2) {
            float f = (float)n / (float)(this.colors.length - 1);
            if (n2 == 0) {
                return new Color(1.0f - f, 1.0f - f, 1.0f - f);
            }
            int n3 = (this.colors[0].length - 1) / 3;
            float f2 = (float)(--n2 % n3) / (float)(n3 - 1);
            if (n2 < n3) {
                return new Color(f2, f, 1.0f - f2);
            }
            if (n2 < 2 * n3) {
                return new Color(f, 1.0f - f2, 1.0f - f2);
            }
            return new Color(f2, 1.0f - f2, f);
        }
    }
}

