/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings.Color;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.color.ContinuousColorInterface;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;
import se.prediktera.map.plot.axisplot.settings.Color.AbstractColorInterface;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;
import se.prediktera.map.plot.axisplot.settings.Color.PlotContinuousColor;
import se.prediktera.map.plot.axisplot.settings.Color.ScalePanel;

public class ColorScalePanel
extends AbstractSettingsPanel
implements AbstractColorInterface {
    private ContinuesRadioButton defaultContinues = null;
    private final ButtonGroup colorScaleGroup = new ButtonGroup();
    private int selindex = -1;
    public JTextFieldButtonUppDown minField = new JTextFieldButtonUppDown(true);
    public JTextFieldButtonUppDown maxField = new JTextFieldButtonUppDown(true);
    public final JCheckBox rangeCheckBox = new JCheckBox("Range Limits", false);
    private final JCheckBox reverseCheckbox = new JCheckBox("Reverse color scale");
    public JTextFieldButtonUppDown noColorsField = new JTextFieldButtonUppDown(1.0, 256.0, false);
    private String defaultColorScale;

    public ColorScalePanel(MapProperty mapProperty, List<PlotContinuousColor> list) throws IOException {
        this(mapProperty, list, true);
    }

    public ColorScalePanel(MapProperty mapProperty, List<PlotContinuousColor> list, boolean bl) throws IOException {
        if (mapProperty.hasProperty("indx")) {
            this.selindex = mapProperty.getLVInt();
        }
        if (mapProperty.hasProperty("auto")) {
            this.rangeCheckBox.setSelected(!mapProperty.getLVBoolean());
        }
        if (mapProperty.hasProperty("range")) {
            this.rangeCheckBox.setSelected(mapProperty.getLVBoolean());
        }
        if (mapProperty.hasProperty("min")) {
            this.minField.setNumber(mapProperty.getLVDouble());
        }
        if (mapProperty.hasProperty("max")) {
            this.maxField.setNumber(mapProperty.getLVDouble());
        }
        if (mapProperty.hasProperty("rev")) {
            this.reverseCheckbox.setSelected(mapProperty.getLVBoolean());
        }
        if (mapProperty.hasProperty("number")) {
            this.noColorsField.setNumber(mapProperty.getLVInt());
        } else {
            this.noColorsField.setNumber(256.0);
        }
        this.setContinuesCard(list, bl);
    }

    public ColorScalePanel(List<PlotContinuousColor> list, String string, boolean bl) {
        this(list, true, string, bl);
    }

    public ColorScalePanel(List<PlotContinuousColor> list, boolean bl, String string, boolean bl2) {
        this.defaultColorScale = string;
        this.noColorsField.setNumber(256.0);
        this.reverseCheckbox.setSelected(bl2);
        this.setContinuesCard(list, bl);
    }

    public void addProperties(Properties properties) {
        Enumeration<AbstractButton> enumeration = this.colorScaleGroup.getElements();
        while (enumeration.hasMoreElements()) {
            ContinuesRadioButton continuesRadioButton = (ContinuesRadioButton)enumeration.nextElement();
            if (!continuesRadioButton.isSelected()) continue;
            properties.put("colorscheme", continuesRadioButton.getText());
        }
    }

    public void copySettings(AbstractSettingsPanel abstractSettingsPanel) {
        ColorScalePanel colorScalePanel = (ColorScalePanel)abstractSettingsPanel;
        this.rangeCheckBox.setSelected(!colorScalePanel.hasAutoScale());
        this.minField.setNumber(colorScalePanel.getMinScale());
        this.maxField.setNumber(colorScalePanel.getMaxScale());
        Enumeration<AbstractButton> enumeration = colorScalePanel.colorScaleGroup.getElements();
        block0: while (enumeration.hasMoreElements()) {
            ContinuesRadioButton continuesRadioButton = (ContinuesRadioButton)enumeration.nextElement();
            if (!continuesRadioButton.isSelected()) continue;
            String string = continuesRadioButton.getContinuesColor().toString();
            enumeration = this.colorScaleGroup.getElements();
            while (enumeration.hasMoreElements()) {
                continuesRadioButton = (ContinuesRadioButton)enumeration.nextElement();
                if (!continuesRadioButton.getContinuesColor().toString().equals(string)) continue;
                if (continuesRadioButton.isSelected()) break block0;
                continuesRadioButton.setSelected(true);
                this.defaultContinues = continuesRadioButton;
                this.selindex = this.defaultContinues.getIndex();
                break block0;
            }
            break block0;
        }
    }

    @Override
    public ContinuousColorInterface getContinuesColor() {
        if (this.defaultContinues == null) {
            return new PlotContinuousColor("Fixed", Color.red);
        }
        return this.defaultContinues.getScalePanel().getContinuesColor();
    }

    @Override
    public double[] getContinuesMinMax() {
        if (this.rangeCheckBox.isSelected()) {
            return new double[]{this.minField.getNumber(), this.maxField.getNumber()};
        }
        return null;
    }

    public double getMaxScale() {
        return this.maxField.getNumber();
    }

    public double getMinScale() {
        return this.minField.getNumber();
    }

    public int getNoColors() {
        return (int)this.noColorsField.getNumber();
    }

    public boolean hasAutoScale() {
        return !this.rangeCheckBox.isSelected();
    }

    public void Save(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyInt("indx", this.selindex);
        randomOutputStream.writePropertyBoolean("range", this.rangeCheckBox.isSelected());
        randomOutputStream.writePropertyDouble("min", this.minField.getNumber());
        randomOutputStream.writePropertyDouble("max", this.maxField.getNumber());
        randomOutputStream.writePropertyBoolean("rev", this.reverseCheckbox.isSelected());
        randomOutputStream.writePropertyInt("number", (int)this.noColorsField.getNumber());
    }

    public void setAutoScale(boolean bl) {
        this.rangeCheckBox.setSelected(!bl);
    }

    public void setContinouesColorIndex(int n) throws Exception {
        if (n >= this.colorScaleGroup.getButtonCount()) {
            throw new Exception("Parameter exceeded maximum length: " + this.colorScaleGroup.getButtonCount());
        }
        int n2 = 0;
        Enumeration<AbstractButton> enumeration = this.colorScaleGroup.getElements();
        while (enumeration.hasMoreElements()) {
            ContinuesRadioButton continuesRadioButton = (ContinuesRadioButton)enumeration.nextElement();
            if (n2++ != n) continue;
            continuesRadioButton.setSelected(true);
            break;
        }
    }

    public void setContinuousColor(ContinuousColorInterface continuousColorInterface) {
        Enumeration<AbstractButton> enumeration = this.colorScaleGroup.getElements();
        while (enumeration.hasMoreElements()) {
            ContinuesRadioButton continuesRadioButton = (ContinuesRadioButton)enumeration.nextElement();
            if (continuesRadioButton.getContinuesColor() != continuousColorInterface) continue;
            continuesRadioButton.setSelected(true);
            break;
        }
    }

    public void setMaxScale(double d) {
        this.maxField.setNumber(d);
    }

    public void setMinScale(double d) {
        this.minField.setNumber(d);
    }

    public void setNoColors(int n) {
        this.noColorsField.setNumber(n);
    }

    public void setProperties(Properties properties) {
        if (ScriptHelper.hasKey(properties, "colorscheme")) {
            Object object;
            String string = EvinceScriptCommands.removeSpace(ScriptHelper.getProperty(properties, "colorscheme"));
            Enumeration<AbstractButton> enumeration = this.colorScaleGroup.getElements();
            while (enumeration.hasMoreElements()) {
                ContinuesRadioButton continuesRadioButton = (ContinuesRadioButton)enumeration.nextElement();
                object = EvinceScriptCommands.removeSpace(continuesRadioButton.getText());
                if (!((String)object).equalsIgnoreCase(string)) continue;
                continuesRadioButton.setSelected(true);
                break;
            }
            if (string.equalsIgnoreCase("[custom]")) {
                int n = ScriptHelper.getPropertyInt(properties, "colors");
                object = new PlotContinuousColor("custom");
                for (int i = 0; i < n; ++i) {
                    Color color;
                    if (!ScriptHelper.hasKey(properties, "color" + (i + 1)) || (color = PerfectSpread.getColorFromString(ScriptHelper.getProperty(properties, "color" + (i + 1)))) == null) continue;
                    ((PlotContinuousColor)object).addColor(color);
                }
                ContinuesRadioButton continuesRadioButton = new ContinuesRadioButton(100, (PlotContinuousColor)object);
                this.colorScaleGroup.add(continuesRadioButton);
                continuesRadioButton.setSelected(true);
                this.defaultContinues = continuesRadioButton;
            }
        }
        if (ScriptHelper.hasKey(properties, "min")) {
            this.rangeCheckBox.setSelected(true);
            this.minField.setNumber(ScriptHelper.getPropertyDouble(properties, "min"));
        }
        if (ScriptHelper.hasKey(properties, "max")) {
            this.rangeCheckBox.setSelected(true);
            this.maxField.setNumber(ScriptHelper.getPropertyDouble(properties, "max"));
        }
        if (ScriptHelper.hasKey(properties, "maxscale")) {
            this.rangeCheckBox.setSelected(true);
            double d = this.maxField.getNumber() - this.minField.getNumber();
            this.maxField.setNumber(this.minField.getNumber() + d * ScriptHelper.getPropertyDouble(properties, "maxscale"));
        }
        if (ScriptHelper.hasKey(properties, "reverse")) {
            this.reverseCheckbox.setSelected(ScriptHelper.getPropertyBool(properties, "reverse"));
        }
        if (ScriptHelper.hasKey(properties, "nocolor")) {
            this.noColorsField.setNumber(ScriptHelper.getPropertyInt(properties, "nocolor"));
            this.setNoColors();
        }
    }

    private void setContinuesCard(List<PlotContinuousColor> list, boolean bl) {
        if (list != null) {
            int n2;
            JLabel jLabel = new JLabel("Min");
            JLabel jLabel2 = new JLabel("Max");
            jLabel2.setHorizontalAlignment(4);
            jLabel2.setHorizontalTextPosition(4);
            this.centerPanel.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 6, 0, 0), 0, 0));
            this.centerPanel.add((Component)jLabel2, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(6, 0, 0, 12), 0, 0));
            ContinuesListener continuesListener = new ContinuesListener();
            ContinuousButtonListener continuousButtonListener = new ContinuousButtonListener();
            for (n2 = 0; n2 < list.size(); ++n2) {
                PlotContinuousColor plotContinuousColor = (PlotContinuousColor)list.get(n2).cloneColors();
                ContinuesRadioButton continuesRadioButton = new ContinuesRadioButton(n2, plotContinuousColor);
                if (this.reverseCheckbox.isSelected()) {
                    plotContinuousColor.reverseColors();
                }
                String string = continuesRadioButton.getText();
                continuesRadioButton.getScalePanel().addActionListener(continuousButtonListener);
                continuesRadioButton.addItemListener(continuesListener);
                this.colorScaleGroup.add(continuesRadioButton);
                this.centerPanel.add((Component)continuesRadioButton, new GridBagConstraints(0, n2 + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
                this.centerPanel.add((Component)continuesRadioButton.getScalePanel(), new GridBagConstraints(1, n2 + 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 6, 0, 12), 0, 0));
                if (this.defaultContinues != null && (this.selindex < 0 || this.selindex != n2) && (this.selindex != -1 || !string.equalsIgnoreCase(this.defaultColorScale))) continue;
                this.defaultContinues = continuesRadioButton;
            }
            this.centerPanel.add((Component)new JLabel(""), new GridBagConstraints(1, n2 + 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.defaultContinues.setSelected(true);
            this.reverseCheckbox.addItemListener(itemEvent -> {
                Enumeration<AbstractButton> enumeration = this.colorScaleGroup.getElements();
                while (enumeration.hasMoreElements()) {
                    ContinuesRadioButton continuesRadioButton = (ContinuesRadioButton)enumeration.nextElement();
                    continuesRadioButton.getScalePanel().reverseColors(((JCheckBox)itemEvent.getItem()).isSelected());
                }
            });
            int n3 = 0;
            if (bl) {
                this.northPanel.add((Component)this.rangeCheckBox, new GridBagConstraints(0, n3++, 0, 1, 1.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
                this.northPanel.add((Component)new JLabel("Min:"), new GridBagConstraints(0, n3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 0, 0), 0, 0));
                this.minField.setEnabled(this.rangeCheckBox.isSelected());
                this.northPanel.add((Component)this.minField, new GridBagConstraints(1, n3++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 60, 0));
                this.northPanel.add((Component)new JLabel("Max:"), new GridBagConstraints(0, n3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 6, 0), 0, 0));
                this.northPanel.add((Component)this.maxField, new GridBagConstraints(1, n3++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 6, 0), 60, 0));
                this.northPanel.add((Component)new JLabel("Number of colors:"), new GridBagConstraints(0, n3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 6, 0), 0, 0));
                this.northPanel.add((Component)this.noColorsField, new GridBagConstraints(1, n3++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 6, 0), 60, 0));
                this.noColorsField.setNumberChangedInterface((n, d) -> this.setNoColors());
            }
            this.maxField.setEnabled(this.rangeCheckBox.isSelected());
            this.northPanel.add((Component)this.reverseCheckbox, new GridBagConstraints(0, n3, 0, 1, 1.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.rangeCheckBox.addItemListener(itemEvent -> {
                this.minField.setEnabled(itemEvent.getStateChange() == 1);
                this.maxField.setEnabled(itemEvent.getStateChange() == 1);
            });
        }
    }

    private void setNoColors() {
        Enumeration<AbstractButton> enumeration = this.colorScaleGroup.getElements();
        while (enumeration.hasMoreElements()) {
            ContinuesRadioButton continuesRadioButton = (ContinuesRadioButton)enumeration.nextElement();
            continuesRadioButton.getScalePanel().setNoVisibleColors((int)this.noColorsField.getNumber());
        }
    }

    private static class ContinuesRadioButton
    extends JRadioButton {
        private final ScalePanel scalePanel;
        private final ContinuousColorInterface continuesColor;
        private final int index;

        public ContinuesRadioButton(int n, PlotContinuousColor plotContinuousColor) {
            this(n, new ScalePanel(plotContinuousColor));
        }

        public ContinuesRadioButton(int n, ScalePanel scalePanel) {
            super(scalePanel.getContinuesColor().toString());
            this.index = n;
            this.continuesColor = scalePanel.getContinuesColor();
            this.scalePanel = scalePanel;
        }

        public ContinuousColorInterface getContinuesColor() {
            return this.continuesColor;
        }

        public int getIndex() {
            return this.index;
        }

        public ScalePanel getScalePanel() {
            return this.scalePanel;
        }
    }

    private class ContinuesListener
    implements ItemListener {
        private ContinuesListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ColorScalePanel.this.defaultContinues = (ContinuesRadioButton)itemEvent.getSource();
            ColorScalePanel.this.selindex = ColorScalePanel.this.defaultContinues.getIndex();
        }
    }

    private class ContinuousButtonListener
    implements ActionListener {
        private ContinuousButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof ScalePanel) {
                ColorScalePanel.this.setContinuousColor(((ScalePanel)actionEvent.getSource()).getContinuesColor());
            }
        }
    }
}

