/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings.Color;

import java.awt.Color;
import se.prediktera.map.common.color.ContinuousColorInterface;

public class PerfectSpread {
    static final int maxindx = 900;
    static int[][] colorscheme = new int[][]{{237, 32, 36}, {58, 210, 58}, {70, 100, 190}, {246, 247, 109}, {115, 225, 250}, {207, 75, 207}, {217, 145, 40}, {255, 255, 225}, {128, 128, 128}, {32, 32, 32}, {0, 255, 153}, {255, 176, 224}};
    static float[] PerfectIndex = new float[900];
    static char[][] Rainbow = new char[900][3];
    static int ColorChunk = 150;

    public static void createRainBox() {
        float f;
        int n = 0;
        float f2 = 255.0f / (float)ColorChunk;
        for (f = 0.0f; f < (float)ColorChunk; f += 1.0f) {
            PerfectSpread.Rainbow[n][0] = 255;
            PerfectSpread.Rainbow[n][1] = (char)(f2 * f);
            PerfectSpread.Rainbow[n++][2] = '\u0000';
        }
        for (f = (float)ColorChunk; f < (float)(ColorChunk * 2); f += 1.0f) {
            PerfectSpread.Rainbow[n][0] = (char)(255.0f - f2 * (f - (float)ColorChunk));
            PerfectSpread.Rainbow[n][1] = 255;
            PerfectSpread.Rainbow[n++][2] = '\u0000';
        }
        for (f = (float)(ColorChunk * 2); f < (float)(ColorChunk * 3); f += 1.0f) {
            PerfectSpread.Rainbow[n][0] = '\u0000';
            PerfectSpread.Rainbow[n][1] = 255;
            PerfectSpread.Rainbow[n++][2] = (char)(f2 * (f - (float)(ColorChunk * 2)));
        }
        for (f = (float)(ColorChunk * 3); f < (float)(ColorChunk * 4); f += 1.0f) {
            PerfectSpread.Rainbow[n][0] = '\u0000';
            PerfectSpread.Rainbow[n][1] = (char)(255.0f - f2 * (f - (float)(ColorChunk * 3)));
            PerfectSpread.Rainbow[n++][2] = 255;
        }
        for (f = (float)(ColorChunk * 4); f < (float)(ColorChunk * 5); f += 1.0f) {
            PerfectSpread.Rainbow[n][0] = (char)(f2 * (f - (float)(ColorChunk * 4)));
            PerfectSpread.Rainbow[n][1] = '\u0000';
            PerfectSpread.Rainbow[n++][2] = 255;
        }
        for (f = (float)(ColorChunk * 5); f < (float)(ColorChunk * 6 - 1); f += 1.0f) {
            PerfectSpread.Rainbow[n][0] = 255;
            PerfectSpread.Rainbow[n][1] = '\u0000';
            PerfectSpread.Rainbow[n++][2] = (char)(255.0f - f2 * (f - (float)(ColorChunk * 5)));
        }
    }

    public static Color createTransparentColor(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public static Color generateColor(int n) {
        if (n < colorscheme.length) {
            return new Color(colorscheme[n][0], colorscheme[n][1], colorscheme[n][2]);
        }
        n -= colorscheme.length;
        n = (int)PerfectIndex[n % 900] % 900;
        return new Color(Rainbow[n][0], Rainbow[n][1], Rainbow[n][2]);
    }

    public static Color getColorFromString(String string) {
        Object[][] objectArray;
        if (string.length() == 0) {
            return null;
        }
        if (string.charAt(0) == '#') {
            return Color.decode(string);
        }
        if (string.startsWith("rgba(")) {
            String[] stringArray = string.substring(5, string.length() - 1).split(",");
            return new Color(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), (int)(Double.parseDouble(stringArray[3]) * 255.0));
        }
        for (Object[] objectArray2 : objectArray = ContinuousColorInterface.colormap) {
            if (!string.equalsIgnoreCase(objectArray2[0].toString())) continue;
            return (Color)objectArray2[1];
        }
        throw new RuntimeException("Illegal color option: " + string);
    }

    public static String generateStringColor(int n) {
        return PerfectSpread.getColorToString(PerfectSpread.generateColor(n));
    }

    public static String getColorToString(Color color) {
        char[] cArray = new char[7];
        cArray[0] = 35;
        String string = Integer.toHexString(color.getRed());
        if (string.length() == 1) {
            cArray[1] = 48;
            cArray[2] = string.charAt(0);
        } else {
            cArray[1] = string.charAt(0);
            cArray[2] = string.charAt(1);
        }
        string = Integer.toHexString(color.getGreen());
        if (string.length() == 1) {
            cArray[3] = 48;
            cArray[4] = string.charAt(0);
        } else {
            cArray[3] = string.charAt(0);
            cArray[4] = string.charAt(1);
        }
        string = Integer.toHexString(color.getBlue());
        if (string.length() == 1) {
            cArray[5] = 48;
            cArray[6] = string.charAt(0);
        } else {
            cArray[5] = string.charAt(0);
            cArray[6] = string.charAt(1);
        }
        return String.valueOf(cArray);
    }

    public static void Setup() {
        PerfectSpread perfectSpread = new PerfectSpread();
        perfectSpread.generatePerfectIndex();
    }

    public void generatePerfectIndex() {
        Node node = new Node();
        node.value = 0.5f;
        PerfectSpread.createRainBox();
        this.buildTree(node, 0, 9, 0.1f, 0.9f);
        int n = 0;
        float f = 0.0f;
        int n2 = 0;
        while (n2 < 3) {
            PerfectSpread.PerfectIndex[n] = f * 300.0f + (float)n2 * 300.0f;
            ++n2;
            ++n;
        }
        for (n2 = 0; n2 < 10; ++n2) {
            int n3 = (int)Math.pow(2.0, n2);
            for (int i = 0; i < n3; ++i) {
                f = this.getValue(node, 0, n2);
                int n4 = 0;
                while (n4 < 3) {
                    if (n < 900) {
                        PerfectSpread.PerfectIndex[n] = f * 300.0f + (float)n4 * 300.0f;
                    }
                    ++n4;
                    ++n;
                }
            }
        }
    }

    private void buildTree(Node node, int n, int n2, float f, float f2) {
        if (n == n2) {
            return;
        }
        Node node2 = new Node();
        Node node3 = new Node();
        node.left = node2;
        node.right = node3;
        float f3 = (f2 - f) / 2.0f;
        node.value = f + f3;
        this.buildTree(node2, n + 1, n2, f, f + f3);
        this.buildTree(node3, n + 1, n2, f + f3, f2);
    }

    private float getValue(Node node, int n, int n2) {
        if (n == n2 || node.left == null || node.right == null) {
            return node.value;
        }
        if (node.left.number <= node.right.number) {
            ++node.left.number;
            return this.getValue(node.left, n + 1, n2);
        }
        ++node.right.number;
        return this.getValue(node.right, n + 1, n2);
    }

    public static Color blendDark(Color color, double d, double d2) {
        return new Color(PerfectSpread.blendDark(color.getRed(), d, d2), PerfectSpread.blendDark(color.getGreen(), d, d2), PerfectSpread.blendDark(color.getBlue(), d, d2));
    }

    public static int blendDark(int n, double d, double d2) {
        double d3 = PerfectSpread.calcPercent(d, d2);
        return (int)((double)n * d3 + (1.0 - d3) * 0.0);
    }

    public static Color blendWhite(Color color, double d, double d2) {
        return new Color(PerfectSpread.blendWhite(color.getRed(), d, d2), PerfectSpread.blendWhite(color.getGreen(), d, d2), PerfectSpread.blendWhite(color.getBlue(), d, d2));
    }

    public static int blendWhite(int n, double d, double d2) {
        double d3 = PerfectSpread.calcPercent(d, d2);
        return (int)((double)n * d3 + (1.0 - d3) * 255.0);
    }

    private static double calcPercent(double d, double d2) {
        return d2 + (1.0 - d2) * d;
    }

    private static class Node {
        public Node left = null;
        public Node right = null;
        public int number = 0;
        public float value = 0.0f;

        private Node() {
        }
    }
}

