/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings.Color;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.color.ContinuousColorInterface;

public class PlotContinuousColor
implements ContinuousColorInterface {
    private int classIndex;
    private List<Color> colorArray = new ArrayList<Color>();
    private String name;
    private Color selectionColor;
    private boolean isReversed = false;
    private int noVisibleColors = -1;

    public PlotContinuousColor(MapProperty mapProperty) {
        this.name = mapProperty.hasProperty("cname") ? mapProperty.getLVStringUTF() : "NoName";
        if (mapProperty.hasProperty("csize")) {
            int n = mapProperty.getLVInt();
            for (int i = 0; i < n; ++i) {
                if (!mapProperty.hasProperty("cc" + i)) continue;
                this.colorArray.add(new Color(mapProperty.getLVInt(), true));
            }
        } else {
            this.colorArray.add(Color.red);
        }
        this.isReversed = mapProperty.getPropertyBoolean("reversed");
    }

    public PlotContinuousColor(String string, Color color) {
        this.name = string;
        this.colorArray.add(color);
    }

    public PlotContinuousColor(String string) {
        this.name = string;
    }

    @Override
    public ContinuousColorInterface cloneColors() {
        PlotContinuousColor plotContinuousColor = new PlotContinuousColor(this.toString());
        for (Color color : this.colorArray) {
            plotContinuousColor.addColor(color);
        }
        plotContinuousColor.setClassIndex(this.classIndex);
        plotContinuousColor.setSelectionColor(this.selectionColor);
        plotContinuousColor.setReversed(this.isReversed);
        plotContinuousColor.setNoVisibleColors(this.noVisibleColors);
        return plotContinuousColor;
    }

    public int[][] createColorIndex() {
        return this.createColorIndex(false);
    }

    public int[][] createColorIndex(boolean bl) {
        int[][] nArray = new int[this.getNrColors()][bl ? 4 : 3];
        for (int i = 0; i < nArray.length; ++i) {
            Color color = this.getColor(i);
            nArray[i][0] = color.getRed();
            nArray[i][1] = color.getGreen();
            nArray[i][2] = color.getBlue();
            if (!bl) continue;
            nArray[i][3] = 255;
        }
        return nArray;
    }

    public boolean equals(Object object) {
        if (object instanceof PlotContinuousColor) {
            return this.name.equals(object.toString());
        }
        return super.equals(object);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getClassIndex() {
        return this.classIndex;
    }

    @Override
    public Color getColor(int n) {
        if (this.noVisibleColors > 0) {
            n = (int)((double)n / (double)this.noVisibleColors * (double)this.colorArray.size());
        }
        if (n >= this.colorArray.size()) {
            n = this.colorArray.size() - 1;
        }
        if (n < 0) {
            n = 0;
        }
        return this.colorArray.get(n);
    }

    @Override
    public int getNoVisibleColors() {
        return this.noVisibleColors;
    }

    @Override
    public int getNrColors() {
        if (this.noVisibleColors > 0) {
            return this.noVisibleColors;
        }
        return this.colorArray.size();
    }

    @Override
    public Color getSelectionColor() {
        return this.selectionColor;
    }

    @Override
    public int getType() {
        if (this.name.equalsIgnoreCase("Fixed")) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isReversed() {
        return this.isReversed;
    }

    @Override
    public void reverseColors() {
        this.isReversed = !this.isReversed;
        ArrayList<Color> arrayList = new ArrayList<Color>();
        for (int i = 0; i < this.colorArray.size(); ++i) {
            arrayList.add(this.colorArray.get(this.colorArray.size() - (i + 1)));
        }
        this.colorArray = arrayList;
    }

    @Override
    public void Save(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyStringUTF("cname", this.name);
        randomOutputStream.writePropertyInt("csize", this.colorArray.size());
        for (int i = 0; i < this.colorArray.size(); ++i) {
            Color color = this.colorArray.get(i) != null ? this.colorArray.get(i) : Color.white;
            randomOutputStream.writePropertyInt("cc" + i, color.getRGB());
        }
        randomOutputStream.writePropertyBoolean("reversed", this.isReversed);
    }

    @Override
    public void setAlpha(float f) {
        for (int i = 0; i < this.colorArray.size(); ++i) {
            this.colorArray.set(i, new Color((float)this.colorArray.get(i).getRed(), (float)this.colorArray.get(i).getGreen(), (float)this.colorArray.get(i).getBlue(), f));
        }
    }

    @Override
    public void setClassIndex(int n) {
        this.classIndex = n;
    }

    public void addColor(Color color) {
        this.colorArray.add(color);
    }

    @Override
    public void setColor(int n, Color color) {
        if (this.noVisibleColors > 0) {
            n = (int)((double)n / (double)this.noVisibleColors * (double)this.colorArray.size());
        }
        this.colorArray.set(n, color);
    }

    @Override
    public void setNoVisibleColors(int n) {
        this.noVisibleColors = n;
    }

    public void setReversed(boolean bl) {
        this.isReversed = bl;
    }

    @Override
    public void setSelectionColor(Color color) {
        this.selectionColor = color;
    }

    public String toString() {
        return this.name;
    }

    public int[] toRgbArray() {
        int[] nArray = new int[this.colorArray.size()];
        for (int i = 0; i < this.colorArray.size(); ++i) {
            nArray[i] = this.colorArray.get(i).getRGB();
        }
        return nArray;
    }
}

