/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings.Color;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import se.prediktera.map.common.color.ContinuousColorInterface;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.layer.AbstractSettingsBox;
import se.prediktera.map.plot.axisplot.settings.Color.ColorChooserPanel;

public class ScalePanel
extends JButton
implements MouseListener {
    protected ContinuousColorInterface continuesColor;
    private int insets = 0;
    private final AbstractSettingsBox settingsBox;
    private int index = 0;

    public static Color showDialog(Component component, String string, Color color) throws HeadlessException {
        JColorChooser jColorChooser = new JColorChooser(color != null ? color : Color.white);
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = jColorChooser.getChooserPanels();
        AbstractColorChooserPanel[] abstractColorChooserPanelArray2 = new AbstractColorChooserPanel[abstractColorChooserPanelArray.length];
        for (int i = 0; i < abstractColorChooserPanelArray.length; ++i) {
            abstractColorChooserPanelArray2[i] = abstractColorChooserPanelArray[i].toString().startsWith("javax.swing.colorchooser.DefaultSwatchChooserPanel") ? new ColorChooserPanel() : abstractColorChooserPanelArray[i];
        }
        jColorChooser.setChooserPanels(abstractColorChooserPanelArray2);
        MyColorTracker myColorTracker = new MyColorTracker(jColorChooser);
        jColorChooser.setColor(color);
        JDialog jDialog = JColorChooser.createDialog(component, string, true, jColorChooser, myColorTracker, null);
        jDialog.setVisible(true);
        return myColorTracker.getColor();
    }

    public ScalePanel(ContinuousColorInterface continuousColorInterface) {
        this(continuousColorInterface, null);
    }

    public ScalePanel(ContinuousColorInterface continuousColorInterface, AbstractSettingsBox abstractSettingsBox) {
        this.settingsBox = abstractSettingsBox;
        if (continuousColorInterface != null) {
            this.setContinuesColor(continuousColorInterface);
        }
        this.addActionListener(actionEvent -> {
            if (this.settingsBox != null && this.settingsBox.hasAdvanceSettings()) {
                this.settingsBox.getAdvanceSettings().showModal();
                this.repaint();
            } else {
                this.showChooser();
            }
        });
        this.addMouseListener(this);
    }

    public ScalePanel(ContinuousColorInterface continuousColorInterface, int n) {
        this(continuousColorInterface, null);
        this.index = n;
    }

    public ScalePanel cloneScalePanel() {
        return new ScalePanel(this.getContinuesColor(), this.index);
    }

    public ContinuousColorInterface getContinuesColor() {
        return this.continuesColor;
    }

    public Color getFixedColor() {
        if (this.continuesColor != null) {
            return this.continuesColor.getColor(this.index);
        }
        return null;
    }

    public int getType() {
        return this.continuesColor.getType();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.continuesColor != null) {
            boolean bl = this.continuesColor.toString().equalsIgnoreCase("Fixed");
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = this.getWidth() - this.insets * 2;
            int n2 = this.getHeight() - this.insets * 2;
            if (bl) {
                graphics2D.setColor(this.continuesColor.getColor(0));
                graphics2D.fillRect(this.insets, this.insets, n, n2);
            } else {
                double d = this.continuesColor.getNrColors();
                double d2 = d / (double)(n - this.insets);
                double d3 = this.insets;
                double d4 = 0.0;
                while (d3 <= (double)n) {
                    graphics2D.setColor(this.continuesColor.getColor((int)d4));
                    graphics2D.fillRect((int)d3, this.insets, 1, n2);
                    d3 += 1.0;
                    d4 += d2;
                }
            }
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(this.insets, this.insets, n - 1, n2 - 1);
        }
    }

    public void reverseColors(boolean bl) {
        if (this.continuesColor.isReversed() != bl) {
            this.continuesColor.reverseColors();
            this.repaint();
        }
    }

    public void setContinuesColor(ContinuousColorInterface continuousColorInterface) {
        this.continuesColor = continuousColorInterface;
        this.repaint();
    }

    public void setFixedColor(Color color) {
        if (this.continuesColor != null) {
            this.continuesColor.setColor(this.index, color);
            this.repaint();
        }
    }

    public void setInsets(int n) {
        this.insets = n;
    }

    public void setNoVisibleColors(int n) {
        this.continuesColor.setNoVisibleColors(n);
        this.repaint();
    }

    public void showChooser() {
        Color color;
        if (this.continuesColor == null || !this.continuesColor.toString().equalsIgnoreCase("Fixed")) {
            return;
        }
        Color color2 = Color.red;
        if (this.continuesColor.getNrColors() > 0) {
            color2 = this.continuesColor.getColor(this.index);
        }
        if ((color = ScalePanel.showDialog(IniManager.getMainFrame(), "Choose color", color2)) != null) {
            this.continuesColor.setColor(this.index, color);
            this.repaint();
        }
    }

    private static class MyColorTracker
    implements ActionListener,
    Serializable {
        JColorChooser chooser;
        Color color;

        public MyColorTracker(JColorChooser jColorChooser) {
            this.chooser = jColorChooser;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.color = this.chooser.getColor();
        }

        public Color getColor() {
            return this.color;
        }
    }
}

