/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings;

import java.awt.Color;
import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.mtj.DenseMatrixFloat;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrixFloat;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixEvent;
import se.prediktera.map.main.layer.AbstractAdvancedFrame;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.Axis.AxisAdvanceFrame;

public class ComboBoxAxis
extends AbstractPlotSettingsBox {
    private int currentEventId = -1;
    private double[] valueArray;

    public ComboBoxAxis(AbstractAxisLayer abstractAxisLayer, byte by) {
        super(abstractAxisLayer.getPlotInit().getMatrix(by), abstractAxisLayer);
        this.axis = by;
    }

    @Override
    public void Calculate() {
        this.valueArray = null;
        PlotInit plotInit = this.getPlotInit();
        if (this.curType == 4) {
            this.axisIndex = -1;
            plotInit.axisPos[this.axis] = -2;
        } else if (this.curType == 0) {
            plotInit.axisPos[this.axis] = this.axisIndex;
            plotInit.setMatrix(this.axis, this.matrix);
        }
        if (this.curType == 12 || this.curType == 13 || this.curType == 101) {
            this.calculateAverageOrSum();
        }
        if (this.curType == 23) {
            this.calculateProfile();
        }
        if (!this.layer.isSubLayer()) {
            this.layer.createRootLeaf(this.currentEventId);
        }
        this.calculateMinMaxMissing();
    }

    public double getAxisValue(int n, int n2) {
        return this.getAxisValueDataIndex(this.getOrigIndexPrimary(n), n2);
    }

    @Override
    public double getAxisValueDataIndex(int n, int n2) {
        if (this.curType == 4) {
            return n + 1;
        }
        if (this.curType == 27) {
            return super.getReferenceIndexPrimary(n) + 1;
        }
        if (n < 0) {
            return 0.0;
        }
        if (this.curType == 12 || this.curType == 13 || this.curType == 101) {
            if (this.valueArray == null) {
                this.calculateAverageOrSum();
            }
            return this.valueArray[n];
        }
        if (this.curType == 23) {
            if (this.valueArray == null) {
                this.calculateProfile();
            }
            return this.valueArray[n];
        }
        return super.getAxisValueDataIndex(n, n2);
    }

    public int getMaxIndex() {
        int n = this.getCoordSizePrimary();
        if (n > 0) {
            return this.getReferenceIndexPrimary(n - 1);
        }
        return -1;
    }

    public int getMinIndex() {
        return this.getReferenceIndexPrimary(0);
    }

    @Override
    public String getScript(boolean bl) {
        if (bl) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("setDataRange(\"");
        stringBuilder.append(this.toString().substring(0, 1).toLowerCase());
        stringBuilder.append("\", \"");
        stringBuilder.append(this.getTypeName());
        stringBuilder.append("\", ");
        stringBuilder.append(this.axisIndex + 1);
        stringBuilder.append(");");
        return stringBuilder.toString();
    }

    @Override
    public byte getType() {
        return (byte)(0 + this.axis);
    }

    @Override
    public boolean hasMultiUpdate() {
        return true;
    }

    @Override
    public boolean isFilterPrimary(int n) {
        if (this.curType == 4) {
            return false;
        }
        return super.isFilterPrimary(n);
    }

    @Override
    public boolean isMissingPrimary(int n) {
        if (this.curType == 4) {
            return false;
        }
        return super.isMissingPrimary(n);
    }

    @Override
    public boolean isProtected() {
        AbstractAxisPlot abstractAxisPlot = this.getAxisPlot();
        if (abstractAxisPlot != null) {
            return abstractAxisPlot.isProtected();
        }
        return false;
    }

    @Override
    public void LoadProperty(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super.LoadProperty(randomInputStream, mapProperty);
        if (mapProperty.hasProperty("vA")) {
            this.valueArray = mapProperty.getLVDoubleArray();
        }
    }

    public ZoneLeaf newLeaf(int n) {
        return new ZoneLeaf(Color.red, 0, n, -1, this.layer);
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyDoubleArray("vA", this.valueArray);
    }

    @Override
    public void setAllCreated() {
        if (this.curType != 4) {
            this.calculateMinMaxMissing();
        }
    }

    @Override
    public void setSelected(int n, int n2) {
        this.currentEventId = -1;
        this.setSelected(n, n2, true);
    }

    @Override
    public void setSelectedChild() {
        this.Calculate();
        if (!this.layer.isSubLayer()) {
            AbstractAxisPlot abstractAxisPlot = this.getAxisPlot();
            abstractAxisPlot.calculateAxisTicksGlobal(this.axis, true, true);
            abstractAxisPlot.repaintPlot((byte)7);
        }
    }

    @Override
    public String toString() {
        return switch (this.axis) {
            case 0 -> "X Axis";
            case 1 -> "Y Axis";
            case 2 -> "Z Axis";
            default -> "";
        };
    }

    @Override
    public void updateCalculation(boolean bl) {
    }

    @Override
    protected AbstractAdvancedFrame createAdvanceSettings(MapProperty mapProperty) throws IOException {
        return new AxisAdvanceFrame(this, this.getPlotInit());
    }

    @Override
    protected boolean setComboItems(boolean bl, boolean bl2, boolean bl3) {
        PlotInit plotInit = this.getPlotInit();
        if (plotInit == null) {
            return false;
        }
        if (!bl && bl2) {
            this.curType = plotInit.axisPos[this.axis] < 0 ? 4 : 0;
        }
        this.setComboBoxWithData();
        if (!bl && bl2) {
            if (plotInit.axisPos[this.axis] < 0) {
                this.setSelectedIndex(0);
            } else {
                this.setSelected(0, plotInit.axisPos[this.axis], bl3);
                return true;
            }
        }
        return false;
    }

    @Override
    protected void setMatrix(DataMatrixEvent dataMatrixEvent) {
        this.currentEventId = dataMatrixEvent.getID();
        super.setMatrix(dataMatrixEvent);
    }

    @Override
    protected void setSelectedLocal(int n, int n2) {
        this.Calculate();
        this.ChangeEvent(n, n2);
        this.isfinish = true;
        if (!this.matrixevent && !this.layer.isSubLayer()) {
            AbstractAxisPlot abstractAxisPlot = this.getAxisPlot();
            abstractAxisPlot.calculateAxisTicksGlobal(this.axis, true, abstractAxisPlot.isAutoRescale());
            abstractAxisPlot.repaintPlot((byte)7);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void calculateAverageOrSum() {
        InnerColumnClass innerColumnClass = null;
        if (this.curType == 101) {
            DataGroupValues dataGroupValues = this.settingsBoxModel.getDataGroupValues();
            innerColumnClass = (InnerColumnClass)dataGroupValues.getInnerColumn(this.axisIndex);
        }
        int n = this.getCoordSizePrimary();
        int n2 = this.getCoordSizeSecondary();
        PlotInit plotInit = this.getPlotInit();
        plotInit.axisPos[this.axis] = this.axisIndex;
        plotInit.setMatrix(this.axis, this.matrix);
        this.valueArray = new double[n];
        AbstractDataMatrix abstractDataMatrix = this.matrix;
        if (abstractDataMatrix instanceof LayerMatrix) {
            LayerMatrix layerMatrix = (LayerMatrix)abstractDataMatrix;
            if (!this.isRowPrimary) {
                if (UpdateHelper.Product.isRunningProductBreezeSuite() && innerColumnClass == null && layerMatrix.getMatrixCount() > 0 && layerMatrix.getMatrixAt(0) instanceof MVmatrixFloat) {
                    double d = 1.0 / (double)n2;
                    for (int i = 0; i < n; ++i) {
                        double d2 = 0.0;
                        MVmatrixFloat mVmatrixFloat = (MVmatrixFloat)layerMatrix.getMatrixAt(i);
                        float[] fArray = ((DenseMatrixFloat)mVmatrixFloat.getInternalMatrixPublic()).data;
                        for (int j = 0; j < n2; d2 += (double)fArray[j], ++j) {
                        }
                        this.valueArray[i] = d2;
                        if (this.curType != 12 && this.curType != 101) continue;
                        int n3 = i;
                        this.valueArray[n3] = this.valueArray[n3] * d;
                    }
                    return;
                }
                for (int i = 0; i < n; ++i) {
                    double d = 0.0;
                    int n4 = 0;
                    AbstractDataMatrix abstractDataMatrix2 = layerMatrix.getMatrixAt(i);
                    int n5 = abstractDataMatrix2.getN();
                    for (int j = 0; j < n2; ++j) {
                        if (innerColumnClass != null && innerColumnClass.getValueShort(this.getReferenceIndexSecondary(j)) != 1) continue;
                        d += abstractDataMatrix2.getValue(j % n5, j / n5);
                        ++n4;
                    }
                    this.valueArray[i] = d;
                    if (this.curType != 12 && this.curType != 101) continue;
                    int n6 = i;
                    this.valueArray[n6] = this.valueArray[n6] / (double)n4;
                }
                return;
            }
        }
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            int n7 = 0;
            for (int j = 0; j < n2; ++j) {
                if (innerColumnClass != null && innerColumnClass.getValueShort(this.getReferenceIndexSecondary(j)) != 1) continue;
                d += this.getCoord(i, j);
                ++n7;
            }
            this.valueArray[i] = d;
            if (this.curType != 12 && this.curType != 101) continue;
            int n8 = i;
            this.valueArray[n8] = this.valueArray[n8] / (double)n7;
        }
    }

    private void calculateProfile() {
        this.getAxisPlot().getRubberband().getStart();
        int n = this.getCoordSizePrimary();
        this.valueArray = new double[n];
        int n2 = this.getFoldN();
        for (int i = 0; i < n; ++i) {
            int n3 = this.getReferenceIndexPrimary(i);
            int n4 = n3 / n2;
            int n5 = n3 % n2;
            double d = n4 - 0;
            double d2 = n5 - 0;
            this.valueArray[i] = Math.sqrt(d * d + d2 * d2);
        }
    }
}

