/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings;

import java.io.IOException;
import javax.swing.JCheckBox;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.main.layer.AbstractAdvancedFrame;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;

public class ComboBoxBins
extends AbstractPlotSettingsBox {
    private final JTextFieldButtonUppDown boxBins = new JTextFieldButtonUppDown(1.0, 2.147483647E9, false);
    private final JCheckBox rangeCheckBox = new JCheckBox("Range Limits", false);
    private final JTextFieldButtonUppDown minField = new JTextFieldButtonUppDown(true);
    private final JTextFieldButtonUppDown maxField = new JTextFieldButtonUppDown(true);

    public ComboBoxBins(AbstractAxisLayer abstractAxisLayer, byte by) {
        super(abstractAxisLayer.getPlotInit().getMatrix(by), abstractAxisLayer);
        this.boxBins.setNumber(50.0);
        this.boxBins.setNumberChangedInterface((n, d) -> this.getAxisPlot().calculateBuildAndRepaint());
        this.rangeCheckBox.addItemListener(itemEvent -> this.getAxisPlot().calculateBuildAndRepaint());
        this.minField.setNumberChangedInterface((n, d) -> this.getAxisPlot().calculateBuildAndRepaint());
        this.maxField.setNumberChangedInterface((n, d) -> this.getAxisPlot().calculateBuildAndRepaint());
    }

    @Override
    public void Calculate() {
    }

    public int getBinSize() {
        return (int)this.boxBins.getNumber();
    }

    public JTextFieldButtonUppDown getBoxBins() {
        return this.boxBins;
    }

    public JTextFieldButtonUppDown getMaxField() {
        return this.maxField;
    }

    public double getMaxRange() {
        return this.maxField.getNumber();
    }

    public JTextFieldButtonUppDown getMinField() {
        return this.minField;
    }

    public double getMinRange() {
        return this.minField.getNumber();
    }

    public JCheckBox getRangeCheckBox() {
        return this.rangeCheckBox;
    }

    @Override
    public byte getType() {
        return 8;
    }

    @Override
    public boolean hasAdvanceSettings() {
        return false;
    }

    public boolean hasManualRange() {
        return this.rangeCheckBox.isSelected();
    }

    @Override
    public boolean hasMultiUpdate() {
        return false;
    }

    @Override
    public void LoadProperty(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super.LoadProperty(randomInputStream, mapProperty);
        this.boxBins.setNumber(mapProperty.getPropertyInt("nr", 50));
        this.rangeCheckBox.setSelected(mapProperty.getPropertyBoolean("manual"));
        this.minField.setNumber(mapProperty.getPropertyDouble("min"));
        this.maxField.setNumber(mapProperty.getPropertyDouble("max"));
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyInt("nr", (int)this.boxBins.getNumber());
        randomOutputStream.writePropertyBoolean("manual", this.hasManualRange());
        randomOutputStream.writePropertyDouble("min", this.getMinRange());
        randomOutputStream.writePropertyDouble("max", this.getMaxRange());
    }

    public void setBinSize(int n) {
        this.boxBins.setNumber(n);
    }

    public void setManualRange(boolean bl) {
        this.rangeCheckBox.setSelected(bl);
    }

    public void setMaxRange(double d) {
        this.maxField.setNumberIntern(d);
    }

    public void setMinRange(double d) {
        this.minField.setNumberIntern(d);
    }

    @Override
    public void setSelectedChild() {
    }

    @Override
    public void updateCalculation(boolean bl) {
        this.setSelected(this.curType, this.axisIndex);
    }

    @Override
    protected AbstractAdvancedFrame createAdvanceSettings(MapProperty mapProperty) throws IOException {
        return null;
    }

    @Override
    protected boolean setComboItems(boolean bl, boolean bl2, boolean bl3) {
        return false;
    }

    protected void ShowSettings() {
    }
}

