/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings;

import java.awt.Color;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.color.ContinuousColorInterface;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBooleanIncExc;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.main.ProjectProperties;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.layer.AbstractAdvancedFrame;
import se.prediktera.map.main.layer.AbstractSettingsBox;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AbstractDensityField;
import se.prediktera.map.plot.axisplot.LeafList;
import se.prediktera.map.plot.axisplot.PlotAxisLayerPanel;
import se.prediktera.map.plot.axisplot.ZoneArray;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.AbstractSettings;
import se.prediktera.map.plot.axisplot.settings.Color.ColorAdvanceFrame;
import se.prediktera.map.plot.axisplot.settings.Color.ColorSettings;
import se.prediktera.map.plot.axisplot.settings.Color.FixedColorChangedInterface;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;
import se.prediktera.map.plot.axisplot.settings.Color.PlotContinuousColor;
import se.prediktera.map.plot.axisplot.settings.Color.ScalePanel;
import se.prediktera.map.plot.axisplot.settings.ComboBoxShape;
import se.prediktera.map.plot.axisplot.settings.Shape.ContinuesShape;
import se.prediktera.map.plot.axisplot.settings.Shape.ShapeAdvanceFrame;
import se.prediktera.map.plot.axisplot.windows.LegendHelper;
import se.prediktera.map.plot.axisplot.windows.LegendHolderInterface;
import se.prediktera.map.plot.axisplot.windows.LegendInterface;
import se.prediktera.map.plot.axisplot.windows.LegendWindow;

public class ComboBoxColor
extends AbstractPlotSettingsBox
implements LegendInterface,
FixedColorChangedInterface {
    private ScalePanel layerColor;
    private byte altitudeAxis = 1;
    private ContinuousColorHelper colorHelper = null;
    private boolean hasClassless = false;
    private final double log10 = Math.log(10.0);
    private boolean forceReflectance = false;

    public ComboBoxColor(AbstractDataMatrix abstractDataMatrix, AbstractAxisLayer abstractAxisLayer) {
        super(abstractDataMatrix, abstractAxisLayer);
        this.layerColor = new ScalePanel(null, this);
    }

    @Override
    public void Calculate() {
        if (this.docalculate > 0) {
            return;
        }
        this.hasClassless = false;
        this.colorHelper = null;
        ColorAdvanceFrame colorAdvanceFrame = this.getColorAdvanceSettings();
        if (colorAdvanceFrame == null) {
            return;
        }
        this.matrix.beginCalculations();
        if (this.curType == 0) {
            colorAdvanceFrame.SyncronizeComboBox(this.matrix, this.curType, this.axisIndex);
        }
        ContinuousColorInterface continuousColorInterface = colorAdvanceFrame.getContinuesColor();
        this.layerColor.setContinuesColor(continuousColorInterface);
        this.getAxisPlot().updateLayerPanel();
        if (this.curType == 26) {
            AbstractDataMatrix abstractDataMatrix = this.getMatrix();
            if (abstractDataMatrix instanceof ModelMatrix) {
                int[][] nArray = abstractDataMatrix.createComponentVector();
                int n = 0;
                List<ZoneLeaf> list = this.layer.getRootList();
                for (int i = 0; i < list.size(); ++i) {
                    ZoneLeaf zoneLeaf = list.get(i);
                    zoneLeaf.setColor(new Color(nArray[0][n], nArray[1][n], nArray[2][n]));
                    ++n;
                }
            }
        } else {
            List<ZoneLeaf> list = this.layer.getRootList();
            for (int i = 0; i < list.size(); ++i) {
                this.initLeaf(list.get(i));
            }
        }
        this.matrix.endCalculations();
    }

    public double[] calculateMinMaxMissingFullPlot() {
        List<ZoneLeaf> list = this.layer.getRootList();
        if (list == null) {
            return this.calculateMinmax(true);
        }
        double[] dArray = new double[]{1.0, -1.0};
        boolean bl = true;
        for (int i = 0; i < list.size(); ++i) {
            ZoneLeaf zoneLeaf = list.get(i);
            if (zoneLeaf instanceof ZoneArray) {
                ZoneArray zoneArray = (ZoneArray)zoneLeaf;
                int n = zoneArray.getNoChildren();
                for (int j = 0; j < n; ++j) {
                    if (zoneArray.isMissing(j)) continue;
                    double d = zoneArray.getValue(j, this.altitudeAxis);
                    if (this.forceReflectance && d < 10.0) {
                        d = Math.exp(-d * this.log10);
                    }
                    if (bl) {
                        dArray[0] = d;
                        dArray[1] = d;
                        bl = false;
                        continue;
                    }
                    if (Double.isInfinite(d) || Double.isNaN(d)) continue;
                    if (dArray[0] > d) {
                        dArray[0] = d;
                    }
                    if (!(dArray[1] < d)) continue;
                    dArray[1] = d;
                }
                continue;
            }
            double d = zoneLeaf.getValue((byte)1);
            if (bl) {
                dArray[0] = d;
                dArray[1] = d;
                bl = false;
                continue;
            }
            if (Double.isInfinite(d) || Double.isNaN(d)) continue;
            if (dArray[0] > d) {
                dArray[0] = d;
            }
            if (!(dArray[1] < d)) continue;
            dArray[1] = d;
        }
        this.minmaxAxis = dArray;
        return dArray;
    }

    @Override
    public void collectLegendValues(LegendWindow legendWindow) {
        block32: {
            int n;
            ComboBoxShape comboBoxShape;
            int n2;
            int n3;
            ContinuousColorInterface continuousColorInterface;
            block38: {
                block37: {
                    double[] dArray;
                    block36: {
                        block35: {
                            block34: {
                                block33: {
                                    block31: {
                                        if (this.isCleaned()) {
                                            return;
                                        }
                                        ColorAdvanceFrame colorAdvanceFrame = this.getColorAdvanceSettings();
                                        if (colorAdvanceFrame == null) {
                                            return;
                                        }
                                        continuousColorInterface = colorAdvanceFrame.getContinuesColor();
                                        dArray = this.getMinmax();
                                        byte by = legendWindow.getPriority();
                                        if (colorAdvanceFrame.getContinuesMinMax() != null) {
                                            dArray = colorAdvanceFrame.getContinuesMinMax();
                                        }
                                        legendWindow.setTitle(this.getLegendType());
                                        n3 = 2;
                                        n2 = 0;
                                        comboBoxShape = (ComboBoxShape)this.layer.getComboBox((byte)5);
                                        if (comboBoxShape != null) {
                                            n3 = comboBoxShape.getCurType();
                                            n2 = comboBoxShape.getAxisIndex();
                                        }
                                        if (((n = this.curType) == 0 || n == 100) && by == 1) {
                                            n = 7;
                                        }
                                        legendWindow.setClassColumn(null);
                                        if ((n != 1 || n3 != 1 && n3 != 2 && n3 != 21) && legendWindow.getPriority() != 2) break block31;
                                        PlotAxisLayerPanel plotAxisLayerPanel = this.getAxisPlot().getSettingsPanel();
                                        if (plotAxisLayerPanel.getMainLayerCount() == 1 && this.layer.getTreeNodeCount() > 0) {
                                            for (int i = 0; i < this.layer.getTreeNodeCount(); ++i) {
                                                DataTreeInterface dataTreeInterface = this.layer.getTreeNodeAt(i);
                                                if (!(dataTreeInterface instanceof AbstractAxisLayer)) continue;
                                                AbstractAxisLayer abstractAxisLayer = (AbstractAxisLayer)dataTreeInterface;
                                                byte by2 = this.getFixedShapeFromLayer(abstractAxisLayer);
                                                ComboBoxColor comboBoxColor = (ComboBoxColor)abstractAxisLayer.getSettingsBoxMap().get((byte)3);
                                                legendWindow.addItem(new ZoneLeaf(comboBoxColor.getContinuesColor().getColor(0), by2, 0, 0, null), abstractAxisLayer.toString());
                                            }
                                            legendWindow.setTitle("Sub-layers");
                                        } else {
                                            for (int i = 0; i < plotAxisLayerPanel.getMainLayerCount(); ++i) {
                                                AbstractAxisLayer abstractAxisLayer = plotAxisLayerPanel.getMainLayer(i);
                                                byte by3 = this.getFixedShapeFromLayer(abstractAxisLayer);
                                                ComboBoxColor comboBoxColor = (ComboBoxColor)abstractAxisLayer.getSettingsBoxMap().get((byte)3);
                                                legendWindow.addItem(new ZoneLeaf(comboBoxColor.getContinuesColor().getColor(0), by3, 0, 0, null), abstractAxisLayer.toString());
                                            }
                                            legendWindow.setTitle("Layers");
                                        }
                                        break block32;
                                    }
                                    if (n != 4) break block33;
                                    int n4 = this.getCoordSizePrimary();
                                    if (n4 < 10) {
                                        legendWindow.setTitle("Index");
                                        LeafList leafList = this.layer.getZoneList();
                                        for (ZoneLeaf zoneLeaf : leafList) {
                                            int n5 = zoneLeaf.getPrimaryIndex();
                                            String string3 = this.getDescriptionSecondary(n5);
                                            ZoneLeaf zoneLeaf2 = new ZoneLeaf(zoneLeaf.getColor(), 0, 0, n5, null);
                                            legendWindow.addItem(zoneLeaf2, string3);
                                        }
                                    } else {
                                        legendWindow.setDescr("Index");
                                        dArray[0] = this.getReferenceIndexPrimary(0) + 1;
                                        dArray[1] = this.getReferenceIndexPrimary(n4 - 1) + 1;
                                        legendWindow.setContinuesColor(continuousColorInterface, dArray[0], dArray[1]);
                                    }
                                    break block32;
                                }
                                if (n != 18) break block34;
                                int n6 = this.getCoordSizeSecondary();
                                if (n6 < 10) {
                                    legendWindow.setTitle("Vector");
                                    LeafList leafList = this.layer.getZoneList();
                                    for (ZoneLeaf zoneLeaf : leafList) {
                                        int n7 = zoneLeaf.getSecondaryIndex();
                                        String string4 = this.getDescriptionPrimary(n7);
                                        ZoneLeaf zoneLeaf3 = new ZoneLeaf(zoneLeaf.getColor(), 0, 0, n7, null);
                                        legendWindow.addItem(zoneLeaf3, string4);
                                    }
                                } else {
                                    legendWindow.setDescr("Vector");
                                    dArray[0] = 1.0;
                                    dArray[1] = n6;
                                    legendWindow.setContinuesColor(continuousColorInterface, dArray[0], dArray[1]);
                                }
                                break block32;
                            }
                            if (n != 0 && n != 100) break block35;
                            legendWindow.setDescr("Value");
                            if (n == 0) {
                                legendWindow.setTitle(this.getDescriptionPrimary(this.axisIndex));
                            } else {
                                legendWindow.setTitle(this.getDescriptionSecondary(this.axisIndex));
                            }
                            legendWindow.setContinuesColor(continuousColorInterface, dArray[0], dArray[1]);
                            break block32;
                        }
                        if (n != 11) break block36;
                        legendWindow.setDescr("Amplitude");
                        legendWindow.setContinuesColor(continuousColorInterface, dArray[0], dArray[1]);
                        break block32;
                    }
                    if (n != 14) break block37;
                    legendWindow.setDescr("Missing Values");
                    legendWindow.setContinuesColor(continuousColorInterface, dArray[0], dArray[1]);
                    break block32;
                }
                if (n != 8) break block38;
                legendWindow.setDescr("Density");
                if (this.colorHelper == null || this.colorHelper.minmax == null) break block32;
                legendWindow.setContinuesColor(continuousColorInterface, this.colorHelper.minmax[0], this.colorHelper.minmax[1]);
                break block32;
            }
            if (n == 7 || n == 101 || n == 19 || n3 == 7 || n3 == 101 || n3 == 19) {
                int n8;
                InnerColumnClass innerColumnClass;
                boolean bl = n3 == 7 || n3 == 101 || n3 == 19;
                boolean bl2 = false;
                if (!(n != 7 && n != 101 && n != 19 || legendWindow.getPriority() != 0 && bl)) {
                    innerColumnClass = this.getClassColumn();
                    n8 = n;
                } else {
                    innerColumnClass = comboBoxShape.getClassColumn();
                    n8 = n3;
                }
                if (this.axisIndex == n2) {
                    bl2 = true;
                }
                if (innerColumnClass == null) {
                    return;
                }
                InnerColumnBooleanIncExc innerColumnBooleanIncExc = this.getIncExcColumn();
                HashMap<String, Integer> hashMap = LegendHelper.getIncludedClasses(innerColumnClass, innerColumnBooleanIncExc, this.getLayer(), n8);
                legendWindow.setTitle(innerColumnClass.toString());
                String[] stringArray = LegendHelper.toStringArray(hashMap);
                if (legendWindow.isSort()) {
                    Arrays.sort(stringArray, (string, string2) -> {
                        double d = NiceDataFormat.toNumber(string);
                        double d2 = NiceDataFormat.toNumber(string2);
                        if (Double.isNaN(d) || Double.isNaN(d2)) {
                            return string.compareToIgnoreCase((String)string2);
                        }
                        return Double.compare(d, d2);
                    });
                } else {
                    innerColumnClass.getObject().sortStringListToClassOrder(stringArray);
                }
                ContinuesShape continuesShape = null;
                if (n3 == 7 || n3 == 101 || n3 == 19) {
                    String[] stringArray2 = comboBoxShape.getSelectedComboItem();
                    ComboItem comboItem = this.getSelectedComboItem();
                    if (comboItem != null && (comboItem.equals(stringArray2) || comboItem.getType() == 1 || legendWindow.getPriority() == 1)) {
                        ShapeAdvanceFrame shapeAdvanceFrame = comboBoxShape.getShapeAdvanceSettings();
                        continuesShape = shapeAdvanceFrame.getContinuesShape();
                    }
                }
                legendWindow.setClassColumn(innerColumnClass);
                for (String string5 : stringArray) {
                    Integer n9 = hashMap.get(string5);
                    byte by = 0;
                    if (n3 == 1) {
                        by = this.getFixedShapeFromLayer(this.layer);
                    } else if (continuesShape != null) {
                        by = continuesShape.getShape(n9);
                    }
                    Color color = Color.orange;
                    if (continuesShape == null || bl2) {
                        color = continuousColorInterface.getColor(n9);
                    }
                    ZoneLeaf zoneLeaf = new ZoneLeaf(color, by, n9, n9, null);
                    legendWindow.addItem(zoneLeaf, string5);
                }
            }
        }
    }

    public String formatTooltipOrNull(double d) {
        if (this.curType == 19) {
            return this.getClassColumn().getHoldObject().getTypeDescriptionNull((int)d);
        }
        return null;
    }

    @Override
    public void copySettingsFrom(AbstractPlotSettingsBox abstractPlotSettingsBox) {
        super.copySettingsFrom(abstractPlotSettingsBox);
        ComboBoxColor comboBoxColor = (ComboBoxColor)abstractPlotSettingsBox;
        this.setContinuesColor(comboBoxColor.getContinuesColor().cloneColors());
        if (!abstractPlotSettingsBox.isAdvanceSettingsCreated()) {
            return;
        }
        ColorAdvanceFrame colorAdvanceFrame = this.getColorAdvanceSettings();
        if (colorAdvanceFrame == null) {
            return;
        }
        if (comboBoxColor.getSelectedType() == 1) {
            colorAdvanceFrame.changeFixedColor(comboBoxColor.getFixedColor());
        }
        if (!this.hasMainType(comboBoxColor.getSelectedType())) {
            if (comboBoxColor.hasMainType(1)) {
                colorAdvanceFrame.changeFixedColor(comboBoxColor.getFixedColor());
            } else {
                colorAdvanceFrame.changeFixedColor(Color.red);
            }
        }
        this.SyncronizeComboBox();
        colorAdvanceFrame.copySettings(abstractPlotSettingsBox.getAdvanceSettings());
    }

    @Override
    public void FixedColorChanged(Color color) {
        if (!this.isAdvanceSettingsShowing()) {
            this.layer.SettingsBoxChangeEvent(this, true);
            this.SyncronizeComboBox();
            this.setSelected(this.curType, this.axisIndex);
        }
    }

    public void forceReflectance() {
        this.forceReflectance = true;
    }

    public ContinuousColorInterface getContinuesColor() {
        ColorAdvanceFrame colorAdvanceFrame = this.getColorAdvanceSettings();
        if (colorAdvanceFrame == null) {
            return null;
        }
        return colorAdvanceFrame.getContinuesColor();
    }

    public int getDensityColorScale(ZoneLeaf zoneLeaf) {
        ContinuousColorHelper continuousColorHelper = this.getColorHelper();
        return continuousColorHelper.getDensityColorScale(zoneLeaf);
    }

    public Color getFixedColor() {
        return this.layerColor.getFixedColor();
    }

    @Override
    public LegendHolderInterface getLegendHolder() {
        return this.layer;
    }

    @Override
    public String getLegendType() {
        return "Color";
    }

    public Properties getProperties() {
        ColorAdvanceFrame colorAdvanceFrame = this.getColorAdvanceSettings();
        if (colorAdvanceFrame == null) {
            return null;
        }
        return colorAdvanceFrame.getProperties();
    }

    public ScalePanel getScalePanel() {
        return this.layerColor;
    }

    @Override
    public String getScript(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("setColor(\"");
        stringBuilder.append(this.getTypeName());
        stringBuilder.append("\", ");
        if (this.curType == 1) {
            Color color = this.getFixedColor();
            if (color == null) {
                color = Color.red;
            }
            stringBuilder.append("\"");
            stringBuilder.append(String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue()));
            stringBuilder.append("\"");
        } else {
            stringBuilder.append(this.axisIndex + 1);
            stringBuilder.append(ScriptHelper.generateString(this.getProperties()));
        }
        stringBuilder.append(");");
        return stringBuilder.toString();
    }

    @Override
    public AbstractSettings getSettings() {
        return new ColorSettings();
    }

    @Override
    public byte getType() {
        return 3;
    }

    @Override
    public boolean hasMultiUpdate() {
        return false;
    }

    @Override
    public final void initLeaf(ZoneLeaf zoneLeaf) {
        if (!this.isCreated() || zoneLeaf == null) {
            return;
        }
        if (this.curType == 1) {
            Color color = this.getFixedColor();
            if (zoneLeaf.getType() != 0 && ((ZoneArray)zoneLeaf).belongsToMultipleLayers()) {
                ZoneArray zoneArray = (ZoneArray)zoneLeaf;
                for (int i = 0; i < zoneArray.getNoChildren(); ++i) {
                    zoneArray.setColor(i, zoneArray.getLayer(i).getFixedColor());
                }
            } else if (zoneLeaf.getLayer() == this.layer) {
                zoneLeaf.setColor(color);
            }
            return;
        }
        ContinuousColorHelper continuousColorHelper = this.getColorHelper();
        if (continuousColorHelper == null) {
            return;
        }
        if ((this.curType == 11 || this.curType == 0 || this.curType == 7 || this.curType == 101 || this.curType == 19 || this.curType == 14 || this.curType == 4) && zoneLeaf.getType() != 0) {
            continuousColorHelper.setArrayColor((ZoneArray)zoneLeaf);
        } else if (zoneLeaf.getLayer() == this.layer) {
            continuousColorHelper.setLeafColor(zoneLeaf);
        }
    }

    @Override
    public void LoadProperty(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super.LoadProperty(randomInputStream, mapProperty);
        this.hasClassless = mapProperty.getPropertyBoolean("hCl");
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        if (this.hasClassless) {
            randomOutputStream.writePropertyBoolean("hCl", this.hasClassless);
        }
    }

    public void setAltitudeAxis(byte by) {
        this.altitudeAxis = by;
    }

    public void setContinuesColor(ContinuousColorInterface continuousColorInterface) {
        this.layerColor.setContinuesColor(continuousColorInterface);
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        if (this.isCreated() || abstractWindow_GUI == null) {
            return;
        }
        if (!bl) {
            ++this.docalculate;
        }
        if (this.layer != null && this.layer.isSubLayer() && !bl) {
            this.setFromInit();
        }
        super.setCreated(abstractWindow_GUI, bl);
        if (bl) {
            if (this.layerColor.getContinuesColor() == null) {
                this.layerColor.setContinuesColor(this.getContinuesColor());
            }
        } else {
            this.setFromInit();
            --this.docalculate;
            this.Calculate();
        }
    }

    public void setFixedColor(Color color) {
        this.layerColor.setFixedColor(color);
        this.SyncronizeComboBox();
    }

    public void setFromInit() {
        ColorAdvanceFrame colorAdvanceFrame;
        PlotInit plotInit = this.getPlotInit();
        if (plotInit.ccolortype >= 0 && this.hasMainType(plotInit.ccolortype)) {
            ColorAdvanceFrame colorAdvanceFrame2 = this.getColorAdvanceSettings();
            if (this.getMatrix().isImage() && plotInit.ccolortype != 8) {
                colorAdvanceFrame2.setScale(plotInit.ccolortype, false, 0.0, 255.0);
            }
            if (plotInit.ccolorindex >= 0 && colorAdvanceFrame2 != null) {
                try {
                    colorAdvanceFrame2.setContinuousColor(plotInit.ccolortype, plotInit.ccolorindex);
                }
                catch (Exception exception) {
                    ErrorHandler.logAndReportException(exception);
                }
            }
            this.setSelected(plotInit.ccolortype, 0, false);
        } else if (this.isCreated() && (colorAdvanceFrame = this.getColorAdvanceSettings()) != null) {
            this.layerColor.setContinuesColor(colorAdvanceFrame.getContinuesColor());
        }
    }

    @Override
    public void setOption(Object[] objectArray, Properties properties) {
        AbstractAxisPlot abstractAxisPlot = this.getAxisPlot();
        abstractAxisPlot.beginUpdate();
        super.setOption(objectArray, properties);
        if (properties != null) {
            this.SyncronizeComboBox();
            ColorAdvanceFrame colorAdvanceFrame = this.getColorAdvanceSettings();
            if (colorAdvanceFrame != null) {
                colorAdvanceFrame.setProperties(properties);
            }
            if (ScriptHelper.hasKey(properties, "forcereflectance")) {
                this.forceReflectance = ScriptHelper.getPropertyBool(properties, "forcereflectance");
            }
        }
        abstractAxisPlot.endUpdate((byte)7);
    }

    @Override
    public void setSelectedChild() {
        this.Calculate();
        this.repaintLegends();
    }

    @Override
    public String toString() {
        return "by " + this.getLegendType();
    }

    @Override
    public void updateCalculation(boolean bl) {
        if (this.isCreated() && (bl || this.curType == 8)) {
            this.Calculate();
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.layerColor = null;
        this.colorHelper = null;
    }

    @Override
    protected AbstractAdvancedFrame createAdvanceSettings(MapProperty mapProperty) throws IOException {
        List<PlotContinuousColor> list = Plot_GUI.getColorScales();
        PlotInit plotInit = this.getPlotInit();
        if (mapProperty != null) {
            return new ColorAdvanceFrame(mapProperty, this, plotInit, list);
        }
        ProjectProperties projectProperties = this.getProjectProperties();
        return new ColorAdvanceFrame(this, plotInit, list, this.layer.getLayerNr(), projectProperties != null ? projectProperties.getPropertyValue("colorScale", "jet") : "jet", projectProperties != null ? projectProperties.getPropertyValue("reverseColorScale", false) : false);
    }

    private ProjectProperties getProjectProperties() {
        Project_GUI project_GUI;
        Plot_GUI plot_GUI;
        AbstractAxisPlot abstractAxisPlot = this.getAxisPlot();
        if (abstractAxisPlot != null && (plot_GUI = abstractAxisPlot.getPlotGui()) != null && (project_GUI = plot_GUI.getProject_GUI()) != null) {
            return project_GUI.getProperties();
        }
        return null;
    }

    @Override
    protected void dataMatrixChanged() {
        ColorAdvanceFrame colorAdvanceFrame = this.getColorAdvanceSettings();
        if (colorAdvanceFrame != null) {
            colorAdvanceFrame.pageShown();
        }
    }

    @Override
    protected boolean setComboItems(boolean bl, boolean bl2, boolean bl3) {
        this.setComboBoxWithData();
        return false;
    }

    @Override
    protected void setFixedOption(Object object) {
        Color color = null;
        if (object instanceof Color) {
            color = (Color)object;
        } else {
            String string = String.valueOf(object);
            color = PerfectSpread.getColorFromString(string);
        }
        if (color == null) {
            return;
        }
        this.setFixedColor(color);
    }

    @Override
    protected void SyncronizeComboBox() {
        super.SyncronizeComboBox();
        AbstractAxisPlot abstractAxisPlot = this.getAxisPlot();
        if (abstractAxisPlot != null) {
            abstractAxisPlot.updateLayerPanel();
        }
    }

    private ColorAdvanceFrame getColorAdvanceSettings() {
        return (ColorAdvanceFrame)this.getAdvanceSettings();
    }

    private ContinuousColorHelper getColorHelper() {
        if (this.colorHelper == null) {
            ColorAdvanceFrame colorAdvanceFrame = this.getColorAdvanceSettings();
            if (colorAdvanceFrame == null) {
                return null;
            }
            ContinuousColorInterface continuousColorInterface = colorAdvanceFrame.getContinuesColor();
            this.colorHelper = new ContinuousColorHelper(continuousColorInterface);
            double[] dArray = new double[2];
            if (this.curType == 0 || this.curType == 100 || this.curType == 11) {
                if (this.getColorAdvanceSettings().hasAutoScale()) {
                    dArray = this.curType == 11 ? this.calculateMinMaxMissingFullPlot() : this.calculateMinMaxMissing(this.curType != 100);
                    colorAdvanceFrame.setScale(dArray[0], dArray[1]);
                } else {
                    dArray[0] = colorAdvanceFrame.getMinScale();
                    dArray[1] = colorAdvanceFrame.getMaxScale();
                }
            } else if (this.curType == 14) {
                dArray[0] = 0.0;
                dArray[1] = 1.0;
            } else if (this.curType == 8) {
                var4_4 = this.layer.calcDensity();
                if (this.getColorAdvanceSettings().hasAutoScale()) {
                    dArray[1] = var4_4 == null ? 1.0 : ((AbstractDensityField)var4_4).getMaxDensity();
                    dArray[0] = 0.0;
                    colorAdvanceFrame.setScale(dArray[0], dArray[1]);
                } else {
                    dArray[0] = colorAdvanceFrame.getMinScale();
                    dArray[1] = colorAdvanceFrame.getMaxScale();
                }
                this.colorHelper.setDensity((AbstractDensityField)var4_4);
            } else if (this.curType == 7 || this.curType == 101 || this.curType == 19) {
                dArray[0] = 0.0;
                var4_4 = this.getClassColumn();
                if (var4_4 != null && ((InnerColumnClass)var4_4).getObject() != null) {
                    this.colorHelper.setClassColumn((AbstractInnerColumn)var4_4);
                    dArray[1] = ((InnerColumnClass)var4_4).getObject().size();
                }
            }
            this.colorHelper.setMinMax(dArray);
            int n = this.curType == 100 || this.curType == 18 ? this.getCoordSizeSecondary() : this.getCoordSizePrimary();
            this.colorHelper.setMaxSize(n);
        }
        return this.colorHelper;
    }

    private byte getFixedShapeFromLayer(AbstractAxisLayer abstractAxisLayer) {
        ShapeAdvanceFrame shapeAdvanceFrame;
        ContinuesShape continuesShape;
        ComboBoxShape comboBoxShape = (ComboBoxShape)abstractAxisLayer.getComboBox((byte)5);
        if (comboBoxShape != null && comboBoxShape.getCurType() == 1 && (continuesShape = (shapeAdvanceFrame = comboBoxShape.getShapeAdvanceSettings()).getContinuesShape()).getNrShapes() >= 1) {
            return continuesShape.getShape(0);
        }
        return 0;
    }

    private class ContinuousColorHelper {
        private final ContinuousColorInterface continuesColor;
        private final double minmaxabs;
        private double[] minmax;
        private double sizeabs;
        private int maxsize;
        private AbstractDensityField density;
        private AbstractInnerColumn classcolumn = null;

        public ContinuousColorHelper(ContinuousColorInterface continuousColorInterface) {
            this.continuesColor = continuousColorInterface;
            this.minmaxabs = continuousColorInterface.getNrColors();
        }

        public final void setArrayColor(ZoneArray zoneArray) {
            block6: {
                int n;
                block7: {
                    block5: {
                        if (zoneArray == null || ComboBoxColor.this.layer == null) {
                            return;
                        }
                        n = zoneArray.getNoChildren();
                        if (ComboBoxColor.this.curType != 11) break block5;
                        AbstractSettingsBox abstractSettingsBox = ComboBoxColor.this.layer.getSettingsBoxMap().get((byte)9);
                        AbstractDataMatrix abstractDataMatrix = abstractSettingsBox.getMatrix();
                        int n2 = zoneArray.getSecondaryIndex();
                        int n3 = ComboBoxColor.this.isRowPrimary ? abstractDataMatrix.getKrefOrig(n2) : abstractDataMatrix.getNrefOrig(n2);
                        for (int i = 0; i < n; ++i) {
                            if (zoneArray.getLayer(i) != ComboBoxColor.this.layer) continue;
                            int n4 = zoneArray.getPrimaryIndex(i);
                            int n5 = ComboBoxColor.this.isRowPrimary ? abstractDataMatrix.getNrefOrig(n4) : abstractDataMatrix.getKrefOrig(n4);
                            int n6 = this.getAltitudeColorScale(zoneArray, abstractDataMatrix, n5, n3);
                            if ((double)n6 >= this.minmaxabs) {
                                n6 = (int)this.minmaxabs - 1;
                            }
                            if (n6 < 0) {
                                n6 = 0;
                            }
                            zoneArray.setColor(i, this.continuesColor.getColor(n6));
                        }
                        break block6;
                    }
                    if (ComboBoxColor.this.curType != 101) break block7;
                    int n7 = this.getClassColorScale(zoneArray);
                    Color color = this.continuesColor.getColor(n7);
                    if (color == null) break block6;
                    zoneArray.setColor(color.getRGB());
                    break block6;
                }
                for (int i = 0; i < n; ++i) {
                    if (zoneArray.getLayer(i) != ComboBoxColor.this.layer) continue;
                    this.setLeafColor(zoneArray, i);
                }
            }
        }

        public void setClassColumn(AbstractInnerColumn abstractInnerColumn) {
            this.classcolumn = abstractInnerColumn;
        }

        public void setDensity(AbstractDensityField abstractDensityField) {
            this.density = abstractDensityField;
        }

        public void setLeafColor(ZoneArray zoneArray, int n) {
            int n2 = 0;
            switch (ComboBoxColor.this.curType) {
                case 0: 
                case 100: {
                    n2 = this.getContinuousColorScale(zoneArray, n);
                    break;
                }
                case 11: {
                    n2 = this.getAltitudeColorScale(zoneArray, n);
                    break;
                }
                case 7: 
                case 19: {
                    n2 = this.getClassColorScale(zoneArray, n);
                    if (n2 != 0) break;
                    ComboBoxColor.this.hasClassless = true;
                    break;
                }
                case 101: {
                    n2 = ComboBoxColor.this.matrix.getFoldN() > 0 ? this.getClassColorScale(zoneArray, n) : this.getClassColorScale(zoneArray);
                    if (n2 != 0) break;
                    ComboBoxColor.this.hasClassless = true;
                    break;
                }
                case 14: {
                    n2 = this.getMissingColorScale(zoneArray, n);
                    break;
                }
                case 4: {
                    n2 = this.getNumbersColorScale(zoneArray, n);
                    break;
                }
                case 18: {
                    n2 = this.getNumbersColorScale(zoneArray);
                    break;
                }
                default: {
                    return;
                }
            }
            if ((double)n2 >= this.minmaxabs) {
                n2 = (int)this.minmaxabs - 1;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            zoneArray.setColor(n, this.continuesColor.getColor(n2));
        }

        public void setLeafColor(ZoneLeaf zoneLeaf) {
            Color color;
            int n = 0;
            switch (ComboBoxColor.this.curType) {
                case 0: 
                case 100: {
                    n = this.getContinuousColorScale(zoneLeaf);
                    break;
                }
                case 11: {
                    n = this.getAltitudeColorScale(zoneLeaf);
                    break;
                }
                case 7: 
                case 19: 
                case 101: {
                    n = this.getClassColorScale(zoneLeaf);
                    if (n != 0) break;
                    ComboBoxColor.this.hasClassless = true;
                    break;
                }
                case 8: {
                    n = this.getDensityColorScale(zoneLeaf);
                    break;
                }
                case 4: {
                    n = this.getNumbersColorScale(zoneLeaf);
                    break;
                }
                case 18: {
                    n = this.getSecondIndexColorScale(zoneLeaf);
                    break;
                }
                case 14: {
                    n = this.getMissingColorScale(zoneLeaf);
                    break;
                }
                default: {
                    return;
                }
            }
            if ((double)n >= this.minmaxabs) {
                n = (int)this.minmaxabs - 1;
            }
            if (n < 0) {
                n = 0;
            }
            if ((color = this.continuesColor.getColor(n)) != null) {
                zoneLeaf.setColor(color.getRGB());
            }
        }

        public void setMaxSize(int n) {
            this.maxsize = n;
        }

        public void setMinMax(double[] dArray) {
            this.minmax = dArray;
            this.sizeabs = dArray[1] - dArray[0];
        }

        private int getAltitudeColorScale(ZoneArray zoneArray, AbstractDataMatrix abstractDataMatrix, int n, int n2) {
            double d;
            if (Double.compare(this.sizeabs, 0.0) == 0) {
                return 0;
            }
            double d2 = d = ComboBoxColor.this.isRowPrimary ? abstractDataMatrix.getValue(n, n2) : abstractDataMatrix.getValue(n2, n);
            if (ComboBoxColor.this.forceReflectance && d < 10.0) {
                d = Math.exp(-d * ComboBoxColor.this.log10);
            }
            return (int)((d - this.minmax[0]) / this.sizeabs * this.minmaxabs);
        }

        private int getAltitudeColorScale(ZoneArray zoneArray, int n) {
            if (Double.compare(this.sizeabs, 0.0) == 0) {
                return 0;
            }
            double d = zoneArray.getValue(n, ComboBoxColor.this.altitudeAxis);
            return (int)((d - this.minmax[0]) / this.sizeabs * this.minmaxabs);
        }

        private int getAltitudeColorScale(ZoneLeaf zoneLeaf) {
            if (Double.compare(this.sizeabs, 0.0) == 0) {
                return 0;
            }
            double d = zoneLeaf.getValue(ComboBoxColor.this.altitudeAxis);
            return (int)((d - this.minmax[0]) / this.sizeabs * this.minmaxabs);
        }

        private int getClassColorScale(int n) {
            Object object;
            if (this.classcolumn != null && (object = this.classcolumn.getValue(n)) instanceof Integer) {
                return (Integer)object;
            }
            return 0;
        }

        private int getClassColorScale(ZoneArray zoneArray) {
            return this.getClassColorScale(zoneArray.getSecondaryIndex());
        }

        private int getClassColorScale(ZoneArray zoneArray, int n) {
            if (ComboBoxColor.this.matrix.getFoldN() > 0) {
                int n2 = ComboBoxColor.this.matrix.isRotate() ? zoneArray.getSecondaryIndex() * ComboBoxColor.this.matrix.getFoldN() + n + (ComboBoxColor.this.matrix.getKref() != null ? ComboBoxColor.this.matrix.getKref()[0] : 0) : (n + (ComboBoxColor.this.matrix.getKref() != null ? ComboBoxColor.this.matrix.getKref()[0] : 0)) * ComboBoxColor.this.matrix.getFoldN() + zoneArray.getSecondaryIndex();
                return this.getClassColorScale(n2);
            }
            return this.getClassColorScale(zoneArray.getPrimaryIndex(n));
        }

        private int getClassColorScale(ZoneLeaf zoneLeaf) {
            return this.getClassColorScale(zoneLeaf.getPrimaryIndex());
        }

        private int getContinuousColorScale(ZoneArray zoneArray, int n) {
            if (Double.compare(this.sizeabs, 0.0) == 0) {
                return 0;
            }
            int n2 = 0;
            double d = switch (ComboBoxColor.this.curType) {
                case 0 -> {
                    n2 = zoneArray.getPrimaryIndex(n);
                    if (n2 < 0 || n2 >= this.maxsize || ComboBoxColor.this.isMissingPrimary(n2)) {
                        yield this.minmax[0];
                    }
                    yield ComboBoxColor.this.getCoordPrimary(n2);
                }
                case 100 -> {
                    n2 = zoneArray.getSecondaryIndex();
                    if (n2 < 0 || n2 >= this.maxsize || ComboBoxColor.this.isMissingSecondary(n2)) {
                        yield this.minmax[0];
                    }
                    yield ComboBoxColor.this.getCoordSecondary(n2);
                }
                default -> 0.0;
            };
            return (int)((d - this.minmax[0]) / this.sizeabs * this.minmaxabs);
        }

        private int getContinuousColorScale(ZoneLeaf zoneLeaf) {
            if (Double.compare(this.sizeabs, 0.0) == 0) {
                return 0;
            }
            int n = 0;
            double d = switch (ComboBoxColor.this.curType) {
                case 0 -> {
                    n = ComboBoxColor.this.getOrigIndexPrimary(zoneLeaf.getPrimaryIndex());
                    if (n < 0 || n >= this.maxsize || ComboBoxColor.this.isMissingPrimary(n)) {
                        yield this.minmax[0];
                    }
                    yield ComboBoxColor.this.getCoordPrimary(n);
                }
                case 100 -> {
                    n = ComboBoxColor.this.getOrigIndexSecondary(zoneLeaf.getSecondaryIndex());
                    if (n < 0 || n >= this.maxsize || ComboBoxColor.this.isMissingSecondary(n)) {
                        yield this.minmax[0];
                    }
                    yield ComboBoxColor.this.getCoordSecondary(n);
                }
                default -> 0.0;
            };
            return (int)((d - this.minmax[0]) / this.sizeabs * this.minmaxabs);
        }

        private int getDensityColorScale(ZoneLeaf zoneLeaf) {
            if (this.density != null) {
                return (int)((this.density.getDensityAt(zoneLeaf) - this.minmax[0]) / this.sizeabs * this.minmaxabs);
            }
            return 0;
        }

        private int getMissingColorScale(ZoneArray zoneArray, int n) {
            if (Double.compare(this.sizeabs, 0.0) == 0) {
                return 0;
            }
            return zoneArray.isMissing(n) ? (int)(this.minmaxabs - 1.0) : 0;
        }

        private int getMissingColorScale(ZoneLeaf zoneLeaf) {
            if (Double.compare(this.sizeabs, 0.0) == 0) {
                return 0;
            }
            return zoneLeaf.isMissing() ? (int)(this.minmaxabs - 1.0) : 0;
        }

        private int getNumbersColorScale(ZoneArray zoneArray, int n) {
            int n2 = ComboBoxColor.this.getOrigIndexPrimary(zoneArray.getPrimaryIndex(n));
            return (int)((double)n2 / (double)this.maxsize * this.minmaxabs);
        }

        private int getNumbersColorScale(ZoneLeaf zoneLeaf) {
            int n = ComboBoxColor.this.getOrigIndexPrimary(zoneLeaf.getPrimaryIndex());
            return (int)((double)n / (double)this.maxsize * this.minmaxabs);
        }

        private int getSecondIndexColorScale(ZoneLeaf zoneLeaf) {
            int n = ComboBoxColor.this.getOrigIndexSecondary(zoneLeaf.getSecondaryIndex());
            return (int)((double)n / (double)this.maxsize * this.minmaxabs);
        }
    }
}

