/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings;

import java.awt.Font;
import java.io.IOException;
import java.util.Properties;
import se.prediktera.map.common.JValidateNumberField;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.main.layer.AbstractAdvancedFrame;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.LeafList;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.AbstractSettings;
import se.prediktera.map.plot.axisplot.settings.Description.DescriptionAdvanceFrame;
import se.prediktera.map.plot.axisplot.settings.Description.DescriptionSettings;

public class ComboBoxDescription
extends AbstractPlotSettingsBox {
    private Font labelFont = new Font("SansSerif", 0, 8);
    private final JValidateNumberField boxFontSize = new JValidateNumberField(1.0, 50.0, false);

    public ComboBoxDescription(AbstractAxisLayer abstractAxisLayer, byte by) {
        super(abstractAxisLayer.getPlotInit().getMatrix(by), abstractAxisLayer);
        this.boxFontSize.setNumber(8.0);
        this.boxFontSize.setupAutoChange();
        this.axis = by;
        this.boxFontSize.setNumberChangedInterface((n, d) -> {
            this.layer.SettingsBoxChangeEvent(this, true);
            this.labelFont = new Font(this.labelFont.getName(), this.labelFont.getStyle(), (int)d);
            this.SyncronizeComboBox();
            this.getAxisPlot().contentPaint((byte)7);
        });
    }

    @Override
    public void Calculate() {
        LeafList leafList = this.layer.getZoneList();
        if (leafList == null) {
            return;
        }
        if (this.curType == 2) {
            for (int i = 0; i < leafList.size(); ++i) {
                ((ZoneLeaf)leafList.get(i)).setDescription("");
            }
            return;
        }
        for (int i = 0; i < leafList.size(); ++i) {
            ZoneLeaf zoneLeaf = (ZoneLeaf)leafList.get(i);
            zoneLeaf.setDescription(this.getDescription(zoneLeaf.getPrimaryIndex(), zoneLeaf.getSecondaryIndex()));
        }
    }

    @Override
    public void copySettingsFrom(AbstractPlotSettingsBox abstractPlotSettingsBox) {
        if (abstractPlotSettingsBox instanceof ComboBoxDescription) {
            ComboBoxDescription comboBoxDescription = (ComboBoxDescription)abstractPlotSettingsBox;
            this.labelFont = comboBoxDescription.getLabelFont();
            this.boxFontSize.setNumberIntern(comboBoxDescription.getBoxFontSize().getNumber());
            if (abstractPlotSettingsBox.isAdvanceSettingsCreated()) {
                DescriptionAdvanceFrame descriptionAdvanceFrame = (DescriptionAdvanceFrame)this.getAdvanceSettings();
                DescriptionAdvanceFrame descriptionAdvanceFrame2 = (DescriptionAdvanceFrame)abstractPlotSettingsBox.getAdvanceSettings();
                descriptionAdvanceFrame.setLength(descriptionAdvanceFrame2.getLength());
                descriptionAdvanceFrame.setStartPos(descriptionAdvanceFrame2.getStartPos());
            }
            super.copySettingsFrom(abstractPlotSettingsBox);
        }
    }

    public JValidateNumberField getBoxFontSize() {
        return this.boxFontSize;
    }

    public String getDescription(int n, int n2) {
        if (this.curType == 2 || this.matrix == null || n < 0) {
            return "";
        }
        String string = this.getDescriptionNoTrim(this.curType, n, n2, this.getOrigIndexPrimary(n), this.getOrigIndexSecondary(n2));
        DescriptionAdvanceFrame descriptionAdvanceFrame = (DescriptionAdvanceFrame)this.getAdvanceSettings();
        if (descriptionAdvanceFrame != null) {
            string = descriptionAdvanceFrame.trimDescription(string);
        }
        return string;
    }

    public String getDescriptionNoTrim(int n, int n2, int n3, int n4, int n5) {
        String string = "";
        if (n != 4 && (n2 < 0 || n4 < 0)) {
            return "";
        }
        switch (n) {
            case 5: {
                string = this.axis == 0 ? this.getDescriptionDescriptionItems(n4) : this.getDescriptionDescriptionItems(n5);
                string = NiceDataFormat.tryGetNiceString(string);
                break;
            }
            case 7: 
            case 19: {
                string = NiceDataFormat.tryGetNiceString(this.getDescriptionClassItems(n == 19, n2));
                break;
            }
            case 101: {
                string = NiceDataFormat.tryGetNiceString(this.getDescriptionClassItems(false, n3));
                break;
            }
            case 0: {
                int n6 = this.getCoordSizePrimary();
                if (n4 < 0 || n4 >= n6) break;
                if (this.isMissingPrimary(n4)) {
                    string = "MV";
                    break;
                }
                string = NiceDataFormat.toString(this.getCoordPrimary(n4));
                break;
            }
            case 100: {
                int n7 = this.getCoordSizeSecondary();
                if (n5 < 0 || n5 >= n7) break;
                if (this.isMissingSecondary(n4)) {
                    string = "MV";
                    break;
                }
                string = NiceDataFormat.toString(this.getCoordSecondary(n5));
                break;
            }
            case 4: {
                if (this.axis == 0) {
                    string = String.valueOf(n2 + 1);
                    break;
                }
                string = String.valueOf(n3 + 1);
                break;
            }
        }
        return string;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    @Override
    public String getScript(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("setLabel(\"");
        stringBuilder.append(this.getTypeName());
        stringBuilder.append("\", ");
        stringBuilder.append(this.axisIndex + 1);
        stringBuilder.append(");");
        return stringBuilder.toString();
    }

    @Override
    public AbstractSettings getSettings() {
        return new DescriptionSettings(this);
    }

    @Override
    public byte getType() {
        return 6;
    }

    @Override
    public boolean hasMultiUpdate() {
        return false;
    }

    @Override
    public void initLeaf(ZoneLeaf zoneLeaf) {
        if (this.curType == 2) {
            zoneLeaf.setDescription("");
            return;
        }
        zoneLeaf.setDescription(this.getDescription(zoneLeaf.getPrimaryIndex(), zoneLeaf.getSecondaryIndex()));
    }

    @Override
    public void LoadProperty(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super.LoadProperty(randomInputStream, mapProperty);
        String string = "SansSerif";
        int n = 0;
        int n2 = 8;
        if (mapProperty.hasProperty("fname")) {
            string = mapProperty.getLVStringUTF();
        }
        if (mapProperty.hasProperty("ftype")) {
            n = mapProperty.getLVInt();
        }
        if (mapProperty.hasProperty("fsize2")) {
            n2 = mapProperty.getLVInt();
        }
        this.labelFont = new Font(string, n, n2);
        this.boxFontSize.setNumberIntern(n2);
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyStringUTF("fname", this.labelFont.getName());
        randomOutputStream.writePropertyInt("ftype", this.labelFont.getStyle());
        randomOutputStream.writePropertyInt("fsize2", this.labelFont.getSize());
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
        this.boxFontSize.setNumber(this.labelFont.getSize());
    }

    @Override
    public void setOption(Object[] objectArray, Properties properties) {
        Object object;
        Object object2;
        if (objectArray.length == 3 && (object2 = objectArray[2]) instanceof Double) {
            object = (Double)object2;
            int n = ((Double)object).intValue();
            this.boxFontSize.setNumber(n);
            this.labelFont = new Font(this.labelFont.getName(), this.labelFont.getStyle(), n);
        }
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "size")) {
                int n = ScriptHelper.getPropertyInt(properties, "size");
                this.boxFontSize.setNumber(n);
                this.labelFont = new Font(this.labelFont.getName(), this.labelFont.getStyle(), n);
            }
            if (ScriptHelper.hasKey(properties, "style") && ((String)(object = ScriptHelper.getProperty(properties, "style"))).equalsIgnoreCase("bold")) {
                this.labelFont = new Font(this.labelFont.getName(), 1, this.labelFont.getSize());
            }
            if (ScriptHelper.hasKey(properties, "font")) {
                object = ScriptHelper.getProperty(properties, "font");
                this.labelFont = new Font((String)object, this.labelFont.getStyle(), this.labelFont.getSize());
            }
        }
        super.setOption(objectArray, properties);
    }

    @Override
    public void setSelectedChild() {
        this.Calculate();
    }

    @Override
    public String toString() {
        return "Description";
    }

    @Override
    public void updateCalculation(boolean bl) {
        if (bl) {
            this.setSelectedChild();
        }
    }

    @Override
    protected AbstractAdvancedFrame createAdvanceSettings(MapProperty mapProperty) throws IOException {
        return new DescriptionAdvanceFrame(this, this.getPlotInit(), this.labelFont);
    }

    @Override
    protected boolean setComboItems(boolean bl, boolean bl2, boolean bl3) {
        this.setComboBoxWithData();
        PlotInit plotInit = this.getPlotInit();
        if (!bl && plotInit != null && plotInit.description == 5) {
            this.setSelectedIndex(2);
        }
        return false;
    }

    @Override
    protected void setFixedOption(Object object) {
        if (object instanceof Double) {
            this.boxFontSize.setNumber((Double)object);
        } else if (object instanceof Double[]) {
            this.boxFontSize.setNumber(((Double[])object)[0]);
        } else {
            this.boxFontSize.setNumber(Double.parseDouble(object.toString()));
        }
    }

    protected void ShowSettings() {
    }

    private String getDescriptionClassItems(boolean bl, int n) {
        AbstractDataInfo abstractDataInfo = this.getDataInfoFromAxis(this.axis);
        if (abstractDataInfo == null) {
            return "";
        }
        InnerColumnClass innerColumnClass = null;
        ClassTypes classTypes = null;
        if (bl) {
            var6_6 = this.getPredictionColumn();
            if (var6_6 != null) {
                innerColumnClass = (InnerColumnClass)var6_6.getInnerColumn(this.axisIndex);
            }
        } else {
            var6_6 = (Transformations)abstractDataInfo.getGroupColumnByType(10);
            if (var6_6 != null && ((Transformations)var6_6).getColumnCount() > 0) {
                innerColumnClass = (InnerColumnClass)((Transformations)var6_6).getInnerColumn(this.axisIndex, 4);
            }
        }
        if (innerColumnClass != null && (classTypes = innerColumnClass.getObject()) != null && n >= 0 && n < innerColumnClass.getSize()) {
            short s = innerColumnClass.getValueShort(n);
            return classTypes.getTypeDescription(s);
        }
        return "[NONE]";
    }

    private String getDescriptionDescriptionItems(int n) {
        if (this.axis == 0) {
            return this.getDescriptionSecondary(n, this.axisIndex);
        }
        return this.getDescriptionPrimary(n, this.axisIndex);
    }
}

