/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings;

import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import se.prediktera.map.common.JValidateNumberField;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.swing.JComboBoxCell;
import se.prediktera.map.main.layer.AbstractAdvancedFrame;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.SortZoneItems;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.Lines.LineRenderingBox;
import se.prediktera.map.plot.axisplot.settings.Lines.LineStyle;
import se.prediktera.map.plot.axisplot.settings.Lines.LinesAdvanceFrame;

public class ComboBoxLines
extends AbstractPlotSettingsBox {
    private final LineStyle drawLineStyle = new LineStyle(0);
    private final LineRenderingBox boxLineStyle = new LineRenderingBox();
    private final JValidateNumberField boxLineWidth = new JValidateNumberField(0.1, 10.0, true);

    public ComboBoxLines(AbstractAxisLayer abstractAxisLayer, byte by) {
        super(abstractAxisLayer.getPlotInit().getMatrix(by), abstractAxisLayer);
        this.axis = by;
        this.boxLineWidth.setupAutoChange();
        this.boxLineStyle.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1 && !this.createbyLoad) {
                int n = this.boxLineStyle.getSelectedIndex();
                this.SyncronizeComboBox();
                this.drawLineStyle.setLineStyle(n);
                this.layer.SettingsBoxChangeEvent(this, true);
                this.getAxisPlot().contentPaint((byte)7);
            }
        });
        this.boxLineWidth.setNumber(1.0);
        this.boxLineWidth.setNumberChangedInterface((n, d) -> {
            this.drawLineStyle.setLineWidth((float)d);
            this.layer.SettingsBoxChangeEvent(this, true);
            this.getAxisPlot().contentPaint((byte)7);
        });
    }

    @Override
    public void Calculate() {
        if (this.curType == 7) {
            this.drawLineStyle.setLineStyle(this.curType);
        } else {
            this.layer.setShowLines(this.curType != 2);
            if (this.curType != 2 && this.layer.getZoneList() != null) {
                Collections.sort(this.layer.getZoneList(), new SortZoneItems(this, this.curType));
            }
        }
    }

    @Override
    public void copySettingsFrom(AbstractPlotSettingsBox abstractPlotSettingsBox) {
        if (abstractPlotSettingsBox != null) {
            super.copySettingsFrom(abstractPlotSettingsBox);
            ComboBoxLines comboBoxLines = (ComboBoxLines)abstractPlotSettingsBox;
            float f = (float)comboBoxLines.getLineWidthBox().getNumber();
            this.boxLineWidth.setNumber(f);
            this.drawLineStyle.setLineWidth(f);
            this.boxLineStyle.setSelectedIndex(comboBoxLines.getLineType());
            this.drawLineStyle.setLineStyle(((ComboBoxLines)abstractPlotSettingsBox).drawLineStyle);
        }
    }

    public LineStyle getDrawLineStyle() {
        return this.drawLineStyle;
    }

    public JComboBoxCell getLineStyleBox() {
        return this.boxLineStyle;
    }

    public int getLineType() {
        return this.boxLineStyle.getSelectedIndex();
    }

    public JValidateNumberField getLineWidthBox() {
        return this.boxLineWidth;
    }

    @Override
    public String getScript(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("setLine(\"");
        stringBuilder.append(this.getTypeName());
        stringBuilder.append("\", ");
        stringBuilder.append(this.axisIndex + 1);
        stringBuilder.append(");");
        return stringBuilder.toString();
    }

    @Override
    public byte getType() {
        return 7;
    }

    @Override
    public boolean hasMultiUpdate() {
        return false;
    }

    @Override
    public void LoadProperty(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super.LoadProperty(randomInputStream, mapProperty);
        if (mapProperty.hasProperty("lwi")) {
            float f = (float)mapProperty.getLVDouble();
            this.boxLineWidth.setNumber(f);
            this.drawLineStyle.setLineWidth(f);
        }
        if (mapProperty.hasProperty("lsI")) {
            this.boxLineStyle.setSelectedIndex(mapProperty.getLVInt());
        }
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyInt("lsI", this.boxLineStyle.getSelectedIndex());
        randomOutputStream.writePropertyDouble("lwi", this.boxLineWidth.getNumber());
    }

    public void setLineType(int n) {
        this.boxLineStyle.setSelectedIndex(n);
    }

    @Override
    public void setOption(Object[] objectArray, Properties properties) {
        AbstractAxisPlot abstractAxisPlot = this.getAxisPlot();
        abstractAxisPlot.beginUpdate();
        super.setOption(objectArray, properties);
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "width")) {
                int n = (int)ScriptHelper.getPropertyDouble(properties, "width");
                this.boxLineWidth.setNumberIntern(n);
                this.drawLineStyle.setLineWidth(n);
            }
            if (ScriptHelper.hasKey(properties, "style")) {
                String[] stringArray = new String[]{"solid", "dashed", "dashed2", "dotted"};
                String string = ScriptHelper.getProperty(properties, "style");
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.equalsIgnoreCase(stringArray[i])) continue;
                    this.boxLineStyle.setSelectedIndex(i);
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new RuntimeException("No such style property: " + string);
                }
            }
        }
        abstractAxisPlot.endUpdate((byte)7);
    }

    @Override
    public void setSelectedChild() {
        this.Calculate();
        if (this.curType == 7) {
            this.getAxisPlot().contentPaint((byte)7);
        }
    }

    @Override
    public String toString() {
        return "Lines";
    }

    @Override
    public void updateCalculation(boolean bl) {
    }

    @Override
    protected AbstractAdvancedFrame createAdvanceSettings(MapProperty mapProperty) throws IOException {
        return new LinesAdvanceFrame(this, this.getPlotInit());
    }

    @Override
    protected boolean setComboItems(boolean bl, boolean bl2, boolean bl3) {
        this.setComboBoxWithData();
        return false;
    }

    protected void ShowSettings() {
    }
}

