/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings;

import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot3D.cube3D.ZoneCube;
import se.prediktera.map.plot.axisplot.settings.ComboBoxRange;

public class ComboBoxRangeCube
extends ComboBoxRange {
    public ComboBoxRangeCube(AbstractAxisLayer abstractAxisLayer) {
        super(abstractAxisLayer);
    }

    @Override
    public void Calculate() {
        int n = this.getCoordSizeSecondary();
        if (n < 0) {
            this.indexToCoord = null;
        } else if (this.indexToCoord == null || this.indexToCoord.length != n) {
            this.indexToCoord = new int[n];
        }
        super.Calculate();
    }

    @Override
    public double[] calculateMinmax(boolean bl) {
        double[] dArray = new double[]{1.0, -1.0};
        boolean bl2 = true;
        for (int i = 0; i < this.getCoordSizePrimary(); ++i) {
            for (int j = 0; j < this.getDescriptionSizePrimary(); ++j) {
                double d;
                if (this.isMissing(i, j) || Double.isInfinite(d = this.getCoord(i, j)) || Double.isNaN(d)) continue;
                if (bl2) {
                    dArray[0] = d;
                    dArray[1] = d;
                    bl2 = false;
                    continue;
                }
                if (dArray[0] > d) {
                    dArray[0] = d;
                }
                if (!(dArray[1] < d)) continue;
                dArray[1] = d;
            }
        }
        this.minmaxAxis = dArray;
        return dArray;
    }

    @Override
    public double getAxisValue(byte by, int n, int n2, int n3) {
        if (by == 2) {
            return super.getAxisValue(by, n, n2, n3);
        }
        int n4 = this.getOrigIndexSecondary(n2);
        return this.indexToCoord == null || n4 < 0 ? (double)n4 : (double)this.indexToCoord[n4];
    }

    public int[] getIndexToCoord() {
        return this.indexToCoord;
    }

    @Override
    public void LoadProperty(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super.LoadProperty(randomInputStream, mapProperty);
        if (mapProperty.hasProperty("i2c")) {
            this.indexToCoord = mapProperty.getLVIntArray();
        }
    }

    @Override
    public final ZoneLeaf newLeaf(int n, int n2) {
        return new ZoneCube(this.layer, n, n2);
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyIntArray("i2c", this.indexToCoord);
    }

    @Override
    protected void calculateAxisTicksGlobal(AbstractAxisPlot abstractAxisPlot) {
        abstractAxisPlot.calculateAxisTicksGlobal(0, true, true);
        abstractAxisPlot.calculateAxisTicksGlobal(1, true, true);
        abstractAxisPlot.calculateAxisTicksGlobal(2, true, true);
        abstractAxisPlot.adjustToAspectRatioGlobal();
    }
}

