/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Properties;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.main.layer.AbstractAdvancedFrame;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.AbstractSettings;
import se.prediktera.map.plot.axisplot.settings.Shape.ContinuesShape;
import se.prediktera.map.plot.axisplot.settings.Shape.ShapeAdvanceFrame;
import se.prediktera.map.plot.axisplot.settings.Shape.ShapeRenderingBox;
import se.prediktera.map.plot.axisplot.settings.Shape.ShapeSettings;

public class ComboBoxShape
extends AbstractPlotSettingsBox
implements ItemListener {
    private ShapeRenderingBox boxShapeFixed = new ShapeRenderingBox(null);
    private final ContinuesShape continuesShape = new ContinuesShape(1);
    private int fixedStartIndex = -1;
    private boolean hasClassless = false;

    public ComboBoxShape(AbstractAxisLayer abstractAxisLayer, byte by) {
        super(abstractAxisLayer.getPlotInit().getMatrix(by), abstractAxisLayer);
        this.axis = by;
        int n = this.getPlotInit().initshape;
        this.boxShapeFixed.setSelectedIndex(n);
        this.continuesShape.setShape(0, (byte)n);
        this.boxShapeFixed.addItemListener(this);
    }

    @Override
    public void Calculate() {
        Object object;
        this.hasClassless = false;
        if (this.curType != 2 && (object = this.getShapeAdvanceSettings()) == null) {
            return;
        }
        object = this.layer.getLeafIterator();
        while (object.hasNext()) {
            this.initLeaf((ZoneLeaf)object.next());
        }
        this.boxShapeFixed.setEnabled(this.curType == 1);
    }

    @Override
    public void copySettingsFrom(AbstractPlotSettingsBox abstractPlotSettingsBox) {
        if (abstractPlotSettingsBox != null) {
            super.copySettingsFrom(abstractPlotSettingsBox);
            this.boxShapeFixed.setCurrentShape(((ComboBoxShape)abstractPlotSettingsBox).getBoxShapeFixed().getCurrentShape());
            if (abstractPlotSettingsBox.isAdvanceSettingsCreated()) {
                ShapeAdvanceFrame shapeAdvanceFrame = this.getShapeAdvanceSettings();
                if (shapeAdvanceFrame == null) {
                    return;
                }
                shapeAdvanceFrame.copySettings(abstractPlotSettingsBox.getAdvanceSettings());
            }
        }
    }

    public ShapeRenderingBox getBoxShapeFixed() {
        return this.boxShapeFixed;
    }

    public int getFixedShape() {
        return this.boxShapeFixed.getSelectedIndex();
    }

    public Properties getProperties() {
        ShapeAdvanceFrame shapeAdvanceFrame = this.getShapeAdvanceSettings();
        if (shapeAdvanceFrame == null) {
            return null;
        }
        return shapeAdvanceFrame.getProperties();
    }

    @Override
    public String getScript(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("setShape(\"");
        stringBuilder.append(this.getTypeName());
        stringBuilder.append("\", ");
        if (this.curType == 1) {
            stringBuilder.append("\"");
            stringBuilder.append(this.boxShapeFixed.getSelectedShape().getDescription().toLowerCase());
            stringBuilder.append("\"");
        } else {
            stringBuilder.append(this.axisIndex + 1);
            stringBuilder.append(ScriptHelper.generateString(this.getProperties()));
        }
        stringBuilder.append(");");
        return stringBuilder.toString();
    }

    @Override
    public AbstractSettings getSettings() {
        return new ShapeSettings();
    }

    public ShapeAdvanceFrame getShapeAdvanceSettings() {
        return (ShapeAdvanceFrame)this.getAdvanceSettings();
    }

    @Override
    public byte getType() {
        return 5;
    }

    @Override
    public boolean hasMultiUpdate() {
        return false;
    }

    @Override
    public void initLeaf(ZoneLeaf zoneLeaf) {
        if (this.curType == 2) {
            zoneLeaf.setShapeType((byte)-1);
            return;
        }
        if (this.curType == 7 || this.curType == 101 || this.curType == 19) {
            ShapeAdvanceFrame shapeAdvanceFrame = this.getShapeAdvanceSettings();
            if (shapeAdvanceFrame == null) {
                return;
            }
            ContinuesShape continuesShape = shapeAdvanceFrame.getContinuesShape();
            InnerColumnClass innerColumnClass = this.getClassColumn();
            if (innerColumnClass != null) {
                int n = zoneLeaf.getIndex(this.curType == 7 || this.curType == 19);
                short s = innerColumnClass.getValueShort(n);
                if (s == 0) {
                    this.hasClassless = true;
                }
                zoneLeaf.setShapeType(continuesShape.getShape(s));
            }
        } else if (this.curType == 1) {
            zoneLeaf.setShapeType(this.getBoxShapeFixed().getSelectedShape().getShapeType());
        } else if (this.curType == 21) {
            zoneLeaf.setShapeType((byte)-1);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        byte by;
        if (itemEvent.getStateChange() == 1 && (by = this.boxShapeFixed.getCurrentShape()) >= 0 && !this.isAdvanceSettingsShowing() && this.getShapeAdvanceSettings() != null) {
            this.layer.SettingsBoxChangeEvent(this, true);
            this.getShapeAdvanceSettings().setFixedShape(by);
            this.setSelected(this.curType, this.axisIndex);
        }
    }

    @Override
    public void LoadProperty(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super.LoadProperty(randomInputStream, mapProperty);
        if (mapProperty.hasProperty("sfI")) {
            this.fixedStartIndex = mapProperty.getLVInt();
        }
        this.hasClassless = mapProperty.getPropertyBoolean("hCl");
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyInt("sfI", this.boxShapeFixed.getSelectedIndex());
        if (this.hasClassless) {
            randomOutputStream.writePropertyBoolean("hCl", this.hasClassless);
        }
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        super.setCreated(abstractWindow_GUI, bl);
        this.boxShapeFixed.setResourceNode(this.getRootResourceNode());
        if (this.fixedStartIndex != -1) {
            this.boxShapeFixed.setSelectedIndex(this.fixedStartIndex);
        }
    }

    public void setFixedShape(int n) {
        this.boxShapeFixed.setCurrentShape(n);
    }

    @Override
    public void setOption(Object[] objectArray, Properties properties) {
        AbstractAxisPlot abstractAxisPlot = this.getAxisPlot();
        abstractAxisPlot.beginUpdate();
        super.setOption(objectArray, properties);
        if (properties != null) {
            ShapeAdvanceFrame shapeAdvanceFrame = this.getShapeAdvanceSettings();
            shapeAdvanceFrame.setProperties(properties);
        }
        abstractAxisPlot.endUpdate((byte)7);
    }

    @Override
    public void setSelectedChild() {
        this.Calculate();
        this.repaintLegends();
    }

    @Override
    public String toString() {
        return "by Shape";
    }

    @Override
    public void updateCalculation(boolean bl) {
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.boxShapeFixed != null) {
            this.boxShapeFixed.removeItemListener(this);
            this.boxShapeFixed = null;
        }
    }

    @Override
    protected AbstractAdvancedFrame createAdvanceSettings(MapProperty mapProperty) throws IOException {
        PlotInit plotInit = this.getPlotInit();
        if (mapProperty != null) {
            return new ShapeAdvanceFrame(mapProperty, (AbstractPlotSettingsBox)this, plotInit);
        }
        return new ShapeAdvanceFrame(this.continuesShape, (AbstractPlotSettingsBox)this, plotInit);
    }

    @Override
    protected boolean setComboItems(boolean bl, boolean bl2, boolean bl3) {
        this.setComboBoxWithData();
        return false;
    }

    @Override
    protected void setFixedOption(Object object) {
        int n = this.boxShapeFixed.getItemCount();
        if (object instanceof Double) {
            int n2 = ((Double)object).intValue() - 1;
            if (0 <= n2 && n2 < n) {
                ZoneLeaf zoneLeaf = (ZoneLeaf)this.boxShapeFixed.getItemAt(n2);
                this.setFixedShape(zoneLeaf.getShapeType());
            }
            return;
        }
        String string = String.valueOf(object);
        int n3 = this.boxShapeFixed.getShapeByName(string);
        if (n3 < 0) {
            throw new RuntimeException("Illegal shape option: " + String.valueOf(object));
        }
        this.setFixedShape(n3);
    }
}

