/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings;

import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import se.prediktera.map.common.JValidateNumberField;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.main.layer.AbstractAdvancedFrame;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot3D.scatter3D.Scatter3DLayer;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.AbstractSettings;
import se.prediktera.map.plot.axisplot.settings.Size.ContinuousSize;
import se.prediktera.map.plot.axisplot.settings.Size.SizeAdvanceFrame;
import se.prediktera.map.plot.axisplot.settings.Size.SizeSettings;

public class ComboBoxSize
extends AbstractPlotSettingsBox {
    private final JValidateNumberField boxMaxSize = new JValidateNumberField(1.0, 120.0, false);
    private final JValidateNumberField boxMinSize = new JValidateNumberField(1.0, 120.0, false);

    public ComboBoxSize(AbstractAxisLayer abstractAxisLayer, byte by) {
        super(abstractAxisLayer.getPlotInit().getMatrix(by), abstractAxisLayer);
        this.boxMaxSize.setEnabled(false);
        this.boxMaxSize.setNumber(30.0);
        this.boxMinSize.setupAutoChange();
        this.boxMaxSize.setupAutoChange();
        int n = this.getPlotInit().initsize;
        this.boxMinSize.setNumber(n < 0 ? 7.0 : (double)n);
        this.boxMaxSize.setNumberChangedInterface(new NumberMinMax());
        this.boxMinSize.setNumberChangedInterface(new NumberMinMax());
    }

    @Override
    public void Calculate() {
        if (this.curType != 9 && this.curType != 1 && this.curType != 7 && this.curType != 19) {
            this.calculateMinMaxMissing();
        }
        this.setEnabled(this.isEnabled());
        this.setPerspective();
        Iterator<ZoneLeaf> iterator = this.layer.getLeafIterator();
        while (iterator.hasNext()) {
            this.initLeaf(iterator.next());
        }
    }

    @Override
    public void copySettingsFrom(AbstractPlotSettingsBox abstractPlotSettingsBox) {
        if (abstractPlotSettingsBox != null) {
            super.copySettingsFrom(abstractPlotSettingsBox);
            this.boxMaxSize.setNumberIntern(((ComboBoxSize)abstractPlotSettingsBox).getMaxValue());
            int n = this.getPlotInit().initsize;
            this.boxMinSize.setNumberIntern(n < 0 ? (double)((ComboBoxSize)abstractPlotSettingsBox).getMinValue() : (double)n);
        }
    }

    public JValidateNumberField getBoxMaxSize() {
        return this.boxMaxSize;
    }

    public JValidateNumberField getBoxMinSize() {
        return this.boxMinSize;
    }

    public int getMaxValue() {
        return (int)this.boxMaxSize.getNumber();
    }

    public int getMinValue() {
        return (int)this.boxMinSize.getNumber();
    }

    @Override
    public String getScript(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("setSize(\"");
        stringBuilder.append(this.getTypeName());
        stringBuilder.append("\", ");
        stringBuilder.append((int)this.boxMinSize.getNumber());
        stringBuilder.append(", ");
        stringBuilder.append((int)this.boxMaxSize.getNumber());
        stringBuilder.append(");");
        return stringBuilder.toString();
    }

    @Override
    public AbstractSettings getSettings() {
        return new SizeSettings();
    }

    @Override
    public byte getType() {
        return 4;
    }

    @Override
    public boolean hasMultiUpdate() {
        return false;
    }

    @Override
    public void initLeaf(ZoneLeaf zoneLeaf) {
        double d = 7.0;
        if (this.layer instanceof Scatter3DLayer && this.curType == 9) {
            d = 1.0;
        }
        if (this.curType == 0) {
            double d2;
            double[] dArray = this.minmaxAxis;
            double d3 = dArray[1] - dArray[0];
            double d4 = this.boxMinSize.getNumber();
            double d5 = this.boxMaxSize.getNumber();
            d5 = this.boxMaxSize.isEnabled() ? d5 : d4;
            double d6 = d5 - d4;
            int n = this.getCoordSizePrimary();
            int n2 = this.getOrigIndexPrimary(zoneLeaf.getPrimaryIndex());
            double d7 = d2 = n2 < 0 || n2 >= n || this.isMissingPrimary(n2) ? dArray[0] : this.getCoordPrimary(n2);
            d = Double.compare(d3, 0.0) == 0 ? d4 : (d2 - dArray[0]) / d3 * d6 + d4;
        } else if (this.curType == 1) {
            d = this.boxMinSize.getNumber();
        } else if (this.curType == 7 || this.curType == 101 || this.curType == 19) {
            InnerColumnClass innerColumnClass;
            ContinuousSize continuousSize;
            SizeAdvanceFrame sizeAdvanceFrame = (SizeAdvanceFrame)this.getAdvanceSettings();
            if (sizeAdvanceFrame != null && (continuousSize = sizeAdvanceFrame.getContinuousSize()) != null && (innerColumnClass = this.getClassColumn()) != null) {
                int n = zoneLeaf.getIndex(this.curType != 101);
                short s = innerColumnClass.getValueShort(n);
                d = continuousSize.getSize(s);
            }
        } else if (this.curType == 4) {
            double d8 = this.boxMinSize.getNumber();
            double d9 = this.getCoordSizePrimary();
            if (Double.compare(d9, 0.0) == 0) {
                d = d8;
            } else {
                double d10 = this.boxMaxSize.getNumber();
                d10 = this.boxMaxSize.isEnabled() ? d10 : d8;
                int n = this.getOrigIndexPrimary(zoneLeaf.getPrimaryIndex());
                double d11 = d10 - d8;
                d = (double)n / d9 * d11 + d8;
            }
        }
        zoneLeaf.setSize((byte)(this.curType == 1 ? d : Math.max(1.0, d)));
    }

    @Override
    public void LoadProperty(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super.LoadProperty(randomInputStream, mapProperty);
        if (mapProperty.hasProperty("bmaxs")) {
            this.boxMaxSize.setNumber(mapProperty.getLVInt());
        }
        if (mapProperty.hasProperty("bmins")) {
            this.boxMinSize.setNumber(mapProperty.getLVInt());
        }
        this.setEnabled(this.isEnabled());
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyInt("bmaxs", (int)this.boxMaxSize.getNumber());
        randomOutputStream.writePropertyInt("bmins", (int)this.boxMinSize.getNumber());
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        super.setCreated(abstractWindow_GUI, bl);
        this.setPerspective();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.boxMinSize.setEnabled(bl && this.curType != 7 && this.curType != 101 && this.curType != 19);
        this.boxMaxSize.setEnabled(bl && this.curType != 1 && this.curType != 7 && this.curType != 101 && this.curType != 19);
    }

    public void setMaxValue(int n) {
        this.boxMaxSize.setNumber(n);
    }

    public void setMinValue(int n) {
        this.boxMinSize.setNumber(n);
    }

    @Override
    public void setOption(Object[] objectArray, Properties properties) {
        if (objectArray.length == 2) {
            Double[] doubleArray = null;
            if (objectArray[1] instanceof Double[]) {
                doubleArray = (Double[])objectArray[1];
            } else if (objectArray[1] instanceof Double) {
                doubleArray = new Double[]{(Double)objectArray[1]};
            }
            if (doubleArray != null) {
                this.boxMinSize.setNumber(doubleArray[0].intValue());
                if (doubleArray.length > 1) {
                    this.boxMaxSize.setNumber(doubleArray[1].intValue());
                }
            }
        }
        super.setOption(objectArray, properties);
    }

    @Override
    public void setSelectedChild() {
        this.Calculate();
    }

    @Override
    public String toString() {
        return "Size";
    }

    @Override
    public void updateCalculation(boolean bl) {
        if (bl) {
            this.Calculate();
        }
    }

    @Override
    protected AbstractAdvancedFrame createAdvanceSettings(MapProperty mapProperty) throws IOException {
        PlotInit plotInit = this.getPlotInit();
        if (mapProperty != null) {
            return new SizeAdvanceFrame(mapProperty, this, plotInit);
        }
        return new SizeAdvanceFrame(this, plotInit);
    }

    @Override
    protected boolean setComboItems(boolean bl, boolean bl2, boolean bl3) {
        this.setComboBoxWithData();
        return false;
    }

    @Override
    protected void setFixedOption(Object object) {
        if (object instanceof Double) {
            this.boxMinSize.setNumber((Double)object);
        } else if (object instanceof Double[]) {
            this.boxMinSize.setNumber(((Double[])object)[0]);
        } else {
            this.boxMinSize.setNumber(Double.parseDouble(object.toString()));
        }
    }

    private void setPerspective() {
        if (this.layer instanceof Scatter3DLayer) {
            if (this.curType == 9) {
                double d = this.boxMinSize.getNumber();
                double d2 = this.boxMaxSize.getNumber();
                ((Scatter3DLayer)this.layer).setPerspective(true, d, d2);
            } else {
                ((Scatter3DLayer)this.layer).setPerspective(false, 0.0, 0.0);
            }
        }
    }

    class NumberMinMax
    implements JValidateNumberField.NumberChangedInterface {
        NumberMinMax() {
        }

        @Override
        public void NumberChanged(int n, double d) {
            ComboBoxSize.this.layer.SettingsBoxChangeEvent(ComboBoxSize.this, true);
            ComboBoxSize.this.Calculate();
            ComboBoxSize.this.SyncronizeComboBox();
            ComboBoxSize.this.getAxisPlot().contentPaint((byte)7);
        }
    }
}

