/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.wizard.PageInterface;
import se.prediktera.map.main.layer.AbstractAdvancedFrame;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;

public class DefaultSettingsCardPanel
extends CleanUpPanel
implements PageInterface {
    private RadioButtonPanel radioButtonPanel = new RadioButtonPanel();
    private final JPanel settingsPanel = new JPanel(new BorderLayout());
    private JPanel settingsCardPanel = null;
    private final CardLayout cardLayout = new CardLayout();
    private final Map<String, String> eqconstrainsMap = new HashMap<String, String>();
    private AbstractAdvancedFrame advanceFrame;

    public DefaultSettingsCardPanel(AbstractAdvancedFrame abstractAdvancedFrame) {
        super("DefaultSettingsCardPanel");
        this.advanceFrame = abstractAdvancedFrame;
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.radioButtonPanel);
        this.add(this.settingsPanel);
    }

    public void addGlobalSettingsPanel(JPanel jPanel) {
        this.settingsPanel.add((Component)jPanel, "South");
    }

    public JRadioButton addRadioButton(String string, int n, AbstractSettingsPanel abstractSettingsPanel) {
        return this.addRadioButtonGlobal(string, n, abstractSettingsPanel, string);
    }

    public JRadioButton addRadioButtonGlobal(String string, int n, AbstractSettingsPanel abstractSettingsPanel, String string2) {
        JRadioButton jRadioButton;
        String string3 = String.valueOf(n);
        String string4 = this.radioButtonPanel.getConstrains(abstractSettingsPanel);
        if (string4 == null) {
            jRadioButton = this.radioButtonPanel.addRadioButton(string, string3, abstractSettingsPanel);
            if (abstractSettingsPanel != null) {
                this.getSettingsCardPanel().add((Component)abstractSettingsPanel, string3);
                abstractSettingsPanel.setBorder(EvinceBorderFactory.createEvinceBorder(string2));
            }
        } else {
            this.eqconstrainsMap.put(string3, string4);
            jRadioButton = this.radioButtonPanel.addRadioButton(string, string3, abstractSettingsPanel);
        }
        return jRadioButton;
    }

    public JRadioButton getCurrentRadioButton() {
        return this.radioButtonPanel.getCurrentRadioButton();
    }

    public int getSelected() {
        return this.radioButtonPanel.getSelected();
    }

    public JPanel getSelectedPanel() {
        return this.radioButtonPanel.getSelectedPanel();
    }

    public boolean isEnabled(int n) {
        return this.radioButtonPanel.isEnabled(String.valueOf(n));
    }

    @Override
    public void pageShown() {
        JPanel jPanel = this.getSelectedPanel();
        if (jPanel instanceof PageInterface) {
            ((PageInterface)((Object)jPanel)).pageShown();
        }
    }

    public void setEnabled(int n, boolean bl) {
        this.radioButtonPanel.setEnabled(String.valueOf(n), bl);
    }

    public void setSelected(int n) {
        this.radioButtonPanel.setSelected(String.valueOf(n));
    }

    @Override
    protected void cleanUpChild() {
        if (this.radioButtonPanel != null) {
            this.radioButtonPanel.cleanUp();
            this.radioButtonPanel = null;
        }
        this.advanceFrame = null;
    }

    private JPanel getSettingsCardPanel() {
        if (this.settingsCardPanel == null) {
            this.settingsCardPanel = new JPanel(this.cardLayout);
            this.settingsPanel.add((Component)this.settingsCardPanel, "Center");
        }
        return this.settingsCardPanel;
    }

    private class RadioButtonPanel
    extends CleanUpPanel {
        private RadioButtonListener radioButtonListener;
        private int radiocount;
        private final ButtonGroup radioButtonGroup;
        private JExtendedRadioButton currentRadioButton;

        public RadioButtonPanel() {
            super("RadioButtonPanel", new GridBagLayout());
            this.radioButtonListener = new RadioButtonListener();
            this.radiocount = 0;
            this.radioButtonGroup = new ButtonGroup();
            this.setBorder(EvinceBorderFactory.createEvinceBorder("Options"));
        }

        public JRadioButton addRadioButton(String string, String string2, AbstractSettingsPanel abstractSettingsPanel) {
            JExtendedRadioButton jExtendedRadioButton = new JExtendedRadioButton(string2);
            jExtendedRadioButton.setText(string);
            jExtendedRadioButton.setAbstractPanel(abstractSettingsPanel);
            this.add((Component)jExtendedRadioButton, new GridBagConstraints(0, this.radiocount, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            jExtendedRadioButton.addItemListener(this.radioButtonListener);
            this.radioButtonGroup.add(jExtendedRadioButton);
            ++this.radiocount;
            if (this.currentRadioButton == null) {
                this.setSelected(string2);
            }
            return jExtendedRadioButton;
        }

        public String getConstrains(AbstractSettingsPanel abstractSettingsPanel) {
            Enumeration<AbstractButton> enumeration = this.radioButtonGroup.getElements();
            while (enumeration.hasMoreElements()) {
                JExtendedRadioButton jExtendedRadioButton = (JExtendedRadioButton)enumeration.nextElement();
                if (jExtendedRadioButton.getAbstractPanel() == null || !jExtendedRadioButton.getAbstractPanel().equals(abstractSettingsPanel)) continue;
                return jExtendedRadioButton.getConstrains();
            }
            return null;
        }

        public JRadioButton getCurrentRadioButton() {
            return this.currentRadioButton;
        }

        public int getSelected() {
            if (this.currentRadioButton != null) {
                return Integer.parseInt(this.currentRadioButton.getConstrains());
            }
            return -1;
        }

        public JPanel getSelectedPanel() {
            if (this.currentRadioButton != null) {
                return this.currentRadioButton.getAbstractPanel();
            }
            return null;
        }

        public boolean isEnabled(String string) {
            for (int i = 0; i < this.radiocount; ++i) {
                JExtendedRadioButton jExtendedRadioButton = (JExtendedRadioButton)this.getComponent(i);
                if (!jExtendedRadioButton.getConstrains().equals(string)) continue;
                return jExtendedRadioButton.isEnabled();
            }
            return false;
        }

        public void setEnabled(String string, boolean bl) {
            for (int i = 0; i < this.radiocount; ++i) {
                JExtendedRadioButton jExtendedRadioButton = (JExtendedRadioButton)this.getComponent(i);
                if (!jExtendedRadioButton.getConstrains().equals(string)) continue;
                jExtendedRadioButton.setEnabled(bl);
            }
        }

        public void setSelected(String string) {
            for (int i = 0; i < this.radiocount; ++i) {
                JExtendedRadioButton jExtendedRadioButton = (JExtendedRadioButton)this.getComponent(i);
                if (!jExtendedRadioButton.getConstrains().equals(string)) continue;
                jExtendedRadioButton.setSelected(true);
                this.currentRadioButton = jExtendedRadioButton;
                break;
            }
        }

        @Override
        protected void cleanUpChild() {
            Enumeration<AbstractButton> enumeration = this.radioButtonGroup.getElements();
            while (enumeration.hasMoreElements()) {
                JExtendedRadioButton jExtendedRadioButton = (JExtendedRadioButton)enumeration.nextElement();
                if (jExtendedRadioButton.getAbstractPanel() == null) continue;
                jExtendedRadioButton.getAbstractPanel().cleanUp();
                jExtendedRadioButton.setAbstractPanel(null);
                jExtendedRadioButton.removeItemListener(this.radioButtonListener);
            }
            this.radioButtonListener = null;
        }

        private class RadioButtonListener
        implements ItemListener {
            private RadioButtonListener() {
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    RadioButtonPanel.this.currentRadioButton = (JExtendedRadioButton)itemEvent.getItem();
                    RadioButtonPanel.this.currentRadioButton.pageShown();
                    if (DefaultSettingsCardPanel.this.settingsCardPanel != null) {
                        try {
                            String string = DefaultSettingsCardPanel.this.eqconstrainsMap.get(RadioButtonPanel.this.currentRadioButton.constrains);
                            if (string == null) {
                                string = RadioButtonPanel.this.currentRadioButton.constrains;
                            }
                            DefaultSettingsCardPanel.this.cardLayout.show(DefaultSettingsCardPanel.this.settingsCardPanel, string);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    DefaultSettingsCardPanel.this.advanceFrame.radioButtonChanged(RadioButtonPanel.this.currentRadioButton);
                }
            }
        }

        private class JExtendedRadioButton
        extends JRadioButton {
            private final String constrains;
            private AbstractSettingsPanel panel;

            public JExtendedRadioButton(String string) {
                this.constrains = string;
            }

            public AbstractSettingsPanel getAbstractPanel() {
                return this.panel;
            }

            public String getConstrains() {
                return this.constrains;
            }

            public void pageShown() {
                if (this.panel != null) {
                    this.panel.pageShown(this.constrains);
                }
            }

            public void setAbstractPanel(AbstractSettingsPanel abstractSettingsPanel) {
                this.panel = abstractSettingsPanel;
            }
        }
    }
}

