/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings.Description;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretListener;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.JValidateNumberField;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.swing.JFontChooser;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.settings.AbstractAdvanceSettings;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;
import se.prediktera.map.plot.axisplot.settings.Axis.DataSearchPanel;
import se.prediktera.map.plot.axisplot.settings.ComboBoxDescription;

public class DescriptionAdvanceFrame
extends AbstractAdvanceSettings {
    private FixedDescriptionPanel fixedDescriptionPanel;

    public DescriptionAdvanceFrame(AbstractPlotSettingsBox abstractPlotSettingsBox, PlotInit plotInit, Font font) {
        super("Advanced Label Settings", abstractPlotSettingsBox, plotInit);
        this.fixedDescriptionPanel = new FixedDescriptionPanel(font);
        this.dataSearchPanel = new DataSearchPanel(abstractPlotSettingsBox, plotInit);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public final int getLength() {
        return this.fixedDescriptionPanel.getLength();
    }

    public final int getStartPos() {
        return this.fixedDescriptionPanel.getStartPos();
    }

    @Override
    public void Save(RandomOutputStream randomOutputStream) throws IOException {
    }

    public final void setLength(int n) {
        this.fixedDescriptionPanel.setLength(n);
    }

    public final void setStartPos(int n) {
        this.fixedDescriptionPanel.setStartPos(n);
    }

    @Override
    public void showModal() {
        this.fixedDescriptionPanel.setExample();
        super.showModal();
    }

    @Override
    public void SyncronizeComboBox(AbstractDataMatrix abstractDataMatrix, int n, int n2) {
        if (0 == n) {
            this.dataSearchPanel.synchronize(abstractDataMatrix, n2);
        }
        this.settingsCardPanel.setSelected(n);
        this.fixedDescriptionPanel.setFixedFont(((ComboBoxDescription)this.settingsBox).getLabelFont());
        this.fixedDescriptionPanel.setExample();
    }

    public final String trimDescription(String string) {
        if (string == null) {
            return "-";
        }
        int n = this.getStartPos();
        int n2 = this.getLength();
        if (string.length() > 0 && (n > 0 || string.length() > n2)) {
            int n3 = n;
            int n4 = Math.min(string.length(), n3 + n2);
            if (n3 < n4) {
                return string.substring(n3, n4);
            }
            return "-";
        }
        return string;
    }

    @Override
    protected void applyChanges() {
        int n = this.settingsCardPanel.getSelected();
        ((ComboBoxDescription)this.settingsBox).setLabelFont(this.fixedDescriptionPanel.getFixedFont());
        if (0 == n) {
            this.settingsBox.setMatrix(this.dataSearchPanel.getMatrix(), false);
            this.settingsBox.setSelected(n, this.dataSearchPanel.getIndex());
        } else {
            this.settingsBox.setSelected(n, this.settingsBox.getAxisIndex());
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.dataSearchPanel != null) {
            this.dataSearchPanel.cleanUp();
            this.dataSearchPanel = null;
        }
        if (this.fixedDescriptionPanel != null) {
            this.fixedDescriptionPanel.cleanUp();
            this.fixedDescriptionPanel = null;
        }
    }

    private void jbInit() throws Exception {
        Object object;
        this.settingsTabbed.addTab("Label", this.settingsCardPanel);
        int n = this.settingsBox.getItemCount();
        block9: for (int i = 0; i < n && (object = this.settingsBox.getItemAt(i)) instanceof ComboItem; ++i) {
            ComboItem comboItem = (ComboItem)object;
            if (!((ComboItem)object).isMainitem()) break;
            switch (comboItem.getType()) {
                case 2: {
                    this.settingsCardPanel.addRadioButtonGlobal("No Label", 2, this.fixedDescriptionPanel, "Label Settings");
                    continue block9;
                }
                case 4: {
                    this.settingsCardPanel.addRadioButtonGlobal(this.settingsBox.getNiceMainString(4), 4, this.fixedDescriptionPanel, "Label Settings");
                    continue block9;
                }
                case 5: {
                    this.settingsCardPanel.addRadioButtonGlobal(this.settingsBox.getNiceMainString(5), 5, this.fixedDescriptionPanel, "Label Settings");
                    continue block9;
                }
                case 7: {
                    this.settingsCardPanel.addRadioButtonGlobal(this.settingsBox.getNiceMainString(7), 7, this.fixedDescriptionPanel, "Label Settings");
                    continue block9;
                }
                case 101: {
                    this.settingsCardPanel.addRadioButtonGlobal(this.settingsBox.getNiceMainString(101), 101, this.fixedDescriptionPanel, "Label Settings");
                    continue block9;
                }
                case 19: {
                    this.settingsCardPanel.addRadioButtonGlobal(this.settingsBox.getNiceMainString(19), 19, this.fixedDescriptionPanel, "Label Settings");
                    continue block9;
                }
                case 0: {
                    this.settingsCardPanel.addRadioButtonGlobal(this.settingsBox.getNiceMainString(0), 0, this.fixedDescriptionPanel, "Label Settings");
                }
            }
        }
        this.settingsTabbed.addTab("Label Source", this.dataSearchPanel);
    }

    private class FixedDescriptionPanel
    extends AbstractSettingsPanel {
        private final JTextField example = new JTextField();
        private final JFontChooser fontChooser = new JFontChooser(new JTextField(2));
        private final JTextFieldButtonUppDown descrStartPos = new JTextFieldButtonUppDown(1.0, 2.147483647E9, false);
        private final JTextFieldButtonUppDown descrLength = new JTextFieldButtonUppDown(1.0, 2.147483647E9, false);

        public FixedDescriptionPanel(Font font) {
            this.init(font);
        }

        public Font getFixedFont() {
            return this.fontChooser.getSelectedFont();
        }

        @Override
        public void pageShown(String string) {
            this.example.grabFocus();
            this.setExample();
            int n = DescriptionAdvanceFrame.this.settingsCardPanel.getSelected();
            boolean bl = n != 2;
            this.descrLength.setEnabled(bl);
            this.descrStartPos.setEnabled(bl);
            this.fontChooser.setEnabled(bl);
        }

        public void Save(RandomOutputStream randomOutputStream) throws IOException {
        }

        public void setFixedFont(Font font) {
            if (this.fontChooser != null) {
                this.fontChooser.selectFont(font);
            }
        }

        public final void setStartPos(int n) {
            this.descrStartPos.setNumber(n + 1);
        }

        private final int getLength() {
            return (int)this.descrLength.getNumber();
        }

        private final int getStartPos() {
            return (int)this.descrStartPos.getNumber() - 1;
        }

        private void init(Font font) {
            AbstractAxisLayer abstractAxisLayer = ((AbstractPlotSettingsBox)DescriptionAdvanceFrame.this.settingsBox).getLayer();
            if (abstractAxisLayer != null) {
                this.fontChooser.setShowFontStyles(!abstractAxisLayer.is3d());
            }
            JValidateNumberField.NumberChangedInterface numberChangedInterface = (n, d) -> this.setExample();
            this.descrStartPos.setNumberChangedInterface(numberChangedInterface);
            this.descrLength.setNumberChangedInterface(numberChangedInterface);
            this.example.addCaretListener(caretEvent -> {
                boolean bl = caretEvent.getDot() < caretEvent.getMark();
                int n = bl ? caretEvent.getDot() : caretEvent.getMark();
                int n2 = Math.abs(caretEvent.getMark() - caretEvent.getDot());
                if (n2 == 0) {
                    n2 = 1;
                }
                if (this.getStartPos() != n) {
                    this.descrStartPos.setNumber(n + 1);
                }
                if (this.getLength() != n2) {
                    this.descrLength.setNumber(n2);
                }
            });
            this.example.setEditable(false);
            this.example.setBackground(Color.white);
            this.descrStartPos.setNumber(1.0);
            this.descrLength.setNumber(100.0);
            this.removeScrolling();
            this.setPreferredSize(new Dimension(380, 400));
            this.centerPanel.add((Component)this.fontChooser, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 0, 0, 0), 0, 0));
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Label Constraints"));
            jPanel.add((Component)new JLabel("Select:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(6, 6, 0, 0), 0, 0));
            jPanel.add((Component)this.example, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 6), 0, 0));
            jPanel.add((Component)new JLabel("Start position:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(6, 6, 0, 0), 0, 0));
            jPanel.add((Component)this.descrStartPos, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 6), 0, 0));
            jPanel.add((Component)new JLabel("Length:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(6, 6, 6, 0), 0, 0));
            jPanel.add((Component)this.descrLength, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 6, 6, 6), 0, 0));
            this.centerPanel.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 17, 2, new Insets(6, 0, 0, 0), 0, 0));
        }

        private void setExample() {
            CaretListener[] caretListenerArray;
            int n = DescriptionAdvanceFrame.this.settingsCardPanel.getSelected();
            String string = ((ComboBoxDescription)DescriptionAdvanceFrame.this.settingsBox).getDescriptionNoTrim(n, 0, 0, 0, 0);
            int n2 = this.getStartPos();
            int n3 = n2 + this.getLength();
            for (CaretListener caretListener : caretListenerArray = this.example.getCaretListeners()) {
                this.example.removeCaretListener(caretListener);
            }
            this.example.setText(string + "                                                     ");
            this.example.select(n2, n3);
            for (CaretListener caretListener : caretListenerArray) {
                this.example.addCaretListener(caretListener);
            }
        }

        private final void setLength(int n) {
            this.descrLength.setNumber(n);
        }
    }
}

