/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings.Lines;

import com.jogamp.opengl.GL2;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import se.prediktera.map.common.swing.ComboBoxItemPaint;

public class LineStyle
extends ComboBoxItemPaint {
    public static final int SOLID = 0;
    public static final int DASHED = 1;
    public static final int DASHED2 = 2;
    public static final int DOTTED = 3;
    public static final String[] DESCRIPTION = new String[]{"   Solid", "   Dashed", "   Dashed2", "   Dotted"};
    private static final float[] dash1 = new float[]{10.0f};
    private static final float[] dash2 = new float[]{6.0f, 4.0f, 2.0f, 4.0f, 2.0f, 4.0f};
    private static final float[] dotted = new float[]{2.0f, 2.0f};
    private BasicStroke linestyle;
    private int type;
    private float lineWidth = 1.0f;

    public LineStyle(int n) {
        this.type = n;
        this.setLineStyle();
    }

    public final void beginDraw(GL2 gL2) {
        gL2.glColor3f(0.0f, 0.0f, 0.0f);
        gL2.glLineWidth(this.lineWidth);
        gL2.glEnable(2852);
        switch (this.type) {
            case 1: {
                gL2.glLineStipple(1, (short)-256);
                break;
            }
            case 2: {
                gL2.glLineStipple(1, (short)-3172);
                break;
            }
            case 3: {
                gL2.glLineStipple(1, (short)-13108);
                break;
            }
            default: {
                gL2.glDisable(2852);
            }
        }
    }

    public final void beginDraw(Graphics2D graphics2D) {
        graphics2D.setStroke(this.linestyle);
        graphics2D.setColor(Color.black);
    }

    public final void drawLine(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setStroke(this.linestyle);
        graphics2D.setColor(Color.black);
        graphics2D.drawLine(n, n2, n3, n4);
    }

    public final void drawLineNoSet(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.drawLine(n, n2, n3, n4);
    }

    public String getDescription() {
        if (this.type < DESCRIPTION.length) {
            return DESCRIPTION[this.type];
        }
        return "None";
    }

    public BasicStroke getStroke() {
        return this.linestyle;
    }

    @Override
    public void paintCustom(Graphics2D graphics2D) {
        Dimension dimension = this.getPreferredSize();
        this.drawLine(graphics2D, 0, dimension.height / 2, dimension.width, dimension.height / 2);
    }

    public void setLineStyle(int n) {
        this.type = n;
        this.setLineStyle();
    }

    public void setLineStyle(LineStyle lineStyle) {
        this.type = lineStyle.type;
        this.setLineStyle();
    }

    public void setLineWidth(float f) {
        if (Float.compare(this.lineWidth, f) != 0) {
            this.lineWidth = f;
            this.setLineStyle();
        }
    }

    private void setLineStyle() {
        switch (this.type) {
            case 1: {
                this.linestyle = new BasicStroke(this.lineWidth, 0, 0, 10.0f, dash1, 0.0f);
                break;
            }
            case 2: {
                this.linestyle = new BasicStroke(this.lineWidth, 0, 0, 10.0f, dash2, 0.0f);
                break;
            }
            case 3: {
                this.linestyle = new BasicStroke(this.lineWidth, 1, 0, 10.0f, dotted, 0.0f);
                break;
            }
            default: {
                this.linestyle = new BasicStroke(this.lineWidth, 1, 0, 10.0f);
            }
        }
    }
}

