/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings.Lines;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.IOException;
import javax.swing.JLabel;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.settings.AbstractAdvanceSettings;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;
import se.prediktera.map.plot.axisplot.settings.Axis.DataSearchPanel;
import se.prediktera.map.plot.axisplot.settings.ComboBoxLines;
import se.prediktera.map.plot.axisplot.settings.Lines.LineRenderingList;

public class LinesAdvanceFrame
extends AbstractAdvanceSettings {
    private FixedLinePanel fixedLinePanel = new FixedLinePanel(0);

    public LinesAdvanceFrame(AbstractPlotSettingsBox abstractPlotSettingsBox, PlotInit plotInit) {
        super("Advanced Lines Settings", abstractPlotSettingsBox, plotInit);
        this.dataSearchPanel = new DataSearchPanel(abstractPlotSettingsBox, plotInit);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public int getLinesType() {
        return this.settingsCardPanel.getSelected();
    }

    @Override
    public void Save(RandomOutputStream randomOutputStream) throws IOException {
    }

    @Override
    public void showModal() {
        super.setVisible(true);
    }

    @Override
    public void SyncronizeComboBox(AbstractDataMatrix abstractDataMatrix, int n, int n2) {
        if (0 == n) {
            this.dataSearchPanel.synchronize(abstractDataMatrix, n2);
        }
        this.settingsCardPanel.setSelected(n);
        this.fixedLinePanel.setLineType(((ComboBoxLines)this.settingsBox).getLineType());
    }

    @Override
    protected void applyChanges() {
        int n = this.getLinesType();
        ((ComboBoxLines)this.settingsBox).setLineType(this.fixedLinePanel.getLineType());
        if (n == 2 || n == 4) {
            this.settingsBox.setSelected(n, 0);
        } else {
            this.settingsBox.setMatrix(this.dataSearchPanel.getMatrix(), false);
            this.settingsBox.setSelected(n, this.dataSearchPanel.getIndex());
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.dataSearchPanel != null) {
            this.dataSearchPanel.cleanUp();
            this.dataSearchPanel = null;
        }
        if (this.fixedLinePanel != null) {
            this.fixedLinePanel.cleanUp();
            this.fixedLinePanel = null;
        }
    }

    private void jbInit() throws Exception {
        Object object;
        this.settingsTabbed.addTab("Lines", this.settingsCardPanel);
        int n = this.settingsBox.getItemCount();
        block5: for (int i = 0; i < n && (object = this.settingsBox.getItemAt(i)) instanceof ComboItem; ++i) {
            ComboItem comboItem = (ComboItem)object;
            if (!((ComboItem)object).isMainitem()) break;
            switch (comboItem.getType()) {
                case 2: {
                    this.settingsCardPanel.addRadioButtonGlobal("No lines", 2, this.fixedLinePanel, "Line type");
                    continue block5;
                }
                case 4: {
                    this.settingsCardPanel.addRadioButtonGlobal(this.settingsBox.getNiceMainString(4), 4, this.fixedLinePanel, "Line type");
                    continue block5;
                }
                case 0: {
                    this.settingsCardPanel.addRadioButtonGlobal(this.settingsBox.getNiceMainString(0), 0, this.fixedLinePanel, "Line type");
                }
            }
        }
        this.settingsTabbed.addTab("Lines Source", this.dataSearchPanel);
    }

    private class FixedLinePanel
    extends AbstractSettingsPanel {
        private LineRenderingList lineRenderingList;

        public FixedLinePanel(int n) {
            this.init(n);
        }

        public int getLineType() {
            return this.lineRenderingList.getSelectedIndex();
        }

        public void setLineType(int n) {
            if (this.lineRenderingList != null) {
                this.lineRenderingList.setSelectedIndex(n);
            }
        }

        private void init(int n) {
            this.lineRenderingList = new LineRenderingList();
            this.lineRenderingList.setSelectedIndex(n);
            this.northPanel.add((Component)new JLabel("Select line type in the list below"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 6, 6), 0, 0));
            this.centerPanel.add((Component)this.lineRenderingList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(6, 12, 12, 12), 0, 0));
        }
    }
}

