/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings.Range;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.ArrayList;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.plot.axisplot.settings.ComboBoxRange;

public class RangePanel
extends CleanUpPanel {
    private final ArrayList<Block> xblock;
    private final ArrayList<Block> yblock;
    private ComboBoxRange rangeBox;
    private Block selectedX;
    private Block selectedY;

    public RangePanel(ComboBoxRange comboBoxRange) {
        this.xblock = new ArrayList();
        this.yblock = new ArrayList();
        this.selectedX = null;
        this.selectedY = null;
        this.rangeBox = comboBoxRange;
    }

    public RangePanel(ComboBoxRange comboBoxRange, MapProperty mapProperty) {
        block8: {
            Block block;
            int n;
            int n2;
            block7: {
                this.xblock = new ArrayList();
                this.yblock = new ArrayList();
                this.selectedX = null;
                this.selectedY = null;
                this.rangeBox = comboBoxRange;
                if (mapProperty.hasProperty("xb")) {
                    n2 = mapProperty.getLVInt();
                    for (n = 0; n < n2; ++n) {
                        block = new Block();
                        block.min = mapProperty.getPropertyInt("xbmin" + n);
                        block.max = mapProperty.getPropertyInt("xbmax" + n);
                        this.yblock.add(block);
                    }
                } else if (mapProperty.hasProperty("ybl")) {
                    n2 = mapProperty.getLVInt();
                    for (n = 0; n < n2; ++n) {
                        block = new Block();
                        block.min = mapProperty.getPropertyInt("ybmin" + n);
                        block.max = mapProperty.getPropertyInt("ybmax" + n);
                        this.yblock.add(block);
                    }
                }
                if (!mapProperty.hasProperty("yb")) break block7;
                n2 = mapProperty.getLVInt();
                for (n = 0; n < n2; ++n) {
                    block = new Block();
                    block.min = mapProperty.getPropertyInt("ybmin" + n);
                    block.max = mapProperty.getPropertyInt("ybmax" + n);
                    this.xblock.add(block);
                }
                break block8;
            }
            if (!mapProperty.hasProperty("xbl")) break block8;
            n2 = mapProperty.getLVInt();
            for (n = 0; n < n2; ++n) {
                block = new Block();
                block.min = mapProperty.getPropertyInt("xbmin" + n);
                block.max = mapProperty.getPropertyInt("xbmax" + n);
                this.xblock.add(block);
            }
        }
    }

    public Block addXblock() {
        Block block = new Block();
        this.xblock.add(block);
        block.min = this.getXprev(block);
        block.max = this.getXnext(block);
        return block;
    }

    public Block addYblock() {
        Block block = new Block();
        this.yblock.add(block);
        block.min = this.getYprev(block);
        block.max = this.getYnext(block);
        return block;
    }

    public int getMatrixColumnSize() {
        int n = 0;
        for (Block block : this.xblock) {
            n += block.max - block.min + 1;
        }
        return n;
    }

    public int getMatrixRowSize() {
        int n = 0;
        for (Block block : this.yblock) {
            n += block.max - block.min + 1;
        }
        return n;
    }

    public ArrayList<Block> getXBlocks() {
        return this.xblock;
    }

    public int getXnext(Block block) {
        int n = this.xblock.indexOf(block);
        if (n == this.xblock.size() - 1) {
            return this.rangeBox.getCoordSizePrimary() - 1;
        }
        return this.xblock.get((int)(n + 1)).min - 1;
    }

    public int getXprev(Block block) {
        int n = this.xblock.indexOf(block);
        if (n == 0) {
            return 0;
        }
        return this.xblock.get((int)(n - 1)).max + 1;
    }

    public ArrayList<Block> getYBlocks() {
        return this.yblock;
    }

    public int getYnext(Block block) {
        int n = this.yblock.indexOf(block);
        if (n == this.yblock.size() - 1) {
            return this.rangeBox.getCoordSizeSecondary() - 1;
        }
        return this.yblock.get((int)(n + 1)).min - 1;
    }

    public int getYprev(Block block) {
        int n = this.yblock.indexOf(block);
        if (n == 0) {
            return 0;
        }
        return this.yblock.get((int)(n - 1)).max + 1;
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        for (Block block : this.xblock) {
            int n3 = this.rangeBox.getCoordSizePrimary();
            int n4 = (int)((double)block.min / (double)n3 * (double)n);
            int n5 = (int)((double)(block.max + 1) / (double)n3 * (double)n);
            for (Block block2 : this.yblock) {
                int n6 = this.rangeBox.getCoordSizeSecondary() - 1;
                int n7 = (int)((double)block2.min / (double)n6 * (double)n2);
                int n8 = (int)((double)(block2.max + 1) / (double)n6 * (double)n2);
                if (block == this.selectedX && block2 == this.selectedY) {
                    graphics2D.setColor(Color.yellow);
                } else {
                    graphics2D.setColor(Color.darkGray);
                }
                graphics2D.fillRect(n4, n7, n5 - n4, n8 - n7);
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(n4, n7, n5 - n4, n8 - n7);
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(0, 0, n - 1, n2 - 1);
    }

    public void removeBlock(Block block) {
        this.xblock.remove(block);
        this.yblock.remove(block);
        if (this.xblock.isEmpty()) {
            this.addXblock();
        }
        if (this.yblock.isEmpty()) {
            this.addYblock();
        }
    }

    public void Save(RandomOutputStream randomOutputStream) throws IOException {
        Block block;
        int n;
        randomOutputStream.writePropertyInt("xbl", this.xblock.size());
        for (n = 0; n < this.xblock.size(); ++n) {
            block = this.xblock.get(n);
            randomOutputStream.writePropertyInt("xbmin" + n, block.min);
            randomOutputStream.writePropertyInt("xbmax" + n, block.max);
        }
        randomOutputStream.writePropertyInt("ybl", this.yblock.size());
        for (n = 0; n < this.yblock.size(); ++n) {
            block = this.yblock.get(n);
            randomOutputStream.writePropertyInt("ybmin" + n, block.min);
            randomOutputStream.writePropertyInt("ybmax" + n, block.max);
        }
    }

    public void selectXblock(Block block) {
        this.selectedX = block;
    }

    public void selectYblock(Block block) {
        this.selectedY = block;
    }

    public boolean showMatrixColumn(int n) {
        for (Block block : this.xblock) {
            if (n < block.min || n > block.max) continue;
            return true;
        }
        return false;
    }

    public boolean showMatrixRow(int n) {
        for (Block block : this.yblock) {
            if (n < block.min || n > block.max) continue;
            return true;
        }
        return false;
    }

    public Block splitXblock(Block block) {
        if (block == null || block.min == block.max) {
            return null;
        }
        Block block2 = new Block();
        this.xblock.add(this.xblock.indexOf(block) + 1, block2);
        block2.max = block.max;
        block2.min = (block.min + block.max + 1) / 2;
        block.max = block2.min - 1;
        return block2;
    }

    public Block splitYblock(Block block) {
        if (block == null || block.min == block.max) {
            return null;
        }
        Block block2 = new Block();
        this.yblock.add(this.yblock.indexOf(block) + 1, block2);
        block2.max = block.max;
        block2.min = (block.min + block.max + 1) / 2;
        block.max = block2.min - 1;
        return block2;
    }

    @Override
    protected void cleanUpChild() {
        this.rangeBox = null;
    }

    public class Block {
        public int min;
        public int max;

        public String toString() {
            if (RangePanel.this.xblock.contains(this)) {
                return RangePanel.this.xblock.indexOf(this) + 1 + ". Block";
            }
            return RangePanel.this.yblock.indexOf(this) + 1 + ". Block";
        }
    }
}

