/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings.Range;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.plot.axisplot.settings.ComboBoxRange;
import se.prediktera.map.plot.axisplot.settings.Range.RangePanel;

public class RangeTab
extends CleanUpPanel {
    private RangePanel rangePanel;
    private final JComboBox boxXblock = new JComboBox();
    private final JComboBox boxXmin = new JComboBox();
    private final JComboBox boxXmax = new JComboBox();
    private final JComboBox boxYblock = new JComboBox();
    private final JComboBox boxYmin = new JComboBox();
    private final JComboBox boxYmax = new JComboBox();
    private final JComboBox boxShow = new JComboBox();
    private RangePanel.Block curXBlock = null;
    private RangePanel.Block curYBlock = null;
    private boolean beginupdate = false;
    private boolean displaydescription = true;
    private final ComboBoxRange rangeBox;

    private static int selectItem(JComboBox jComboBox) {
        Object object = jComboBox.getSelectedItem();
        if (!(object instanceof String)) {
            return jComboBox.getSelectedIndex();
        }
        String string = (String)object;
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            if (!jComboBox.getItemAt(i).toString().equalsIgnoreCase(string)) continue;
            jComboBox.setSelectedIndex(i);
            return i;
        }
        jComboBox.setSelectedIndex(0);
        return 0;
    }

    public RangeTab(ComboBoxRange comboBoxRange) {
        this.rangeBox = comboBoxRange;
        try {
            this.rangePanel = new RangePanel(comboBoxRange);
            this.jbInit();
            this.addXblock(this.rangePanel.addXblock());
            this.addYblock(this.rangePanel.addYblock());
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public RangeTab(ComboBoxRange comboBoxRange, MapProperty mapProperty) {
        this.rangeBox = comboBoxRange;
        try {
            this.rangePanel = new RangePanel(comboBoxRange, mapProperty);
            if (this.rangePanel.getXBlocks().size() == 0) {
                this.rangePanel.addXblock();
            }
            if (this.rangePanel.getYBlocks().size() == 0) {
                this.rangePanel.addYblock();
            }
            this.remakeXitems();
            this.remakeYitems();
            this.jbInit();
            this.setDescription(true, true);
            this.rangePanel.selectXblock(this.curXBlock);
            this.rangePanel.selectYblock(this.curYBlock);
            this.rangePanel.repaint();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public void addXblock() {
        RangePanel.Block block = this.rangePanel.splitXblock(this.curXBlock);
        if (block != null) {
            this.addXblock(block);
        }
    }

    public void addYblock() {
        RangePanel.Block block = this.rangePanel.splitYblock(this.curYBlock);
        if (block != null) {
            this.addYblock(block);
        }
    }

    public int getMatrixColumnSize() {
        return this.rangePanel.getMatrixColumnSize();
    }

    public int getMatrixRowSize() {
        return this.rangePanel.getMatrixRowSize();
    }

    public void removeXblock() {
        this.rangePanel.removeBlock(this.curXBlock);
        this.remakeXitems();
        this.curXBlock = (RangePanel.Block)this.boxXblock.getSelectedItem();
        this.rangePanel.selectXblock(this.curXBlock);
        this.rangePanel.repaint();
        this.setDescription(true, false);
    }

    public void removeYblock() {
        this.rangePanel.removeBlock(this.curYBlock);
        this.remakeYitems();
        this.curYBlock = (RangePanel.Block)this.boxYblock.getSelectedItem();
        this.rangePanel.selectYblock(this.curYBlock);
        this.rangePanel.repaint();
        this.setDescription(false, true);
    }

    public void Save(RandomOutputStream randomOutputStream) throws IOException {
        this.rangePanel.Save(randomOutputStream);
    }

    public boolean showMatrixColumn(int n) {
        return this.rangePanel.showMatrixColumn(n);
    }

    public boolean showMatrixRow(int n) {
        return this.rangePanel.showMatrixRow(n);
    }

    @Override
    protected void cleanUpChild() {
        if (this.rangePanel != null) {
            this.rangePanel.cleanUp();
            this.rangePanel = null;
        }
    }

    private void addXblock(RangePanel.Block block) {
        this.beginupdate = true;
        this.curXBlock = block;
        this.remakeXitems();
        this.boxXblock.setSelectedItem(block);
        this.rangePanel.selectXblock(block);
        this.beginupdate = false;
        this.setDescription(true, false);
        this.rangePanel.repaint();
    }

    private void addYblock(RangePanel.Block block) {
        this.beginupdate = true;
        this.curYBlock = block;
        this.remakeYitems();
        this.boxYblock.setSelectedItem(block);
        this.rangePanel.selectYblock(block);
        this.beginupdate = false;
        this.setDescription(false, true);
        this.rangePanel.repaint();
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        MinMaxListener minMaxListener = new MinMaxListener();
        BlockListener blockListener = new BlockListener();
        this.boxXmin.setEditable(true);
        this.boxXmax.setEditable(true);
        this.boxYmin.setEditable(true);
        this.boxYmax.setEditable(true);
        this.boxXmin.setPreferredSize(new Dimension(80, 19));
        this.boxXmin.addItemListener(minMaxListener);
        this.boxXmax.setPreferredSize(new Dimension(80, 19));
        this.boxXmax.addItemListener(minMaxListener);
        this.boxXblock.setPreferredSize(new Dimension(80, 19));
        this.boxXblock.addItemListener(blockListener);
        this.boxYblock.setPreferredSize(new Dimension(80, 19));
        this.boxYblock.addItemListener(blockListener);
        this.boxYmin.setPreferredSize(new Dimension(80, 19));
        this.boxYmin.addItemListener(minMaxListener);
        this.boxYmax.setPreferredSize(new Dimension(80, 19));
        this.boxYmax.addItemListener(minMaxListener);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.boxShow.setPreferredSize(new Dimension(80, 19));
        this.boxShow.addItem("Description");
        this.boxShow.addItem("Number");
        this.boxShow.addItemListener(itemEvent -> {
            this.displaydescription = this.boxShow.getSelectedIndex() == 0;
            this.boxXmin.setEditable(false);
            this.boxXmin.setEditable(true);
            this.boxXmax.setEditable(false);
            this.boxXmax.setEditable(true);
            this.boxYmin.setEditable(false);
            this.boxYmin.setEditable(true);
            this.boxYmax.setEditable(false);
            this.boxYmax.setEditable(true);
            this.boxXmin.repaint();
            this.boxXmax.repaint();
            this.boxYmin.repaint();
            this.boxYmax.repaint();
        });
        jPanel3.setBorder(EvinceBorderFactory.createEvinceBorder("Global"));
        jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("X axis range"));
        jPanel2.setBorder(EvinceBorderFactory.createEvinceBorder("Y axis range"));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), "X axis block"));
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), "Y axis range"));
        JButton jButton = new JButton("Split");
        jButton.addActionListener(actionEvent -> this.addYblock());
        JButton jButton2 = new JButton("Delete");
        jButton2.addActionListener(actionEvent -> this.removeYblock());
        JButton jButton3 = new JButton("Split");
        jButton3.addActionListener(actionEvent -> this.addXblock());
        JButton jButton4 = new JButton("Delete");
        jButton4.addActionListener(actionEvent -> this.removeXblock());
        jPanel3.add((Component)new JLabel("Show by:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this.boxShow, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel4, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel5, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.rangePanel, new GridBagConstraints(1, 1, 2, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel3, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)new JLabel("Min"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.boxYmin, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 0), 0, 0));
        jPanel2.add((Component)new JLabel("Max"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.boxYmax, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel("Min"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.boxXmin, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
        jPanel.add((Component)new JLabel("Max"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.boxXmax, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)new JLabel("X blocks"), new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this.boxXblock, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)jButton4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel5.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 21, 0));
        jPanel5.add((Component)new JLabel("Y blocks"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 32, 0));
        jPanel5.add((Component)this.boxYblock, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        jPanel5.add((Component)jButton2, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 3, 0));
        jPanel4.add((Component)jButton3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void remakeXitems() {
        this.boxXblock.removeAllItems();
        ArrayList<RangePanel.Block> arrayList = this.rangePanel.getXBlocks();
        RangePanel.Block block = null;
        for (RangePanel.Block block2 : arrayList) {
            this.boxXblock.addItem(block2);
            if (block != null && !block2.equals(this.curXBlock)) continue;
            block = block2;
        }
        if (block != null) {
            this.curXBlock = block;
            this.boxXblock.setSelectedItem(this.curXBlock);
        }
    }

    private void remakeYitems() {
        this.boxYblock.removeAllItems();
        ArrayList<RangePanel.Block> arrayList = this.rangePanel.getYBlocks();
        RangePanel.Block block = null;
        for (RangePanel.Block block2 : arrayList) {
            this.boxYblock.addItem(block2);
            if (block != null && !block2.equals(this.curYBlock)) continue;
            block = block2;
        }
        if (block != null) {
            this.curYBlock = block;
            this.boxYblock.setSelectedItem(this.curYBlock);
        }
    }

    private void setDescription(boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        this.beginupdate = true;
        if (bl) {
            this.boxXmin.removeAllItems();
            this.boxXmax.removeAllItems();
            if (this.curXBlock != null) {
                for (n3 = n2 = this.rangePanel.getXprev(this.curXBlock); n3 <= this.curXBlock.max; ++n3) {
                    this.boxXmin.addItem(new ItemWrapper(this.rangeBox.getDescriptionSecondary(n3), n3));
                }
                this.boxXmin.setSelectedIndex(this.curXBlock.min - n2);
                n = this.rangePanel.getXnext(this.curXBlock);
                for (n3 = n2 = this.curXBlock.min; n3 <= n; ++n3) {
                    this.boxXmax.addItem(new ItemWrapper(this.rangeBox.getDescriptionSecondary(n3), n3));
                }
                this.boxXmax.setSelectedIndex(this.curXBlock.max - n2);
            }
        }
        if (bl2) {
            this.boxYmin.removeAllItems();
            this.boxYmax.removeAllItems();
            if (this.curYBlock != null) {
                for (n3 = n2 = this.rangePanel.getYprev(this.curYBlock); n3 <= this.curYBlock.max; ++n3) {
                    this.boxYmin.addItem(new ItemWrapper(this.rangeBox.getDescriptionPrimary(n3), n3));
                }
                this.boxYmin.setSelectedIndex(this.curYBlock.min - n2);
                n = this.rangePanel.getYnext(this.curYBlock);
                for (n3 = n2 = this.curYBlock.min; n3 <= n; ++n3) {
                    this.boxYmax.addItem(new ItemWrapper(this.rangeBox.getDescriptionPrimary(n3), n3));
                }
                this.boxYmax.setSelectedIndex(this.curYBlock.max - n2);
            }
        }
        this.beginupdate = false;
    }

    private class MinMaxListener
    implements ItemListener {
        private MinMaxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (!RangeTab.this.beginupdate && itemEvent.getStateChange() == 1) {
                ItemWrapper itemWrapper;
                ItemWrapper itemWrapper2;
                if (RangeTab.this.curXBlock != null) {
                    RangeTab.selectItem(RangeTab.this.boxXmin);
                    RangeTab.selectItem(RangeTab.this.boxXmax);
                    itemWrapper2 = (ItemWrapper)RangeTab.this.boxXmax.getSelectedItem();
                    itemWrapper = (ItemWrapper)RangeTab.this.boxXmin.getSelectedItem();
                    RangeTab.this.curXBlock.max = itemWrapper2.number;
                    RangeTab.this.curXBlock.min = itemWrapper.number;
                }
                if (RangeTab.this.curYBlock != null) {
                    RangeTab.selectItem(RangeTab.this.boxYmin);
                    RangeTab.selectItem(RangeTab.this.boxYmax);
                    itemWrapper2 = (ItemWrapper)RangeTab.this.boxYmax.getSelectedItem();
                    itemWrapper = (ItemWrapper)RangeTab.this.boxYmin.getSelectedItem();
                    RangeTab.this.curYBlock.max = itemWrapper2.number;
                    RangeTab.this.curYBlock.min = itemWrapper.number;
                }
                RangeTab.this.rangePanel.repaint();
                RangeTab.this.setDescription(true, true);
            }
        }
    }

    private class BlockListener
    implements ItemListener {
        private BlockListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (!RangeTab.this.beginupdate && itemEvent.getStateChange() == 1) {
                RangeTab.this.curXBlock = (RangePanel.Block)RangeTab.this.boxXblock.getSelectedItem();
                RangeTab.this.curYBlock = (RangePanel.Block)RangeTab.this.boxYblock.getSelectedItem();
                RangeTab.this.rangePanel.selectXblock(RangeTab.this.curXBlock);
                RangeTab.this.rangePanel.selectYblock(RangeTab.this.curYBlock);
                RangeTab.this.rangePanel.repaint();
                RangeTab.this.setDescription(true, true);
            }
        }
    }

    private class ItemWrapper {
        public String description;
        public int number;

        public ItemWrapper(String string, int n) {
            this.description = string;
            this.number = n;
        }

        public String toString() {
            return RangeTab.this.displaydescription ? this.description : String.valueOf(this.number + 1);
        }
    }
}

