/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.prediktera.map.common.cleanup.CleanUpDialog;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.AbstractSettings;

public class SettingsBoxDialog
extends CleanUpDialog {
    private AbstractAxisPlot axisPlot;
    private List<ZoneLeaf> selectionList;
    private final LinkedList<AbstractSettings> settingsList = new LinkedList();

    public SettingsBoxDialog(AbstractAxisPlot abstractAxisPlot, AbstractAxisPlot.SelectionList selectionList) {
        super(IniManager.getMainFrame(), "Adjust settings", true);
        this.axisPlot = abstractAxisPlot;
        this.selectionList = selectionList;
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        JButton jButton = new JButton("OK");
        jButton.setPreferredSize(new Dimension(73, 27));
        jButton.addActionListener(actionEvent -> {
            this.applyAdjustment();
            this.dispose();
        });
        JButton jButton2 = new JButton("Apply");
        jButton2.setPreferredSize(new Dimension(73, 27));
        jButton2.addActionListener(actionEvent -> this.applyAdjustment());
        JButton jButton3 = new JButton("Close");
        jButton3.setPreferredSize(new Dimension(73, 27));
        jButton3.addActionListener(actionEvent -> this.dispose());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createRaisedBevelBorder());
        int n = 0;
        jPanel2.add((Component)new JLabel("Change Settings for Selection:"), new GridBagConstraints(0, n++, 2, 1, 0.0, 1.0, 17, 0, new Insets(12, 12, 6, 6), 0, 0));
        ZoneLeaf zoneLeaf = selectionList.getFirst();
        AbstractAxisLayer abstractAxisLayer = abstractAxisPlot.getSelectionMainLayer();
        for (AbstractPlotSettingsBox abstractPlotSettingsBox : abstractAxisLayer.getSettingsBoxMap().values()) {
            AbstractSettings abstractSettings = abstractPlotSettingsBox.getSettings();
            if (abstractSettings == null) continue;
            this.settingsList.add(abstractSettings);
            n += abstractSettings.initSettings(jPanel2, n, zoneLeaf);
        }
        jPanel2.add((Component)new JLabel(""), new GridBagConstraints(0, n, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 12, 12, 12), 0, 0));
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        jPanel3.add((Component)jButton, null);
        jPanel3.add((Component)jButton2, null);
        jPanel3.add((Component)jButton3, null);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "South");
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setLocationRelativeTo(null);
    }

    @Override
    protected void cleanUpChild() {
        this.settingsList.clear();
        this.selectionList = null;
        this.axisPlot = null;
    }

    private void applyAdjustment() {
        for (AbstractSettings abstractSettings : this.settingsList) {
            for (ZoneLeaf zoneLeaf : this.selectionList) {
                abstractSettings.applySettings(zoneLeaf);
            }
        }
        this.axisPlot.contentPaint((byte)7);
    }
}

