/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings.Shape;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.resource.ResourceManager;
import se.prediktera.map.common.resource.ResourceNode;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.layer.AbstractAdvancedFrame;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.settings.AbstractAdvanceSettings;
import se.prediktera.map.plot.axisplot.settings.AbstractClassPanel;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;
import se.prediktera.map.plot.axisplot.settings.ComboBoxShape;
import se.prediktera.map.plot.axisplot.settings.Shape.ContinuesShape;
import se.prediktera.map.plot.axisplot.settings.Shape.ImagePanel;
import se.prediktera.map.plot.axisplot.settings.Shape.ShapeRenderingBox;
import se.prediktera.map.plot.axisplot.settings.Shape.ShapeRenderingList;

public class ShapeAdvanceFrame
extends AbstractAdvanceSettings {
    private FixedShapePanel fixedShapeCard;
    private ClassPanel primClassCard;
    private ClassPanel secClassCard;
    private ClassPanel predClassCard;
    private ImagePanel imageCard;

    public ShapeAdvanceFrame(ContinuesShape continuesShape, AbstractPlotSettingsBox abstractPlotSettingsBox, PlotInit plotInit) {
        super("Advanced Shape Settings", abstractPlotSettingsBox, plotInit);
        this.fixedShapeCard = new FixedShapePanel(continuesShape.getShape(0));
        this.primClassCard = new ClassPanel(abstractPlotSettingsBox.getDataInfoFromAxis(0));
        if (abstractPlotSettingsBox.hasMainType(101)) {
            this.secClassCard = new ClassPanel(abstractPlotSettingsBox.getDataInfoFromAxis(1));
        }
        this.predClassCard = new ClassPanel(abstractPlotSettingsBox.getDataInfoFromAxis(0));
        this.imageCard = new ImagePanel(abstractPlotSettingsBox.getDataInfoFromAxis(0));
        this.jbInit();
    }

    public ShapeAdvanceFrame(MapProperty mapProperty, AbstractPlotSettingsBox abstractPlotSettingsBox, PlotInit plotInit) throws IOException {
        super("Advanced Shape Settings", abstractPlotSettingsBox, plotInit);
        String string = mapProperty.getPrefix();
        mapProperty.setPrefix(string + "cf");
        this.fixedShapeCard = new FixedShapePanel(mapProperty);
        mapProperty.setPrefix(string + "cc");
        this.primClassCard = new ClassPanel(mapProperty, abstractPlotSettingsBox.getDataInfoFromAxis(0));
        if (abstractPlotSettingsBox.hasMainType(101)) {
            mapProperty.setPrefix(string + "cc2");
            this.secClassCard = new ClassPanel(mapProperty, abstractPlotSettingsBox.getDataInfoFromAxis(1));
        }
        mapProperty.setPrefix(string + "ccp");
        this.predClassCard = new ClassPanel(mapProperty, abstractPlotSettingsBox.getDataInfoFromAxis(0));
        this.imageCard = new ImagePanel(abstractPlotSettingsBox.getDataInfoFromAxis(0));
        mapProperty.setPrefix(string);
        this.jbInit();
    }

    @Override
    public void applyChanges() {
        int n = this.settingsCardPanel.getSelected();
        if (n == 1) {
            ((ComboBoxShape)this.settingsBox).setFixedShape(this.getFixedShape());
            this.settingsBox.setSelected(n, 0);
        } else if (n == 7 || n == 101) {
            this.settingsBox.setSelected(n, this.getClassIndex());
        } else if (n == 21) {
            this.settingsBox.setSelected(n, 0);
        }
    }

    public void copySettings(AbstractAdvancedFrame abstractAdvancedFrame) {
        ShapeAdvanceFrame shapeAdvanceFrame = (ShapeAdvanceFrame)abstractAdvancedFrame;
        this.fixedShapeCard.getContinuesShape().setShape(0, shapeAdvanceFrame.fixedShapeCard.getContinuesShape().getShape(0));
        this.primClassCard.copySettings(shapeAdvanceFrame.primClassCard);
        if (this.secClassCard != null) {
            this.secClassCard.copySettings(shapeAdvanceFrame.secClassCard);
        }
        this.predClassCard.copySettings(shapeAdvanceFrame.predClassCard);
        this.applyChanges();
    }

    public int getClassIndex() {
        if (this.settingsCardPanel.getSelected() == 101) {
            return this.secClassCard.getClassIndex();
        }
        if (this.settingsCardPanel.getSelected() == 7) {
            return this.primClassCard.getClassIndex();
        }
        return this.predClassCard.getClassIndex();
    }

    public ContinuesShape getContinuesShape() {
        return ((AbstractShapePanel)((Object)this.settingsCardPanel.getSelectedPanel())).getContinuesShape();
    }

    public int getFixedShape() {
        return this.fixedShapeCard.getContinuesShape().getShape(0);
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        JPanel jPanel = this.settingsCardPanel.getSelectedPanel();
        if (jPanel instanceof ClassPanel) {
            ((ClassPanel)jPanel).addProperties(properties);
        }
        return properties;
    }

    @Override
    public void Save(RandomOutputStream randomOutputStream) throws IOException {
        String string = randomOutputStream.getPrefix();
        randomOutputStream.setPrefix(string + "cf");
        this.fixedShapeCard.Save(randomOutputStream);
        randomOutputStream.setPrefix(string + "cc");
        this.primClassCard.Save(randomOutputStream);
        if (this.secClassCard != null) {
            randomOutputStream.setPrefix(string + "cc2");
            this.secClassCard.Save(randomOutputStream);
        }
        randomOutputStream.setPrefix(string + "ccp");
        this.predClassCard.Save(randomOutputStream);
        randomOutputStream.setPrefix(string);
    }

    public void setFixedShape(int n) {
        this.settingsCardPanel.setSelected(1);
        this.fixedShapeCard.setFixedShape(n);
    }

    public void setProperties(Properties properties) {
        JPanel jPanel = this.settingsCardPanel.getSelectedPanel();
        if (jPanel instanceof ClassPanel) {
            ((ClassPanel)jPanel).setProperties(properties);
            this.applyChanges();
        }
    }

    @Override
    public void SyncronizeComboBox(AbstractDataMatrix abstractDataMatrix, int n, int n2) {
        this.settingsCardPanel.setSelected(n);
        if (n == 7) {
            this.primClassCard.setClassIndex(n, n2);
        } else if (n == 101) {
            this.secClassCard.setClassIndex(n, n2);
        } else if (n == 19) {
            this.predClassCard.setClassIndex(n, n2);
        } else {
            this.fixedShapeCard.setFixedShape(((ComboBoxShape)this.settingsBox).getFixedShape());
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.fixedShapeCard = null;
        this.primClassCard = null;
        this.secClassCard = null;
        this.predClassCard = null;
        this.imageCard = null;
    }

    private void jbInit() {
        Object object;
        this.settingsTabbed.addTab("Shape", this.settingsCardPanel);
        int n = this.settingsBox.getItemCount();
        block7: for (int i = 0; i < n && (object = this.settingsBox.getItemAt(i)) instanceof ComboItem; ++i) {
            ComboItem comboItem = (ComboItem)object;
            if (!((ComboItem)object).isMainitem()) break;
            switch (comboItem.getType()) {
                case 1: {
                    this.settingsCardPanel.addRadioButton("Fixed Shape", 1, this.fixedShapeCard);
                    continue block7;
                }
                case 7: {
                    this.settingsCardPanel.addRadioButton(this.settingsBox.getNiceMainString(7), 7, this.primClassCard);
                    continue block7;
                }
                case 101: {
                    this.settingsCardPanel.addRadioButton(this.settingsBox.getNiceMainString(101), 101, this.secClassCard);
                    continue block7;
                }
                case 19: {
                    this.settingsCardPanel.addRadioButton(this.settingsBox.getNiceMainString(19), 19, this.predClassCard);
                    continue block7;
                }
                case 21: {
                    this.settingsCardPanel.addRadioButton(this.settingsBox.getNiceMainString(21), 21, this.imageCard);
                }
            }
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.settingsCardPanel.addGlobalSettingsPanel(jPanel);
        object = new JButton("Add Custom Image");
        ((AbstractButton)object).addActionListener(actionEvent -> {
            ResourceManager resourceManager = new ResourceManager((JDialog)this, (DataContainer)this.settingsBox.getWindow_GUI().getProject_GUI().getRootNode());
            resourceManager.setVisible(true);
        });
        jPanel.add((Component)new JLabel(""), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 6, 0), 0, 0));
        jPanel.add((Component)object, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 6, 6, 6), 0, 0));
    }

    private class FixedShapePanel
    extends AbstractSettingsPanel
    implements AbstractShapePanel {
        private ShapeRenderingList shapeRenderingList;
        private final ContinuesShape fixedShape = new ContinuesShape(1);

        public FixedShapePanel(int n) {
            this.init(n);
        }

        public FixedShapePanel(MapProperty mapProperty) throws IOException {
            int n = this.fixedShape.getShape(0);
            if (mapProperty.hasProperty("sh")) {
                n = mapProperty.getLVInt();
            }
            this.init(n);
        }

        @Override
        public ContinuesShape getContinuesShape() {
            this.fixedShape.setShape(0, (byte)this.shapeRenderingList.getSelectedIndex());
            return this.fixedShape;
        }

        public void Save(RandomOutputStream randomOutputStream) throws IOException {
            randomOutputStream.writePropertyInt("sh", this.shapeRenderingList.getSelectedIndex());
        }

        public void setFixedShape(int n) {
            if (this.shapeRenderingList != null) {
                this.shapeRenderingList.setSelectedIndex(n);
            }
        }

        private void init(int n) {
            ResourceNode resourceNode = ((AbstractPlotSettingsBox)ShapeAdvanceFrame.this.settingsBox).getRootResourceNode();
            this.shapeRenderingList = new ShapeRenderingList(resourceNode);
            this.shapeRenderingList.setSelectedIndex(n);
            this.northPanel.add((Component)new JLabel("Select fixed shape in the list below"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 6, 6), 0, 0));
            this.centerPanel.add((Component)this.shapeRenderingList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(6, 12, 12, 12), 0, 0));
        }
    }

    private class ClassPanel
    extends AbstractClassPanel
    implements AbstractShapePanel {
        private final ItemSelector itemSelector;
        private final Vector<ShapeRenderingBox> classShapes;

        public ClassPanel(AbstractDataInfo abstractDataInfo) {
            super(abstractDataInfo);
            this.itemSelector = new ItemSelector();
            this.classShapes = new Vector();
            this.setItemSelector(this.itemSelector);
        }

        public ClassPanel(MapProperty mapProperty, AbstractDataInfo abstractDataInfo) throws IOException {
            super(mapProperty, abstractDataInfo);
            this.itemSelector = new ItemSelector();
            this.classShapes = new Vector();
            this.setItemSelector(this.itemSelector, true);
            if (mapProperty.hasProperty("nshapes")) {
                int n = mapProperty.getLVInt();
                for (int i = 0; i < n && i < this.classShapes.size(); ++i) {
                    if (!mapProperty.hasProperty("s" + i)) continue;
                    this.classShapes.elementAt(i).setCurrentShape(mapProperty.getLVByte());
                }
            }
        }

        public void addProperties(Properties properties) {
            properties.put("colorscheme", "[CUSTOM]");
            for (int i = 0; i < this.classShapes.size(); ++i) {
                String string = this.classShapes.elementAt(i).getCurrentName();
                properties.put("shape" + (i + 1), string);
            }
        }

        public void copySettings(ClassPanel classPanel) {
            if (classPanel != null) {
                int n = Math.min(this.classShapes.size(), classPanel.classShapes.size());
                for (int i = 0; i < n; ++i) {
                    this.classShapes.get(i).setSelectedIndex(classPanel.classShapes.get(i).getSelectedIndex());
                }
            }
        }

        @Override
        public ContinuesShape getContinuesShape() {
            ContinuesShape continuesShape = new ContinuesShape(this.classShapes.size());
            for (int i = 0; i < this.classShapes.size(); ++i) {
                continuesShape.setShape(i, this.classShapes.elementAt(i).getCurrentShape());
            }
            return continuesShape;
        }

        @Override
        public void pageShown() {
        }

        @Override
        public void Save(RandomOutputStream randomOutputStream) throws IOException {
            super.Save(randomOutputStream);
            randomOutputStream.writePropertyInt("nshapes", this.classShapes.size());
            for (int i = 0; i < this.classShapes.size(); ++i) {
                randomOutputStream.writePropertyByte("s" + i, this.classShapes.elementAt(i).getCurrentShape());
            }
        }

        public void setProperties(Properties properties) {
            String string;
            if (ScriptHelper.hasKey(properties, "shapescheme") && (string = ScriptHelper.getProperty(properties, "shapescheme")).equalsIgnoreCase("[CUSTOM]")) {
                ShapeRenderingBox shapeRenderingBox = ((ComboBoxShape)ShapeAdvanceFrame.this.settingsBox).getBoxShapeFixed();
                for (int i = 0; i < this.classShapes.size(); ++i) {
                    if (!ScriptHelper.hasKey(properties, "shape" + (i + 1))) continue;
                    String string2 = EvinceScriptCommands.removeSpace(ScriptHelper.getProperty(properties, "shape" + (i + 1)));
                    int n = shapeRenderingBox.getShapeByName(string2);
                    if (n >= 0) {
                        this.classShapes.elementAt(i).setCurrentShape(n);
                        continue;
                    }
                    throw new RuntimeException("Illegal shape option: " + string2);
                }
            }
        }

        @Override
        protected DataTreeInterface getSpecificDti() {
            if (ShapeAdvanceFrame.this.settingsBox != null) {
                return ShapeAdvanceFrame.this.settingsBox.getMatrix();
            }
            return null;
        }

        @Override
        protected void updateComboItems() {
            if (ShapeAdvanceFrame.this.settingsBox != null) {
                ShapeAdvanceFrame.this.settingsBox.updateClasses();
            }
        }

        @Override
        protected void updateItemsLocal(boolean bl) {
            ClassTypes classTypes = (ClassTypes)this.comboClassTypes.getSelectedItem();
            this.centerPanel.removeAll();
            this.centerPanel.add((Component)new JLabel("Category"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.centerPanel.add((Component)new JLabel("Shape"), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.classShapes.clear();
            if (classTypes != null && ShapeAdvanceFrame.this.settingsBox != null) {
                int n = classTypes.size();
                if (n > 127) {
                    n = 127;
                }
                int n2 = 0;
                ResourceNode resourceNode = ((AbstractPlotSettingsBox)ShapeAdvanceFrame.this.settingsBox).getRootResourceNode();
                for (n2 = 0; n2 < n; ++n2) {
                    ShapeRenderingBox shapeRenderingBox = new ShapeRenderingBox(resourceNode, (byte)n2);
                    this.classShapes.addElement(shapeRenderingBox);
                    this.centerPanel.add((Component)new JLabel(classTypes.getTypeDescription(n2)), new GridBagConstraints(0, n2 + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
                    this.centerPanel.add((Component)shapeRenderingBox, new GridBagConstraints(1, n2 + 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 6, 0, 12), 0, 0));
                }
                this.centerPanel.add((Component)new JLabel(""), new GridBagConstraints(1, n2 + 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
        }

        private class ItemSelector
        implements ItemListener {
            private ItemSelector() {
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent == null || itemEvent.getStateChange() == 1) {
                    ClassPanel.this.updateItems(false);
                }
                ShapeAdvanceFrame.this.repaint();
            }
        }
    }

    protected static interface AbstractShapePanel {
        public ContinuesShape getContinuesShape();
    }
}

