/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings.Shape;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JSeparator;
import se.prediktera.map.common.resource.ResourceNode;
import se.prediktera.map.common.swing.ComboBoxRenderer;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.common.swing.JComboBoxCell;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.event.DataTreeListener;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.PlotImages;

public class ShapeRenderingBox
extends JComboBoxCell {
    private ResourceNode resourceNode;

    public ShapeRenderingBox(ResourceNode resourceNode) {
        super(true);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        for (int i = 0; i < 14; ++i) {
            Color color = new Color(85, 128, 170);
            ZoneLeaf zoneLeaf = new ZoneLeaf(color, (byte)i, i, i, null);
            zoneLeaf.setDescription(PlotImages.getImageDescription(i));
            this.addItem(zoneLeaf);
        }
        this.addItem(new ComboItem("%SEPARATOR#", 0));
        this.setRenderer(new myListCellRenderer());
        this.setResourceNode(resourceNode);
    }

    public ShapeRenderingBox(ResourceNode resourceNode, byte by) {
        this(resourceNode);
        this.setCurrentShape(by);
    }

    public final String getCurrentName() {
        ZoneLeaf zoneLeaf = this.getSelectedShape();
        if (zoneLeaf == null) {
            return null;
        }
        return zoneLeaf.getDescription();
    }

    public final byte getCurrentShape() {
        ZoneLeaf zoneLeaf = this.getSelectedShape();
        if (zoneLeaf == null) {
            return -1;
        }
        return zoneLeaf.getShapeType();
    }

    public ZoneLeaf getSelectedShape() {
        return this.getShape(this.getSelectedIndex());
    }

    public ZoneLeaf getShape(int n) {
        Object e = this.getItemAt(n);
        if (e instanceof ZoneLeaf) {
            return (ZoneLeaf)e;
        }
        return null;
    }

    public int getShapeByName(String string) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            ZoneLeaf zoneLeaf;
            Object object = this.getItemAt(i);
            if (!(object instanceof ZoneLeaf) || !string.equalsIgnoreCase((String)(object = EvinceScriptCommands.removeSpace((zoneLeaf = (ZoneLeaf)object).getDescription())))) continue;
            return zoneLeaf.getShapeType();
        }
        return -1;
    }

    public final void setCurrentShape(int n) {
        if (n >= 14) {
            ++n;
        }
        this.setSelectedIndex(n % this.getItemCount());
    }

    public final void setResourceNode(ResourceNode resourceNode) {
        this.resourceNode = resourceNode;
        if (resourceNode != null) {
            resourceNode.addDataTreeChangeListener(new DataTreeListener(){

                @Override
                public void eventFinished(DataTreeEvent dataTreeEvent) {
                }

                @Override
                public void nodeReplaced(DataTreeEvent dataTreeEvent) {
                }

                @Override
                public void propertyChanged(DataTreeEvent dataTreeEvent) {
                    if (dataTreeEvent.getProperty() != 0) {
                        ShapeRenderingBox.this.updateResources();
                    }
                }
            });
        }
        this.updateResources();
    }

    private void updateResources() {
        this.removeAllItemsAfterSeparator();
        Color color = new Color(85, 128, 170);
        if (this.resourceNode != null) {
            for (int i = 0; i < this.resourceNode.getTreeNodeCount(); ++i) {
                this.addItem(new ZoneLeaf(color, (byte)(i + 14), i, i, null));
            }
        }
    }

    class myListCellRenderer
    extends ComboBoxRenderer {
        private ZoneLeaf zoneLeaf = null;

        public myListCellRenderer() {
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (component instanceof JSeparator) {
                return component;
            }
            this.setText("    ");
            this.zoneLeaf = object instanceof ZoneLeaf ? (ZoneLeaf)object : null;
            return this;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = this.getHeight();
            if (this.zoneLeaf != null) {
                this.zoneLeaf.setSize((byte)(n > 255 ? 255 : n - 4));
                int n2 = n / 2;
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                PlotImages.draw(ShapeRenderingBox.this.resourceNode, graphics2D, this.zoneLeaf, new int[]{n2 * 2, n2}, 1.0, true);
            }
        }
    }
}

