/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings.Shape;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import se.prediktera.map.common.resource.ImageResource;
import se.prediktera.map.common.resource.ResourceNode;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.event.DataTreeListener;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.PlotImages;

public class ShapeRenderingList
extends JList {
    private final Vector<ZoneLeaf> shapeVector = new Vector();
    private ResourceNode resourceNode;

    public ShapeRenderingList(ResourceNode resourceNode) {
        for (int i = 0; i < 14; ++i) {
            ZoneLeaf zoneLeaf = new ZoneLeaf(Color.orange, (byte)i, i, i, null);
            zoneLeaf.setDescription(PlotImages.getImageDescription(i));
            this.shapeVector.addElement(zoneLeaf);
        }
        this.setListData(this.shapeVector);
        this.setCellRenderer(new myListCellRenderer());
        this.setResourceNode(resourceNode);
    }

    public ShapeRenderingList(ResourceNode resourceNode, int n) {
        this(resourceNode);
        this.setCurrentShape(n);
    }

    public int getCurrentShape() {
        return this.getSelectedIndex();
    }

    public ZoneLeaf getShape(int n) {
        return this.shapeVector.elementAt(n);
    }

    public void setCurrentShape(int n) {
        this.setSelectedIndex(n % this.shapeVector.size());
    }

    public void setResourceNode(ResourceNode resourceNode) {
        this.resourceNode = resourceNode;
        if (this.resourceNode != null) {
            this.resourceNode.addDataTreeChangeListener(new DataTreeListener(){

                @Override
                public void eventFinished(DataTreeEvent dataTreeEvent) {
                }

                @Override
                public void nodeReplaced(DataTreeEvent dataTreeEvent) {
                }

                @Override
                public void propertyChanged(DataTreeEvent dataTreeEvent) {
                    if (dataTreeEvent.getProperty() == 0) {
                        if (ShapeRenderingList.this.resourceNode != null) {
                            for (int i = 0; i < ShapeRenderingList.this.resourceNode.getTreeNodeCount(); ++i) {
                                ImageResource imageResource = (ImageResource)ShapeRenderingList.this.resourceNode.getTreeNodeAt(i);
                                if (imageResource != dataTreeEvent.getDataTreeInterface()) continue;
                                ZoneLeaf zoneLeaf = ShapeRenderingList.this.shapeVector.get(14 + i);
                                if (zoneLeaf == null) break;
                                zoneLeaf.setDescription(dataTreeEvent.getName());
                                break;
                            }
                        }
                        ShapeRenderingList.this.repaint();
                    } else {
                        ShapeRenderingList.this.updateResources();
                        if (dataTreeEvent.getProperty() == 1) {
                            ShapeRenderingList.this.setSelectedIndex(ShapeRenderingList.this.shapeVector.size() - 1);
                        }
                    }
                }
            });
        }
        this.updateResources();
    }

    private void updateResources() {
        int n;
        int n2 = this.getSelectedIndex();
        for (n = this.shapeVector.size() - 1; n >= 14; --n) {
            this.shapeVector.removeElementAt(n);
        }
        if (this.resourceNode != null) {
            for (n = 0; n < this.resourceNode.getTreeNodeCount(); ++n) {
                ImageResource imageResource = (ImageResource)this.resourceNode.getTreeNodeAt(n);
                ZoneLeaf zoneLeaf = new ZoneLeaf(Color.orange, (byte)(n + 14), n, n, null);
                zoneLeaf.setDescription(imageResource.toString());
                this.shapeVector.addElement(zoneLeaf);
            }
        }
        this.setListData(this.shapeVector);
        if (n2 < 0 || n2 >= this.shapeVector.size()) {
            this.setSelectedIndex(0);
        } else {
            this.setSelectedIndex(n2);
        }
    }

    class myListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private ZoneLeaf zoneLeaf = null;

        public myListCellRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.zoneLeaf = (ZoneLeaf)object;
            this.setText("          " + this.zoneLeaf.getDescription());
            return this;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = this.getHeight();
            if (this.zoneLeaf != null) {
                this.zoneLeaf.setSize((byte)(n > 255 ? 255 : n - 4));
                int n2 = n / 2;
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                PlotImages.draw(ShapeRenderingList.this.resourceNode, graphics2D, this.zoneLeaf, new int[]{n2 * 2, n2}, 1.0, true);
            }
        }
    }
}

