/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings.Size;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import se.prediktera.map.common.JValidateNumberField;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.PlotImages;
import se.prediktera.map.plot.axisplot.settings.AbstractAdvanceSettings;
import se.prediktera.map.plot.axisplot.settings.AbstractClassPanel;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;
import se.prediktera.map.plot.axisplot.settings.Axis.DataSearchPanel;
import se.prediktera.map.plot.axisplot.settings.ComboBoxSize;
import se.prediktera.map.plot.axisplot.settings.Size.ContinuousSize;

public class SizeAdvanceFrame
extends AbstractAdvanceSettings {
    private FixedSizePanel fixedSizePanel;
    private ClassPanel primClassCard;
    private ClassPanel secClassCard;
    private ClassPanel predClassCard;

    public SizeAdvanceFrame(AbstractPlotSettingsBox abstractPlotSettingsBox, PlotInit plotInit) {
        super("Advanced Size Settings", abstractPlotSettingsBox, plotInit);
        this.dataSearchPanel = new DataSearchPanel(abstractPlotSettingsBox, plotInit);
        this.fixedSizePanel = new FixedSizePanel();
        this.primClassCard = new ClassPanel(true, abstractPlotSettingsBox.getDataInfoFromAxis(0));
        if (abstractPlotSettingsBox.hasMainType(101)) {
            this.secClassCard = new ClassPanel(false, abstractPlotSettingsBox.getDataInfoFromAxis(1));
        }
        this.predClassCard = new ClassPanel(true, abstractPlotSettingsBox.getDataInfoFromAxis(0));
        this.jbInit();
    }

    public SizeAdvanceFrame(MapProperty mapProperty, AbstractPlotSettingsBox abstractPlotSettingsBox, PlotInit plotInit) throws IOException {
        super("Advanced Size Settings", abstractPlotSettingsBox, plotInit);
        this.dataSearchPanel = new DataSearchPanel(abstractPlotSettingsBox, plotInit);
        this.fixedSizePanel = new FixedSizePanel();
        String string = mapProperty.getPrefix();
        mapProperty.setPrefix(string + "cc");
        this.primClassCard = new ClassPanel(mapProperty, true, abstractPlotSettingsBox.getDataInfoFromAxis(0));
        if (abstractPlotSettingsBox.hasMainType(101)) {
            mapProperty.setPrefix(string + "cc2");
            this.secClassCard = new ClassPanel(mapProperty, false, abstractPlotSettingsBox.getDataInfoFromAxis(1));
        }
        mapProperty.setPrefix(string + "ccp");
        this.predClassCard = new ClassPanel(mapProperty, true, abstractPlotSettingsBox.getDataInfoFromAxis(0));
        mapProperty.setPrefix(string);
        this.jbInit();
    }

    public ContinuousSize getContinuousSize() {
        JPanel jPanel = this.settingsCardPanel.getSelectedPanel();
        if (jPanel instanceof ClassPanel) {
            return ((ClassPanel)this.settingsCardPanel.getSelectedPanel()).getContinuousSize();
        }
        return null;
    }

    @Override
    public void Save(RandomOutputStream randomOutputStream) throws IOException {
    }

    @Override
    public void SyncronizeComboBox(AbstractDataMatrix abstractDataMatrix, int n, int n2) {
        if (0 == n) {
            this.dataSearchPanel.synchronize(abstractDataMatrix, n2);
        } else if (7 == n) {
            this.primClassCard.setClassIndex(n, n2);
        } else if (101 == n) {
            this.secClassCard.setClassIndex(n, n2);
        } else if (19 == n) {
            this.predClassCard.setClassIndex(n, n2);
        }
        this.settingsCardPanel.setSelected(n);
        this.fixedSizePanel.setMinValue(((ComboBoxSize)this.settingsBox).getMinValue());
        this.fixedSizePanel.setMaxValue(((ComboBoxSize)this.settingsBox).getMaxValue());
    }

    @Override
    protected void applyChanges() {
        int n = this.settingsCardPanel.getSelected();
        int n2 = 0;
        ((ComboBoxSize)this.settingsBox).setMinValue(this.fixedSizePanel.getMinValue());
        ((ComboBoxSize)this.settingsBox).setMaxValue(this.fixedSizePanel.getMaxValue());
        if (0 == n) {
            this.settingsBox.setMatrix(this.dataSearchPanel.getMatrix(), false);
            n2 = this.dataSearchPanel.getIndex();
        } else if (n == 7) {
            this.settingsBox.setMatrix(this.dataSearchPanel.getMatrix(), false);
            n2 = this.primClassCard.getClassIndex();
        } else if (n == 101) {
            this.settingsBox.setMatrix(this.dataSearchPanel.getMatrix(), false);
            n2 = this.secClassCard.getClassIndex();
        } else if (n == 19) {
            this.settingsBox.setMatrix(this.dataSearchPanel.getMatrix(), false);
            n2 = this.predClassCard.getClassIndex();
        }
        this.settingsBox.setSelected(n, n2);
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.dataSearchPanel != null) {
            this.dataSearchPanel.cleanUp();
            this.dataSearchPanel = null;
        }
        if (this.fixedSizePanel != null) {
            this.fixedSizePanel.cleanUp();
            this.fixedSizePanel = null;
        }
        if (this.primClassCard != null) {
            this.primClassCard.cleanUp();
            this.primClassCard = null;
        }
        if (this.secClassCard != null) {
            this.secClassCard.cleanUp();
            this.secClassCard = null;
        }
        if (this.predClassCard != null) {
            this.predClassCard.cleanUp();
            this.predClassCard = null;
        }
    }

    private void jbInit() {
        Object object;
        this.settingsTabbed.addTab("Size", this.settingsCardPanel);
        int n = this.settingsBox.getItemCount();
        block9: for (int i = 0; i < n && (object = this.settingsBox.getItemAt(i)) instanceof ComboItem; ++i) {
            ComboItem comboItem = (ComboItem)object;
            if (!((ComboItem)object).isMainitem()) break;
            switch (comboItem.getType()) {
                case 1: {
                    this.settingsCardPanel.addRadioButtonGlobal("Fixed Size", 1, this.fixedSizePanel, "Size Settings");
                    continue block9;
                }
                case 4: {
                    this.settingsCardPanel.addRadioButtonGlobal(this.settingsBox.getNiceMainString(4), 4, this.fixedSizePanel, "Size Settings");
                    continue block9;
                }
                case 0: {
                    this.settingsCardPanel.addRadioButtonGlobal(this.settingsBox.getNiceMainString(0), 0, this.fixedSizePanel, "Size Settings");
                    continue block9;
                }
                case 9: {
                    this.settingsCardPanel.addRadioButtonGlobal(this.settingsBox.getNiceMainString(9), 9, this.fixedSizePanel, "Size Settings");
                    continue block9;
                }
                case 7: {
                    this.settingsCardPanel.addRadioButton(this.settingsBox.getNiceMainString(7), 7, this.primClassCard);
                    continue block9;
                }
                case 101: {
                    this.settingsCardPanel.addRadioButton(this.settingsBox.getNiceMainString(101), 101, this.secClassCard);
                    continue block9;
                }
                case 19: {
                    this.settingsCardPanel.addRadioButton(this.settingsBox.getNiceMainString(19), 19, this.predClassCard);
                }
            }
        }
        this.settingsTabbed.addTab("Size Source", this.dataSearchPanel);
    }

    private class FixedSizePanel
    extends AbstractSettingsPanel {
        private final JSlider minSlider = new JSlider();
        private ShapePanel minShapePanel = new ShapePanel(this.minSlider);
        private final JLabel minLabel = new JLabel();
        private final JSlider maxSlider = new JSlider();
        private ShapePanel maxShapePanel = new ShapePanel(this.maxSlider);
        private final JLabel maxLabel = new JLabel();

        public FixedSizePanel() {
            this.minSlider.setMinorTickSpacing(1);
            this.minSlider.setMajorTickSpacing(10);
            this.minSlider.setMinimum(1);
            this.minSlider.setMaximum(50);
            this.minSlider.setPaintTicks(true);
            this.minSlider.setPaintLabels(true);
            this.minSlider.addChangeListener(changeEvent -> this.minShapePanel.repaint());
            this.minLabel.setFont(new Font("SansSerif", 1, 11));
            this.maxSlider.setMinorTickSpacing(1);
            this.maxSlider.setMajorTickSpacing(10);
            this.maxSlider.setMinimum(1);
            this.maxSlider.setMaximum(50);
            this.maxSlider.setPaintTicks(true);
            this.maxSlider.setPaintLabels(true);
            this.maxSlider.addChangeListener(changeEvent -> this.maxShapePanel.repaint());
            this.maxLabel.setFont(new Font("SansSerif", 1, 11));
            this.northPanel.add((Component)new JLabel("Select min and max size"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 6, 6), 0, 0));
            this.centerPanel.add((Component)this.minLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 6, 6), 0, 0));
            this.centerPanel.add((Component)this.minShapePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 24, 6, 6), 0, 0));
            this.centerPanel.add((Component)this.minSlider, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(6, 24, 6, 6), 0, 0));
            this.centerPanel.add((Component)this.maxLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 6, 6, 6), 0, 0));
            this.centerPanel.add((Component)this.maxShapePanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 24, 6, 6), 0, 0));
            this.centerPanel.add((Component)this.maxSlider, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(6, 24, 6, 6), 0, 0));
        }

        public int getMaxValue() {
            return this.maxSlider.getValue();
        }

        public int getMinValue() {
            return this.minSlider.getValue();
        }

        @Override
        public void pageShown(String string) {
            if (string.equals(String.valueOf(1))) {
                this.maxSlider.setEnabled(false);
                this.maxLabel.setEnabled(false);
                this.minLabel.setText("Fixed Size");
                this.maxLabel.setText("Disabled");
                this.maxShapePanel.setEnabled(false);
            } else if (string.equals(String.valueOf(0)) || string.equals(String.valueOf(4))) {
                this.maxSlider.setEnabled(true);
                this.maxLabel.setEnabled(true);
                this.minLabel.setText("Minimum Value Size");
                this.maxLabel.setText("Maximum Value Size");
                this.maxShapePanel.setEnabled(true);
            } else if (string.equals(String.valueOf(9))) {
                this.maxSlider.setEnabled(true);
                this.maxLabel.setEnabled(true);
                this.minLabel.setText("Far Size");
                this.maxLabel.setText("Near Size");
                this.maxShapePanel.setEnabled(true);
            }
        }

        public void setMaxValue(int n) {
            this.maxSlider.setValue(n);
        }

        public void setMinValue(int n) {
            this.minSlider.setValue(n);
        }

        @Override
        protected void cleanUpChild() {
            super.cleanUpChild();
            if (this.minShapePanel != null) {
                this.minShapePanel.cleanUp();
                this.minShapePanel = null;
            }
            if (this.maxShapePanel != null) {
                this.maxShapePanel.cleanUp();
                this.maxShapePanel = null;
            }
        }

        private class ShapePanel
        extends CleanUpPanel {
            private ZoneLeaf zoneLeaf = new ZoneLeaf(Color.orange, 0, 0, 0, null);
            private JSlider slider;

            public ShapePanel(JSlider jSlider) {
                this.slider = jSlider;
            }

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                if (this.zoneLeaf != null) {
                    if (this.isEnabled()) {
                        this.zoneLeaf.setColor(Color.orange);
                    } else {
                        this.zoneLeaf.setColor(Color.lightGray);
                    }
                    this.zoneLeaf.setSize((byte)this.slider.getValue());
                    int n = this.getHeight() / 2;
                    graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    PlotImages.draw(null, graphics2D, this.zoneLeaf, new int[]{n * 2, n}, 1.0, true);
                }
            }

            @Override
            protected void cleanUpChild() {
                this.slider = null;
                this.zoneLeaf = null;
            }
        }
    }

    private class ClassPanel
    extends AbstractClassPanel {
        private final ItemSelector itemSelector;
        private final Vector<JValidateNumberField> classSizes;
        private final boolean isPrimary;

        public ClassPanel(boolean bl, AbstractDataInfo abstractDataInfo) {
            super(abstractDataInfo);
            this.itemSelector = new ItemSelector();
            this.classSizes = new Vector();
            this.isPrimary = bl;
            this.setItemSelector(this.itemSelector);
        }

        public ClassPanel(MapProperty mapProperty, boolean bl, AbstractDataInfo abstractDataInfo) throws IOException {
            super(mapProperty, abstractDataInfo);
            this.itemSelector = new ItemSelector();
            this.classSizes = new Vector();
            this.isPrimary = bl;
            this.setItemSelector(this.itemSelector, true);
            if (mapProperty.hasProperty("nsizes")) {
                int n = mapProperty.getLVInt();
                for (int i = 0; i < n && i < this.classSizes.size(); ++i) {
                    if (!mapProperty.hasProperty("s" + i)) continue;
                    this.classSizes.elementAt(i).setNumber(mapProperty.getLVByte());
                }
            }
        }

        public ContinuousSize getContinuousSize() {
            ContinuousSize continuousSize = new ContinuousSize(this.classSizes.size());
            for (int i = 0; i < this.classSizes.size(); ++i) {
                continuousSize.setSize(i, (byte)this.classSizes.elementAt(i).getNumber());
            }
            return continuousSize;
        }

        @Override
        public void pageShown() {
            AbstractAxisLayer abstractAxisLayer = ((AbstractPlotSettingsBox)SizeAdvanceFrame.this.settingsBox).getLayer();
            AbstractDataInfo abstractDataInfo = abstractAxisLayer.getDataInfoFromAxis(SizeAdvanceFrame.this.dataSearchPanel.getMatrix(), this.isPrimary ? 0 : 1);
            this.setDataInfo(abstractDataInfo);
        }

        @Override
        public void Save(RandomOutputStream randomOutputStream) throws IOException {
            super.Save(randomOutputStream);
            randomOutputStream.writePropertyInt("nsizes", this.classSizes.size());
            for (int i = 0; i < this.classSizes.size(); ++i) {
                randomOutputStream.writePropertyByte("s" + i, (byte)this.classSizes.elementAt(i).getNumber());
            }
        }

        @Override
        protected DataTreeInterface getSpecificDti() {
            if (SizeAdvanceFrame.this.settingsBox != null) {
                return SizeAdvanceFrame.this.settingsBox.getMatrix();
            }
            return null;
        }

        @Override
        protected void updateComboItems() {
            SizeAdvanceFrame.this.settingsBox.updateClasses();
        }

        @Override
        protected void updateItemsLocal(boolean bl) {
            ClassTypes classTypes = (ClassTypes)this.comboClassTypes.getSelectedItem();
            this.centerPanel.removeAll();
            this.centerPanel.add((Component)new JLabel("Category"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.centerPanel.add((Component)new JLabel("Size"), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.classSizes.clear();
            if (classTypes != null) {
                int n = classTypes.size();
                if (n > 127) {
                    n = 127;
                }
                int n2 = 0;
                for (n2 = 0; n2 < n; ++n2) {
                    JValidateNumberField jValidateNumberField = new JValidateNumberField(1.0, 50.0, false);
                    jValidateNumberField.setNumber(n2 + 1);
                    this.classSizes.addElement(jValidateNumberField);
                    this.centerPanel.add((Component)new JLabel(classTypes.getTypeDescription(n2)), new GridBagConstraints(0, n2 + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
                    this.centerPanel.add((Component)jValidateNumberField, new GridBagConstraints(1, n2 + 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 6, 0, 12), 0, 0));
                }
                this.centerPanel.add((Component)new JLabel(""), new GridBagConstraints(1, n2 + 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
        }

        private class ItemSelector
        implements ItemListener {
            private ItemSelector() {
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent == null || itemEvent.getStateChange() == 1) {
                    ClassPanel.this.updateItems(false);
                }
                SizeAdvanceFrame.this.repaint();
            }
        }
    }
}

