/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings.Statistics;

import java.awt.Graphics2D;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.extclass.AbstractInfo;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.ZoneArray;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlot2D;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;

public abstract class AbstractStatisticsInfo
extends AbstractInfo {
    protected double xMean;
    protected double yMean;
    protected double zMean;
    protected double xVariance;
    protected double yVariance;
    protected double zVariance;
    private int selectedAxis = -1;
    private boolean autoAdjustMinMax = true;

    public void adjustMinMax(AbstractAxisLayer abstractAxisLayer, int n, double[] dArray) {
    }

    public abstract void calculate(AbstractAxisLayer var1, AbstractDataMatrix var2, int var3);

    public ComboItem createComboItem() {
        return new ComboItem(this.toString(), this.getType(), 0, this);
    }

    public abstract AbstractSettingsPanel createSettingsPanel();

    public abstract void draw(Graphics2D var1, AbstractAxisPlot var2, AbstractAxisLayer var3, AbstractDataMatrix var4, int var5, double var6, double var8);

    public void drawInBg(Graphics2D graphics2D, AbstractAxisPlot abstractAxisPlot, AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n, double d, double d2) {
    }

    public int getSelectedAxis() {
        return this.selectedAxis;
    }

    public int hasStatisticAtGlobal(double d, double d2, AbstractAxisPlot abstractAxisPlot) {
        this.selectedAxis = this.hasStatisticAt(d, d2, abstractAxisPlot);
        return this.selectedAxis;
    }

    public abstract void load(MapProperty var1) throws IOException;

    public abstract void save(RandomOutputStream var1) throws IOException;

    public void setOption(Object object) {
    }

    public void setProperties(Properties properties) {
        if (properties != null && ScriptHelper.hasKey(properties, "autoadjustminmax")) {
            this.autoAdjustMinMax = ScriptHelper.getPropertyBool(properties, "autoadjustminmax");
        }
    }

    public void setValue(int n, double[] dArray, FloatWindowPlot2D floatWindowPlot2D, boolean bl) {
    }

    public void setValue(int n, double d, double d2, boolean bl) {
    }

    public abstract String toNiceString();

    protected int calculateMeanAndVariance(AbstractAxisLayer abstractAxisLayer) {
        int n;
        ZoneLeaf zoneLeaf;
        int n2 = 0;
        this.xMean = 0.0;
        this.yMean = 0.0;
        this.zMean = 0.0;
        Iterator<ZoneLeaf> iterator = abstractAxisLayer.getLeafIterator();
        while (iterator.hasNext()) {
            zoneLeaf = iterator.next();
            if (zoneLeaf.getType() == 0) {
                this.xMean += zoneLeaf.getValue((byte)0);
                this.yMean += zoneLeaf.getValue((byte)1);
                this.zMean += zoneLeaf.getValue((byte)2);
            } else {
                ZoneArray zoneArray = (ZoneArray)zoneLeaf;
                for (n = 0; n < zoneArray.getNoChildren(); ++n) {
                    this.xMean += (double)n;
                    this.yMean += zoneArray.getValue(n, (byte)1);
                    ++n2;
                }
            }
            ++n2;
        }
        this.xMean /= (double)n2;
        this.yMean /= (double)n2;
        this.zMean /= (double)n2;
        this.xVariance = 0.0;
        this.yVariance = 0.0;
        this.zVariance = 0.0;
        iterator = abstractAxisLayer.getLeafIterator();
        while (iterator.hasNext()) {
            double d;
            double d2;
            zoneLeaf = iterator.next();
            if (zoneLeaf.getType() == 0) {
                double d3 = zoneLeaf.getValue((byte)0) - this.xMean;
                this.xVariance += d3 * d3;
                d2 = zoneLeaf.getValue((byte)1) - this.yMean;
                this.yVariance += d2 * d2;
                d = zoneLeaf.getValue((byte)2) - this.zMean;
                this.zVariance += d * d;
                continue;
            }
            ZoneArray zoneArray = (ZoneArray)zoneLeaf;
            for (n = 0; n < zoneArray.getNoChildren(); ++n) {
                d2 = n;
                this.xVariance += d2 * d2;
                d = zoneArray.getValue(n, (byte)1) - this.yMean;
                this.yVariance += d * d;
            }
        }
        if (n2 > 1) {
            this.xVariance = Math.sqrt(this.xVariance / (double)(n2 - 1));
            this.yVariance = Math.sqrt(this.yVariance / (double)(n2 - 1));
            this.zVariance = Math.sqrt(this.zVariance / (double)(n2 - 1));
        }
        return n2;
    }

    @Override
    protected void cleanUpChild() {
    }

    protected abstract int getType();

    protected int hasStatisticAt(double d, double d2, AbstractAxisPlot abstractAxisPlot) {
        return -1;
    }

    public void setAutoAdjustMinMax(boolean bl) {
        this.autoAdjustMinMax = bl;
    }

    public boolean isAutoAdjustMinMax() {
        return this.autoAdjustMinMax;
    }
}

