/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.settings.Statistics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import no.uib.cipr.matrix.DenseVector;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.serie.serie2D.FloatWindowSerie;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;
import se.prediktera.map.plot.axisplot.settings.Statistics.AbstractStatisticsInfo;

public class ConfidenceIntervalInfo
extends AbstractStatisticsInfo {
    private static final BasicStroke stroke = new BasicStroke(2.0f, 0, 0);
    private DenseVector ci = null;

    @Override
    public void adjustMinMax(AbstractAxisLayer abstractAxisLayer, int n, double[] dArray) {
        int n2 = 0;
        List<ZoneLeaf> list = abstractAxisLayer.getRootList();
        for (int i = 0; i < list.size(); ++i) {
            ZoneLeaf zoneLeaf = list.get(i);
            if (!zoneLeaf.isMissing()) {
                double d = zoneLeaf.getValue((byte)1);
                if (n2 < this.ci.size()) {
                    double d2 = this.ci.get(n2);
                    double d3 = Math.min(d - d2, d + d2);
                    double d4 = Math.max(d - d2, d + d2);
                    if (dArray[0] > d3) {
                        dArray[0] = d3;
                    }
                    if (dArray[1] < d4) {
                        dArray[1] = d4;
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    public void calculate(AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n) {
        this.ci = null;
        if (abstractDataMatrix instanceof ModelMatrix) {
            Vector<DenseVector> vector = ((ModelMatrix)abstractDataMatrix).getCIvector();
            this.ci = vector.get(n);
        }
    }

    @Override
    public AbstractSettingsPanel createSettingsPanel() {
        return new AbstractSettingsPanel(){};
    }

    @Override
    public void draw(Graphics2D graphics2D, AbstractAxisPlot abstractAxisPlot, AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n, double d, double d2) {
        if (this.ci == null || d2 < 2.0 || n < 0 || n >= abstractDataMatrix.getN()) {
            return;
        }
        FloatWindowSerie floatWindowSerie = (FloatWindowSerie)abstractAxisPlot;
        Shape shape = graphics2D.getClip();
        floatWindowSerie.setPlotGroundClip(graphics2D);
        graphics2D.setColor(Color.black);
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(ConfidenceIntervalInfo.stroke);
        List<ZoneLeaf> list = abstractAxisLayer.getRootList();
        for (int i = 0; i < list.size(); ++i) {
            ZoneLeaf zoneLeaf = list.get(i);
            if (zoneLeaf.isMissing()) continue;
            double d3 = zoneLeaf.getValue((byte)1);
            int n2 = zoneLeaf.getPrimaryIndex();
            int n3 = abstractDataMatrix.getKrefOrig(n2);
            if (n3 < 0 || n3 >= abstractDataMatrix.getK() || n3 < 0 || n3 >= this.ci.size()) continue;
            double d4 = this.ci.get(n3);
            floatWindowSerie.translateToScreenDouble(dArray2, n2, d3 + d4);
            floatWindowSerie.translateToScreenDouble(dArray, n2, d3 - d4);
            dArray[0] = dArray[0] + d;
            if (!zoneLeaf.isVisible()) continue;
            graphics2D.drawLine((int)(dArray[0] + 0.5 * d2), (int)dArray[1], (int)(dArray[0] + 0.5 * d2), (int)dArray2[1]);
            graphics2D.drawLine((int)(dArray[0] + 0.25 * d2), (int)dArray[1], (int)(dArray[0] + 0.75 * d2), (int)dArray[1]);
            graphics2D.drawLine((int)(dArray[0] + 0.25 * d2), (int)dArray2[1], (int)(dArray[0] + 0.75 * d2), (int)dArray2[1]);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setClip(shape);
    }

    @Override
    public void load(MapProperty mapProperty) throws IOException {
    }

    @Override
    public void save(RandomOutputStream randomOutputStream) throws IOException {
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface instanceof FloatWindowSerie) {
            FloatWindowSerie floatWindowSerie = (FloatWindowSerie)dataTreeInterface;
            DataTreeInterface dataTreeInterface2 = floatWindowSerie.getPlotInit().getDataTreeInterface();
            return dataTreeInterface2 instanceof ModelMatrix && ((ModelMatrix)dataTreeInterface2).hasConfidenceInterval();
        }
        return false;
    }

    @Override
    public String toNiceString() {
        return "Confidence Interval";
    }

    public String toString() {
        return "[CONFIDENCE INTERVAL]";
    }

    @Override
    protected int getType() {
        return 17;
    }
}

