/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.windows;

import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.resource.ImageResource;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.axisplot.windows.FloatWindow;
import se.prediktera.map.plot.axisplot.windows.PlotZoneImage;

public class FloatImageWindow
extends FloatWindow {
    protected PlotZoneImage plotZoneImage;

    public FloatImageWindow() {
        super(true, 0.0, 0.0, 0.0, 0.0, false);
        this.setTransparent(true);
        this.plotZoneImage = new PlotZoneImage(null, 0, 0.0, 0.0, false);
        this.addPlotZone(this.plotZoneImage, 4);
    }

    public FloatImageWindow(Point point, Point point2, byte by) {
        this();
        int n = point.x < point2.x ? point.x : point2.x;
        int n2 = point.y < point2.y ? point.y : point2.y;
        int n3 = point2.x < point.x ? point.x : point2.x;
        int n4 = point2.y < point.y ? point.y : point2.y;
        this.setBackground(new Color(255, 255, 225));
        this.setBorderColor(Color.black);
        this.tempOrigoX = n;
        this.tempOrigoY = n2;
        this.tempWidth = n3 - n;
        this.tempHeight = n4 - n2;
        if (by == 3 && (point.y > point2.y && point.x < point2.x || point.y < point2.y && point.x > point2.x)) {
            this.setShapeType((byte)4);
        } else {
            this.setShapeType(by);
        }
        this.setProtected(false);
        this.setTransparent(false);
    }

    public FloatImageWindow(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        ImageResource imageResource = null;
        if (mapProperty.hasProperty("fimage")) {
            imageResource = (ImageResource)mapProperty.resolveNodeFromName(randomInputStream, "fimage");
        }
        this.plotZoneImage = new PlotZoneImage(null, 0, 0.0, 0.0, false);
        this.addPlotZone(this.plotZoneImage, 4);
        this.plotZoneImage.setImageNoResize(imageResource);
    }

    @Override
    public String getFloatText() {
        return this.plotZoneImage.toString();
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder(330);
        stringBuilder.append("<HTML><BODY><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        stringBuilder.append("<TR><TD>Text:</TD><TD>").append(this.getFloatText()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>X:</TD><TD>").append(this.getTryOrigoX()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Y</TD><TD>").append(this.getTryOrigoY()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Width:</TD><TD>").append(this.getTryWidth()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Heigth</TD><TD>").append(this.getTryHeight()).append("</TD></TR>");
        stringBuilder.append("</TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    @Override
    public byte getTreeType() {
        return 15;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyNode("fimage", this.plotZoneImage.getImage());
    }

    @Override
    public byte SendGlobalMessage(byte by, byte by2) {
        if (by == 5) {
            this.contentPaint((byte)7);
            return 1;
        }
        return super.SendGlobalMessage(by, by2);
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        super.setCreated(abstractWindow_GUI, bl);
        if (!bl && this.plotZoneImage.toString().length() > 0) {
            this.plotZoneImage.setRelativeSize();
        }
    }

    public void setFloatImage(ImageResource imageResource) {
        this.setFloatImage(imageResource, true);
    }

    public void setFloatImage(ImageResource imageResource, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = imageResource == null == (this.plotZoneImage.getImage() == null);
        if (imageResource != null) {
            bl2 = imageResource.equals(this.plotZoneImage.getImage());
        }
        if (!bl2) {
            this.beginUpdate();
            if (bl) {
                this.plotZoneImage.setImage(imageResource);
            } else {
                this.plotZoneImage.setImageNoResize(imageResource);
            }
            this.endUpdate((byte)7);
        }
    }

    public void setImageAlignment(byte by) {
        this.plotZoneImage.setAlignment(by);
    }

    public void superComponentResized(double d, double d2, boolean bl, boolean bl2) {
        super.componentResized(d, d2, bl, bl2);
    }

    @Override
    public String toString() {
        return "Text (" + this.getFloatText() + ")";
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.plotZoneImage = null;
    }
}

