/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.windows;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.axisplot.windows.FloatWindow;
import se.prediktera.map.plot.axisplot.windows.PlotZoneText;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class FloatTextWindow
extends FloatWindow {
    protected PlotZoneText plotZoneText;
    private boolean autotext = true;

    public FloatTextWindow() {
        this((Font)null);
    }

    public FloatTextWindow(Font font) {
        this(font, 0);
    }

    public FloatTextWindow(Font font, int n) {
        super(true, 0.0, 0.0, 0.0, 0.0, false);
        this.setTransparent(true);
        this.plotZoneText = new PlotZoneText(null, n, 0.0, 0.0, false);
        if (font != null) {
            this.plotZoneText.setFont(font, false);
        }
        this.addPlotZone(this.plotZoneText, 4);
    }

    public FloatTextWindow(Point point, Point point2, byte by) {
        this((Font)null);
        int n = point.x < point2.x ? point.x : point2.x;
        int n2 = point.y < point2.y ? point.y : point2.y;
        int n3 = point2.x < point.x ? point.x : point2.x;
        int n4 = point2.y < point.y ? point.y : point2.y;
        this.setBackground(new Color(255, 255, 225));
        this.setBorderColor(Color.black);
        this.tempOrigoX = n;
        this.tempOrigoY = n2;
        this.tempWidth = n3 - n;
        this.tempHeight = n4 - n2;
        if (by == 3 && (point.y > point2.y && point.x < point2.x || point.y < point2.y && point.x > point2.x)) {
            this.setShapeType((byte)4);
        } else {
            this.setShapeType(by);
        }
        this.setProtected(false);
        this.setTransparent(false);
        this.autotext = false;
    }

    public FloatTextWindow(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        if (mapProperty.hasProperty("atext")) {
            this.autotext = mapProperty.getLVBoolean();
        }
        String string = "";
        if (mapProperty.hasProperty("ftext")) {
            string = mapProperty.getLVStringUTF();
        }
        this.plotZoneText = new PlotZoneText(null, 0.0, 0.0, false);
        if (mapProperty.hasProperty("frot")) {
            this.plotZoneText.setRotate(mapProperty.getLVBoolean(), false);
        }
        if (mapProperty.hasProperty("ffsize")) {
            this.plotZoneText.setFont(new Font("SansSerif", 1, mapProperty.getLVInt()), false);
        }
        if (mapProperty.hasProperty("align")) {
            this.plotZoneText.setHorizontalAlignment(mapProperty.getLVInt());
        }
        this.addPlotZone(this.plotZoneText, 4);
        this.plotZoneText.setTextNoResize(string);
    }

    public Font getFloatFont() {
        if (this.plotZoneText != null) {
            return this.plotZoneText.getTextFont();
        }
        return null;
    }

    @Override
    public String getFloatText() {
        if (this.plotZoneText != null) {
            return this.plotZoneText.toString();
        }
        return "";
    }

    @Override
    public Color getFontColor() {
        return this.plotZoneText.getFontColor();
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder(330);
        stringBuilder.append("<HTML><BODY><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        stringBuilder.append("<TR><TD>Text:</TD><TD>").append(this.getFloatText()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>X:</TD><TD>").append(this.getTryOrigoX()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Y</TD><TD>").append(this.getTryOrigoY()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Width:</TD><TD>").append(this.getTryWidth()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Heigth</TD><TD>").append(this.getTryHeight()).append("</TD></TR>");
        stringBuilder.append("</TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    @Override
    public byte getTextAlignment() {
        return (byte)this.plotZoneText.getHorizontalAlignment();
    }

    @Override
    public byte getTreeType() {
        return 0;
    }

    @Override
    public boolean hasAutoText() {
        return this.autotext;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyBoolean("atext", this.autotext);
        randomOutputStream.writePropertyStringUTF("ftext", this.plotZoneText.toString());
        randomOutputStream.writePropertyBoolean("frot", this.plotZoneText.isRotate());
        randomOutputStream.writePropertyInt("ffsize", this.plotZoneText.getFontSize());
        randomOutputStream.writePropertyInt("align", this.plotZoneText.getHorizontalAlignment());
    }

    @Override
    public byte SendGlobalMessage(byte by, byte by2) {
        if (by == 5) {
            this.contentPaint((byte)7);
            return 1;
        }
        return super.SendGlobalMessage(by, by2);
    }

    public void set(String string, String string2) {
        if (!string.equalsIgnoreCase("text")) {
            throw new RuntimeException("No such option: " + string);
        }
        this.autotext = false;
        this.setFloatText(string2);
    }

    @Override
    public void setAutoText(boolean bl) {
        DataTreeInterface dataTreeInterface;
        this.autotext = bl;
        if (bl && (dataTreeInterface = this.getTreeParent()) instanceof AbstractPlotLayout) {
            AbstractPlotLayout abstractPlotLayout = (AbstractPlotLayout)dataTreeInterface;
            abstractPlotLayout.getMainWindow().updateDescriptionTextBox();
        }
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        super.setCreated(abstractWindow_GUI, bl);
        if (!bl && this.plotZoneText.toString().length() > 0) {
            this.plotZoneText.setRelativeSize();
        }
    }

    public void setFloatFont(Font font) {
        this.plotZoneText.setFont(font, true);
    }

    public void setFloatRotate(boolean bl) {
        this.plotZoneText.setRotate(bl, true);
    }

    public void setFloatText(String string) {
        this.setFloatText(string, true);
    }

    @Override
    public void setFloatText(String string, boolean bl) {
        if (this.plotZoneText != null) {
            boolean bl2;
            boolean bl3 = bl2 = string == null == (this.plotZoneText.toString() == null);
            if (string != null) {
                bl2 = string.equals(this.plotZoneText.toString());
            }
            if (!bl2) {
                this.beginUpdate();
                if (bl) {
                    this.plotZoneText.setText(string);
                } else {
                    this.plotZoneText.setTextNoResize(string);
                }
                this.endUpdate((byte)7);
            }
        }
    }

    @Override
    public void setFont(String string, Double d, Double d2) {
        this.setFloatFont(new Font(string, d.intValue(), d2.intValue()));
    }

    public void setFont(String string, String string2, Double d) {
        int n = 0;
        if (string2.equalsIgnoreCase("bold")) {
            n = 1;
        }
        if (string2.equalsIgnoreCase("italic")) {
            n = 2;
        }
        this.plotZoneText.setFont(new Font(string, n, d.intValue()), true);
    }

    @Override
    public void setFontColor(Color color) {
        this.plotZoneText.setFontColor(color);
    }

    public void setHorizontalAlignment(int n) {
        this.plotZoneText.setHorizontalAlignment(n);
    }

    public void setRelativeSize() {
        this.plotZoneText.setRelativeSize();
    }

    @Override
    public void setTextAlignment(byte by) {
        this.plotZoneText.setHorizontalAlignment(by);
    }

    public void superComponentResized(double d, double d2, boolean bl, boolean bl2) {
        super.componentResized(d, d2, bl, bl2);
    }

    @Override
    public String toString() {
        return "Text (" + this.getFloatText() + ")";
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.plotZoneText = null;
    }
}

