/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.windows;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.RepaintManager;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.resource.ResourceNode;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.event.DataTreeListener;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.main.BrowserElement;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlot2D;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;
import se.prediktera.map.plot.axisplot.windows.FloatMainWindow;
import se.prediktera.map.plot.axisplot.windows.PlotZone;
import se.prediktera.map.plot.axisplot.windows.ZoneLayout;
import se.prediktera.map.plot.axisplot.windows.ZoneRelativeLayout;
import se.prediktera.map.plot.layout.AbstractPlotLayout;
import se.prediktera.map.plot.layout.PlotEditInterface;
import se.prediktera.map.plot.layout.PlotWindowInterface;

public abstract class FloatWindow
extends CleanUpPanel
implements PlotWindowInterface,
PlotEditInterface,
MouseListener,
MouseMotionListener {
    private static final float[] dash1 = new float[]{5.0f};
    private static final BasicStroke rubberStroke = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
    protected static final BasicStroke normalStroke = new BasicStroke(1.0f, 0, 0, 10.0f);
    protected static final Color transparentColor = new Color(0, 0, 0, 0);
    protected AbstractPlotLayout baseWindow;
    private double relativeX = 0.0;
    private double relativeY = 0.0;
    private double relativeWidth = 1.0;
    private double relativeHeight = 1.0;
    private double lastOrigoX;
    private double lastOrigoY;
    private double lastWidth;
    private double lastHeight;
    protected double tempOrigoX;
    protected double tempOrigoY;
    protected double tempWidth;
    protected double tempHeight;
    private boolean selected = false;
    private int boxHalfSize;
    private int boxSize;
    private ZoneLayout zoneLayout;
    private BufferedImage baseImage;
    private BufferedImage selectionImage;
    protected JPanel redirectPanel = null;
    private boolean transparent = false;
    private final boolean hasselections;
    private boolean created = false;
    private final boolean dependsOnCreated;
    private Vector<DataTreeInterface> treeVector = new Vector();
    private Integer windowID;
    private DataTreeInterface nodeParent;
    private DataTreeManager dataTreeManager;
    private int saveIndex = -1;
    private BrowserElement browserElement;
    private boolean isprotected = true;
    private int updating = 0;
    private int windowlayout = 5;
    private byte shapeType = 1;
    private boolean drawLine = true;
    private Color borderColor = null;
    private BasicStroke borderStroke = new BasicStroke(1.0f, 0, 0, 10.0f);
    private boolean isvirtualresize = false;
    private final int[][] cursor_maximum = new int[][]{{1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}};
    private GradientPaint backgroundGradient;
    private boolean highSelectionContrast = false;

    public static void main(String[] stringArray) {
        FloatWindow floatWindow = new FloatWindow(false, 0.0, 0.0, 5.0, 5.0, true){

            @Override
            public byte getTreeType() {
                return 0;
            }
        };
        BufferedImage bufferedImage = floatWindow.selectionImage = new BufferedImage(5, 5, 2);
        int n = Color.red.getRGB();
        bufferedImage.setRGB(2, 0, n);
        bufferedImage.setRGB(1, 1, n);
        bufferedImage.setRGB(3, 1, n);
        bufferedImage.setRGB(0, 2, n);
        bufferedImage.setRGB(2, 2, n);
        bufferedImage.setRGB(4, 2, n);
        bufferedImage.setRGB(1, 3, n);
        bufferedImage.setRGB(3, 3, n);
        bufferedImage.setRGB(2, 4, n);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        floatWindow.markSelectionObjects(graphics2D);
        graphics2D.dispose();
    }

    public FloatWindow(boolean bl, double d, double d2, double d3, double d4, boolean bl2) {
        super("FloatWindow");
        this.dependsOnCreated = bl;
        this.hasselections = bl2;
        this.relativeX = d;
        this.relativeY = d2;
        this.relativeWidth = d3;
        this.relativeHeight = d4;
        this.init();
        this.setBackground(Color.white);
    }

    public FloatWindow(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super("FloatWindow");
        this.dataTreeManager = randomInputStream.getDataTreeManager();
        this.windowID = randomInputStream.getDataTreeManager().addUniqueID(randomInputStream.getCT().id, this);
        if (mapProperty.hasProperty("tox")) {
            this.tempOrigoX = mapProperty.getLVInt();
        }
        if (mapProperty.hasProperty("toy")) {
            this.tempOrigoY = mapProperty.getLVInt();
        }
        if (mapProperty.hasProperty("tow")) {
            this.tempWidth = mapProperty.getLVInt();
        }
        if (mapProperty.hasProperty("toh")) {
            this.tempHeight = mapProperty.getLVInt();
        }
        if (mapProperty.hasProperty("toxd")) {
            this.tempOrigoX = mapProperty.getLVDouble();
        }
        if (mapProperty.hasProperty("toyd")) {
            this.tempOrigoY = mapProperty.getLVDouble();
        }
        if (mapProperty.hasProperty("towd")) {
            this.tempWidth = mapProperty.getLVDouble();
        }
        if (mapProperty.hasProperty("tohd")) {
            this.tempHeight = mapProperty.getLVDouble();
        }
        this.relativeX = mapProperty.getPropertyDouble("relx");
        this.relativeY = mapProperty.getPropertyDouble("rely");
        this.relativeWidth = mapProperty.getPropertyDouble("relw", 1.0);
        this.relativeHeight = mapProperty.getPropertyDouble("relh", 1.0);
        if (mapProperty.hasProperty("bgcolor")) {
            this.setBackground(new Color(mapProperty.getLVInt()));
        } else {
            this.setBackground(Color.white);
        }
        if (mapProperty.hasProperty("border")) {
            this.borderColor = new Color(mapProperty.getLVInt());
        }
        float f = mapProperty.getPropertyFloat("bwidth", 1.0f);
        this.borderStroke = new BasicStroke(f, 0, 0, 10.0f);
        this.selected = mapProperty.getPropertyBoolean("sel");
        this.transparent = mapProperty.getPropertyBoolean("trs");
        this.hasselections = mapProperty.getPropertyBoolean("hsl");
        this.dependsOnCreated = mapProperty.getPropertyBoolean("doc");
        this.isprotected = mapProperty.getPropertyBoolean("protected", true);
        this.windowlayout = mapProperty.getPropertyInt("windowlayout");
        this.shapeType = mapProperty.getPropertyByte("shape");
        this.drawLine = mapProperty.getPropertyBoolean("dl", true);
        this.highSelectionContrast = mapProperty.getPropertyBoolean("hsc", false);
        this.init();
    }

    @Override
    public boolean acceptDrag() {
        if (this.resizeLayout(true)) {
            this.contentPaint((byte)7);
        }
        this.dataTreeManager.setProjectChanged();
        return true;
    }

    @Override
    public void addDataTreeChangeListener(DataTreeListener dataTreeListener) {
    }

    public void addPlotZone(PlotZone plotZone, int n) {
        this.beginUpdate();
        plotZone.setParent(this);
        this.zoneLayout.addPlotZone(plotZone, n);
        this.resizeLayout(true);
        this.endUpdate((byte)7);
    }

    @Override
    public void addShortcut(DataTreeInterface dataTreeInterface) {
        this.treeVector.addElement(dataTreeInterface);
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        return false;
    }

    @Override
    public void addTreeNode(DataTreeInterface dataTreeInterface) {
        dataTreeInterface.setTreeParent(this);
        this.treeVector.addElement(dataTreeInterface);
    }

    @Override
    public void beginDrag() {
        this.tempOrigoX = this.lastOrigoX = this.getTryOrigoX();
        this.tempOrigoY = this.lastOrigoY = this.getTryOrigoY();
        this.tempWidth = this.lastWidth = this.getTryWidth();
        this.tempHeight = this.lastHeight = this.getTryHeight();
    }

    @Override
    public void beginUpdate() {
        ++this.updating;
    }

    @Override
    public void componentResized(double d, double d2, boolean bl, boolean bl2) {
        if (this.isCreated()) {
            this.setActualSize();
            if (bl) {
                this.setActualPosition();
            } else {
                this.resizeLayout(true);
            }
        }
    }

    @Override
    public boolean containsTreeNode(DataTreeInterface dataTreeInterface) {
        return this.treeVector.contains(dataTreeInterface);
    }

    @Override
    public synchronized boolean contentPaint(byte by) {
        if (!this.created || this.isUpdating() || this.baseWindow == null || !this.baseWindow.isContentReady()) {
            return false;
        }
        try {
            if (this.redirectPanel == null) {
                if ((by & 1) == 1 && this.baseImage != null) {
                    this.contentPaint(this.baseImage, (byte)1, this.transparent);
                }
                if (this.hasselections && (by & 2) == 2 && this.selectionImage != null) {
                    this.contentPaint(this.selectionImage, (byte)2, true);
                }
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            Logg.error("Paint error", concurrentModificationException);
        }
        catch (Throwable throwable) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(throwable);
        }
        this.repaint();
        return true;
    }

    @Override
    public void doChange() {
        if (this.baseWindow != null) {
            this.relativeX = this.tempOrigoX / (double)this.baseWindow.getWidth();
            this.relativeY = this.tempOrigoY / (double)this.baseWindow.getHeight();
            this.relativeWidth = this.tempWidth / (double)this.baseWindow.getWidth();
            this.relativeHeight = this.tempHeight / (double)this.baseWindow.getHeight();
        }
        this.zoneLayout.doChange();
    }

    public void drawLine(Double[] doubleArray) throws Exception {
    }

    @Override
    public void endFloated(Graphics2D graphics2D) {
        graphics2D.setPaintMode();
    }

    @Override
    public void endUpdate(byte by) {
        --this.updating;
        if (this.updating < 0) {
            this.updating = 0;
        }
        if (this.updating == 0) {
            this.contentPaint(by);
        }
    }

    public PlotZone getArea(String string) {
        if (this.zoneLayout != null) {
            return this.zoneLayout.getArea(string);
        }
        return null;
    }

    @Override
    public Color getBorderColor() {
        return this.borderColor;
    }

    @Override
    public float getBorderWidth() {
        return this.borderStroke.getLineWidth();
    }

    public BrowserElement getBrowserWrapper() {
        return this.browserElement;
    }

    public final int getCeilHeight() {
        return (int)Math.ceil(this.getTryHeight());
    }

    public final int getCeilWidth() {
        return (int)Math.ceil(this.getTryWidth());
    }

    @Override
    public int getCorner(Point point) {
        double d = this.getTryOrigoX();
        double d2 = this.getTryOrigoY();
        double d3 = this.getTryWidth();
        double d4 = this.getTryHeight();
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n2 = (int)(d + d3 * 0.5 * (double)j);
                int n3 = (int)(d2 + d4 * 0.5 * (double)i);
                if (j == 1 && i == 1) {
                    n = -1;
                    continue;
                }
                if (!this.isOnCorner(point, n2, n3)) continue;
                return i * 3 + j + n;
            }
        }
        if (this.zoneLayout == null) {
            return -1;
        }
        return this.zoneLayout.getCorner(point);
    }

    @Override
    public DataTreeManager getDataTreeManager() {
        if (this.dataTreeManager == null && this.nodeParent != null) {
            this.setDataTreeManager(this.nodeParent.getDataTreeManager(), false);
        }
        return this.dataTreeManager;
    }

    @Override
    public String getFloatText() {
        return "";
    }

    @Override
    public Color getFontColor() {
        return null;
    }

    @Override
    public ImageIcon getIcon(byte by) {
        return null;
    }

    @Override
    public Integer getID() {
        if (this.windowID == null && this.getDataTreeManager() != null) {
            this.windowID = this.dataTreeManager.addUniqueID(null, this);
        }
        return this.windowID;
    }

    @Override
    public String getInformation() {
        return "<HTML><BODY><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >";
    }

    @Override
    public byte getNodeType() {
        return 3;
    }

    @Override
    public AbstractPlotLayout getParentBaseWindow() {
        return this.baseWindow;
    }

    public double getRelative() {
        double d;
        double d2 = this.getTryWidth() * 0.004;
        if (d2 > (d = this.getTryHeight() * 0.004)) {
            return d;
        }
        return d2;
    }

    @Override
    public final double getRelativeHeight() {
        return this.relativeHeight;
    }

    @Override
    public final double getRelativeWidth() {
        return this.relativeWidth;
    }

    @Override
    public final double getRelativeX() {
        return this.relativeX;
    }

    @Override
    public final double getRelativeY() {
        return this.relativeY;
    }

    public DataTreeInterface getRootNode() {
        DataTreeInterface dataTreeInterface = this;
        while (dataTreeInterface.getTreeParent() != null) {
            dataTreeInterface = dataTreeInterface.getTreeParent();
        }
        return dataTreeInterface;
    }

    public ResourceNode getRootResourceNode() {
        DataTreeInterface dataTreeInterface;
        DataTreeInterface dataTreeInterface2 = this.getRootNode();
        if (dataTreeInterface2 instanceof DataContainer && (dataTreeInterface = ((DataContainer)dataTreeInterface2).getNodeByName("Resources")) instanceof ResourceNode) {
            return (ResourceNode)dataTreeInterface;
        }
        return null;
    }

    @Override
    public int getSaveIndex() {
        return this.saveIndex;
    }

    @Override
    public byte getShapeType() {
        return this.shapeType;
    }

    @Override
    public byte getTextAlignment() {
        return 2;
    }

    @Override
    public DataTreeInterface getTreeNodeAt(int n) {
        return this.treeVector.elementAt(n);
    }

    @Override
    public int getTreeNodeCount() {
        return this.treeVector.size();
    }

    @Override
    public DataTreeInterface getTreeParent() {
        return this.nodeParent;
    }

    @Override
    public final double getTryHeight() {
        if (this.baseWindow == null || this.baseWindow.getHeight() == 0) {
            return 1.0;
        }
        return Math.max(1.0, this.relativeHeight * (double)this.baseWindow.getHeight());
    }

    @Override
    public final double getTryOrigoX() {
        if (this.baseWindow == null) {
            return 0.0;
        }
        return this.relativeX * (double)this.baseWindow.getWidth();
    }

    @Override
    public final double getTryOrigoY() {
        if (this.baseWindow == null) {
            return 0.0;
        }
        return this.relativeY * (double)this.baseWindow.getHeight();
    }

    @Override
    public final double getTryWidth() {
        if (this.baseWindow == null || this.baseWindow.getWidth() == 0) {
            return 1.0;
        }
        return Math.max(1.0, this.relativeWidth * (double)this.baseWindow.getWidth());
    }

    @Override
    public int getWindowLayout() {
        return this.windowlayout;
    }

    @Override
    public boolean hasAutoText() {
        return false;
    }

    public final boolean hasRedirectPanel() {
        return this.redirectPanel != null;
    }

    @Override
    public void insertTreeNode(DataTreeInterface dataTreeInterface) {
        dataTreeInterface.setTreeParent(this);
        this.treeVector.insertElementAt(dataTreeInterface, 0);
    }

    public boolean isCreated() {
        return this.baseWindow != null && this.created;
    }

    @Override
    public boolean isDrawLine() {
        return this.drawLine;
    }

    @Override
    public boolean isInside(Point point) {
        if (point != null) {
            double d = this.getTryOrigoX();
            double d2 = this.getTryOrigoY();
            double d3 = this.getTryWidth();
            double d4 = this.getTryHeight();
            return (double)point.x >= d && (double)point.y >= d2 && (double)point.x < d + d3 && (double)point.y < d2 + d4;
        }
        return false;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isNode() {
        return true;
    }

    public final boolean isOnCorner(Point point, int n, int n2) {
        int n3 = n - this.boxHalfSize;
        int n4 = n + this.boxHalfSize;
        int n5 = n2 - this.boxHalfSize;
        int n6 = n2 + this.boxHalfSize;
        return point.x >= n3 && point.y >= n5 && point.x < n4 && point.y < n6;
    }

    @Override
    public boolean isProtected() {
        return this.isprotected;
    }

    @Override
    public boolean isTransparent() {
        return this.transparent;
    }

    @Override
    public boolean isVisibleInTree() {
        return false;
    }

    @Override
    public void makeScreenShot(Graphics2D graphics2D, boolean bl, boolean bl2) {
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        repaintManager.setDoubleBufferingEnabled(false);
        graphics2D.setStroke(normalStroke);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(this.getTryOrigoX(), this.getTryOrigoY());
        if (!this.transparent) {
            this.drawShape(graphics2D, true);
        }
        int n = 16;
        if (bl2) {
            n = (byte)(n | 0x20);
        }
        double d = this.getRelative();
        if (this.redirectPanel == null) {
            this.preparePaint(graphics2D, d);
            this.zoneLayout.makeScreenShot(graphics2D, (byte)(n | 1 | 8), d);
            if (bl) {
                this.zoneLayout.makeScreenShot(graphics2D, (byte)(n | 8 | 2), d);
            }
            if (this.hasInteractionContent()) {
                this.zoneLayout.makeScreenShot(graphics2D, (byte)(n | 4), d);
            }
        } else {
            this.redirectPanel.paint(graphics2D);
        }
        if (this.borderColor != null) {
            this.drawShape(graphics2D, false);
        }
        graphics2D.setTransform(affineTransform);
        repaintManager.setDoubleBufferingEnabled(true);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.baseWindow != null) {
            this.baseWindow.mouseClicked(this.invokeEvent(mouseEvent, false));
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        DataTreeManager dataTreeManager;
        if (this.baseWindow != null) {
            this.baseWindow.mouseDragged(this.invokeEvent(mouseEvent, true));
        }
        if ((dataTreeManager = this.getDataTreeManager()) != null) {
            dataTreeManager.setProjectChanged();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.baseWindow != null) {
            this.baseWindow.mouseEntered(this.invokeEvent(mouseEvent, false));
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.baseWindow != null) {
            this.baseWindow.mouseExited(this.invokeEvent(mouseEvent, false));
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.baseWindow != null) {
            this.baseWindow.mouseMoved(this.invokeEvent(mouseEvent, true));
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.baseWindow != null) {
            this.baseWindow.mousePressed(this.invokeEvent(mouseEvent, false));
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.baseWindow != null) {
            this.baseWindow.mouseReleased(this.invokeEvent(mouseEvent, false));
        }
    }

    public void moveFloated(int n, int n2) {
        if (this.lastOrigoX + (double)n >= 0.0 && this.lastOrigoY + (double)n2 >= 0.0 && this.lastOrigoX + this.lastWidth + (double)n < (double)this.baseWindow.getWidth() && this.lastOrigoY + this.lastHeight + (double)n2 < (double)this.baseWindow.getHeight()) {
            this.lastOrigoX += (double)n;
            this.lastOrigoY += (double)n2;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.hasRedirectPanel()) {
            super.paint(graphics);
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (!this.isCreated()) {
            return;
        }
        if (this.redirectPanel == null) {
            int n = (int)this.getTryOrigoX();
            int n2 = (int)this.getTryOrigoY();
            graphics2D.drawImage((Image)this.baseImage, n, n2, null);
            if (this.hasselections) {
                graphics2D.drawImage(this.selectionImage, null, n, n2);
            }
            if (this.hasInteractionContent()) {
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.translate(n, n2);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.baseWindow.getAntiAliasHint());
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, this.baseWindow.getRenderingQualityHint());
                double d = this.getRelative();
                if (this.zoneLayout != null) {
                    this.zoneLayout.paint(graphics2D, (byte)4, d);
                }
                graphics2D.setTransform(affineTransform);
            }
        }
        if (this.selected) {
            this.paintSelected(graphics2D);
        }
    }

    public void paintArea(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        if (this.redirectPanel == null) {
            int n5 = (int)this.getTryOrigoX();
            int n6 = (int)this.getTryOrigoY();
            graphics2D.drawImage(this.baseImage, n5 + n, n6 + n2, n5 + n3, n6 + n4, n, n2, n3, n4, null);
            if (this.hasselections) {
                graphics2D.drawImage(this.selectionImage, n5 + n, n6 + n2, n5 + n3, n6 + n4, n, n2, n3, n4, null);
            }
        }
    }

    @Override
    public void paintFloated(Graphics2D graphics2D) {
        graphics2D.drawRect((int)this.getTryOrigoX(), (int)this.getTryOrigoY(), (int)this.getTryWidth(), (int)this.getTryHeight());
        this.zoneLayout.paintFloated(graphics2D);
    }

    public final void paintSelectionBox(Graphics2D graphics2D, int n, int n2) {
        graphics2D.fillRect(n - this.boxHalfSize, n2 - this.boxHalfSize, this.boxSize, this.boxSize);
    }

    public void removeArea(String string) {
        this.zoneLayout.removeArea(string);
    }

    @Override
    public void removeDataTreeChangeListener(DataTreeListener dataTreeListener) {
    }

    @Override
    public boolean removeTreeNode(DataTreeInterface dataTreeInterface) {
        return this.treeVector.removeElement(dataTreeInterface);
    }

    @Override
    public void repaint() {
        if (this.created && !this.isUpdating()) {
            if (this.baseWindow != null) {
                this.baseWindow.repaint();
            }
            if (this.redirectPanel != null) {
                super.repaint();
            }
        } else {
            super.repaint();
        }
    }

    public void SaveData(RandomOutputStream randomOutputStream) throws IOException {
    }

    public void SaveData(RandomOutputStream randomOutputStream, int n) throws IOException {
        this.SaveData(randomOutputStream);
    }

    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream, int n) throws IOException {
        this.saveIndex = n;
        randomOutputStream.writePropertyDouble("relx", this.relativeX);
        randomOutputStream.writePropertyDouble("rely", this.relativeY);
        randomOutputStream.writePropertyDouble("relw", this.relativeWidth);
        randomOutputStream.writePropertyDouble("relh", this.relativeHeight);
        randomOutputStream.writePropertyInt("bgcolor", this.getBackground().getRGB());
        if (this.borderColor != null) {
            randomOutputStream.writePropertyInt("border", this.borderColor.getRGB());
        }
        randomOutputStream.writePropertyFloat("bwidth", this.borderStroke.getLineWidth());
        randomOutputStream.writePropertyBoolean("sel", this.selected);
        randomOutputStream.writePropertyBoolean("trs", this.transparent);
        randomOutputStream.writePropertyBoolean("hsl", this.hasselections);
        randomOutputStream.writePropertyBoolean("doc", this.dependsOnCreated);
        randomOutputStream.writePropertyBoolean("protected", this.isprotected);
        randomOutputStream.writePropertyInt("windowlayout", this.windowlayout);
        randomOutputStream.writePropertyByte("shape", this.shapeType);
        randomOutputStream.writePropertyBoolean("dl", this.drawLine);
        randomOutputStream.writePropertyBoolean("hsc", this.highSelectionContrast);
        this.zoneLayout.SaveProperty(randomOutputStream);
        this.SaveProperty(randomOutputStream);
    }

    @Override
    public byte SendGlobalMessage(byte by, byte by2) {
        return 0;
    }

    public void setActualDimensions() {
        this.setActualPosition();
        this.setActualSize();
    }

    public void setAntiAliasOn(boolean bl) {
        this.baseWindow.setAntiAliasing(bl);
    }

    @Override
    public void setAutoText(boolean bl) {
    }

    @Override
    public void setBackground(Color color) {
        if (color == null) {
            this.transparent = true;
        } else {
            this.transparent = false;
            super.setBackground(color);
        }
    }

    public void setBackgroundColor(Color color) {
        this.setBackgroundColor(PerfectSpread.getColorToString(color), null, null);
    }

    public void setBackgroundColor(Color color, Color color2) {
        this.setBackgroundColor(PerfectSpread.getColorToString(color), PerfectSpread.getColorToString(color2), null);
    }

    public void setBackgroundColor(Color color, Color color2, Properties properties) {
        this.setBackgroundColor(PerfectSpread.getColorToString(color), PerfectSpread.getColorToString(color2), properties);
    }

    public void setBackgroundColor(String string) {
        this.setBackgroundColor(string, null, null);
    }

    public void setBackgroundColor(String string, String string2) {
        this.setBackgroundColor(string, string2, null);
    }

    public void setBackgroundColor(String string, String string2, Properties properties) {
        if (string.equalsIgnoreCase("transparent") || string.equalsIgnoreCase("none")) {
            this.setBackground(null);
        } else {
            Color color = PerfectSpread.getColorFromString(string);
            this.setBackground(color);
            if (string2 != null) {
                Color color2 = PerfectSpread.getColorFromString(string2);
                int n = this.getWidth() / 2;
                int n2 = this.getHeight() / 2;
                if (properties != null) {
                    if (ScriptHelper.hasKey(properties, "width")) {
                        n = ScriptHelper.getPropertyInt(properties, "width");
                    }
                    if (ScriptHelper.hasKey(properties, "height")) {
                        n2 = ScriptHelper.getPropertyInt(properties, "height");
                    }
                }
                this.backgroundGradient = new GradientPaint(0.0f, 0.0f, color, n, n2, color2);
            }
        }
    }

    public void setBorder(String string) throws Exception {
        this.setBorder(string, null, null);
    }

    public void setBorder(String string, Properties properties) {
        this.setBorder(string, null, properties);
    }

    public void setBorder(String string, String string2) {
        this.setBorder(string, string2, null);
    }

    public void setBorder(String string, String string2, Properties properties) {
        Object object;
        if (string != null) {
            object = AbstractPlotLayout.SHAPES;
            for (int i = 0; i < ((String[])object).length; ++i) {
                if (!string.equalsIgnoreCase(object[i])) continue;
                this.setShapeType((byte)(i - 1));
            }
        }
        if (string2 != null) {
            if (string2.equalsIgnoreCase("transparent") || string2.equalsIgnoreCase("none")) {
                this.setBorderColor(null);
            } else {
                object = PerfectSpread.getColorFromString(string2);
                this.setBorderColor((Color)object);
            }
        }
        if (properties != null && ScriptHelper.hasKey(properties, "width")) {
            this.setBorderWidth((float)ScriptHelper.getPropertyDouble(properties, "width"));
        }
    }

    @Override
    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    @Override
    public void setBorderWidth(float f) {
        if (this.borderStroke.getLineWidth() != f) {
            this.borderStroke = new BasicStroke(f, 0, 0, 10.0f);
        }
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds((int)this.getTryOrigoX(), (int)this.getTryOrigoY(), (int)this.getTryWidth(), (int)this.getTryHeight());
    }

    public void setBrowserWrapper(BrowserElement browserElement) {
        this.browserElement = browserElement;
    }

    @Override
    public void setDataTreeManager(DataTreeManager dataTreeManager, boolean bl) {
        if (bl || this.dataTreeManager != null && this.dataTreeManager != dataTreeManager) {
            this.windowID = null;
        }
        this.dataTreeManager = dataTreeManager;
        if (this.windowID == null && this.dataTreeManager != null) {
            this.windowID = this.dataTreeManager.addUniqueID(null, this);
        }
        int n = this.getTreeNodeCount();
        for (int i = 0; i < n; ++i) {
            this.getTreeNodeAt(i).setDataTreeManager(dataTreeManager, bl);
        }
    }

    public void setDimension(Double d, Double d2) {
        if (this.baseWindow.getWidth() <= 1 || this.baseWindow.getHeight() <= 1) {
            this.baseWindow.setSize(600, 600);
        }
        double d3 = d / 100.0;
        double d4 = d2 / 100.0;
        double d5 = this.baseWindow.getWidth();
        double d6 = this.baseWindow.getHeight();
        double d7 = (this.getTryOrigoX() + this.getTryWidth() / 2.0 - d5 * d3 / 2.0) / d5;
        double d8 = (this.getTryOrigoY() + this.getTryHeight() / 2.0 - d6 * d4 / 2.0) / d6;
        this.setRelativeSize(d3, d4);
        if (this.windowlayout != 5) {
            this.baseWindow.autoLayout();
        }
        this.setRelativePosition(d7, d8);
    }

    @Override
    public void setDrawLine(boolean bl) {
        this.drawLine = bl;
    }

    @Override
    public void setFloatText(String string, boolean bl) {
    }

    @Override
    public void setFloatWindowCreated(Plot_GUI plot_GUI, boolean bl) {
        this.beginUpdate();
        this.resizeLayout(true);
        this.created = true;
        this.setVisible(true);
        this.setCreated(plot_GUI, bl);
    }

    public void setFont(String string, Double d, Double d2) {
    }

    public void setFont(String string, String string2, Double[] doubleArray) {
    }

    @Override
    public void setFontColor(Color color) {
    }

    public void setFontColor(String string) {
        this.setFontColor(PerfectSpread.getColorFromString(string));
    }

    public void setHighSelectionContrast(boolean bl) {
        this.highSelectionContrast = bl;
    }

    public void setLayout(ZoneLayout zoneLayout) {
        this.zoneLayout = zoneLayout;
        zoneLayout.setFloatWindow(this);
    }

    public void setPanel(JPanel jPanel) {
        this.redirectPanel = jPanel;
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
    }

    @Override
    public void setParentBaseWindow(AbstractPlotLayout abstractPlotLayout) {
        this.baseWindow = abstractPlotLayout;
        this.temporaryToRelative();
        this.contentPaint((byte)7);
        if (!abstractPlotLayout.isLayoutEnable()) {
            this.selected = false;
        }
    }

    public void setPosition(Double d) {
        PlotInit plotInit = this.baseWindow.getPlotInit();
        AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)plotInit.getDataTreeInterface();
        int n = abstractDataMatrix.getFoldN();
        if (abstractDataMatrix instanceof FoldMatrix) {
            FoldMatrix foldMatrix = (FoldMatrix)abstractDataMatrix;
            n = foldMatrix.getFoldN();
        }
        int n2 = d.intValue();
        double d2 = n2 / n + 1;
        double d3 = n2 % n + 1;
        double[] dArray = new double[2];
        FloatMainWindow floatMainWindow = this.baseWindow.getMainWindow();
        FloatWindowPlot2D floatWindowPlot2D = (FloatWindowPlot2D)this.baseWindow.getMainWindow();
        AxisRange axisRange = floatWindowPlot2D.getRange(1, 0);
        floatWindowPlot2D.translateToScreenDouble(dArray, d2, axisRange.getDataMax() - d3);
        this.setPosition((dArray[0] + floatMainWindow.getTryOrigoX()) / (double)this.baseWindow.getWidth() * 100.0, (dArray[1] + floatMainWindow.getTryOrigoY()) / (double)this.baseWindow.getHeight() * 100.0);
    }

    public void setPosition(Double d, Double d2) {
        if (this.baseWindow.getWidth() <= 1 || this.baseWindow.getHeight() <= 1) {
            this.baseWindow.setSize(600, 600);
        }
        double d3 = d / 100.0;
        double d4 = d2 / 100.0;
        double d5 = this.baseWindow.getWidth();
        double d6 = this.baseWindow.getHeight();
        double d7 = (d5 * d3 - this.getTryWidth() * d3) / d5;
        double d8 = (d6 * d4 - this.getTryHeight() * d4) / d6;
        this.setRelativePosition(d7, d8);
    }

    public void setProtected(boolean bl) {
        this.isprotected = bl;
    }

    @Override
    public void setRelativePosition(double d, double d2) {
        this.relativeX = d;
        this.relativeY = d2;
        this.setActualPosition();
    }

    @Override
    public void setRelativeSize(double d, double d2) {
        this.relativeWidth = d;
        this.relativeHeight = d2;
        this.setActualSize();
    }

    public void setRenderingHighQuality(boolean bl) {
        this.baseWindow.setValueRenderingQuality(bl);
    }

    @Override
    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void setSelectionColor(String string, Properties properties) {
        if (properties != null && ScriptHelper.hasKey(properties, "highcontrast")) {
            this.highSelectionContrast = ScriptHelper.getPropertyBool(properties, "highcontrast");
        }
    }

    @Override
    public void setShapeType(byte by) {
        this.shapeType = by;
    }

    @Override
    public void setTextAlignment(byte by) {
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    @Override
    public void setTreeParent(DataTreeInterface dataTreeInterface) {
        this.nodeParent = dataTreeInterface;
        if (dataTreeInterface != null && dataTreeInterface.getDataTreeManager() != null) {
            this.dataTreeManager = dataTreeInterface.getDataTreeManager();
            if (this.windowID == null) {
                this.windowID = this.dataTreeManager.addUniqueID(null, this);
            }
            int n = this.getTreeNodeCount();
            for (int i = 0; i < n; ++i) {
                this.getTreeNodeAt(i).setTreeParent(this);
            }
        }
    }

    @Override
    public void setWindowLayout(int n) {
        this.windowlayout = n;
    }

    @Override
    public void setWindowLocation(double d, double d2) {
        if (this.baseWindow != null) {
            this.relativeX = d / (double)this.baseWindow.getWidth();
            this.relativeY = d2 / (double)this.baseWindow.getHeight();
        }
        this.setActualPosition(d, d2);
    }

    @Override
    public void setWindowSize(double d, double d2) {
        if (d <= 1.0) {
            d = 1.0;
        }
        if (d2 <= 1.0) {
            d2 = 1.0;
        }
        if (this.baseWindow != null) {
            this.relativeWidth = d / (double)this.baseWindow.getWidth();
            this.relativeHeight = d2 / (double)this.baseWindow.getHeight();
        }
        this.setActualSize(d, d2);
    }

    public void showProperties() {
    }

    @Override
    public void startFloated(Graphics2D graphics2D, Color color) {
        graphics2D.setXORMode(color);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(rubberStroke);
    }

    @Override
    public void swapNodes(int n, int n2) {
        DataTreeInterface dataTreeInterface = this.treeVector.get(n);
        this.treeVector.set(n, this.treeVector.get(n2));
        this.treeVector.set(n2, dataTreeInterface);
    }

    @Override
    public boolean tryMove(int n, int n2) {
        this.tempOrigoX = this.lastOrigoX + (double)n;
        this.tempOrigoY = this.lastOrigoY + (double)n2;
        if (this.tempOrigoX < 0.0) {
            this.tempOrigoX = 0.0;
        }
        if (this.tempOrigoY < 0.0) {
            this.tempOrigoY = 0.0;
        }
        if (this.baseWindow != null) {
            if (this.tempOrigoX + this.lastWidth > (double)this.baseWindow.getWidth()) {
                this.tempOrigoX = (double)this.baseWindow.getWidth() - this.lastWidth - 1.0;
            }
            if (this.tempOrigoY + this.lastHeight > (double)this.baseWindow.getHeight()) {
                this.tempOrigoY = (double)this.baseWindow.getHeight() - this.lastHeight - 1.0;
            }
        }
        return (int)this.tempOrigoX != (int)this.lastOrigoX || (int)this.tempOrigoY != (int)this.lastOrigoY;
    }

    @Override
    public boolean tryResize(int n, double d, double d2) {
        if (n > 7) {
            return this.zoneLayout.tryResize(n, d, d2);
        }
        this.tempOrigoX = this.lastOrigoX;
        this.tempOrigoY = this.lastOrigoY;
        this.tempWidth = this.lastWidth;
        this.tempHeight = this.lastHeight;
        if (n < 3) {
            if (this.lastOrigoY + d2 < 0.0) {
                d2 = -this.lastOrigoY;
            }
            this.tempOrigoY += d2;
            this.tempHeight -= d2;
        }
        if (n > 4) {
            if (this.baseWindow != null && this.lastOrigoY + this.lastHeight + d2 > (double)this.baseWindow.getHeight()) {
                d2 = (double)this.baseWindow.getHeight() - this.lastHeight - this.lastOrigoY - 1.0;
            }
            this.tempHeight += d2;
        }
        if (n == 0 || n == 3 || n == 5) {
            if (this.lastOrigoX + d < 0.0) {
                d = -this.lastOrigoX;
            }
            this.tempOrigoX += d;
            this.tempWidth -= d;
        }
        if (n == 2 || n == 4 || n == 7) {
            if (this.baseWindow != null && this.lastOrigoX + this.lastWidth + d > (double)this.baseWindow.getWidth()) {
                d = (double)this.baseWindow.getWidth() - this.lastWidth - this.lastOrigoX - 1.0;
            }
            this.tempWidth += d;
        }
        return (int)this.tempOrigoX != (int)this.lastOrigoX || (int)this.tempOrigoY != (int)this.lastOrigoY || (int)this.tempWidth != (int)this.lastWidth || (int)this.tempHeight != (int)this.lastHeight;
    }

    @Override
    public void virtualResize(double d, double d2) {
        this.isvirtualresize = true;
        this.relativeX *= d;
        this.relativeY *= d2;
        this.relativeWidth *= d;
        this.relativeHeight *= d2;
        this.setActualSize();
        this.setActualPosition();
        this.resizeLayout(false);
        this.isvirtualresize = false;
    }

    @Override
    protected void cleanUpChild() {
        this.created = false;
        while (!this.treeVector.isEmpty()) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(0);
            if ((this.dataTreeManager == null || this.dataTreeManager.hasDataMask(dataTreeInterface)) && !dataTreeInterface.cleanUp()) continue;
            this.treeVector.removeElementAt(0);
        }
        this.treeVector = null;
        if (this.dataTreeManager != null && this.windowID != null) {
            this.dataTreeManager.removeUniqueID(this.windowID);
            this.dataTreeManager = null;
        }
        this.windowID = null;
        if (this.nodeParent != null) {
            this.nodeParent.removeTreeNode(this);
            this.nodeParent = null;
        }
        this.zoneLayout = null;
        this.baseWindow = null;
        this.backgroundGradient = null;
        this.browserElement = null;
        this.redirectPanel = null;
        this.baseImage = null;
        this.selectionImage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void contentPaint(BufferedImage bufferedImage, byte by, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        try {
            graphics2D.setBackground(transparentColor);
            if (bl || this.shapeType != 1) {
                graphics2D.clearRect(0, 0, (int)this.getTryWidth(), (int)this.getTryHeight());
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.baseWindow.getAntiAliasHint());
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, this.baseWindow.getRenderingQualityHint());
            if (!bl) {
                this.drawShape(graphics2D, true);
            }
            double d = this.getRelative();
            this.preparePaint(graphics2D, d);
            if (this.zoneLayout != null) {
                this.zoneLayout.paint(graphics2D, by, d);
            }
            if (this.borderColor != null && (by & 1) == 1) {
                this.drawShape(graphics2D, false);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            Logg.error("Paint error", concurrentModificationException);
        }
        finally {
            graphics2D.dispose();
        }
    }

    protected boolean enableHighContrast() {
        return this.highSelectionContrast;
    }

    protected float getBlackBorderSize() {
        return this.getWhiteBorderSize() / 2.0f;
    }

    protected float getWhiteBorderSize() {
        return 2.0f;
    }

    protected boolean hasBaseContent(byte by) {
        return (by & 1) != 0;
    }

    protected boolean hasInteractionContent() {
        return false;
    }

    protected boolean hasSelectionContent(byte by) {
        return (by & 2) != 0;
    }

    protected boolean isLayoutEnable() {
        if (this.baseWindow != null) {
            return this.baseWindow.isLayoutEnable();
        }
        return false;
    }

    protected void markSelectionObjects(Graphics2D graphics2D) {
        this.markSelectionObjects(graphics2D, this.selectionImage, null);
    }

    protected void markSelectionObjects(Graphics2D graphics2D, BufferedImage bufferedImage, Color color) {
        if (bufferedImage != null) {
            int n;
            int n2;
            WritableRaster writableRaster = bufferedImage.getRaster();
            int n3 = bufferedImage.getWidth();
            int n4 = bufferedImage.getHeight();
            boolean[][] blArray = new boolean[n3][n4];
            ArrayList<GeneralPath> arrayList = new ArrayList<GeneralPath>();
            int[] nArray = new int[4];
            for (n2 = 0; n2 < n4; ++n2) {
                for (n = 0; n < n3; ++n) {
                    if (blArray[n][n2] || !(this.min(writableRaster, n, n2, 0, 0, n3, n4, nArray) > 0.0)) continue;
                    GeneralPath generalPath = this.followBorder(writableRaster, n, n2, 0, 0, n3, n4, 0);
                    if (generalPath != null) {
                        arrayList.add(generalPath);
                    }
                    this.coverArea(writableRaster, blArray, n, n2, 0, 0, n3, n4, true, color);
                    if (generalPath == null) continue;
                    Rectangle rectangle = generalPath.getBounds();
                    int n5 = rectangle.x + rectangle.width + 1;
                    int n6 = rectangle.y + rectangle.height + 1;
                    for (int i = n6 - 1; i >= rectangle.y; --i) {
                        for (int j = rectangle.x; j < n5; ++j) {
                            GeneralPath generalPath2;
                            if (blArray[j][i] || this.min(writableRaster, j, i, rectangle.x, rectangle.y, n5, n6, nArray) != 0.0 || this.coverArea(writableRaster, blArray, j, i, rectangle.x, rectangle.y, n5, n6, false, null) || (generalPath2 = this.followBorder(writableRaster, j - 1, i, rectangle.x, rectangle.y, n5, n6, 2)) == null) continue;
                            arrayList.add(generalPath2);
                        }
                    }
                }
            }
            if (this.getWhiteBorderSize() > 0.0f) {
                graphics2D.setColor(Color.white);
                graphics2D.setStroke(new BasicStroke(this.getWhiteBorderSize(), 0, 0, 10.0f));
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    graphics2D.draw((Shape)iterator.next());
                }
            }
            if (this.getBlackBorderSize() > 0.0f) {
                graphics2D.setColor(Color.black);
                graphics2D.setStroke(new BasicStroke(this.getBlackBorderSize(), 0, 0, 10.0f));
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    graphics2D.draw((Shape)iterator.next());
                }
            }
            if (this.enableHighContrast()) {
                for (n2 = 0; n2 < n4; ++n2) {
                    for (n = 0; n < n3; ++n) {
                        if (writableRaster.getSample(n, n2, 3) != 0) continue;
                        writableRaster.setSample(n, n2, 0, 255);
                        writableRaster.setSample(n, n2, 1, 255);
                        writableRaster.setSample(n, n2, 2, 255);
                        writableRaster.setSample(n, n2, 3, 220);
                    }
                }
            }
            graphics2D.setColor(Color.black);
        }
    }

    protected void markSelectionObjects(Graphics2D graphics2D, Color color) {
        this.markSelectionObjects(graphics2D, this.selectionImage, color);
    }

    protected void paintSelected(Graphics2D graphics2D) {
        graphics2D.setColor(Color.black);
        double d = this.getTryOrigoX();
        double d2 = this.getTryOrigoY();
        double d3 = this.getTryWidth();
        double d4 = this.getTryHeight();
        graphics2D.drawRect((int)d, (int)d2, (int)d3, (int)d4);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (j == 1 && i == 1) continue;
                int n = (int)(d + d3 * 0.5 * (double)j);
                int n2 = (int)(d2 + d4 * 0.5 * (double)i);
                this.paintSelectionBox(graphics2D, n, n2);
            }
        }
        this.zoneLayout.paintSelected(graphics2D);
    }

    protected void preparePaint(Graphics2D graphics2D, double d) {
    }

    protected boolean resizeLayout(boolean bl) {
        if (this.zoneLayout != null) {
            return this.zoneLayout.resize();
        }
        return false;
    }

    protected void setAlphaOnSelection(Color color, int n) {
        WritableRaster writableRaster = this.selectionImage.getRaster();
        int n2 = this.selectionImage.getWidth();
        int n3 = this.selectionImage.getHeight();
        int n4 = color.getRed();
        int n5 = color.getGreen();
        int n6 = color.getBlue();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n7 = writableRaster.getSample(j, i, 0);
                int n8 = writableRaster.getSample(j, i, 1);
                int n9 = writableRaster.getSample(j, i, 2);
                int n10 = writableRaster.getSample(j, i, 3);
                if (n7 != n4 || n8 != n5 || n9 != n6 || n10 <= 0) continue;
                writableRaster.setSample(j, i, 3, n);
            }
        }
    }

    protected void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        this.componentResized(1.0, 1.0, true, true);
    }

    private boolean coverArea(WritableRaster writableRaster, boolean[][] blArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, Color color) {
        LinkedList<Point> linkedList = new LinkedList<Point>();
        linkedList.add(new Point(n, n2));
        int n7 = bl ? 1 : 2;
        boolean bl2 = false;
        int[] nArray = new int[4];
        while (!linkedList.isEmpty()) {
            Point point = (Point)linkedList.remove(0);
            if (blArray[point.x][point.y]) continue;
            blArray[point.x][point.y] = true;
            for (int i = 0; i < this.cursor_maximum.length; i += n7) {
                int n8 = point.x + this.cursor_maximum[i][0];
                int n9 = point.y + this.cursor_maximum[i][1];
                double d = this.min(writableRaster, n8, n9, n3, n4, n5, n6, nArray);
                if (d < 0.0) {
                    bl2 = true;
                }
                if (!(bl && d > 0.0) && (bl || d != 0.0) || blArray[n8][n9]) continue;
                if (color != null) {
                    writableRaster.setSample(n8, n9, 3, color.getAlpha());
                }
                linkedList.add(new Point(n8, n9));
            }
        }
        return bl2;
    }

    private void drawShape(Graphics2D graphics2D, boolean bl) {
        if (bl) {
            if (this.backgroundGradient != null) {
                graphics2D.setPaint(this.backgroundGradient);
            } else {
                graphics2D.setColor(this.getBackground());
            }
        } else {
            graphics2D.setColor(this.borderColor);
        }
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(this.borderStroke);
        int n = (int)this.getTryWidth();
        int n2 = (int)this.getTryHeight();
        switch (this.shapeType) {
            case 1: {
                if (bl) {
                    graphics2D.fillRect(0, 0, n, n2);
                    break;
                }
                graphics2D.drawRect(0, 0, n - 1, n2 - 1);
                break;
            }
            case 2: {
                if (bl) {
                    graphics2D.fillOval(0, 0, n - 1, n2 - 1);
                    break;
                }
                graphics2D.drawOval(0, 0, n - 1, n2 - 1);
                break;
            }
            case 3: {
                graphics2D.drawLine(0, 0, n - 1, n2 - 1);
                break;
            }
            case 4: {
                graphics2D.drawLine(0, n2 - 1, n - 1, 0);
            }
        }
        graphics2D.setStroke(stroke);
    }

    private GeneralPath followBorder(WritableRaster writableRaster, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        GeneralPath generalPath = new GeneralPath();
        boolean bl = false;
        int n8 = n;
        int n9 = n2;
        generalPath.moveTo(n8, n9);
        int n10 = 0;
        int n11 = Math.min(10000, (n5 - n3) * (n6 - n4));
        int n12 = -1;
        int[] nArray = new int[4];
        while (!bl) {
            boolean bl2 = false;
            for (int i = 0; i < this.cursor_maximum.length; ++i) {
                int n13;
                int[] nArray2 = this.getDirection(n7, i);
                int n14 = n8 + nArray2[0];
                if (!(this.min(writableRaster, n14, n13 = n9 + nArray2[1], n3, n4, n5, n6, nArray) > 0.0) && i != this.cursor_maximum.length - 1) continue;
                if ((n7 = n7 + i - 2) < 0) {
                    n7 += this.cursor_maximum.length;
                } else if (n7 >= this.cursor_maximum.length) {
                    n7 -= this.cursor_maximum.length;
                }
                bl2 = true;
                ++n10;
                if (n14 == n && n13 == n2) {
                    generalPath.closePath();
                    bl = true;
                    break;
                }
                if (n12 != n7) {
                    generalPath.lineTo(n8, n9);
                    n12 = n7;
                }
                n8 = n14;
                n9 = n13;
                break;
            }
            if (bl2 && n10 <= n11) continue;
            return null;
        }
        return generalPath;
    }

    private int[] getDirection(int n, int n2) {
        int n3 = n + n2 - 2;
        if (n3 < 0) {
            n3 += this.cursor_maximum.length;
        } else if (n3 >= this.cursor_maximum.length) {
            n3 -= this.cursor_maximum.length;
        }
        return this.cursor_maximum[n3];
    }

    private void init() {
        this.setVisible(false);
        this.setLayout(new ZoneRelativeLayout());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.boxHalfSize = 3;
        this.boxSize = this.boxHalfSize * 2 + 1;
    }

    private MouseEvent invokeEvent(MouseEvent mouseEvent, boolean bl) {
        Point point = mouseEvent.getPoint();
        if (bl) {
            return new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), (int)((double)point.x + this.lastOrigoX), (int)((double)point.y + this.lastOrigoY), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
        }
        return new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), (int)((double)point.x + this.getTryOrigoX()), (int)((double)point.y + this.getTryOrigoY()), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
    }

    private final boolean isUpdating() {
        return this.updating > 0;
    }

    private double min(WritableRaster writableRaster, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n >= n3 && n2 >= n4 && n < n5 && n2 < n6) {
            writableRaster.getPixel(n, n2, nArray);
            if (nArray[3] > 0 && (nArray[0] < 255 || nArray[1] < 255 || nArray[2] < 255)) {
                return 1.0;
            }
            return 0.0;
        }
        return -1.0;
    }

    private void setActualPosition() {
        this.setActualPosition(this.getTryOrigoX(), this.getTryOrigoY());
    }

    private void setActualPosition(double d, double d2) {
        this.tempOrigoX = this.lastOrigoX = d;
        this.tempOrigoY = this.lastOrigoY = d2;
        if (super.getX() != (int)d || super.getY() != (int)d2) {
            super.setLocation((int)d, (int)d2);
            if (this.redirectPanel == null) {
                this.resizeLayout(false);
            }
        }
    }

    private void setActualSize() {
        this.setActualSize(this.getTryWidth(), this.getTryHeight());
    }

    private void setActualSize(double d, double d2) {
        this.tempWidth = this.lastWidth = d;
        this.tempHeight = this.lastHeight = d2;
        boolean bl = false;
        if (this.redirectPanel == null && !this.isvirtualresize) {
            int n = (int)this.getTryWidth();
            int n2 = (int)this.getTryHeight();
            if (this.baseImage == null || this.baseImage.getWidth() != n || this.baseImage.getHeight() != n2) {
                this.baseImage = new BufferedImage(n, n2, 2);
                if (this.hasselections) {
                    this.selectionImage = new BufferedImage(n, n2, 2);
                }
                bl = true;
            }
        }
        if (super.getWidth() != (int)d || super.getHeight() != (int)d2) {
            super.setSize((int)d, (int)d2);
            if (this.redirectPanel == null) {
                bl = true;
            } else {
                this.redirectPanel.setSize((int)d, (int)d2);
            }
        }
        if (bl && !this.isvirtualresize) {
            this.resizeLayout(true);
            this.contentPaint((byte)7);
        }
    }

    private void temporaryToRelative() {
        if (this.baseWindow != null && this.tempWidth > 0.0 && this.tempHeight > 0.0 && this.baseWindow.getWidth() > 0 && this.baseWindow.getHeight() > 0) {
            this.relativeX = this.tempOrigoX / (double)this.baseWindow.getWidth();
            this.relativeY = this.tempOrigoY / (double)this.baseWindow.getHeight();
            this.relativeWidth = this.tempWidth / (double)this.baseWindow.getWidth();
            this.relativeHeight = this.tempHeight / (double)this.baseWindow.getHeight();
        }
        this.setActualPosition();
        this.setActualSize();
    }
}

