/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.color.ContinuousColorInterface;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.common.resource.ResourceNode;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.main.window.AbstractWindowProperties;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.TickInfo;
import se.prediktera.map.plot.axisplot.ZoneArray;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.PlotImages;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.Shape.ShapeRenderingBox;
import se.prediktera.map.plot.axisplot.windows.FloatWindow;
import se.prediktera.map.plot.axisplot.windows.LegendHolderInterface;
import se.prediktera.map.plot.axisplot.windows.LegendInterface;
import se.prediktera.map.plot.axisplot.windows.PlotZone;
import se.prediktera.map.plot.axisplot.windows.PlotZoneText;
import se.prediktera.map.plot.layout.AbstractPlotLayout;
import se.prediktera.map.plot.layout.LayoutException;

public class LegendWindow
extends FloatWindow
implements InteractionInterface {
    public double syPercent = 0.2;
    public double shPercent = 0.7;
    public static final byte COLOR = 0;
    public static final byte SHAPE = 1;
    public static final byte LAYER = 2;
    private final PlotZoneText title = new PlotZoneText(null, 1.0, 0.2, false);
    private final ArrayList<Item> items = new ArrayList();
    private boolean continues = true;
    private ContinuousColorInterface continuesColor = null;
    private double cmin;
    private double cmax;
    private LegendInterface legendInterface;
    private String adescr = "descr";
    private final ActionClass actionClass = new ActionClass();
    private boolean autoText = true;
    private boolean sort = true;
    private int startpos = 0;
    private int digits = 4;
    private boolean percent = false;
    private boolean round = false;
    private InnerColumnClass classColumn = null;
    private Item interactionItem = null;
    private String description = null;
    private byte priority = 0;
    private boolean ctrldown = false;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        AbstractPlotLayout abstractPlotLayout = new AbstractPlotLayout((Plot_GUI)null, null){

            @Override
            public byte getTreeType() {
                return 0;
            }

            @Override
            protected AbstractWindowProperties createProperties() {
                return null;
            }

            @Override
            protected String getDefaultTitle() {
                return null;
            }
        };
        LegendWindow legendWindow = new LegendWindow(abstractPlotLayout);
        final LegendHolderInterface legendHolderInterface = by -> null;
        LegendInterface legendInterface = new LegendInterface(){
            private final ShapeRenderingBox boxShapeFixed = new ShapeRenderingBox(null);

            @Override
            public void collectLegendValues(LegendWindow legendWindow) {
                legendWindow.setTitle(this.getLegendType());
                for (int i = 0; i < this.boxShapeFixed.getItemCount(); ++i) {
                    legendWindow.addItem(this.boxShapeFixed.getShape(i), "Value " + i);
                }
            }

            @Override
            public AbstractAxisLayer getLayer() {
                return null;
            }

            @Override
            public LegendHolderInterface getLegendHolder() {
                return legendHolderInterface;
            }

            @Override
            public String getLegendType() {
                return "Test";
            }
        };
        legendWindow.setDescr("Test av legend");
        legendWindow.setLegendInterface(legendInterface);
        legendWindow.setFloatWindowCreated(null, false);
        legendWindow.endUpdate((byte)7);
        try {
            abstractPlotLayout.addWindow(legendWindow, 0, 4);
        }
        catch (LayoutException layoutException) {
            ErrorHandler.logAndReportException(layoutException);
        }
        jFrame.getContentPane().add((Component)abstractPlotLayout, "Center");
        JButton jButton = new JButton();
        jButton.setPreferredSize(new Dimension(0, 30));
        jButton.addActionListener(actionEvent -> abstractPlotLayout.updateLegends());
        jFrame.getContentPane().add((Component)jButton, "South");
        jFrame.setSize(200, 350);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public LegendWindow(AbstractPlotLayout abstractPlotLayout) {
        this(abstractPlotLayout, new Point(0, 0));
    }

    public LegendWindow(AbstractPlotLayout abstractPlotLayout, Point point) {
        super(false, 0.0, 0.0, 0.15, 0.3, false);
        this.title.setTextNoResize("Legend");
        this.init();
        this.baseWindow = abstractPlotLayout;
        this.setBorderColor(abstractPlotLayout.getForeground());
        this.setWindowLocation(point.x, point.y);
    }

    public LegendWindow(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        Object object;
        this.legendInterface = (LegendInterface)((Object)mapProperty.resolveNodeFromName(randomInputStream, "legendI"));
        if (this.legendInterface == null && (object = (LegendHolderInterface)((Object)mapProperty.resolveNodeFromName(randomInputStream, "legendH"))) != null && mapProperty.hasProperty("comboBox")) {
            this.legendInterface = object.getComboBoxLegend((byte)3);
        }
        if ((object = mapProperty.getPropertyStringUTF("title")) != null) {
            this.title.setTextNoResize((String)object);
            this.autoText = mapProperty.getPropertyBoolean("auto", true);
        }
        this.sort = mapProperty.getPropertyBoolean("sort", true);
        this.startpos = mapProperty.getPropertyInt("sp", 0);
        this.digits = mapProperty.getPropertyInt("digits", 4);
        this.round = mapProperty.getPropertyBoolean("round", false);
        this.percent = mapProperty.getPropertyBoolean("percent", false);
        this.description = mapProperty.getPropertyStringUTF("descr", null);
        this.priority = mapProperty.getPropertyByte("priority", (byte)0);
        this.init();
        this.title.setBorderColor(this.getBorderColor());
    }

    public void addItem(ZoneLeaf zoneLeaf, String string) {
        this.continues = false;
        this.items.add(new Item(zoneLeaf, string));
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        if (this.baseWindow != null) {
            JMenuItem jMenuItem;
            JPopupMenu jPopupMenu2 = this.collectLegendInterface();
            CMenu cMenu = new CMenu("Legend", true);
            for (int i = jPopupMenu2.getComponentCount() - 1; i >= 0; --i) {
                jMenuItem = (CMenuItem)jPopupMenu2.getComponent(i);
                jMenuItem.addActionListener(this.actionClass);
                cMenu.add((Component)jMenuItem, 0);
            }
            jPopupMenu.add(cMenu);
            CMenu cMenu2 = new CMenu("Label Priority", true);
            jMenuItem = new JRadioButtonMenuItem("Color");
            jMenuItem.setSelected(this.priority == 0);
            jMenuItem.addActionListener(actionEvent -> {
                this.priority = 0;
                this.contentPaint((byte)7);
            });
            cMenu2.add(jMenuItem);
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Shape");
            jRadioButtonMenuItem.setSelected(this.priority == 1);
            jRadioButtonMenuItem.addActionListener(actionEvent -> {
                this.priority = 1;
                this.contentPaint((byte)7);
            });
            cMenu2.add(jRadioButtonMenuItem);
            JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("Layer");
            jRadioButtonMenuItem2.setSelected(this.priority == 2);
            jRadioButtonMenuItem2.addActionListener(actionEvent -> {
                this.priority = (byte)2;
                this.contentPaint((byte)7);
            });
            cMenu2.add(jRadioButtonMenuItem2);
            jPopupMenu.add(cMenu2);
        }
        return true;
    }

    public void collectValues() {
        this.continues = false;
        this.items.clear();
        if (this.legendInterface != null) {
            this.legendInterface.collectLegendValues(this);
        }
    }

    @Override
    public boolean doInteraction(InteractionInterface interactionInterface) {
        return false;
    }

    @Override
    public void doQuickInteraction(InteractionInterface interactionInterface, int n, int n2, int n3, int n4) {
    }

    @Override
    public void finishInteraction() {
    }

    @Override
    public String getFloatText() {
        return this.title.toString();
    }

    public LegendInterface getLegendInterface() {
        return this.legendInterface;
    }

    public byte getPriority() {
        return this.priority;
    }

    @Override
    public byte getTreeType() {
        return 1;
    }

    @Override
    public boolean hasAutoText() {
        return this.autoText;
    }

    public boolean isSort() {
        return this.sort;
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.title != null) {
            this.title.setFontColor(color);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (!this.continues && this.classColumn != null && this.items != null) {
            this.interactionItem = this.getItemFromPoint(mouseEvent.getPoint());
            if (this.interactionItem != null) {
                this.ctrldown = mouseEvent.isControlDown();
                Project_GUI project_GUI = this.getParentBaseWindow().getProject_GUI();
                project_GUI.doInteraction(this);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
        if (!this.continues && this.classColumn != null && this.items != null) {
            Item item = this.getItemFromPoint(mouseEvent.getPoint());
            if (item != null) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void prepareInteraction() {
        AbstractDataInfo abstractDataInfo = this.classColumn.getDataInfo();
        if (abstractDataInfo != null) {
            int n = abstractDataInfo instanceof ObservationInfo ? 1 : 2;
            AbstractPlotLayout abstractPlotLayout = this.getParentBaseWindow();
            Project_GUI project_GUI = abstractPlotLayout.getProject_GUI();
            AbstractAxisLayer abstractAxisLayer = this.legendInterface.getLayer();
            InteractionArray interactionArray = null;
            interactionArray = this.ctrldown ? project_GUI.getInteractionArray(n, abstractDataInfo.getGroupID()) : project_GUI.getInteractionArray(abstractDataInfo.getCase(), n, this.classColumn.getSize(), abstractDataInfo.getGroupID());
            ClassTypes classTypes = this.classColumn.getObject();
            short s = classTypes.getTypeDescriptionIndex(this.interactionItem.text);
            if (s < 0 && this.interactionItem.text.equals("No class")) {
                s = 0;
            }
            List<ZoneLeaf> list = abstractAxisLayer.getRootList();
            for (int i = 0; i < list.size(); ++i) {
                int n2;
                ZoneLeaf zoneLeaf = list.get(i);
                if (!zoneLeaf.isVisible()) continue;
                if (zoneLeaf instanceof ZoneArray) {
                    ZoneArray zoneArray = (ZoneArray)zoneLeaf;
                    n2 = zoneArray.getSecondaryIndex();
                    if (abstractAxisLayer.isFoldMatrix()) {
                        int n3 = abstractAxisLayer.getFoldN();
                        for (int j = 0; j < zoneArray.getNoChildren(); ++j) {
                            int n4;
                            int n5;
                            if (!zoneArray.isVisible(j) || zoneArray.isMissing(j) || this.classColumn.getValueShort(n5 = (n4 = zoneArray.getPrimaryIndex(j)) * n3 + n2) != s) continue;
                            interactionArray.set(n5);
                        }
                        continue;
                    }
                    if (this.classColumn.getValueShort(n2) != s) continue;
                    interactionArray.set(n2);
                    continue;
                }
                n2 = zoneLeaf.getPrimaryIndex();
                if (this.classColumn.getValueShort(n2) != s) continue;
                interactionArray.set(n2);
            }
        }
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        LegendHolderInterface legendHolderInterface;
        super.SaveProperty(randomOutputStream);
        if (this.legendInterface instanceof DataTreeInterface) {
            randomOutputStream.writePropertyNode("legendI", (DataTreeInterface)((Object)this.legendInterface));
        } else if (this.legendInterface instanceof AbstractPlotSettingsBox && (legendHolderInterface = this.legendInterface.getLegendHolder()) != null) {
            randomOutputStream.writePropertyNode("legendH", (DataTreeInterface)((Object)legendHolderInterface));
            AbstractPlotSettingsBox abstractPlotSettingsBox = (AbstractPlotSettingsBox)((Object)this.legendInterface);
            randomOutputStream.writePropertyByte("comboBox", abstractPlotSettingsBox.getType());
        }
        randomOutputStream.writePropertyBoolean("auto", this.autoText);
        randomOutputStream.writePropertyStringUTF("title", this.title.toString());
        randomOutputStream.writePropertyBoolean("sort", this.sort);
        randomOutputStream.writePropertyInt("sp", this.startpos);
        randomOutputStream.writePropertyInt("digits", this.digits);
        randomOutputStream.writePropertyBoolean("round", this.round);
        randomOutputStream.writePropertyBoolean("percent", this.percent);
        randomOutputStream.writePropertyStringUTF("descr", this.description);
        randomOutputStream.writePropertyByte("priority", this.priority);
    }

    @Override
    public byte SendGlobalMessage(byte by, byte by2) {
        if (by == 5) {
            this.contentPaint((byte)7);
            return 1;
        }
        return super.SendGlobalMessage(by, by2);
    }

    @Override
    public void setAutoText(boolean bl) {
        this.autoText = bl;
    }

    @Override
    public void setBorderColor(Color color) {
        super.setBorderColor(color);
        this.title.setBorderColor(color);
    }

    public void setClassColumn(InnerColumnClass innerColumnClass) {
        this.classColumn = innerColumnClass;
    }

    public void setContinuesColor(ContinuousColorInterface continuousColorInterface, double d, double d2) {
        this.continues = true;
        this.continuesColor = continuousColorInterface;
        this.cmin = d;
        this.cmax = d2;
    }

    public void setDescr(String string) {
        this.adescr = string;
    }

    @Override
    public void setFloatText(String string, boolean bl) {
        this.title.setTextNoResize(string);
    }

    @Override
    public void setInteractionFlag(byte by) {
    }

    public void setLegendInterface(LegendInterface legendInterface) {
        this.legendInterface = legendInterface;
        this.collectValues();
        this.contentPaint((byte)7);
    }

    public void setPriority(byte by) {
        this.priority = by;
    }

    public void setProperties(Properties properties) {
        if (ScriptHelper.hasKey(properties, "title")) {
            this.setTitleNoAutoText(ScriptHelper.getProperty(properties, "title"));
        }
        if (ScriptHelper.hasKey(properties, "textbegin")) {
            this.startpos = ScriptHelper.getPropertyInt(properties, "textbegin");
        }
        if (ScriptHelper.hasKey(properties, "digits")) {
            this.digits = ScriptHelper.getPropertyInt(properties, "digits");
        }
        if (ScriptHelper.hasKey(properties, "round")) {
            this.round = ScriptHelper.getPropertyBool(properties, "round");
        }
        if (ScriptHelper.hasKey(properties, "percent")) {
            this.percent = ScriptHelper.getPropertyBool(properties, "percent");
        }
        if (ScriptHelper.hasKey(properties, "description")) {
            this.description = ScriptHelper.getProperty(properties, "description");
        }
    }

    public void setTitleNoAutoText(String string) {
        this.title.setTextNoResize(string);
        this.autoText = false;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setSort(boolean bl) {
        this.sort = bl;
    }

    public void setTitle(String string) {
        if (this.autoText) {
            this.title.setTextNoResize(string);
        }
    }

    @Override
    public String toString() {
        return "Legend";
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.legendInterface = null;
    }

    private JPopupMenu collectLegendInterface() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.baseWindow != null && this.baseWindow.getMainWindow() != null) {
            this.baseWindow.getMainWindow().collectLegendInterface(jPopupMenu);
        }
        return jPopupMenu;
    }

    private Item getItemFromPoint(Point point) {
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            Item item = this.items.get(i);
            Point point2 = item.point;
            int n2 = item.size / 2 + 1;
            if (item.point == null || point.x < point2.x - n2 || point.x >= point2.x + n2 || point.y < point2.y - n2 || point.y >= point2.y + n2) continue;
            return item;
        }
        return null;
    }

    private void init() {
        this.title.setPadding(0.1);
        this.setProtected(false);
        this.addPlotZone(this.title, 0);
        this.addPlotZone(new LegendCenter(), 4);
    }

    class ActionClass
    implements ActionListener {
        ActionClass() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CMenuItem cMenuItem;
            Object object = actionEvent.getSource();
            if (object instanceof CMenuItem && (cMenuItem = (CMenuItem)object).getObject() instanceof LegendInterface) {
                LegendWindow.this.setLegendInterface((LegendInterface)cMenuItem.getObject());
                LegendWindow.this.contentPaint((byte)1);
            }
        }
    }

    private static class Item {
        private final ZoneLeaf zoneLeaf;
        private final String text;
        private Point point;
        private int size;

        public Item(ZoneLeaf zoneLeaf, String string) {
            this.zoneLeaf = zoneLeaf;
            this.text = string;
        }

        public void setPoint(Point point) {
            this.point = point;
        }

        public void setSize(int n) {
            this.size = n;
        }
    }

    protected class LegendCenter
    extends PlotZone {
        public LegendCenter() {
            super(Color.white, 1.0, 0.9, (byte)1);
        }

        @Override
        public void paint(Graphics2D graphics2D, byte by, double d) {
            if (LegendWindow.this.legendInterface != null) {
                LegendWindow.this.collectValues();
                graphics2D.setFont(new Font("SansSerif", 1, (int)(30.0 * d)));
                if (LegendWindow.this.continues && LegendWindow.this.continuesColor != null) {
                    this.paintContinuous(graphics2D, d);
                } else if (LegendWindow.this.items != null) {
                    this.paintItems(graphics2D, d);
                }
            }
        }

        public void paintContinuous(Graphics2D graphics2D, double d) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(this.origoX, this.origoY);
            int n = (int)((double)this.width * 0.5);
            int n2 = (int)((double)this.height * LegendWindow.this.syPercent);
            int n3 = (int)((double)this.width * 0.4);
            int n4 = (int)((double)this.height * LegendWindow.this.shPercent);
            int n5 = LegendWindow.this.continuesColor.getNrColors();
            double d2 = (double)n4 / (double)n5;
            for (int i = 0; i < n5; ++i) {
                int n6 = n2 + (int)(d2 * (double)(n5 - i - 1));
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(n, n6, n3, (int)Math.ceil(d2));
                graphics2D.setColor(LegendWindow.this.continuesColor.getColor(i));
                graphics2D.fillRect(n, n6, n3, (int)Math.ceil(d2));
            }
            AxisRange axisRange = new AxisRange(LegendWindow.this.cmin, LegendWindow.this.cmax);
            axisRange.setAxisTicks(n4, 35, LegendWindow.this.digits, LegendWindow.this.percent, true);
            List<TickInfo> list = axisRange.getTickList();
            graphics2D.setColor(LegendWindow.this.getForeground());
            graphics2D.setFont(new Font("SansSerif", 0, (int)(30.0 * d)));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            for (TickInfo tickInfo : list) {
                double d3 = tickInfo.pos;
                int n7 = (int)((double)n4 - (d3 - LegendWindow.this.cmin) / (LegendWindow.this.cmax - LegendWindow.this.cmin) * (double)n4) + n2;
                graphics2D.drawLine(n - (int)((double)this.width * 0.05), n7, n + n3, n7);
                String string = tickInfo.text;
                double d4 = fontMetrics.stringWidth(string);
                int n8 = fontMetrics.getHeight();
                graphics2D.drawString(string, n - (int)((double)this.width * 0.1 + d4), n7 + n8 / 3);
            }
            String string = LegendWindow.this.description != null ? LegendWindow.this.description : LegendWindow.this.adescr;
            graphics2D.drawString(string, (int)((double)this.width * 0.1), n2 / 2 + fontMetrics.getHeight() / 3);
            graphics2D.setColor(LegendWindow.this.getForeground());
            graphics2D.drawRect(n, n2, n3, n4);
            graphics2D.setTransform(affineTransform);
        }

        public void paintItems(Graphics2D graphics2D, double d) {
            double d2;
            double d3;
            ResourceNode resourceNode = LegendWindow.this.getRootResourceNode();
            graphics2D.setColor(LegendWindow.this.getForeground());
            graphics2D.setFont(new Font("SansSerif", 0, (int)(30.0 * d)));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            double d4 = d3 = (double)fontMetrics.getHeight();
            double d5 = d3 * 0.1;
            d3 += d5 * 2.0;
            double d6 = fontMetrics.stringWidth("12345");
            int n = 0;
            int n2 = LegendWindow.this.items.size();
            for (int i = 0; i < n2; ++i) {
                Item item = LegendWindow.this.items.get(i);
                d2 = fontMetrics.stringWidth(this.substring(item.text, LegendWindow.this.startpos));
                if (item.zoneLeaf != null) {
                    n = (int)(Math.ceil(d4) * 1.05);
                }
                if (!(d6 < d2)) continue;
                d6 = d2;
            }
            if ((d6 += (double)n) > 0.0) {
                double d7;
                int n3;
                int n4;
                double d8 = d6 * 0.1;
                d2 = (double)this.width / (d6 += d8 * 2.0);
                double d9 = (double)this.height / d3;
                double d10 = Math.sqrt((double)n2 / (d2 * d9));
                if (d2 > d9) {
                    n4 = (int)Math.ceil(d2 * d10);
                    n3 = (int)Math.ceil((double)n2 / (double)n4);
                } else {
                    n3 = (int)Math.ceil(d9 * d10);
                    n4 = (int)Math.ceil((double)n2 / (double)n3);
                }
                double d11 = (double)this.width / ((double)n4 * d6);
                double d12 = (double)this.height / ((double)n3 * d3);
                double d13 = d7 = d11 < d12 ? d11 : d12;
                if (d2 > d9) {
                    n4 = (int)((double)this.width / d6 / d7 + 0.01);
                    n3 = (int)Math.ceil((double)n2 / (double)n4);
                } else {
                    n3 = (int)((double)this.height / d3 / d7 + 0.01);
                    n4 = (int)Math.ceil((double)n2 / (double)n3);
                }
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        int n5 = i * n3 + j;
                        if (n5 >= n2) continue;
                        AffineTransform affineTransform = graphics2D.getTransform();
                        Item item = LegendWindow.this.items.get(n5);
                        graphics2D.translate(this.origoX, this.origoY);
                        graphics2D.scale(d7, d7);
                        graphics2D.translate((double)i * d6, (double)j * d3);
                        if (item.zoneLeaf != null) {
                            double d14 = item.zoneLeaf.getSize();
                            double d15 = d4 / (d14 * 2.0);
                            item.setSize((int)(d14 * d15));
                            int n6 = (int)Math.ceil(d4 * 0.5);
                            item.setPoint(new Point((int)(((double)i * d6 + (double)n6) * d7 + (double)this.origoX), (int)(((double)j * d3 + (double)n6) * d7 + (double)this.origoY)));
                            Stroke stroke = graphics2D.getStroke();
                            PlotImages.draw(resourceNode, graphics2D, item.zoneLeaf, n6, n6, d15, true);
                            graphics2D.setColor(LegendWindow.this.getForeground());
                            graphics2D.setStroke(stroke);
                        }
                        graphics2D.translate((double)n, d4 - d5 * 2.0);
                        graphics2D.drawString(this.substring(item.text, LegendWindow.this.startpos), 0, 0);
                        graphics2D.setTransform(affineTransform);
                    }
                }
            }
        }

        private String substring(String string, int n) {
            if (n < string.length()) {
                return string.substring(n);
            }
            return "";
        }
    }
}

