/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.windows;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.plot.axisplot.windows.FloatWindow;

public abstract class PlotZone
extends DataTreeClass {
    protected int width;
    protected int height;
    protected int origoX;
    protected int origoY;
    private int minWidth = -1;
    private int minHeight = -1;
    private double preferredRelativeWidth;
    private double preferredRelativeHeight;
    private double relativewidth;
    private double relativeheight;
    protected FloatWindow floatWindow;
    protected Color bkcolor = null;
    protected Color bordercolor = null;
    private final byte handleContent;

    public PlotZone(Color color, double d, double d2, byte by) {
        super("PlotZone");
        this.handleContent = by;
        this.preferredRelativeWidth = d;
        this.preferredRelativeHeight = d2;
        this.relativewidth = d;
        this.relativeheight = d2;
        this.bkcolor = color;
    }

    public PlotZone(double d, double d2, byte by) {
        this(null, d, d2, by);
    }

    public PlotZone(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.width = mapProperty.getPropertyInt("w");
        this.height = mapProperty.getPropertyInt("h");
        this.origoX = mapProperty.getPropertyInt("oX");
        this.origoY = mapProperty.getPropertyInt("oY");
        this.relativewidth = mapProperty.getPropertyDouble("rw");
        this.relativeheight = mapProperty.getPropertyDouble("rh");
        this.preferredRelativeWidth = mapProperty.getPropertyDouble("prw");
        this.preferredRelativeHeight = mapProperty.getPropertyDouble("prh");
        if (mapProperty.hasProperty("bkc")) {
            this.bkcolor = new Color(mapProperty.getLVInt());
        }
        if (mapProperty.hasProperty("bc")) {
            this.bordercolor = new Color(mapProperty.getLVInt());
        }
        this.handleContent = mapProperty.getPropertyByte("hC");
    }

    public boolean canHandleContent(byte by) {
        return (by & this.handleContent) != 0;
    }

    public double getAbsoluteHeight(double d, boolean bl) {
        double d2 = Math.max(this.relativeheight * d, (double)this.minHeight);
        if (bl) {
            return d - d2;
        }
        return d2;
    }

    public double getAbsoluteWidth(double d, boolean bl) {
        double d2 = Math.max(this.relativewidth * d, (double)this.minWidth);
        if (bl) {
            return d - d2;
        }
        return d2;
    }

    public final int getHeight() {
        return this.getHeight(0);
    }

    public int getHeight(int n) {
        return this.height;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    @Override
    public byte getNodeType() {
        return 0;
    }

    public final int getOrigoX() {
        return this.getOrigoX(0);
    }

    public int getOrigoX(int n) {
        return this.origoX;
    }

    public final int getOrigoY() {
        return this.getOrigoY(0);
    }

    public int getOrigoY(int n) {
        return this.origoY;
    }

    public int getPlotUnderCoords(double d, double d2) {
        return 0;
    }

    public double getPreferredRelativeHeight() {
        return this.preferredRelativeHeight;
    }

    public double getPreferredRelativeWidth() {
        return this.preferredRelativeWidth;
    }

    public double getRelativeHeight() {
        return this.relativeheight;
    }

    public double getRelativeWidth() {
        return this.relativewidth;
    }

    @Override
    public byte getTreeType() {
        return 0;
    }

    public final int getWidth() {
        return this.getWidth(0);
    }

    public int getWidth(int n) {
        return this.width;
    }

    public boolean isInside(int n, int n2) {
        return n >= this.origoX && n <= this.origoX + this.width && n2 >= this.origoY && n2 <= this.origoY + this.height;
    }

    public boolean isInsideX(int n) {
        return n >= this.origoX && n <= this.origoX + this.width;
    }

    public boolean isInsideY(int n) {
        return n >= this.origoY && n <= this.origoY + this.height;
    }

    public void makeScreenShot(Graphics2D graphics2D, byte by, double d) {
        graphics2D.setClip(null);
        this.paint(graphics2D, by, d);
    }

    public void paintFloated(Graphics2D graphics2D, int n, int n2) {
        graphics2D.drawRect(n, n2, this.width, this.height);
    }

    public void paintZone(Graphics2D graphics2D, byte by, double d) {
        if (this.width == 0 || this.height == 0) {
            return;
        }
        graphics2D.setClip(null);
        this.paint(graphics2D, by, d);
    }

    public void resizeGlobal() {
        if (this.floatWindow != null) {
            this.floatWindow.componentResized(1.0, 1.0, true, true);
        }
    }

    public void setBackgroundColor(Color color) {
        this.bkcolor = color;
        if (this.floatWindow != null) {
            this.floatWindow.contentPaint((byte)7);
        }
    }

    public void setBorderColor(Color color) {
        this.bordercolor = color;
        if (this.floatWindow != null) {
            this.floatWindow.contentPaint((byte)7);
        }
    }

    public void setDimension(Double[] doubleArray) {
        if (doubleArray.length != 2) {
            throw new RuntimeException("Illigal number of parameters");
        }
        this.preferredRelativeWidth = doubleArray[0];
        this.preferredRelativeHeight = doubleArray[1];
        this.relativewidth = doubleArray[0];
        this.relativeheight = doubleArray[1];
        this.minWidth = doubleArray[0].intValue();
        this.minHeight = doubleArray[1].intValue();
    }

    public void setHeight(int n) {
        this.height = n;
        this.resizeGlobal();
    }

    public void setMinHeight(int n) {
        this.minHeight = n;
    }

    public void setMinWidth(int n) {
        this.minWidth = n;
    }

    public void setParent(FloatWindow floatWindow) {
        this.floatWindow = floatWindow;
    }

    public boolean setPlotSize(int n, int n2, int n3, int n4) {
        if (this.origoX != n || this.origoY != n2 || this.width != n3 || this.height != n4) {
            this.origoX = n;
            this.origoY = n2;
            this.width = n3;
            this.height = n4;
            return true;
        }
        return false;
    }

    public void setPreferredRelativeHeight(double d) {
        this.preferredRelativeHeight = d;
    }

    public void setPreferredRelativeWidth(double d) {
        this.preferredRelativeWidth = d;
    }

    public void setRelativeHeight(double d) {
        this.relativeheight = d;
    }

    public void setRelativeWidth(double d) {
        this.relativewidth = d;
    }

    public void setWidth(int n) {
        this.width = n;
        this.resizeGlobal();
    }

    public int[] translateToZone(int n, int n2) {
        return new int[]{n + this.origoX, n2 + this.origoY};
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.floatWindow = null;
    }

    protected abstract void paint(Graphics2D var1, byte var2, double var3);

    @Override
    protected void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyInt("w", this.width);
        randomOutputStream.writePropertyInt("h", this.height);
        randomOutputStream.writePropertyInt("oX", this.origoX);
        randomOutputStream.writePropertyInt("oY", this.origoY);
        randomOutputStream.writePropertyDouble("rw", this.relativewidth);
        randomOutputStream.writePropertyDouble("rh", this.relativeheight);
        randomOutputStream.writePropertyDouble("prw", this.preferredRelativeWidth);
        randomOutputStream.writePropertyDouble("prh", this.preferredRelativeHeight);
        if (this.bkcolor != null) {
            randomOutputStream.writePropertyInt("bkc", this.bkcolor.getRGB());
        }
        if (this.bordercolor != null) {
            randomOutputStream.writePropertyInt("bc", this.bordercolor.getRGB());
        }
        randomOutputStream.writePropertyByte("hC", this.handleContent);
    }
}

