/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.windows;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.windows.PlotZone;

public class PlotZoneScroll
extends PlotZone {
    private boolean horizontal = false;
    private boolean hidden = false;
    private int barPos = 0;
    private int nSteps = 10;
    private int barSize = 1;
    private int scrollOrigoX = 0;
    private int scrollOrigoY = 0;
    private int scrollWidth = 0;
    private int scrollHeight = 0;
    private double stepSize = 0.0;
    private int selectedStep = -1;
    private ArrowButton buttonUp;
    private ArrowButton buttonDown;
    private final AbstractAxisPlot axisPlot;

    public PlotZoneScroll(AbstractAxisPlot abstractAxisPlot, Color color, double d, double d2, boolean bl) {
        this(abstractAxisPlot, color, d, d2, bl, 1);
    }

    public PlotZoneScroll(AbstractAxisPlot abstractAxisPlot, Color color, double d, double d2, boolean bl, byte by) {
        super(color, d, d2, by);
        this.axisPlot = abstractAxisPlot;
        boolean bl2 = this.horizontal = !bl;
        if (this.horizontal) {
            this.buttonUp = new ArrowButton(2);
            this.buttonDown = new ArrowButton(3);
        } else {
            this.buttonUp = new ArrowButton(0);
            this.buttonDown = new ArrowButton(1);
        }
    }

    public int getBarPos() {
        return this.barPos;
    }

    public int getBarSize() {
        return this.barSize;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.selectedStep < 0) {
            return;
        }
        int n = this.getStep(mouseEvent.getX(), mouseEvent.getY(), true);
        this.barPos = n - this.selectedStep;
        if (this.barPos < 0) {
            this.barPos = 0;
        } else if (this.barPos + this.barSize >= this.nSteps) {
            this.barPos = this.nSteps - this.barSize;
        }
        this.floatWindow.contentPaint((byte)7);
        mouseEvent.consume();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.getStep(mouseEvent.getX(), mouseEvent.getY(), false);
        if (n >= 0) {
            if (n < this.barPos || n >= this.barPos + this.barSize) {
                this.barPos = n;
                this.selectedStep = -1;
            } else {
                this.selectedStep = n - this.barPos;
            }
            this.floatWindow.contentPaint((byte)7);
            mouseEvent.consume();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.selectedStep >= 0) {
            this.selectedStep = -1;
            this.floatWindow.contentPaint((byte)7);
            mouseEvent.consume();
        } else {
            this.buttonUp.mouseReleased(mouseEvent);
            this.buttonDown.mouseReleased(mouseEvent);
        }
    }

    public void setBarPos(int n) {
        this.barPos = n;
        if (this.barPos + this.barSize > this.nSteps) {
            this.barPos = this.nSteps - this.barSize;
        }
        if (this.barPos < 0) {
            this.barPos = 0;
        }
    }

    public void setBarSize(int n) {
        this.barSize = n;
        if (this.barPos + this.barSize > this.nSteps) {
            this.barPos = this.nSteps - this.barSize;
        }
        if (this.barPos < 0) {
            this.barPos = 0;
        }
    }

    public void setNsteps(int n) {
        this.nSteps = n;
        if (this.barSize > this.nSteps) {
            this.barSize = this.nSteps;
        }
        this.stepSize = this.horizontal ? (double)(this.scrollWidth - 4) / (double)this.nSteps : (double)(this.scrollHeight - 4) / (double)this.nSteps;
        if (this.barPos + this.barSize > this.nSteps) {
            this.barPos = this.nSteps - this.barSize;
        }
        if (this.barPos < 0) {
            this.barPos = 0;
        }
    }

    @Override
    public boolean setPlotSize(int n, int n2, int n3, int n4) {
        boolean bl = super.setPlotSize(n, n2, n3, n4);
        this.scrollOrigoX = this.origoX;
        this.scrollOrigoY = this.origoY;
        this.scrollWidth = this.width;
        this.scrollHeight = this.height;
        if (this.horizontal) {
            this.scrollHeight /= 2;
            this.scrollOrigoY += this.scrollHeight / 2;
            int n5 = this.scrollWidth / 10;
            this.buttonUp.setPosition(this.scrollOrigoX, this.scrollOrigoY, n5, this.scrollHeight);
            this.buttonDown.setPosition(this.scrollOrigoX + this.scrollWidth - n5, this.scrollOrigoY, n5, this.scrollHeight);
            this.scrollWidth -= 2 * n5;
            this.scrollOrigoX += n5;
            this.stepSize = (double)(this.scrollWidth - 4) / (double)this.nSteps;
        } else {
            this.scrollWidth /= 2;
            this.scrollOrigoX += this.scrollWidth / 2;
            int n6 = this.scrollHeight / 10;
            this.buttonUp.setPosition(this.scrollOrigoX, this.scrollOrigoY, this.scrollWidth, n6);
            this.buttonDown.setPosition(this.scrollOrigoX, this.scrollOrigoY + this.scrollHeight - n6, this.scrollWidth, n6);
            this.scrollHeight -= 2 * n6;
            this.scrollOrigoY += n6;
            this.stepSize = (double)(this.scrollHeight - 4) / (double)this.nSteps;
        }
        return bl;
    }

    public void show(boolean bl) {
        this.hidden = !bl;
    }

    @Override
    protected void paint(Graphics2D graphics2D, byte by, double d) {
        if (this.hidden || this.barSize >= this.nSteps) {
            return;
        }
        graphics2D.setColor(this.axisPlot.getAxisColor());
        graphics2D.drawRect(this.scrollOrigoX, this.scrollOrigoY, this.scrollWidth, this.scrollHeight);
        int n = this.scrollOrigoX + 2;
        int n2 = this.scrollOrigoY + 2;
        int n3 = this.scrollWidth - 4;
        int n4 = this.scrollHeight - 4;
        if (this.selectedStep >= 0) {
            graphics2D.setColor(this.axisPlot.getPlotBgColor());
        } else {
            graphics2D.setColor(this.axisPlot.getAxisColor());
        }
        if (this.horizontal) {
            graphics2D.fillRect(n + (int)((double)this.barPos * this.stepSize), n2, (int)((double)this.barSize * this.stepSize), n4);
        } else {
            graphics2D.fillRect(n, n2 + (int)((double)this.barPos * this.stepSize), n3, (int)((double)this.barSize * this.stepSize));
        }
        if (this.selectedStep >= 0) {
            graphics2D.setColor(this.axisPlot.getAxisColor());
            if (this.horizontal) {
                graphics2D.drawRect(n + (int)((double)this.barPos * this.stepSize), n2, (int)((double)this.barSize * this.stepSize), n4);
            } else {
                graphics2D.drawRect(n, n2 + (int)((double)this.barPos * this.stepSize), n3, (int)((double)this.barSize * this.stepSize));
            }
        }
        this.buttonUp.paint(graphics2D);
        this.buttonDown.paint(graphics2D);
    }

    private void buttonClicked(byte by) {
        if (by == 2 || by == 0) {
            --this.barPos;
            if (this.barPos < 0) {
                this.barPos = 0;
            }
            this.floatWindow.contentPaint((byte)7);
        } else if (by == 3 || by == 1) {
            ++this.barPos;
            if (this.barPos + this.barSize >= this.nSteps) {
                this.barPos = this.nSteps - this.barSize;
            }
            this.floatWindow.contentPaint((byte)7);
        }
    }

    private int getStep(int n, int n2, boolean bl) {
        if (!bl && ((n -= this.scrollOrigoX) < 0 || n >= this.scrollWidth || !this.horizontal && (n2 -= this.scrollOrigoY) < 0 || n2 >= this.scrollHeight)) {
            return -1;
        }
        if (this.horizontal) {
            return (int)((double)n / this.stepSize);
        }
        return (int)((double)n2 / this.stepSize);
    }

    public class ArrowButton {
        public static final byte UP = 0;
        public static final byte DOWN = 1;
        public static final byte LEFT = 2;
        public static final byte RIGHT = 3;
        private final byte direction;
        private int originX;
        private int originY;
        private int width;
        private int height;

        ArrowButton(byte by) {
            this.direction = by;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getX() >= this.originX && mouseEvent.getX() < this.originX + this.width && mouseEvent.getY() >= this.originY && mouseEvent.getY() < this.originY + this.height) {
                mouseEvent.consume();
                PlotZoneScroll.this.buttonClicked(this.direction);
            }
        }

        void paint(Graphics2D graphics2D) {
            graphics2D.drawRect(this.originX, this.originY, this.width, this.height);
            GeneralPath generalPath = new GeneralPath();
            switch (this.direction) {
                case 0: {
                    generalPath.moveTo((float)this.originX + (float)this.width / 2.0f, (float)this.originY + (float)this.height / 4.0f);
                    generalPath.lineTo((float)this.originX + (float)this.width / 4.0f, (float)this.originY + 3.0f * (float)this.height / 4.0f);
                    generalPath.lineTo((float)this.originX + 3.0f * (float)this.width / 4.0f, (float)this.originY + 3.0f * (float)this.height / 4.0f);
                    generalPath.lineTo((float)this.originX + (float)this.width / 2.0f, (float)this.originY + (float)this.height / 4.0f);
                    break;
                }
                case 1: {
                    generalPath.moveTo((float)this.originX + (float)this.width / 2.0f, (float)this.originY + 3.0f * (float)this.height / 4.0f);
                    generalPath.lineTo((float)this.originX + 3.0f * (float)this.width / 4.0f, (float)this.originY + (float)this.height / 4.0f);
                    generalPath.lineTo((float)this.originX + (float)this.width / 4.0f, (float)this.originY + (float)this.height / 4.0f);
                    generalPath.lineTo((float)this.originX + (float)this.width / 2.0f, (float)this.originY + 3.0f * (float)this.height / 4.0f);
                    break;
                }
                case 2: {
                    generalPath.moveTo((float)this.originX + (float)this.width / 4.0f, (float)this.originY + (float)this.height / 2.0f);
                    generalPath.lineTo((float)this.originX + 3.0f * (float)this.width / 4.0f, (float)this.originY + 3.0f * (float)this.height / 4.0f);
                    generalPath.lineTo((float)this.originX + 3.0f * (float)this.width / 4.0f, (float)this.originY + (float)this.height / 4.0f);
                    generalPath.lineTo((float)this.originX + (float)this.width / 4.0f, (float)this.originY + (float)this.height / 2.0f);
                    break;
                }
                case 3: {
                    generalPath.moveTo((float)this.originX + 3.0f * (float)this.width / 4.0f, (float)this.originY + (float)this.height / 2.0f);
                    generalPath.lineTo((float)this.originX + (float)this.width / 4.0f, (float)this.originY + (float)this.height / 4.0f);
                    generalPath.lineTo((float)this.originX + (float)this.width / 4.0f, (float)this.originY + 3.0f * (float)this.height / 4.0f);
                    generalPath.lineTo((float)this.originX + 3.0f * (float)this.width / 4.0f, (float)this.originY + (float)this.height / 2.0f);
                }
            }
            graphics2D.fill(generalPath);
        }

        void setPosition(int n, int n2, int n3, int n4) {
            this.originX = n;
            this.originY = n2;
            this.width = n3;
            this.height = n4;
        }
    }
}

