/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.windows;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JTextArea;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.StringFun;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.windows.FloatWindow;
import se.prediktera.map.plot.axisplot.windows.PlotZone;
import se.prediktera.map.plot.axisplot.windows.TagHelper;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class PlotZoneText
extends PlotZone {
    private Color fontColor = Color.black;
    private String rawtext = "";
    private boolean rotate;
    private Font font = new Font("SansSerif", 1, 16);
    private final BufferedImage tempImage = new BufferedImage(1, 1, 2);
    private final boolean editable = false;
    private int alignment;
    private double padding = 0.05;

    public PlotZoneText(Color color, double d, double d2, boolean bl) {
        this(color, 0, d, d2, bl);
    }

    public PlotZoneText(Color color, int n, double d, double d2, boolean bl) {
        super(color, d, d2, (byte)1);
        this.alignment = n;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public int getFontSize() {
        return this.font.getSize();
    }

    public int getHorizontalAlignment() {
        return this.alignment;
    }

    public double getPadding() {
        return this.padding;
    }

    public Font getTextFont() {
        return this.font;
    }

    public boolean isRotate() {
        return this.rotate;
    }

    @Override
    public void paint(Graphics2D graphics2D, byte by, double d) {
        String string = this.getFormatedText();
        if (string.length() > 0 && this.floatWindow != null) {
            double d2;
            graphics2D.setFont(this.font);
            ArrayList<String> arrayList = this.getTextRows(string);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.font);
            double d3 = this.getMaxStringWidth(fontMetrics, arrayList);
            double d4 = fontMetrics.getHeight();
            int n = arrayList.size();
            double d5 = this.calcWindowSize(d3, 1);
            double d6 = this.calcWindowSize(d4, n);
            double d7 = this.rotate ? (double)this.height : (double)this.width;
            double d8 = this.rotate ? (double)this.width : (double)this.height;
            double d9 = this.calcTextSize(d7, 1);
            double d10 = this.calcTextSize(d8, n);
            AffineTransform affineTransform = graphics2D.getTransform();
            double d11 = d7 / d5;
            double d12 = d8 / d6;
            double d13 = d2 = d11 < d12 ? d11 : d12;
            if (this.bkcolor != null) {
                graphics2D.setColor(this.bkcolor);
                graphics2D.fillRect(0, 0, this.width, this.height);
            }
            if (this.bordercolor != null) {
                graphics2D.setColor(this.bordercolor);
                graphics2D.drawRect(0, 0, this.width - 1, this.height - 1);
            }
            if (this.rotate) {
                graphics2D.translate(0, this.height);
                graphics2D.rotate(-1.5707963267948966);
            }
            graphics2D.translate((double)this.origoX + d7 * this.padding, (double)this.origoY);
            graphics2D.setColor(this.fontColor);
            graphics2D.scale(d2, d2);
            for (String string2 : arrayList) {
                graphics2D.translate(0.0, d8 * this.padding / d2);
                this.drawString(graphics2D, string2, d9, d10, d2, this.rotate);
                graphics2D.translate(0.0, d10 / d2);
            }
            graphics2D.setTransform(affineTransform);
        }
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyStringUTF("text", this.rawtext);
    }

    public void setFont(Font font, boolean bl) {
        this.font = font;
        if (bl) {
            this.setText(this.rawtext);
        }
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
        this.floatWindow.contentPaint((byte)7);
    }

    public void setHorizontalAlignment(int n) {
        this.alignment = n;
    }

    public void setPadding(double d) {
        this.padding = d;
    }

    @Override
    public void setParent(FloatWindow floatWindow) {
        super.setParent(floatWindow);
    }

    public void setRelativeSize() {
        Graphics2D graphics2D = this.tempImage.createGraphics();
        if (graphics2D != null && this.floatWindow != null) {
            double d;
            String string = this.getFormatedText();
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.font);
            ArrayList<String> arrayList = this.getTextRows(string);
            double d2 = this.getMaxStringWidth(fontMetrics, arrayList);
            double d3 = fontMetrics.getHeight();
            int n = arrayList.size();
            double d4 = this.calcWindowSize(d2, 1);
            double d5 = this.calcWindowSize(d3, n);
            double d6 = Math.min(1.0, d4 * 0.0015);
            double d7 = Math.min(1.0, d5 * 0.0015);
            if (this.rotate) {
                d = d7;
                d7 = d6;
                d6 = d;
            }
            d = this.floatWindow.getRelativeX() + 0.5 * (this.floatWindow.getRelativeWidth() - d6);
            double d8 = this.floatWindow.getRelativeY() + 0.5 * (this.floatWindow.getRelativeHeight() - d7);
            d = Math.max(0.0, d);
            d = Math.min(1.0 - d6, d);
            d8 = Math.max(0.0, d8);
            d8 = Math.min(1.0 - d7, d8);
            this.floatWindow.setRelativeSize(d6, d7);
            this.floatWindow.setRelativePosition(d, d8);
        }
    }

    public void setRotate(boolean bl, boolean bl2) {
        this.rotate = bl;
        if (bl2) {
            this.setText(this.rawtext);
        }
    }

    public void setText(String string) {
        this.rawtext = string;
        this.setRelativeSize();
    }

    public void setTextNoResize(String string) {
        this.rawtext = string;
    }

    @Override
    public String toString() {
        return this.rawtext;
    }

    private double calcTextSize(double d, int n) {
        return d * (1.0 - this.padding * (double)(n + 1)) / (double)n;
    }

    private double calcWindowSize(double d, int n) {
        return d * (double)n / (1.0 - this.padding * (double)(n + 1));
    }

    private void drawString(Graphics2D graphics2D, String string, double d, double d2, double d3, boolean bl) {
        AffineTransform affineTransform = graphics2D.getTransform();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.font);
        double d4 = fontMetrics.stringWidth(string);
        double d5 = d2 / 2.0 / d3 + (double)(fontMetrics.getHeight() / 3);
        if (this.alignment == 2) {
            graphics2D.translate(0.0, d5);
        } else if (this.alignment == 0) {
            graphics2D.translate(d / 2.0 / d3 - d4 / 2.0, d5);
        } else {
            graphics2D.translate(d - (d4 + d5) * d3, d5);
        }
        graphics2D.drawString(string, 0, 0);
        graphics2D.setTransform(affineTransform);
    }

    private String getFormatedText() {
        AbstractPlotLayout abstractPlotLayout;
        PlotInit plotInit;
        String string = this.rawtext;
        if (this.floatWindow != null && this.floatWindow.getParentBaseWindow() != null && (plotInit = (abstractPlotLayout = this.floatWindow.getParentBaseWindow()).getPlotInit()) != null && plotInit.getDataTreeInterface() != null) {
            DataTreeInterface dataTreeInterface = plotInit.getDataTreeInterface();
            string = TagHelper.formatText(dataTreeInterface, this.floatWindow, string);
        }
        return string;
    }

    private double getMaxStringWidth(FontMetrics fontMetrics, ArrayList<String> arrayList) {
        double d = 0.0;
        double d2 = arrayList.size();
        int n = 0;
        while ((double)n < d2) {
            double d3 = fontMetrics.stringWidth(arrayList.get(n));
            if (d3 > d) {
                d = d3;
            }
            ++n;
        }
        return d;
    }

    private ArrayList<String> getTextRows(String string) {
        return StringFun.cutIntoRows(string);
    }

    private void setTextFromTextArea(JTextArea jTextArea) {
        String string = jTextArea.getText();
        if (string.length() > 0) {
            this.setText(string);
            this.floatWindow.remove(jTextArea);
            this.floatWindow.getParentBaseWindow().repaint();
        }
    }
}

