/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.windows;

import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.cleanup.CleanUpInterface;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.layer.AbstractLayerPanel;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.PlotAxisLayerPanel;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.ComboBoxRange;
import se.prediktera.map.plot.axisplot.windows.FloatWindow;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class TagHelper {
    private static String[] tags = new String[]{"matrix", "model", "prediction", "dataset", "case", "range"};
    private static Class[] tagclass = new Class[]{String.class, AbstractModel.class, AbstractPrediction.class, DataSet.class, Case.class, ComboBoxRange.class};

    public static String formatText(DataTreeInterface dataTreeInterface, String string) {
        return TagHelper.formatText(dataTreeInterface, null, string);
    }

    public static String formatText(DataTreeInterface dataTreeInterface, FloatWindow floatWindow, String string) {
        if (dataTreeInterface instanceof FoldMatrix) {
            dataTreeInterface = ((FoldMatrix)dataTreeInterface).getReferencedMatrix();
        }
        if (dataTreeInterface != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '$') {
                    int n = TagHelper.getTagIndex(string, i + 1);
                    int n2 = tags[n].length();
                    String string2 = null;
                    int n3 = i + n2 + 1;
                    if (n3 < string.length() && string.charAt(n3) == '_') {
                        string2 = TagHelper.getString(string, n3 + 1);
                    }
                    stringBuilder.append(TagHelper.getReplaceString(dataTreeInterface, floatWindow, tagclass[n], string2));
                    i += n2;
                    if (string2 == null) continue;
                    i += string2.length() + 1;
                    continue;
                }
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
        return string;
    }

    private static String getReplaceString(DataTreeInterface dataTreeInterface, FloatWindow floatWindow, Class clazz, String string) {
        Object object;
        AbstractPlotSettingsBox abstractPlotSettingsBox;
        DataTreeInterface dataTreeInterface2;
        CleanUpInterface cleanUpInterface;
        DataTreeInterface dataTreeInterface3;
        DataTreeClass dataTreeClass = null;
        if (clazz.equals(ComboBoxRange.class) && floatWindow != null && (dataTreeInterface3 = floatWindow.getParentBaseWindow()) != null && (cleanUpInterface = ((AbstractPlotLayout)dataTreeInterface3).getMainWindow()) instanceof AbstractAxisPlot && ((AbstractLayerPanel)(cleanUpInterface = ((AbstractAxisPlot)(dataTreeInterface2 = (AbstractAxisPlot)cleanUpInterface)).getSettingsPanel())).getMainLayerCount() > 0 && (abstractPlotSettingsBox = (object = ((PlotAxisLayerPanel)cleanUpInterface).getMainLayer(0).getSettingsBoxMap()).get((byte)9)) != null) {
            return abstractPlotSettingsBox.getSelectedItem().toString();
        }
        if (clazz.equals(AbstractModel.class) && (dataTreeInterface3 = (DataSet)DataTreeManager.getAncestorNull(dataTreeInterface, DataSet.class)) != null && ((DataSet)dataTreeInterface3).isExternal() && ((DataTreeClass)dataTreeInterface3).getNodeByName("Predictions") != null && (dataTreeInterface2 = ((DataTreeClass)dataTreeInterface3).getNodeByName("Predictions")) != null && dataTreeInterface2.getTreeNodeCount() > 0 && (cleanUpInterface = (AbstractPrediction)dataTreeInterface2.getTreeNodeAt(0)) != null) {
            dataTreeClass = ((AbstractPrediction)cleanUpInterface).getModel();
        }
        if (dataTreeClass == null) {
            dataTreeClass = (DataTreeClass)DataTreeManager.getAncestorNull(dataTreeInterface, clazz);
            if (dataTreeClass == null && clazz == AbstractPrediction.class) {
                dataTreeInterface3 = (AbstractModel)DataTreeManager.getAncestorNull(dataTreeInterface, AbstractModel.class);
                if (dataTreeInterface3 != null) {
                    dataTreeClass = ((AbstractModel)dataTreeInterface3).getLocalPredictionNode();
                }
            } else if (clazz.equals(String.class)) {
                return dataTreeInterface.toString();
            }
        }
        if (dataTreeClass != null) {
            if (clazz.equals(Case.class)) {
                return ((Case)dataTreeClass).getOriginalName();
            }
            if (string != null) {
                try {
                    dataTreeInterface3 = null;
                    dataTreeInterface3 = dataTreeClass instanceof AbstractModel ? ((AbstractModel)dataTreeClass).getMatrixByName(string) : dataTreeClass.getNodeByName(string);
                    if (dataTreeInterface3 instanceof ModelMatrix) {
                        dataTreeInterface2 = (ModelMatrix)dataTreeInterface3;
                        cleanUpInterface = ((ModelMatrix)dataTreeInterface2).getLastRM();
                        if (cleanUpInterface.size() > 1) {
                            object = new StringBuilder();
                            double d = 0.0;
                            if (cleanUpInterface != null) {
                                for (int i = 0; i < cleanUpInterface.size(); ++i) {
                                    ((StringBuilder)object).append(((ModelMatrix)dataTreeInterface2).getColumnDescription(i, 0));
                                    ((StringBuilder)object).append("= ");
                                    double d2 = cleanUpInterface.get(i);
                                    ((StringBuilder)object).append(NiceDataFormat.toString(d2));
                                    d += d2;
                                    ((StringBuilder)object).append("\n");
                                }
                            }
                            ((StringBuilder)object).append("Average= ");
                            ((StringBuilder)object).append(NiceDataFormat.toString(d / (double)cleanUpInterface.size()));
                            return ((StringBuilder)object).toString();
                        }
                        if (cleanUpInterface.size() == 1) {
                            return NiceDataFormat.toString(cleanUpInterface.get(0));
                        }
                    } else if (dataTreeInterface3 != null) {
                        return dataTreeInterface3.toString();
                    }
                }
                catch (Exception exception) {
                    ErrorHandler.logAndReportException(exception);
                }
            } else {
                return dataTreeClass.toString();
            }
        }
        return "N/A";
    }

    private static String getString(String string, int n) {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < string.length() && (c = string.charAt(i)) != ' ' && c != '\n' && c != '\r'; ++i) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static int getTagIndex(String string, int n) {
        for (int i = 0; i < tags.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < tags[i].length() && j < string.length(); ++j) {
                bl = true;
                if (string.charAt(n + j) == tags[i].charAt(j)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return i;
        }
        return -1;
    }
}

