/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.windows;

import java.awt.Graphics2D;
import java.awt.Point;
import java.io.IOException;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.plot.axisplot.windows.PlotZone;
import se.prediktera.map.plot.axisplot.windows.ZoneLayout;

public class ZoneRelativeLayout
extends ZoneLayout {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int CENTER = 4;
    public static final int FREE = 5;
    public static final String[] LAYOUT = new String[]{"top", "bottom", "left", "right", "center", "free"};
    private final PlotZone[] childPlotZones = new PlotZone[]{null, null, null, null, null};
    private int resizeCorner = -1;
    private double offsetX = 0.0;
    private double offsetY = 0.0;

    @Override
    public void addPlotZone(PlotZone plotZone, int n) {
        this.childPlotZones[n] = plotZone;
        double d = plotZone.getPreferredRelativeHeight();
        double d2 = plotZone.getPreferredRelativeWidth();
        if (n == 0 || n == 1) {
            if (d2 > 0.0) {
                plotZone.setRelativeWidth(d2);
            } else {
                plotZone.setRelativeWidth(1.0);
            }
            plotZone.setRelativeHeight(d);
        } else if (n == 2 || n == 3) {
            double d3 = 1.0;
            if (d > 0.0) {
                d3 = d;
            }
            plotZone.setRelativeHeight(d3);
            plotZone.setRelativeWidth(d2);
        }
    }

    @Override
    public void doChange() {
        double d;
        double d2;
        if (this.resizeCorner == 8 && this.childPlotZones[2] != null && (d2 = (double)this.childPlotZones[2].getWidth() + this.offsetX) >= Math.max(1.0, (double)this.childPlotZones[2].getMinWidth())) {
            d = d2 / this.floatWindow.getTryWidth();
            this.childPlotZones[2].setRelativeWidth(d);
        }
        if (this.resizeCorner == 9 && this.childPlotZones[1] != null && (d2 = (double)this.childPlotZones[1].getHeight() - this.offsetY) >= Math.max(1.0, (double)this.childPlotZones[1].getMinHeight())) {
            d = d2 / this.floatWindow.getTryHeight();
            this.childPlotZones[1].setRelativeHeight(d);
        }
        if (this.resizeCorner == 10 && this.childPlotZones[3] != null && (d2 = (double)this.childPlotZones[3].getWidth() - this.offsetX) >= Math.max(1.0, (double)this.childPlotZones[3].getMinWidth())) {
            d = d2 / this.floatWindow.getTryWidth();
            this.childPlotZones[3].setRelativeWidth(d);
        }
        if (this.resizeCorner == 11 && this.childPlotZones[0] != null && (d2 = (double)this.childPlotZones[0].getHeight() + this.offsetY) >= Math.max(1.0, (double)this.childPlotZones[0].getMinHeight())) {
            d = d2 / this.floatWindow.getTryHeight();
            this.childPlotZones[0].setRelativeHeight(d);
        }
        this.resizeCorner = -1;
    }

    @Override
    public PlotZone getArea(String string) {
        for (int i = 0; i < this.childPlotZones.length; ++i) {
            if (!string.equals(LAYOUT[i])) continue;
            return this.childPlotZones[i];
        }
        return null;
    }

    @Override
    public int getCorner(Point point) {
        int n;
        int n2;
        int n3;
        int n4 = (int)this.floatWindow.getTryOrigoX();
        int n5 = (int)this.floatWindow.getTryOrigoY();
        if (this.childPlotZones[2] != null && this.floatWindow.isOnCorner(point, n3 = this.childPlotZones[2].getOrigoX() + n4 + this.childPlotZones[2].getWidth(), (n2 = this.childPlotZones[2].getOrigoY() + n5) + (n = this.childPlotZones[2].getHeight()) / 2)) {
            return 8;
        }
        if (this.childPlotZones[1] != null) {
            n3 = this.childPlotZones[1].getOrigoX() + n4;
            n2 = this.childPlotZones[1].getOrigoY() + n5;
            n = this.childPlotZones[1].getWidth();
            if (this.floatWindow.isOnCorner(point, n3 + n / 2, n2)) {
                return 9;
            }
        }
        if (this.childPlotZones[3] != null && this.floatWindow.isOnCorner(point, n3 = this.childPlotZones[3].getOrigoX() + n4, (n2 = this.childPlotZones[3].getOrigoY() + n5) + (n = this.childPlotZones[3].getHeight()) / 2)) {
            return 10;
        }
        if (this.childPlotZones[0] != null) {
            n3 = this.childPlotZones[0].getOrigoX() + n4;
            n2 = this.childPlotZones[0].getOrigoY() + n5 + this.childPlotZones[0].getHeight();
            n = this.childPlotZones[0].getWidth();
            if (this.floatWindow.isOnCorner(point, n3 + n / 2, n2)) {
                return 11;
            }
        }
        return -1;
    }

    @Override
    public void makeScreenShot(Graphics2D graphics2D, byte by, double d) {
        for (int i = this.childPlotZones.length - 1; i >= 0; --i) {
            if (this.childPlotZones[i] == null || !this.childPlotZones[i].canHandleContent(by)) continue;
            this.childPlotZones[i].makeScreenShot(graphics2D, by, d);
        }
    }

    @Override
    public void paint(Graphics2D graphics2D, byte by, double d) {
        for (int i = this.childPlotZones.length - 1; i >= 0; --i) {
            if (this.childPlotZones[i] == null || !this.childPlotZones[i].canHandleContent(by)) continue;
            this.childPlotZones[i].paintZone(graphics2D, by, d);
        }
    }

    @Override
    public void paintFloated(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        int n4 = (int)this.floatWindow.getTryOrigoX();
        int n5 = (int)this.floatWindow.getTryOrigoY();
        double d = this.floatWindow.getTryWidth();
        double d2 = this.floatWindow.getTryHeight();
        if (this.childPlotZones[1] != null) {
            n3 = this.childPlotZones[1].getOrigoX() + n4;
            n2 = n5 + (int)this.childPlotZones[1].getAbsoluteHeight(d2, true);
            n = this.childPlotZones[1].getWidth();
            graphics2D.drawLine(n3, n2, n3 + n, n2);
        }
        if (this.childPlotZones[2] != null) {
            n3 = this.childPlotZones[2].getOrigoX() + n4 + (int)this.childPlotZones[2].getAbsoluteWidth(d, false);
            n2 = this.childPlotZones[2].getOrigoY() + n5;
            n = this.childPlotZones[2].getHeight();
            graphics2D.drawLine(n3, n2, n3, n2 + n);
        }
        if (this.childPlotZones[0] != null) {
            n3 = this.childPlotZones[0].getOrigoX() + n4;
            n2 = n5 + (int)this.childPlotZones[0].getAbsoluteHeight(d2, false);
            n = this.childPlotZones[0].getWidth();
            graphics2D.drawLine(n3, n2, n3 + n, n2);
        }
        if (this.childPlotZones[3] != null) {
            n3 = n4 + (int)this.childPlotZones[3].getAbsoluteWidth(d, true);
            n2 = this.childPlotZones[3].getOrigoY() + n5;
            n = this.childPlotZones[3].getHeight();
            graphics2D.drawLine(n3, n2, n3, n2 + n);
        }
    }

    @Override
    public void paintSelected(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        int n4 = (int)this.floatWindow.getTryOrigoX();
        int n5 = (int)this.floatWindow.getTryOrigoY();
        double d = this.floatWindow.getTryWidth();
        double d2 = this.floatWindow.getTryHeight();
        if (this.childPlotZones[1] != null) {
            n3 = this.childPlotZones[1].getOrigoX() + n4;
            n2 = n5 + (int)this.childPlotZones[1].getAbsoluteHeight(d2, true);
            n = this.childPlotZones[1].getWidth();
            graphics2D.drawLine(n3, n2, n3 + n, n2);
            this.floatWindow.paintSelectionBox(graphics2D, n3 + n / 2, n2);
        }
        if (this.childPlotZones[2] != null) {
            n3 = this.childPlotZones[2].getOrigoX() + n4 + (int)this.childPlotZones[2].getAbsoluteWidth(d, false);
            n2 = this.childPlotZones[2].getOrigoY() + n5;
            n = this.childPlotZones[2].getHeight();
            graphics2D.drawLine(n3, n2, n3, n2 + n);
            this.floatWindow.paintSelectionBox(graphics2D, n3, n2 + n / 2);
        }
        if (this.childPlotZones[0] != null) {
            n3 = this.childPlotZones[0].getOrigoX() + n4;
            n2 = n5 + (int)this.childPlotZones[0].getAbsoluteHeight(d2, false);
            n = this.childPlotZones[0].getWidth();
            graphics2D.drawLine(n3, n2, n3 + n, n2);
            this.floatWindow.paintSelectionBox(graphics2D, n3 + n / 2, n2);
        }
        if (this.childPlotZones[3] != null) {
            n3 = n4 + (int)this.childPlotZones[3].getAbsoluteWidth(d, true);
            n2 = this.childPlotZones[3].getOrigoY() + n5;
            n = this.childPlotZones[3].getHeight();
            graphics2D.drawLine(n3, n2, n3, n2 + n);
            this.floatWindow.paintSelectionBox(graphics2D, n3, n2 + n / 2);
        }
    }

    @Override
    public void removeArea(String string) {
        PlotZone plotZone;
        super.removeArea(string);
        if (string.equalsIgnoreCase("all")) {
            for (PlotZone plotZone2 : this.childPlotZones) {
                if (plotZone2 == null) continue;
                plotZone2.setDimension(new Double[]{0.0, 0.0});
            }
        } else if (string.equals("labelx") && (plotZone = this.getArea("bottom")) != null) {
            plotZone.setDimension(new Double[]{0.0, 0.1});
        }
    }

    @Override
    public boolean resize() {
        super.resize();
        boolean bl = false;
        for (int i = 0; i < this.childPlotZones.length; ++i) {
            if (this.childPlotZones[i] == null || !this.resize(this.childPlotZones[i], i)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean resize(PlotZone plotZone, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        double d = plotZone.getRelativeHeight();
        double d2 = plotZone.getRelativeWidth();
        if (n == 0 || n == 1) {
            int n6;
            n2 = this.width;
            if (d2 > 0.0) {
                n2 = (int)((double)n2 * d2);
            }
            if ((n3 = (int)((double)(n6 = this.floatWindow.getHeight()) * d)) < plotZone.getMinHeight()) {
                n3 = Math.min(plotZone.getMinHeight(), n6);
            }
            n4 = this.origoX;
            n5 = this.origoY;
            if (n == 1) {
                n5 = this.origoY + this.height - n3;
            }
        } else if (n == 2 || n == 3) {
            int n7 = this.floatWindow.getWidth();
            n2 = (int)((double)n7 * d2);
            if (n2 < plotZone.getMinWidth()) {
                n2 = Math.min(plotZone.getMinWidth(), n7);
            }
            n3 = this.height;
            if (d > 0.0) {
                n3 = (int)((double)n3 * d);
            }
            n4 = this.origoX;
            n5 = this.origoY;
            if (n == 3) {
                n4 = this.origoX + this.width - n2;
            }
            PlotZone plotZone2 = this.childPlotZones[0];
            PlotZone plotZone3 = this.childPlotZones[1];
            if (plotZone2 != null) {
                n5 += plotZone2.getHeight();
                n3 -= plotZone2.getHeight();
            }
            if (plotZone3 != null) {
                n3 -= plotZone3.getHeight();
            }
        } else if (n == 4) {
            n2 = this.width;
            n3 = this.height;
            n4 = this.origoX;
            n5 = this.origoY;
            PlotZone plotZone4 = this.childPlotZones[0];
            PlotZone plotZone5 = this.childPlotZones[1];
            PlotZone plotZone6 = this.childPlotZones[2];
            PlotZone plotZone7 = this.childPlotZones[3];
            if (plotZone4 != null) {
                n5 += plotZone4.getHeight();
                n3 -= plotZone4.getHeight();
            }
            if (plotZone5 != null) {
                n3 -= plotZone5.getHeight();
            }
            if (plotZone6 != null) {
                n4 += plotZone6.getWidth();
                n2 -= plotZone6.getWidth();
            }
            if (plotZone7 != null) {
                n2 -= plotZone7.getWidth();
            }
        }
        return plotZone.setPlotSize(n4, n5, n2, n3);
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        for (int i = 0; i < this.childPlotZones.length; ++i) {
            if (this.childPlotZones[i] == null || this.childPlotZones[i].getTreeParent() != null) continue;
            this.childPlotZones[i].SaveProperty(randomOutputStream, i);
        }
    }

    @Override
    public boolean tryResize(int n, double d, double d2) {
        this.resizeCorner = n;
        this.offsetX = d;
        this.offsetY = d2;
        return true;
    }
}

