/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.layout;

import com.jogamp.opengl.GLException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.resource.ImageResource;
import se.prediktera.map.common.resource.ResourceManager;
import se.prediktera.map.common.swing.JComboBoxCell;
import se.prediktera.map.common.swing.scrollabledesktop.BaseInternalFrame;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.AbstractScriptInfo;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.FileDataClass;
import se.prediktera.map.main.script.ImageDataClass;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.plot.AbstractPlot;
import se.prediktera.map.plot.ImgSel;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.PlotPopupMenu;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.PlotAxisLayerPanel;
import se.prediktera.map.plot.axisplot.PlotSelectionHelper;
import se.prediktera.map.plot.axisplot.plot2D.contour2D.FloatWindowContour2D;
import se.prediktera.map.plot.axisplot.plot3D.Abstract3dPlotBaseWindow;
import se.prediktera.map.plot.axisplot.plot3D.FloatWindowPlot3D;
import se.prediktera.map.plot.axisplot.plot3D.contour3D.Contour3D;
import se.prediktera.map.plot.axisplot.plot3D.scatter3D.Scatter3D;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;
import se.prediktera.map.plot.axisplot.windows.FloatImageWindow;
import se.prediktera.map.plot.axisplot.windows.FloatMainWindow;
import se.prediktera.map.plot.axisplot.windows.FloatTextWindow;
import se.prediktera.map.plot.axisplot.windows.FloatWindow;
import se.prediktera.map.plot.axisplot.windows.LegendWindow;
import se.prediktera.map.plot.axisplot.windows.PlotZoneImage;
import se.prediktera.map.plot.axisplot.windows.ZoneRelativeLayout;
import se.prediktera.map.plot.layout.DescriptionTextBox;
import se.prediktera.map.plot.layout.LayoutException;
import se.prediktera.map.plot.layout.PlotLayoutToolbar;
import se.prediktera.map.plot.layout.PlotWindowInterface;
import se.prediktera.map.plot.layout.SwitchTextBox;
import se.prediktera.map.plot.layout.TextBoxProperties;

public abstract class AbstractPlotLayout
extends AbstractPlot
implements MouseMotionListener {
    public static final int MAXLAYERS = 2;
    public static final byte NONE = -1;
    public static final byte TEXTBOX = 0;
    public static final byte SHAPERECT = 1;
    public static final byte SHAPEELLIPSE = 2;
    public static final byte SHAPELINE = 3;
    public static final byte SHAPELINEUP = 4;
    public static final byte LEGEND = 5;
    public static final byte IMAGE = 6;
    public static final String[] SHAPES = new String[]{"none", "n/a", "rectangular", "ellipse", "line", "", "", "image"};
    private static final int[] resizeCursors = new int[]{6, 8, 7, 10, 11, 4, 9, 5, 10, 9, 11, 8};
    protected FloatMainWindow floatPlotWindow;
    private ArrayList<PlotWindowInterface> selectedWindows = new ArrayList();
    private int resizeCorner = -1;
    private boolean beginDrag = false;
    private boolean layoutEnable = false;
    private byte createFloatWindow = (byte)-1;
    private Point firstPoint;
    private Point lastPoint;
    private Dimension lastDimension = null;
    private ArrayList<Vector<PlotWindowInterface>> layerVector = new ArrayList(2);
    private PlotLayoutToolbar layoutToolbar = new PlotLayoutToolbar(this, this.windowButtonGroup);
    private ComponentListener compListener = null;
    private final JPanel floatPanel = new FloatPanel();
    private boolean antiAliased = true;
    private boolean valueRenderQuality = true;
    private Timer windowSizeChangeTimer = null;

    private static boolean cornerInsideRect(double d, double d2, Point point, Point point2) {
        int n = point.x < point2.x ? point.x : point2.x;
        int n2 = point.y < point2.y ? point.y : point2.y;
        int n3 = point2.x < point.x ? point.x : point2.x;
        int n4 = point2.y < point.y ? point.y : point2.y;
        return d >= (double)n && d < (double)n3 && d2 >= (double)n2 && d2 < (double)n4;
    }

    private static void drawTextBox(Graphics2D graphics2D, Point point, Point point2, byte by) {
        int n = point.x < point2.x ? point.x : point2.x;
        int n2 = point.y < point2.y ? point.y : point2.y;
        int n3 = point2.x < point.x ? point.x : point2.x;
        int n4 = point2.y < point.y ? point.y : point2.y;
        switch (by) {
            case 0: 
            case 3: {
                graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                graphics2D.drawRect(n, n2, n3 - n, n4 - n2);
                break;
            }
            case 2: {
                graphics2D.drawOval(n, n2, n3 - n, n4 - n2);
            }
        }
    }

    private static void sortVector(Vector<PlotWindowInterface> vector, PlotWindowInterface plotWindowInterface) {
        for (int i = 0; i < vector.size(); ++i) {
            PlotWindowInterface plotWindowInterface2 = vector.elementAt(i);
            if (plotWindowInterface.getWindowLayout() == 0 || plotWindowInterface.getWindowLayout() == 1) {
                if (!(plotWindowInterface.getRelativeY() < plotWindowInterface2.getRelativeY())) continue;
                vector.insertElementAt(plotWindowInterface, 0);
                return;
            }
            if (plotWindowInterface.getWindowLayout() != 2 && plotWindowInterface.getWindowLayout() != 3 || !(plotWindowInterface.getRelativeX() < plotWindowInterface2.getRelativeX())) continue;
            vector.insertElementAt(plotWindowInterface, 0);
            return;
        }
        vector.addElement(plotWindowInterface);
    }

    public AbstractPlotLayout(Plot_GUI plot_GUI, PlotInit plotInit) {
        super(plot_GUI, plotInit);
        if (plotInit == null || plotInit.dimension == null) {
            this.init(600, 600);
        } else {
            this.init(plotInit.dimension.width, plotInit.dimension.height);
        }
    }

    public AbstractPlotLayout(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.init(mapProperty.getPropertyInt("bwidth", 600), mapProperty.getPropertyInt("bheight", 600));
        for (int i = 0; i < 2; ++i) {
            if (!mapProperty.hasProperty("fw" + i)) continue;
            int n = mapProperty.getLVByte();
            for (int j = 0; j < n; ++j) {
                PlotWindowInterface plotWindowInterface = (PlotWindowInterface)mapProperty.resolveNodeFromName(randomInputStream, "fw" + i + "-" + j);
                if (plotWindowInterface == null) continue;
                this.addLoadWindow(plotWindowInterface, i);
            }
        }
        this.floatPlotWindow = (FloatMainWindow)mapProperty.resolveNodeFromName(randomInputStream, "fwplot");
    }

    public DataTreeInterface addImageArea(ImageResource imageResource, String string) {
        return this.addImageArea(imageResource, string, null);
    }

    public DataTreeInterface addImageArea(ImageResource imageResource, String string, Properties properties) {
        FloatImageWindow floatImageWindow = new FloatImageWindow();
        floatImageWindow.setFloatImage(imageResource);
        if (properties != null && ScriptHelper.hasKey(properties, "alignment")) {
            String string2 = ScriptHelper.getProperty(properties, "alignment");
            if (string2.equalsIgnoreCase("center")) {
                floatImageWindow.setImageAlignment((byte)0);
            } else if (string2.equalsIgnoreCase("right")) {
                floatImageWindow.setImageAlignment((byte)4);
            }
        }
        return this.addArea(floatImageWindow, string);
    }

    public DataTreeInterface addImageArea(String string, String string2) {
        try {
            ImageResource imageResource = ResourceManager.loadImage(new File(string));
            return this.addImageArea(imageResource, string2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public DataTreeInterface addLayer(AbstractDataMatrix abstractDataMatrix) {
        return this.floatPlotWindow.addLayer(abstractDataMatrix);
    }

    public LegendWindow addLegend(Object[] objectArray) {
        return this.floatPlotWindow.addLegend(objectArray);
    }

    public void addShape(String string, String string2, Double[] doubleArray) {
        Color color = PerfectSpread.getColorFromString(string2);
        FloatMainWindow floatMainWindow = this.getMainWindow();
        for (int n = 2; n < SHAPES.length; n = (int)((byte)(n + 1))) {
            if (!string.equalsIgnoreCase(SHAPES[n])) continue;
            for (int i = 0; i < doubleArray.length; i += 2) {
                DescriptionTextBox descriptionTextBox = new DescriptionTextBox(0, 0);
                descriptionTextBox.setDrawLine(false);
                descriptionTextBox.setBackground(color);
                descriptionTextBox.setFloatText("");
                descriptionTextBox.setShapeType((byte)(n - 1));
                this.addWindow(descriptionTextBox, 0, 5);
                descriptionTextBox.setDimension(2.0, 2.0);
                Point point = floatMainWindow.getPointAtCoordsAt(doubleArray[i], doubleArray[i + 1]);
                point.setLocation(point.x + floatMainWindow.getX(), point.y + floatMainWindow.getY());
                descriptionTextBox.setPosition((double)point.x / (double)this.getWidth() * 100.0, (double)point.y / (double)this.getHeight() * 100.0);
            }
            return;
        }
        throw new RuntimeException("Illegal shape parameter: " + string);
    }

    public DataTreeInterface addSwitchArea(String string, String string2, String string3) {
        SwitchTextBox switchTextBox = new SwitchTextBox(string2);
        switchTextBox.setFloatText(string);
        return this.addArea(switchTextBox, string3);
    }

    public FloatWindow addTextArea(String string, String string2) {
        return this.addTextArea(string, string2, null);
    }

    public FloatWindow addTextArea(String string, String string2, Properties properties) {
        string = string.replace("\\n", "\n");
        DescriptionTextBox descriptionTextBox = new DescriptionTextBox(0, 0);
        descriptionTextBox.setDrawLine(false);
        descriptionTextBox.setFloatText(string);
        if (properties != null && ScriptHelper.hasKey(properties, "alignment")) {
            String string3 = ScriptHelper.getProperty(properties, "alignment");
            if (string3.equalsIgnoreCase("center")) {
                descriptionTextBox.setTextAlignment((byte)0);
            } else if (string3.equalsIgnoreCase("right")) {
                descriptionTextBox.setTextAlignment((byte)4);
            }
        }
        return this.addArea(descriptionTextBox, string2);
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        if (bl) {
            PlotWindowInterface plotWindowInterface = this.findWindow(point);
            if (this.layoutEnable) {
                boolean bl2 = !this.selectedWindows.isEmpty();
                boolean bl3 = false;
                for (PlotWindowInterface cleanUpInterface2 : this.selectedWindows) {
                    if (!cleanUpInterface2.isProtected()) continue;
                    bl3 = true;
                    break;
                }
                CMenuItem cMenuItem = new CMenuItem("Delete Plot Field(s)", 127);
                cMenuItem.addActionListener(actionEvent -> this.deleteSelectedFields());
                cMenuItem.setEnabled(bl2 && !bl3);
                jPopupMenu.add(cMenuItem);
                CMenuItem cMenuItem2 = new CMenuItem("Plot Field Properties", true);
                cMenuItem2.addActionListener(actionEvent -> {
                    TextBoxProperties textBoxProperties = new TextBoxProperties(this.selectedWindows);
                    textBoxProperties.showModal();
                    this.repaint();
                });
                jPopupMenu.add(cMenuItem2);
                cMenuItem2.setEnabled(bl2);
                CMenuItem cMenuItem3 = new CMenuItem("Bring to Front", true);
                cMenuItem3.addActionListener(actionEvent -> {
                    for (PlotWindowInterface plotWindowInterface : this.selectedWindows) {
                        this.setOrder(plotWindowInterface, true);
                    }
                });
                jPopupMenu.add(cMenuItem3);
                cMenuItem3.setEnabled(bl2);
                CMenuItem cMenuItem4 = new CMenuItem("Bring to Back", true);
                cMenuItem4.addActionListener(actionEvent -> {
                    for (PlotWindowInterface plotWindowInterface : this.selectedWindows) {
                        this.setOrder(plotWindowInterface, false);
                    }
                });
                jPopupMenu.add(cMenuItem4);
                cMenuItem4.setEnabled(bl2);
                jPopupMenu.addSeparator();
            }
            if (plotWindowInterface == null) {
                this.floatPlotWindow.addToPopup(project_GUI, dataTreeInterface, null, jPopupMenu, bl);
            } else {
                CMenuItem cMenuItem = new CMenuItem("Plot Field Properties", true);
                cMenuItem.addActionListener(actionEvent -> {
                    ArrayList<PlotWindowInterface> arrayList = new ArrayList<PlotWindowInterface>();
                    arrayList.add(plotWindowInterface);
                    TextBoxProperties textBoxProperties = new TextBoxProperties(arrayList);
                    textBoxProperties.showModal();
                    this.repaint();
                });
                jPopupMenu.add(cMenuItem);
                if (plotWindowInterface instanceof LegendWindow) {
                    CMenuItem cMenuItem4 = new CMenuItem("Remove Legend", 127);
                    cMenuItem4.addActionListener(actionEvent -> {
                        this.removeWindow(plotWindowInterface);
                        this.floatPlotWindow.deleteSelectedFields();
                    });
                    jPopupMenu.add(cMenuItem4);
                }
                plotWindowInterface.addToPopup(project_GUI, dataTreeInterface, null, jPopupMenu, bl);
            }
            jPopupMenu.addSeparator();
        }
        return super.addToPopup(project_GUI, dataTreeInterface, point, jPopupMenu, bl);
    }

    public void addWindow(PlotWindowInterface plotWindowInterface, int n, int n2) throws LayoutException {
        if (!(plotWindowInterface instanceof JComponent) || this.windowExists(plotWindowInterface)) {
            return;
        }
        if (n >= 0 && n < 2) {
            this.floatPanel.add((Component)((JComponent)((Object)plotWindowInterface)), "Center");
            this.addTreeNode(plotWindowInterface);
            plotWindowInterface.setWindowLayout(n2);
            this.layerVector.get(n).insertElementAt(plotWindowInterface, 0);
            plotWindowInterface.setParentBaseWindow(this);
            if (this.isCreated()) {
                plotWindowInterface.setFloatWindowCreated((Plot_GUI)this.window_gui, false);
                if (n2 == 5) {
                    plotWindowInterface.endUpdate((byte)7);
                } else {
                    plotWindowInterface.endUpdate((byte)0);
                    this.autoLayout();
                }
            }
        } else {
            throw new LayoutException("layer index exceeds MAXLAYERS = 2");
        }
    }

    public void autoLayout() {
        this.autoLayout(false);
    }

    public void autoLayout(boolean bl) {
        Vector<PlotWindowInterface> vector = new Vector<PlotWindowInterface>();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        double d4 = 1.0;
        this.beginUpdate();
        for (int i = 0; i < 5; ++i) {
            Object object;
            int n;
            vector.removeAllElements();
            for (n = 1; n >= 0; --n) {
                object = this.layerVector.get(n);
                for (int j = 0; j < ((Vector)object).size(); ++j) {
                    PlotWindowInterface plotWindowInterface = (PlotWindowInterface)((Vector)object).elementAt(j);
                    if (plotWindowInterface.getWindowLayout() != i) continue;
                    AbstractPlotLayout.sortVector(vector, plotWindowInterface);
                }
            }
            for (n = 0; n < vector.size(); ++n) {
                object = (PlotWindowInterface)vector.elementAt(n);
                if (i == 0) {
                    if (!bl) {
                        object.setRelativePosition(0.5 - 0.5 * object.getRelativeWidth(), d2);
                    }
                    d2 += object.getRelativeHeight();
                    continue;
                }
                if (i == 1) {
                    if (!bl) {
                        object.setRelativePosition(0.5 - 0.5 * object.getRelativeWidth(), d4 - object.getRelativeHeight());
                    }
                    d4 -= object.getRelativeHeight();
                    continue;
                }
                if (i == 2) {
                    if (!bl) {
                        object.setRelativePosition(d, 0.5 - 0.5 * object.getRelativeHeight());
                    }
                    d += object.getRelativeWidth();
                    continue;
                }
                if (i == 3) {
                    if (!bl) {
                        object.setRelativePosition(d3 - object.getRelativeWidth(), 0.5 - 0.5 * object.getRelativeHeight());
                    }
                    d3 -= object.getRelativeWidth();
                    continue;
                }
                object.setRelativeSize(d3 - d, d4 - d2);
                object.setRelativePosition(d, d2);
            }
        }
        this.endUpdate((byte)7);
    }

    public void beginUpdate() {
        for (int i = 1; i >= 0; --i) {
            Vector<PlotWindowInterface> vector = this.layerVector.get(i);
            for (int j = 0; j < vector.size(); ++j) {
                vector.elementAt(j).beginUpdate();
            }
        }
    }

    public void endUpdate() {
        for (int i = 1; i >= 0; --i) {
            Vector<PlotWindowInterface> vector = this.layerVector.get(i);
            for (int j = 0; j < vector.size(); ++j) {
                vector.elementAt(j).endUpdate((byte)7);
            }
        }
    }

    public void clearSelection() {
        if (this.floatPlotWindow instanceof AbstractAxisPlot) {
            ((AbstractAxisPlot)this.floatPlotWindow).clearSelection();
        }
    }

    public void copyToClipboard() throws Exception {
        this.copyToClipboard(null);
    }

    public void copyToClipboard(Properties properties) throws Exception {
        this.copyToClipboard(Double.valueOf(this.getWidth()), Double.valueOf(this.getHeight()), properties);
    }

    public void copyToClipboard(Double d, Double d2) throws Exception {
        this.copyToClipboard(d, d2, null);
    }

    public void copyToClipboard(Double d, Double d2, Properties properties) throws Exception {
        int n = 1;
        boolean bl = true;
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "scale")) {
                n = ScriptHelper.getPropertyInt(properties, "scale");
            }
            if (ScriptHelper.hasKey(properties, "includeselection")) {
                bl = ScriptHelper.getPropertyBool(properties, "includeselection");
            }
        }
        BufferedImage bufferedImage = this.makeBufferedImageScreenShot(d.intValue() * n, d2.intValue() * n, bl);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new ImgSel(bufferedImage), null);
    }

    public ImageDataClass createImage(ProgressManager progressManager, Double d, Double d2) throws Exception {
        return this.createImage(progressManager, d, d2, null);
    }

    public ImageDataClass createImage(ProgressManager progressManager, Double d, Double d2, Properties properties) throws Exception {
        BufferedImage bufferedImage = this.createImageLocal(progressManager, d, d2, properties);
        return new ImageDataClass(this.getPlotInit().getDataTreeInterface(), bufferedImage);
    }

    public void createWindow(byte by) {
        this.createFloatWindow = by;
    }

    @Override
    public boolean doInteraction(InteractionInterface interactionInterface) {
        boolean bl = false;
        if (this.floatPlotWindow instanceof InteractionInterface && interactionInterface != this.floatPlotWindow) {
            bl = ((InteractionInterface)((Object)this.floatPlotWindow)).doInteraction(interactionInterface);
        }
        this.doSelectionDialogInteraction(interactionInterface);
        return bl;
    }

    public void endUpdate(byte by) {
        for (int i = 1; i >= 0; --i) {
            Vector<PlotWindowInterface> vector = this.layerVector.get(i);
            for (int j = 0; j < vector.size(); ++j) {
                vector.elementAt(j).endUpdate(by);
            }
        }
    }

    @Override
    public void finishInteraction() {
        if (this.floatPlotWindow instanceof InteractionInterface) {
            ((InteractionInterface)((Object)this.floatPlotWindow)).finishInteraction();
        }
    }

    @Override
    public Object get(String string) {
        FloatWindow floatWindow;
        DataTreeInterface dataTreeInterface = null;
        PlotInit plotInit = this.getPlotInit();
        DataTreeInterface dataTreeInterface2 = plotInit.getDataTreeInterface();
        if (string.equalsIgnoreCase("data") || string.equalsIgnoreCase("matrix")) {
            dataTreeInterface = dataTreeInterface2;
        }
        if (string.equalsIgnoreCase("dataset")) {
            dataTreeInterface = DataTreeManager.getAncestorNull(dataTreeInterface2, DataSet.class);
        }
        if (string.equalsIgnoreCase("datasettype")) {
            DataSet dataSet = (DataSet)DataTreeManager.getAncestorNull(dataTreeInterface2, DataSet.class);
            if (dataSet != null) {
                return dataSet.get("type");
            }
            return "Standard";
        }
        if (string.equalsIgnoreCase("selection")) {
            return this.getInteractionArray(((AbstractAxisPlot)this.floatPlotWindow).getPrimaryMatrixTag());
        }
        if (string.equalsIgnoreCase("objects")) {
            return ((AbstractAxisPlot)this.floatPlotWindow).getNrObjects();
        }
        if (string.equalsIgnoreCase("type")) {
            return this.getDefaultTitle();
        }
        if (string.equalsIgnoreCase("title") && (floatWindow = this.getArea("title")) instanceof FloatTextWindow) {
            return ((FloatTextWindow)floatWindow).getFloatText();
        }
        if (dataTreeInterface != null) {
            return dataTreeInterface;
        }
        return super.get(string);
    }

    public Object getAntiAliasHint() {
        if (this.isAntiAliased()) {
            return RenderingHints.VALUE_ANTIALIAS_ON;
        }
        return RenderingHints.VALUE_ANTIALIAS_OFF;
    }

    public FloatWindow getArea(String string) {
        return null;
    }

    @Override
    public String getInformation() {
        return this.floatPlotWindow.getInformation();
    }

    public InteractionArray getInteractionArray(int n) {
        int n2 = this.getPlotInit().getGroupID();
        return this.project_GUI.getInteractionArray(n, n2);
    }

    public AbstractAxisLayer getLayer(Double d) {
        if (this.floatPlotWindow != null) {
            return this.floatPlotWindow.getLayer(d);
        }
        return null;
    }

    public FloatMainWindow getMainWindow() {
        return this.floatPlotWindow;
    }

    public Object getRenderingQualityHint() {
        if (this.valueRenderingQuality()) {
            return RenderingHints.VALUE_RENDER_QUALITY;
        }
        return RenderingHints.VALUE_RENDER_SPEED;
    }

    @Override
    public String getScript() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.getScript());
        stringBuilder.append(this.floatPlotWindow.getScript());
        return stringBuilder.toString();
    }

    @Override
    public JPanel getSettingsPanel() {
        if (this.floatPlotWindow == null) {
            return null;
        }
        return this.floatPlotWindow.getSettingsPanel();
    }

    @Override
    public void getToolbars(Vector<JToolBar> vector) {
        super.getToolbars(vector);
        vector.add(this.layoutToolbar);
        if (this.floatPlotWindow != null) {
            this.floatPlotWindow.getToolbars(vector);
        }
    }

    public boolean hasWindow(PlotWindowInterface plotWindowInterface) {
        for (int i = 0; i < this.floatPanel.getComponentCount(); ++i) {
            if (!this.floatPanel.getComponent(i).equals(plotWindowInterface)) continue;
            return true;
        }
        return false;
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public boolean isLayoutEnable() {
        return this.layoutEnable;
    }

    public Object[] list(String string) throws Exception {
        Object[] objectArray;
        if (this.floatPlotWindow instanceof AbstractAxisPlot && (objectArray = ((AbstractAxisPlot)this.floatPlotWindow).list(string)) != null) {
            return objectArray;
        }
        throw new Exception("Cannot find data with name: " + string);
    }

    @Override
    public void makeScreenShot(Graphics2D graphics2D, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        Vector<PlotWindowInterface> vector;
        int n4;
        if (this.floatPlotWindow instanceof AbstractAxisPlot) {
            ((AbstractAxisPlot)this.floatPlotWindow).setRangesLocked(true);
        }
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        repaintManager.setDoubleBufferingEnabled(false);
        this.initGraphics(graphics2D);
        Color color = this.getBackground();
        if (color != null && color.getAlpha() > 0) {
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, n, n2);
        }
        boolean bl4 = n != this.getWidth() || n2 != this.getHeight();
        double d = (double)n / (double)this.getWidth();
        double d2 = (double)n2 / (double)this.getHeight();
        if (bl4) {
            for (n4 = 0; n4 < 2; ++n4) {
                vector = this.layerVector.get(n4);
                for (n3 = vector.size() - 1; n3 >= 0; --n3) {
                    vector.elementAt(n3).virtualResize(d, d2);
                }
            }
        }
        for (n4 = 0; n4 < 2; ++n4) {
            vector = this.layerVector.get(n4);
            for (n3 = vector.size() - 1; n3 >= 0; --n3) {
                vector.elementAt(n3).makeScreenShot(graphics2D, bl, bl3);
            }
        }
        if (bl4) {
            for (n4 = 0; n4 < 2; ++n4) {
                vector = this.layerVector.get(n4);
                for (n3 = vector.size() - 1; n3 >= 0; --n3) {
                    vector.elementAt(n3).virtualResize(1.0 / d, 1.0 / d2);
                }
            }
        }
        repaintManager.setDoubleBufferingEnabled(true);
        if (this.floatPlotWindow instanceof AbstractAxisPlot) {
            ((AbstractAxisPlot)this.floatPlotWindow).setRangesLocked(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (this.layoutEnable && SwingUtilities.isLeftMouseButton(mouseEvent) && this.resizeCorner == -1) {
            PlotWindowInterface plotWindowInterface = this.findWindow(this.firstPoint);
            if (!mouseEvent.isControlDown()) {
                for (PlotWindowInterface plotWindowInterface2 : this.selectedWindows) {
                    plotWindowInterface2.setSelected(false);
                }
                this.selectedWindows.clear();
            }
            if (this.selectedWindows.contains(plotWindowInterface)) {
                plotWindowInterface.setSelected(false);
                this.selectedWindows.remove(plotWindowInterface);
            } else if (plotWindowInterface != null) {
                plotWindowInterface.setSelected(true);
                this.selectedWindows.add(plotWindowInterface);
            }
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            if (this.layoutEnable && this.firstPoint != null) {
                Point point = mouseEvent.getPoint();
                int n = point.x - this.firstPoint.x;
                int n2 = point.y - this.firstPoint.y;
                boolean bl = false;
                for (PlotWindowInterface plotWindowInterface : this.selectedWindows) {
                    if (!this.beginDrag) {
                        plotWindowInterface.beginDrag();
                    }
                    if (!(bl = this.resizeCorner == -1 ? plotWindowInterface.tryMove(n, n2) : plotWindowInterface.tryResize(this.resizeCorner, n, n2))) continue;
                    plotWindowInterface.startFloated(graphics2D, this.getBackground());
                    if (this.beginDrag) {
                        plotWindowInterface.paintFloated(graphics2D);
                    }
                    plotWindowInterface.doChange();
                    plotWindowInterface.paintFloated(graphics2D);
                    plotWindowInterface.endFloated(graphics2D);
                }
                if (bl) {
                    this.beginDrag = true;
                }
            }
            if (!this.layoutEnable && this.createFloatWindow != -1 || this.layoutEnable && !this.beginDrag) {
                byte by = this.createFloatWindow;
                if (this.layoutEnable && !this.beginDrag) {
                    by = 1;
                    graphics2D.setStroke(AbstractRubberband.robberStroke);
                }
                graphics2D.setXORMode(this.getBackground());
                if (this.firstPoint != null) {
                    if (this.lastPoint != null) {
                        AbstractPlotLayout.drawTextBox(graphics2D, this.firstPoint, this.lastPoint, by);
                    }
                    this.lastPoint = mouseEvent.getPoint();
                    if (this.lastPoint != null) {
                        AbstractPlotLayout.drawTextBox(graphics2D, this.firstPoint, this.lastPoint, by);
                    }
                }
            }
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
        mouseEvent.consume();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.layoutEnable && !this.beginDrag) {
            this.resizeCorner = -1;
            for (PlotWindowInterface plotWindowInterface : this.selectedWindows) {
                this.resizeCorner = plotWindowInterface.getCorner(mouseEvent.getPoint());
                if (this.resizeCorner == -1) continue;
                break;
            }
            if (this.resizeCorner == -1) {
                this.setCursorAll(Cursor.getDefaultCursor());
            } else {
                this.setCursorAll(Cursor.getPredefinedCursor(resizeCursors[this.resizeCorner]));
            }
        }
        mouseEvent.consume();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.firstPoint = mouseEvent.getPoint();
        }
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (this.layoutEnable && this.beginDrag && !this.selectedWindows.isEmpty()) {
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            for (PlotWindowInterface j : this.selectedWindows) {
                j.startFloated(graphics2D, this.getBackground());
                j.paintFloated(graphics2D);
                j.endFloated(graphics2D);
                if (!j.acceptDrag()) continue;
                j.componentResized(1.0, 1.0, true, true);
            }
            graphics2D.dispose();
            this.repaint();
            this.setCursorAll(Cursor.getDefaultCursor());
            this.beginDrag = false;
        } else if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (!this.layoutEnable && this.createFloatWindow != -1 && this.firstPoint != null) {
                try {
                    FloatWindow floatWindow = null;
                    switch (this.createFloatWindow) {
                        case 0: {
                            floatWindow = this.floatPlotWindow.createDescriptionTextBox(mouseEvent.getPoint(), this.firstPoint);
                            break;
                        }
                        case 6: {
                            floatWindow = new FloatTextWindow(this.firstPoint, mouseEvent.getPoint(), this.createFloatWindow);
                            PlotZoneImage plotZoneImage = new PlotZoneImage(null, 0, 1.0, 1.0, false);
                            FileDataClass fileDataClass = (FileDataClass)EvinceScriptCommands.showInputDialog(null, "image", "Select image");
                            plotZoneImage.setImage(ResourceManager.loadImage(fileDataClass.getFile()));
                            floatWindow.addPlotZone(plotZoneImage, 1);
                            floatWindow.addTreeNode(plotZoneImage);
                            break;
                        }
                        case 5: {
                            floatWindow = new LegendWindow(this, this.firstPoint);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            floatWindow = new FloatTextWindow(this.firstPoint, mouseEvent.getPoint(), this.createFloatWindow);
                        }
                    }
                    if (floatWindow == null) {
                        this.repaint();
                    } else {
                        this.addWindow(floatWindow, 1, 5);
                        if (this.createFloatWindow == 0) {
                            this.floatPlotWindow.addDescriptionTextBox((DescriptionTextBox)floatWindow);
                        }
                    }
                }
                catch (Exception exception) {
                    ErrorHandler.logAndReportException(exception);
                }
            } else if (this.layoutEnable && this.firstPoint != null) {
                for (PlotWindowInterface object : this.selectedWindows) {
                    object.setSelected(false);
                }
                this.selectedWindows.clear();
                for (int i = 1; i >= 0; --i) {
                    Vector<PlotWindowInterface> vector = this.layerVector.get(i);
                    for (int j = vector.size() - 1; j >= 0; --j) {
                        PlotWindowInterface plotWindowInterface = vector.elementAt(j);
                        if (!AbstractPlotLayout.cornerInsideRect(plotWindowInterface.getTryOrigoX(), plotWindowInterface.getTryOrigoY(), this.firstPoint, mouseEvent.getPoint()) || !AbstractPlotLayout.cornerInsideRect(plotWindowInterface.getTryOrigoX(), plotWindowInterface.getTryOrigoY() + plotWindowInterface.getTryHeight(), this.firstPoint, mouseEvent.getPoint()) || !AbstractPlotLayout.cornerInsideRect(plotWindowInterface.getTryOrigoX() + plotWindowInterface.getTryWidth(), plotWindowInterface.getTryOrigoY() + plotWindowInterface.getTryHeight(), this.firstPoint, mouseEvent.getPoint()) || !AbstractPlotLayout.cornerInsideRect(plotWindowInterface.getTryOrigoX() + plotWindowInterface.getTryWidth(), plotWindowInterface.getTryOrigoY(), this.firstPoint, mouseEvent.getPoint())) continue;
                        plotWindowInterface.setSelected(true);
                        this.selectedWindows.add(plotWindowInterface);
                    }
                }
                this.repaint();
            }
        }
        this.lastPoint = null;
        mouseEvent.consume();
    }

    @Override
    public void nodeReplaced(DataTreeEvent dataTreeEvent) {
        super.nodeReplaced(dataTreeEvent);
        if (this.floatPlotWindow != null) {
            this.floatPlotWindow.nodeReplaced(dataTreeEvent);
        }
    }

    @Override
    public void prepareInteraction() {
        if (this.floatPlotWindow instanceof InteractionInterface) {
            ((InteractionInterface)((Object)this.floatPlotWindow)).prepareInteraction();
            this.doSelectionDialogInteraction(this);
        }
    }

    public void refresh() {
        for (int i = 0; this.layerVector != null && i < 2; ++i) {
            if (this.layerVector.get(i) == null) continue;
            Vector<PlotWindowInterface> vector = this.layerVector.get(i);
            for (int j = vector.size() - 1; j >= 0; --j) {
                PlotWindowInterface plotWindowInterface = vector.elementAt(j);
                if (plotWindowInterface == this.floatPlotWindow) continue;
                plotWindowInterface.contentPaint((byte)7);
            }
        }
    }

    public void removeArea(FloatWindow floatWindow) {
        this.removeWindow(floatWindow);
        this.floatPlotWindow.removeArea(floatWindow);
    }

    public void removeArea(String string) {
        FloatWindow floatWindow = this.getArea(string);
        this.removeArea(floatWindow);
        try {
            this.floatPlotWindow.removeArea(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void removeWindow(PlotWindowInterface plotWindowInterface) {
        if (plotWindowInterface instanceof JComponent && this.layerVector != null && this.windowExists(plotWindowInterface)) {
            for (int i = 0; i < 2; ++i) {
                Vector<PlotWindowInterface> vector = this.layerVector.get(i);
                if (vector == null) continue;
                vector.removeElement(plotWindowInterface);
            }
            this.selectedWindows.remove(plotWindowInterface);
            this.floatPanel.remove((JComponent)((Object)plotWindowInterface));
            this.removeTreeNode(plotWindowInterface);
            this.floatPlotWindow.removeDescriptionTextBox(plotWindowInterface);
            if (plotWindowInterface.getWindowLayout() != 5) {
                this.autoLayout();
            }
            this.repaint();
            plotWindowInterface.cleanUp();
        }
    }

    public FileDataClass save(ProgressManager progressManager, String string, String string2) {
        return this.save(progressManager, string, string2, null, null);
    }

    public FileDataClass save(ProgressManager progressManager, String string, String string2, Double d, Double d2) {
        try {
            return this.save(progressManager, string, string2, d, d2, null);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public FileDataClass save(ProgressManager progressManager, String string, String string2, Double d, Double d2, Properties properties) throws Exception {
        File file = new File(string);
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new Exception("Cannot create file path: " + file.getAbsolutePath());
        }
        BufferedImage bufferedImage = this.createImageLocal(progressManager, d, d2, properties);
        PlotPopupMenu.save(bufferedImage, file, string2);
        return new FileDataClass(file);
    }

    public InteractionArray select(Object[] objectArray) {
        FloatMainWindow floatMainWindow = this.floatPlotWindow;
        if (floatMainWindow instanceof AbstractAxisPlot) {
            AbstractAxisPlot abstractAxisPlot = (AbstractAxisPlot)floatMainWindow;
            return PlotSelectionHelper.select(abstractAxisPlot, objectArray);
        }
        return null;
    }

    public Double[] getSelection() {
        FloatMainWindow floatMainWindow = this.floatPlotWindow;
        if (floatMainWindow instanceof AbstractAxisPlot) {
            AbstractAxisPlot abstractAxisPlot = (AbstractAxisPlot)floatMainWindow;
            return PlotSelectionHelper.get(abstractAxisPlot);
        }
        return null;
    }

    @Override
    public byte SendGlobalMessage(byte by, byte by2) {
        switch (by) {
            case 3: {
                return this.layoutToolbar.sendGlobalMessage(by2);
            }
            case 0: {
                for (int i = 1; i >= 0; --i) {
                    Vector<PlotWindowInterface> vector = this.layerVector.get(i);
                    for (int j = 0; j < vector.size(); ++j) {
                        if (vector.elementAt(j).SendGlobalMessage(by, by2) != 2) continue;
                        return 2;
                    }
                }
                break;
            }
            case 5: 
            case 6: {
                if (this.layerVector != null && !this.isCleaned()) {
                    for (int i = 1; i >= 0; --i) {
                        if (this.layerVector == null) continue;
                        Vector<PlotWindowInterface> vector = this.layerVector.get(i);
                        for (int j = 0; j < vector.size(); ++j) {
                            vector.elementAt(j).SendGlobalMessage(by, by2);
                        }
                    }
                }
                if (by == 6) {
                    this.floatPlotWindow.SendGlobalMessage(by, by2);
                }
                return 1;
            }
        }
        return this.floatPlotWindow.SendGlobalMessage(by, by2);
    }

    @Override
    public void set(String string, Object object) {
        if (string.equalsIgnoreCase("root")) {
            PlotInit plotInit = this.getPlotInit();
            plotInit.setDataTreeInterface((DataTreeInterface)object);
        } else {
            super.set(string, object);
        }
    }

    public void setAntiAliasing(boolean bl) {
        this.antiAliased = bl;
    }

    public void setAxisLabel(Object[] objectArray) throws Exception {
        this.floatPlotWindow.setSettingBoxOption((byte)15, objectArray);
    }

    public void setBackgroundColor(Color color) {
        this.setBackground(color);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 > 0 && n4 > 0) {
            super.setBounds(n, n2, n3, n4);
            return;
        }
        super.setBounds(n, n2, 1, 1);
    }

    public void setColor(Object[] objectArray) {
        if (this.floatPlotWindow != null) {
            this.floatPlotWindow.setSettingBoxOption((byte)3, objectArray);
        }
    }

    public void setComment(Object[] objectArray) {
        this.floatPlotWindow.setSettingBoxOption((byte)10, objectArray);
    }

    @Override
    public void setContentReady(boolean bl) {
        this.setContentReady(bl, true);
    }

    public void setContentReady(boolean bl, boolean bl2) {
        if (this.floatPlotWindow != null) {
            this.floatPlotWindow.setContentReady(bl);
            super.setContentReady(bl);
            if (bl && bl2) {
                if (this.floatPlotWindow instanceof AbstractAxisPlot) {
                    ((AbstractAxisPlot)this.floatPlotWindow).calculateBuildAndRepaint();
                } else {
                    this.floatPlotWindow.contentPaint((byte)7);
                }
            }
        }
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        this.setCreated(null, abstractWindow_GUI, bl);
        if (this.hasInteractivity() && this.doInteraction(this)) {
            this.finishInteraction();
        }
    }

    public void setCreated(ProgressManager progressManager, AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        if (!this.isCreated()) {
            AbstractScriptInfo abstractScriptInfo;
            Vector<PlotWindowInterface> vector;
            super.setCreated(abstractWindow_GUI, bl);
            if (this.floatPlotWindow != null) {
                int n;
                int n2;
                this.baseResized();
                for (n2 = 1; n2 >= 0; --n2) {
                    vector = this.layerVector.get(n2);
                    for (n = 0; n < vector.size(); ++n) {
                        vector.elementAt(n).setFloatWindowCreated((Plot_GUI)abstractWindow_GUI, bl);
                    }
                }
                if (!bl) {
                    this.autoLayout();
                }
                for (n2 = 1; n2 >= 0; --n2) {
                    vector = this.layerVector.get(n2);
                    for (n = 0; n < vector.size(); ++n) {
                        vector.elementAt(n).endUpdate((byte)7);
                    }
                }
            }
            if (this.init != null && this.init.scriptInfo != null && ((String)((Object)(vector = (abstractScriptInfo = this.init.scriptInfo).getScript()))).length() > 0) {
                try {
                    if (progressManager == null) {
                        progressManager = new ProgressManagerImpl(this){

                            @Override
                            public Object doWork() {
                                return null;
                            }
                        };
                    }
                    ScriptManager scriptManager = new ScriptManager(null);
                    scriptManager.addVariable(this, abstractWindow_GUI.getGUI_Name().toLowerCase());
                    scriptManager.evaluteScript(progressManager, (String)((Object)vector));
                }
                catch (Exception exception) {
                    ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
                }
            }
        }
    }

    public void setCursorAll(Cursor cursor) {
        this.setCursor(cursor);
        for (int i = 1; i >= 0; --i) {
            Vector<PlotWindowInterface> vector = this.layerVector.get(i);
            for (int j = 0; j < vector.size(); ++j) {
                vector.elementAt(j).setCursor(cursor);
            }
        }
        if (this.associatedFrame != null) {
            this.associatedFrame.getRootPane().registerKeyboardAction(actionEvent -> this.deleteSelectedFields(), KeyStroke.getKeyStroke(127, 0), 2);
        }
    }

    public void setDataRange(Object[] objectArray) {
        if (objectArray.length == 0) {
            throw new RuntimeException("Invalid number of arguments");
        }
        byte by = this.getAxisSettingsBox(objectArray[0].toString());
        Object[] objectArray2 = new Object[objectArray.length - 1];
        System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
        if (this.floatPlotWindow != null) {
            this.floatPlotWindow.setSettingBoxOption(by, objectArray2);
        }
    }

    private byte getAxisSettingsBox(String string) {
        int n;
        if (string.equalsIgnoreCase("X")) {
            n = 0;
        } else if (string.equalsIgnoreCase("Y")) {
            n = 1;
        } else if (string.equalsIgnoreCase("Z")) {
            n = 2;
        } else if (string.equalsIgnoreCase("Range")) {
            n = 9;
        } else {
            throw new RuntimeException("Invalid axis arguments: " + string + ", should be X, Y, Z or Range");
        }
        return (byte)n;
    }

    public void setGridColor(Color color) {
        if (this.floatPlotWindow instanceof AbstractAxisPlot) {
            ((AbstractAxisPlot)this.floatPlotWindow).setGridColor(color);
        }
    }

    @Override
    public void setInteractionFlag(byte by) {
        if (this.floatPlotWindow instanceof InteractionInterface) {
            ((InteractionInterface)((Object)this.floatPlotWindow)).setInteractionFlag(by);
        }
        super.setInteractionFlag(by);
    }

    public void setLabel(Object[] objectArray) {
        this.floatPlotWindow.setSettingBoxOption((byte)6, objectArray);
    }

    public void setLayerOrder(AbstractAxisLayer abstractAxisLayer, Double[] doubleArray) {
        this.floatPlotWindow.setLayerOrder(abstractAxisLayer, doubleArray);
    }

    public void setLayoutEnable(boolean bl) {
        this.layoutEnable = bl;
        for (PlotWindowInterface plotWindowInterface : this.selectedWindows) {
            plotWindowInterface.setSelected(bl);
        }
        this.repaint();
    }

    public LegendWindow setLegend(Object[] objectArray) {
        return this.addLegend(objectArray);
    }

    public void setLine(Object[] objectArray) {
        this.floatPlotWindow.setSettingBoxOption((byte)7, objectArray);
    }

    public void setPlotBackgroundColor(Color color) {
        if (this.floatPlotWindow instanceof AbstractAxisPlot) {
            ((AbstractAxisPlot)this.floatPlotWindow).setPlotBgColor(color);
        }
    }

    public void setPlotInitTitle(String string) {
        this.getPlotInit().title = string;
        this.getPlot_GUI().selectedWindowUpdated(this);
        this.getProject_GUI().repaint();
    }

    public void setPlotTitle(String string) {
    }

    public void setSelectionColor(String string, Properties properties) {
        if (this.floatPlotWindow instanceof AbstractAxisPlot) {
            this.floatPlotWindow.setSelectionColor(string, properties);
        }
    }

    public void setSelectionTool(String string) {
        FloatMainWindow floatMainWindow = this.getMainWindow();
        floatMainWindow.setPanview(false);
        floatMainWindow.setSelectionTool(string);
    }

    public void setZoomTool(byte by) {
        FloatMainWindow floatMainWindow = this.getMainWindow();
        floatMainWindow.setPanview(false);
        floatMainWindow.setSelectionTool("none");
        if (by == -1) {
            floatMainWindow.zoomAll();
        } else if (by == 5) {
            floatMainWindow.setPanview(true);
        } else {
            floatMainWindow.setZooming(by);
        }
    }

    public void setShape(Object[] objectArray) {
        this.floatPlotWindow.setSettingBoxOption((byte)5, objectArray);
    }

    public void setSize(Object[] objectArray) {
        this.floatPlotWindow.setSettingBoxOption((byte)4, objectArray);
    }

    public void setStatistics(Object[] objectArray) {
        this.floatPlotWindow.setSettingBoxOption((byte)13, objectArray);
    }

    public Object getSettingBoxSelectedItem(byte by) {
        return this.floatPlotWindow.getSettingBoxSelectedItem(by);
    }

    public void setTextColor(Color color) {
        this.setTextColor(color, null);
    }

    public void setTextColor(Color color, Properties properties) {
        if (this.floatPlotWindow instanceof AbstractAxisPlot) {
            ((AbstractAxisPlot)this.floatPlotWindow).setAxisColor(color);
        }
    }

    public void setTitle(String string) {
        string = string.replace("\\n", "\n");
        this.setPlotTitle(string);
    }

    public void setupInteractionBetweenComboBoxes(byte by) {
        PlotAxisLayerPanel plotAxisLayerPanel = (PlotAxisLayerPanel)this.getSettingsPanel();
        LinkedList<AbstractAxisLayer> linkedList = new LinkedList<AbstractAxisLayer>();
        if (plotAxisLayerPanel.getLayerCount() <= 1) {
            return;
        }
        for (int i = 0; i < plotAxisLayerPanel.getLayerCount(); ++i) {
            linkedList.add(plotAxisLayerPanel.getMainLayer(i));
        }
        for (AbstractAxisLayer abstractAxisLayer : linkedList) {
            for (AbstractAxisLayer abstractAxisLayer2 : linkedList) {
                if (abstractAxisLayer == abstractAxisLayer2) continue;
                Map<Byte, AbstractPlotSettingsBox> map = abstractAxisLayer.getSettingsBoxMap();
                Map<Byte, AbstractPlotSettingsBox> map2 = abstractAxisLayer2.getSettingsBoxMap();
                AbstractPlotSettingsBox abstractPlotSettingsBox = map.get(by);
                AbstractPlotSettingsBox abstractPlotSettingsBox2 = map2.get(by);
                if (abstractPlotSettingsBox == null || abstractPlotSettingsBox2 == null) {
                    return;
                }
                abstractPlotSettingsBox.addItemListener(itemEvent -> {
                    int n = ((JComboBoxCell)itemEvent.getSource()).getSelectedIndex();
                    if (abstractPlotSettingsBox2.getSelectedIndex() != n) {
                        abstractPlotSettingsBox2.setSelectedIndex(n);
                    }
                });
            }
        }
    }

    public void setValueRenderingQuality(boolean bl) {
        this.valueRenderQuality = bl;
    }

    public void setXaxisDateFormat(SimpleDateFormat simpleDateFormat) {
        if (this.floatPlotWindow != null) {
            this.floatPlotWindow.setXaxisDateFormat(simpleDateFormat);
        }
    }

    public void show(String string, Double d) {
        if (this.floatPlotWindow instanceof AbstractAxisPlot) {
            ((AbstractAxisPlot)this.floatPlotWindow).show(string, d);
        }
    }

    @Override
    public boolean supportSVG() {
        return !(this.floatPlotWindow instanceof FloatWindowContour2D);
    }

    public void updateLegends() {
        for (int i = 0; this.layerVector != null && i < 2; ++i) {
            if (this.layerVector.get(i) == null) continue;
            Vector<PlotWindowInterface> vector = this.layerVector.get(i);
            for (int j = vector.size() - 1; j >= 0; --j) {
                PlotWindowInterface plotWindowInterface = vector.elementAt(j);
                if (!(plotWindowInterface instanceof LegendWindow)) continue;
                ((LegendWindow)plotWindowInterface).contentPaint((byte)7);
            }
        }
    }

    public void updateAllWindows() {
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof FloatTextWindow) && !(dataTreeInterface instanceof LegendWindow)) continue;
            ((FloatWindow)dataTreeInterface).contentPaint((byte)7);
        }
    }

    public boolean valueRenderingQuality() {
        return this.valueRenderQuality;
    }

    @Override
    public void windowChangeSizeEvent() {
        this.windowSizeChangeTimer.restart();
    }

    public boolean windowExists(PlotWindowInterface plotWindowInterface) {
        for (int i = 1; i >= 0; --i) {
            Vector<PlotWindowInterface> vector = this.layerVector.get(i);
            for (int j = 0; j < vector.size(); ++j) {
                if (!vector.elementAt(j).equals(plotWindowInterface)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void cleanUpChild() {
        if (this.compListener != null) {
            this.removeComponentListener(this.compListener);
            this.compListener = null;
        }
        super.cleanUpChild();
        if (this.layerVector != null) {
            for (int i = 0; i < 2; ++i) {
                this.layerVector.get(i).removeAllElements();
            }
        }
        this.layerVector = null;
        if (this.floatPlotWindow != null) {
            this.floatPlotWindow.cleanUp();
            this.floatPlotWindow = null;
        }
        this.selectedWindows.clear();
        this.selectedWindows = null;
        if (this.layoutToolbar != null) {
            this.layoutToolbar.cleanUp();
            this.layoutToolbar = null;
        }
    }

    @Override
    protected boolean handleDirectPrintout() {
        return this.floatPlotWindow.handleDirectPrintout();
    }

    @Override
    protected void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyInt("bwidth", this.getWidth());
        randomOutputStream.writePropertyInt("bheight", this.getHeight());
        for (int i = 0; i < 2; ++i) {
            Vector<PlotWindowInterface> vector = this.layerVector.get(i);
            randomOutputStream.writePropertyByte("fw" + i, (byte)vector.size());
            for (int j = vector.size() - 1; j >= 0; --j) {
                randomOutputStream.writePropertyInt("fw" + i + "-" + j, vector.elementAt(j).getID());
            }
        }
        randomOutputStream.writePropertyNode("fwplot", this.floatPlotWindow);
    }

    private FloatWindow addArea(FloatWindow floatWindow, String string) {
        int n = -1;
        string = string.toLowerCase();
        for (int i = 0; i < ZoneRelativeLayout.LAYOUT.length; ++i) {
            if (!ZoneRelativeLayout.LAYOUT[i].equals(string)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new RuntimeException("Illegal layout parameter: " + string);
        }
        this.addWindow(floatWindow, 0, n);
        return floatWindow;
    }

    private void addLoadWindow(PlotWindowInterface plotWindowInterface, int n) {
        this.layerVector.get(n).addElement(plotWindowInterface);
        plotWindowInterface.setParentBaseWindow(this);
        this.floatPanel.add((Component)((JComponent)((Object)plotWindowInterface)), "Center");
        plotWindowInterface.contentPaint((byte)7);
    }

    public synchronized boolean baseResized() {
        double d = 1.0;
        double d2 = 1.0;
        Dimension dimension = this.floatPanel.getSize();
        if (dimension.getWidth() > 0.0 && dimension.getHeight() > 0.0 && (Double.compare(dimension.getHeight(), this.lastDimension.getHeight()) != 0 || Double.compare(dimension.getWidth(), this.lastDimension.getWidth()) != 0)) {
            d = this.getSize().getWidth() / this.lastDimension.getWidth();
            if (Double.isInfinite(d)) {
                d = -1.0;
            }
            if (Double.isInfinite(d2 = this.getSize().getHeight() / this.lastDimension.getHeight())) {
                d2 = -1.0;
            }
            if (d > 0.0 && d2 > 0.0) {
                for (int i = 1; i >= 0; --i) {
                    if (this.layerVector == null) continue;
                    Vector<PlotWindowInterface> vector = this.layerVector.get(i);
                    for (int j = vector.size() - 1; j >= 0; --j) {
                        PlotWindowInterface plotWindowInterface = vector.elementAt(j);
                        plotWindowInterface.componentResized(d, d2, true, true);
                    }
                }
                this.lastDimension.setSize(dimension);
                if (this.window_gui != null) {
                    this.window_gui.repaint();
                }
            } else {
                this.autoLayout();
            }
            return true;
        }
        return false;
    }

    private BufferedImage createImageLocal(ProgressManager progressManager, Double d, Double d2, Properties properties) {
        if (!this.isCreated()) {
            Plot_GUI plot_GUI = this.getPlot_GUI();
            this.setCreated(progressManager, plot_GUI, false);
        }
        if (!this.isContentReady()) {
            this.setContentReady(true, false);
        }
        int n = 500;
        int n2 = 500;
        if (d != null && d2 != null) {
            n = d.intValue();
            n2 = d2.intValue();
        }
        boolean bl = false;
        if (properties != null && ScriptHelper.hasKey(properties, "includeselection")) {
            bl = ScriptHelper.getPropertyBool(properties, "includeselection");
        }
        return this.makeBufferedImageScreenShot(n, n2, bl);
    }

    private void deleteSelectedFields() {
        if (this.layoutEnable) {
            for (int i = this.selectedWindows.size() - 1; i >= 0; --i) {
                PlotWindowInterface plotWindowInterface = this.selectedWindows.get(i);
                if (plotWindowInterface.isProtected()) continue;
                this.removeWindow(plotWindowInterface);
            }
            this.floatPlotWindow.deleteSelectedFields();
        }
    }

    private PlotWindowInterface findWindow(Point point) {
        for (int i = 1; i >= 0; --i) {
            Vector<PlotWindowInterface> vector = this.layerVector.get(i);
            for (int j = 0; j < vector.size(); ++j) {
                PlotWindowInterface plotWindowInterface = vector.elementAt(j);
                if (!plotWindowInterface.isInside(point)) continue;
                return plotWindowInterface;
            }
        }
        return null;
    }

    private void init(int n, int n2) {
        for (int i = 0; i < 2; ++i) {
            this.layerVector.add(new Vector());
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.floatPanel, "Center");
        this.floatPanel.addMouseListener(this);
        this.floatPanel.addMouseMotionListener(this);
        this.floatPanel.setBackground(Color.white);
        this.setBackground(Color.white);
        this.setSize(n, n2);
        this.doLayout();
        this.setPreferredSize(new Dimension(n, n2));
        this.lastDimension = this.floatPanel.getSize();
        this.compListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (AbstractPlotLayout.this.isCreated()) {
                    AbstractPlotLayout.this.windowChangeSizeEvent();
                }
            }
        };
        this.floatPanel.addComponentListener(this.compListener);
        this.windowSizeChangeTimer = new Timer(50, actionEvent -> this.baseResized());
        this.windowSizeChangeTimer.setRepeats(false);
    }

    private void initGraphics(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.getAntiAliasHint());
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, this.getRenderingQualityHint());
    }

    private void setOrder(PlotWindowInterface plotWindowInterface, boolean bl) {
        for (int i = 1; i >= 0; --i) {
            Vector<PlotWindowInterface> vector = this.layerVector.get(i);
            int n = vector.indexOf(plotWindowInterface);
            if (n < 0) continue;
            if (bl) {
                for (var6_6 = n - 1; var6_6 >= 0; --var6_6) {
                    vector.setElementAt(vector.elementAt(var6_6), var6_6 + 1);
                }
                vector.setElementAt(plotWindowInterface, 0);
            } else {
                for (var6_6 = n + 1; var6_6 < vector.size(); ++var6_6) {
                    vector.setElementAt(vector.elementAt(var6_6), var6_6 - 1);
                }
                vector.setElementAt(plotWindowInterface, vector.size() - 1);
            }
            this.repaint();
        }
    }

    public boolean isAbsorbanceData() {
        Case case_;
        DataTreeInterface dataTreeInterface = this.getPlotInit().getDataTreeInterface();
        if (dataTreeInterface instanceof AbstractDataMatrix && (case_ = ((AbstractDataMatrix)dataTreeInterface).getCase()) != null) {
            return case_.getCalibrationType() == 1;
        }
        return false;
    }

    public AbstractModel getModel() {
        PlotInit plotInit = this.getPlotInit();
        if (plotInit != null) {
            DataTreeInterface dataTreeInterface;
            DataTreeInterface dataTreeInterface2 = plotInit.getDataTreeInterface();
            if (dataTreeInterface2 instanceof ModelMatrix) {
                ModelMatrix modelMatrix = (ModelMatrix)dataTreeInterface2;
                return modelMatrix.getModel();
            }
            if (dataTreeInterface2 != null && (dataTreeInterface = dataTreeInterface2.getTreeParent()) instanceof AbstractModel) {
                AbstractModel abstractModel = (AbstractModel)dataTreeInterface;
                return abstractModel;
            }
            if (dataTreeInterface2 != null && (dataTreeInterface = dataTreeInterface2.getTreeParent()) instanceof AbstractPrediction) {
                AbstractPrediction abstractPrediction = (AbstractPrediction)dataTreeInterface;
                return abstractPrediction.getModel();
            }
        }
        return null;
    }

    public DataSet getDataSet() {
        FloatMainWindow floatMainWindow = this.getMainWindow();
        if (floatMainWindow instanceof AbstractAxisPlot) {
            AbstractAxisPlot abstractAxisPlot = (AbstractAxisPlot)floatMainWindow;
            return abstractAxisPlot.getDataSet();
        }
        AbstractModel abstractModel = this.getModel();
        if (abstractModel != null) {
            return abstractModel.getDataSet();
        }
        return null;
    }

    public class FloatPanel
    extends JPanel {
        private boolean doPaint;

        public FloatPanel() {
            super(new BorderLayout());
            this.doPaint = true;
        }

        @Override
        public void paint(Graphics graphics) {
            if (!this.doPaint || !AbstractPlotLayout.this.isContentReady()) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(AbstractPlotLayout.this.getBackground());
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics2D.setColor(AbstractPlotLayout.this.getForeground());
                Font font = graphics2D.getFont();
                graphics2D.setFont(new Font(font.getName(), font.getStyle(), 16));
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                String string = AbstractPlotLayout.this.getContentInformation();
                if (string != null) {
                    int n = fontMetrics.stringWidth(string);
                    graphics2D.drawString(string, this.getWidth() / 2 - n / 2, this.getHeight() / 2);
                }
                return;
            }
            try {
                super.paint(graphics);
                if (!(AbstractPlotLayout.this.floatPlotWindow instanceof FloatWindowPlot3D)) {
                    graphics.setColor(AbstractPlotLayout.this.getBackground());
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                if (AbstractPlotLayout.this.layerVector != null) {
                    AbstractPlotLayout.this.initGraphics((Graphics2D)graphics);
                    for (int i = 0; i < 2; ++i) {
                        Vector<PlotWindowInterface> vector = AbstractPlotLayout.this.layerVector.get(i);
                        for (int j = vector.size() - 1; j >= 0; --j) {
                            PlotWindowInterface plotWindowInterface = vector.elementAt(j);
                            if (plotWindowInterface instanceof DescriptionTextBox && ((DescriptionTextBox)plotWindowInterface).getLayer() != null && ((DescriptionTextBox)plotWindowInterface).getLayer().isCleaned()) {
                                AbstractPlotLayout.this.removeWindow(plotWindowInterface);
                                continue;
                            }
                            plotWindowInterface.paint((Graphics2D)graphics);
                        }
                    }
                }
            }
            catch (GLException gLException) {
                ErrorHandler.logAndReportException(gLException);
                this.doPaint = false;
                BaseInternalFrame baseInternalFrame = AbstractPlotLayout.this.getAssociatedFrame();
                if (baseInternalFrame != null) {
                    SwingUtilities.invokeLater(() -> {
                        if (FloatWindowPlot3D.isHardwareAccelerated()) {
                            FloatWindowPlot3D.setHardwareAcceleration(false);
                            Plot_GUI plot_GUI = AbstractPlotLayout.this.getPlot_GUI();
                            Abstract3dPlotBaseWindow abstract3dPlotBaseWindow = null;
                            if (AbstractPlotLayout.this instanceof Scatter3D) {
                                abstract3dPlotBaseWindow = new Scatter3D(plot_GUI, AbstractPlotLayout.this.getPlotInit());
                            } else if (AbstractPlotLayout.this instanceof Contour3D) {
                                abstract3dPlotBaseWindow = new Contour3D(plot_GUI, AbstractPlotLayout.this.getPlotInit());
                            }
                            if (abstract3dPlotBaseWindow != null) {
                                plot_GUI.addWindow(abstract3dPlotBaseWindow, false);
                                abstract3dPlotBaseWindow.setCreated(plot_GUI, false);
                            }
                        }
                        baseInternalFrame.doDefaultCloseAction();
                        JOptionPane.showMessageDialog(IniManager.getMainFrame(), "A 3D graphics (OpenGL) error has been detected,\nand hardware acceleration has been disabled.\nThis is probably due to faulty graphics drivers.\nTry updating your graphics drivers.", "3D graphics (OpenGL) error", 0);
                    });
                }
                this.setVisible(false);
            }
        }
    }
}

